/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.cxx.configure;

import com.android.build.gradle.internal.SdkLocator;
import com.android.build.gradle.internal.cxx.configure.GradleLocalPropertiesKt;
import com.android.build.gradle.internal.cxx.configure.Location;
import com.android.build.gradle.internal.cxx.configure.LocationType;
import com.android.build.gradle.internal.cxx.configure.NdkLocatorKt;
import com.android.build.gradle.internal.cxx.configure.NdkLocatorRecord;
import com.android.build.gradle.internal.cxx.configure.SdkSourceProperties;
import com.android.build.gradle.internal.cxx.logging.IssueReporterLoggingEnvironment;
import com.android.build.gradle.internal.cxx.logging.LoggingEnvironmentKt;
import com.android.build.gradle.internal.cxx.logging.PassThroughDeduplicatingLoggingEnvironment;
import com.android.builder.errors.EvalIssueReporter;
import com.android.repository.Revision;
import com.android.utils.FileUtils;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000>\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0007\u001a\u00020\b\u001ab\u0010\t\u001a\u0004\u0018\u00010\b2\b\u0010\n\u001a\u0004\u0018\u00010\u00012\b\u0010\u000b\u001a\u0004\u0018\u00010\u00012\b\u0010\f\u001a\u0004\u0018\u00010\b2\b\u0010\u0006\u001a\u0004\u0018\u00010\u00012\u0018\u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u000f0\u000e2\u0014\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u000eH\u0002\u001a`\u0010\u0012\u001a\u00020\u00032\b\u0010\u0006\u001a\u0004\u0018\u00010\u00012\b\u0010\n\u001a\u0004\u0018\u00010\u00012\b\u0010\u000b\u001a\u0004\u0018\u00010\u00012\b\u0010\f\u001a\u0004\u0018\u00010\b2\u0018\u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u000f0\u000e2\u0014\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u000eH\u0007\u001a\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0014\u001a\u00020\bH\u0007\u001a\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00010\u000f2\u0006\u0010\u0016\u001a\u00020\bH\u0007\u001a\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"ANDROID_GRADLE_PLUGIN_FIXED_DEFAULT_NDK_VERSION", "", "findNdkPath", "Lcom/android/build/gradle/internal/cxx/configure/NdkLocatorRecord;", "evalIssueReporter", "Lcom/android/builder/errors/EvalIssueReporter;", "ndkVersionFromDsl", "projectDir", "Ljava/io/File;", "findNdkPathImpl", "ndkDirProperty", "androidNdkHomeEnvironmentVariable", "sdkFolder", "getNdkVersionedFolderNames", "Lkotlin/Function1;", "", "getNdkSourceProperties", "Lcom/android/build/gradle/internal/cxx/configure/SdkSourceProperties;", "findNdkPathWithRecord", "getNdkVersionInfo", "ndkRoot", "getNdkVersionedFolders", "ndkVersionRoot", "isAcceptableNdkVersion", "", "sourcePropertiesRevision", "Lcom/android/repository/Revision;", "revisionFromDsl", "gradle"})
public final class NdkLocatorKt {
    @NotNull
    public static final String ANDROID_GRADLE_PLUGIN_FIXED_DEFAULT_NDK_VERSION = "21.0.5935234";

    /*
     * Unable to fully structure code
     */
    private static final File findNdkPathImpl(String ndkDirProperty, String androidNdkHomeEnvironmentVariable, File sdkFolder, String ndkVersionFromDsl, Function1<? super File, ? extends List<String>> getNdkVersionedFolderNames, Function1<? super File, SdkSourceProperties> getNdkSourceProperties) {
        v0 = new StringBuilder().append("android.ndkVersion from module build.gradle is ");
        v1 = ndkVersionFromDsl;
        if (v1 == null) {
            v1 = "not set";
        }
        LoggingEnvironmentKt.infoln(v0.append(v1).toString(), new Object[0]);
        v2 = new StringBuilder().append("ndk.dir in local.properties is ");
        v3 = ndkDirProperty;
        if (v3 == null) {
            v3 = "not set";
        }
        LoggingEnvironmentKt.infoln(v2.append(v3).toString(), new Object[0]);
        v4 = new StringBuilder().append("ANDROID_NDK_HOME environment variable is ");
        v5 = androidNdkHomeEnvironmentVariable;
        if (v5 == null) {
            v5 = "not set";
        }
        LoggingEnvironmentKt.infoln(v4.append((Object)v5).toString(), new Object[0]);
        if (sdkFolder != null) {
            LoggingEnvironmentKt.infoln("sdkFolder is " + sdkFolder, new Object[0]);
            v6 = sxsRoot = FileUtils.join((File)sdkFolder, (String[])new String[]{"ndk"});
            Intrinsics.checkExpressionValueIsNotNull((Object)v6, (String)"sxsRoot");
            if (!v6.isDirectory()) {
                LoggingEnvironmentKt.infoln("NDK side-by-side folder from sdkFolder " + sxsRoot + " does not exist", new Object[0]);
            }
        } else {
            LoggingEnvironmentKt.infoln("sdkFolder is not set", new Object[0]);
        }
        var7_7 = ndkVersionFromDsl;
        var8_8 = false;
        var9_10 = false;
        if (!(var7_7 == null || StringsKt.isBlank((CharSequence)var7_7) != false)) ** GOTO lbl-1000
        var7_7 = ndkDirProperty;
        var8_8 = false;
        var9_10 = false;
        if (!(var7_7 == null || StringsKt.isBlank((CharSequence)var7_7) != false)) ** GOTO lbl-1000
        var7_7 = androidNdkHomeEnvironmentVariable;
        var8_8 = false;
        var9_10 = false;
        if (var7_7 == null || StringsKt.isBlank((CharSequence)var7_7) != false) {
            LoggingEnvironmentKt.infoln("Because no explicit NDK was requested, the default version '21.0.5935234' for this Android Gradle Plugin will be used", new Object[0]);
            v7 = "21.0.5935234";
        } else lbl-1000:
        // 3 sources

        {
            v7 = ndkVersionOrDefault = ndkVersionFromDsl;
        }
        if (androidNdkHomeEnvironmentVariable != null) {
            LoggingEnvironmentKt.warnln("Support for ANDROID_NDK_HOME is deprecated and will be removed in the future. Use android.ndkVersion in build.gradle instead.", new Object[0]);
        }
        $fun$considerAndReject$1 = findNdkPathImpl.1.INSTANCE;
        var9_10 = false;
        foundLocations = new ArrayList<E>();
        if (ndkDirProperty != null) {
            var9_11 = foundLocations;
            var10_15 = new Location(LocationType.NDK_DIR_LOCATION, new File(ndkDirProperty));
            var11_17 = false;
            var9_11.add(var10_15);
        }
        if (androidNdkHomeEnvironmentVariable != null) {
            var9_12 = foundLocations;
            var10_15 = new Location(LocationType.ANDROID_NDK_HOME_LOCATION, new File(androidNdkHomeEnvironmentVariable));
            var11_17 = false;
            var9_12.add(var10_15);
        }
        if (sdkFolder != null) {
            var9_13 = foundLocations;
            var10_15 = new Location(LocationType.NDK_BUNDLE_FOLDER_LOCATION, new File(sdkFolder, "ndk-bundle"));
            var11_17 = false;
            var9_13.add(var10_15);
        }
        ndkVersionFromDslRevision = null;
        if (ndkVersionOrDefault != null) {
            try {
                ndkVersionFromDslRevision = Revision.parseRevision((String)ndkVersionOrDefault);
                if (ndkVersionFromDslRevision.toIntArray(true).length < 3) {
                    LoggingEnvironmentKt.errorln("Specified android.ndkVersion '" + ndkVersionOrDefault + "' does not have " + "enough precision. Use major.minor.micro in version.", new Object[0]);
                    return null;
                }
            }
            catch (NumberFormatException e) {
                LoggingEnvironmentKt.errorln("Requested NDK version '" + ndkVersionFromDsl + "' could not be parsed", new Object[0]);
                return null;
            }
        }
        if (sdkFolder != null) {
            versionRoot = new File(sdkFolder, "ndk");
            var11_18 = foundLocations;
            $this$map$iv = (Iterable)getNdkVersionedFolderNames.invoke((Object)versionRoot);
            $i$f$map = false;
            var14_29 = $this$map$iv;
            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Iterator<T> item$iv$iv : $this$mapTo$iv$iv) {
                var19_60 = (String)item$iv$iv;
                var33_57 = destination$iv$iv;
                $i$a$-map-NdkLocatorKt$findNdkPathImpl$2 = false;
                var34_58 = new Location(LocationType.NDK_VERSIONED_FOLDER_LOCATION, new File(versionRoot, (String)version));
                var33_57.add(var34_58);
            }
            $this$map$iv = (List)destination$iv$iv;
            $i$f$map = false;
            CollectionsKt.addAll((Collection)var11_18, (Iterable)$this$map$iv);
        }
        $this$forEach$iv = foundLocations;
        $i$f$forEach = false;
        for (T element$iv : $this$forEach$iv) {
            location = (Location)element$iv;
            $i$a$-forEach-NdkLocatorKt$findNdkPathImpl$3 = false;
            LoggingEnvironmentKt.infoln("Considering " + location.getNdkRoot() + ' ' + location.getType().getTag(), new Object[0]);
        }
        $this$mapNotNull$iv = foundLocations;
        $i$f$mapNotNull = false;
        element$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$mapNotNullTo = false;
        $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        $i$f$forEach = false;
        item$iv$iv = $this$forEach$iv$iv$iv.iterator();
        while (item$iv$iv.hasNext()) {
            element$iv$iv = element$iv$iv$iv = item$iv$iv.next();
            $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv = false;
            location = (Location)element$iv$iv;
            $i$a$-mapNotNull-NdkLocatorKt$findNdkPathImpl$versionedLocations$1 = false;
            versionInfo = (SdkSourceProperties)getNdkSourceProperties.invoke((Object)location.getNdkRoot());
            if (versionInfo == null) {
                if (FilesKt.resolve((File)location.getNdkRoot(), (String)"RELEASE.TXT").exists()) {
                    findNdkPathImpl.1.INSTANCE.invoke(location, "it contains an unsupported (pre-r11) NDK");
                } else {
                    findNdkPathImpl.1.INSTANCE.invoke(location, "that location has no source.properties");
                }
                v8 = null;
            } else if (versionInfo.getValue(SdkSourceProperties.Companion.SdkSourceProperty.SDK_PKG_REVISION) == null) {
                findNdkPathImpl.1.INSTANCE.invoke(location, "that location had source.properties " + "with no " + SdkSourceProperties.Companion.SdkSourceProperty.SDK_PKG_REVISION.getKey());
                v8 = null;
            } else {
                if (versionInfo.getValue(SdkSourceProperties.Companion.SdkSourceProperty.SDK_PKG_REVISION) == null) {
                    Intrinsics.throwNpe();
                }
                try {
                    Revision.parseRevision((String)revision);
                    var26_79 = new Pair((Object)location, (Object)versionInfo);
                }
                catch (NumberFormatException e) {
                    findNdkPathImpl.1.INSTANCE.invoke(location, "that location had " + "source.properties with invalid " + SdkSourceProperties.Companion.SdkSourceProperty.SDK_PKG_REVISION.getKey() + '=' + revision);
                    var26_79 = null;
                }
                v8 = var26_79;
            }
            if (v8 == null) continue;
            var28_81 = v8;
            var29_82 = false;
            var30_83 = false;
            it$iv$iv = var28_81;
            $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv = false;
            destination$iv$iv.add(it$iv$iv);
        }
        versionedLocations = CollectionsKt.asReversed((List)CollectionsKt.sortedWith((Iterable)((List)destination$iv$iv), (Comparator)ComparisonsKt.compareBy((Function1[])new Function1[]{findNdkPathImpl.versionedLocations.2.INSTANCE, findNdkPathImpl.versionedLocations.3.INSTANCE})));
        highest = (Pair)CollectionsKt.firstOrNull((List)versionedLocations);
        if (highest == null) {
            if (ndkVersionFromDsl == null) {
                LoggingEnvironmentKt.warnln("Compatible side by side NDK version was not found. Default is 21.0.5935234.", new Object[0]);
            } else {
                LoggingEnvironmentKt.warnln("Compatible side by side NDK version was not found for android.ndkVersion " + '\'' + ndkVersionFromDslRevision + '\'', new Object[0]);
            }
            return null;
        }
        if (ndkVersionFromDslRevision != null) {
            if (ndkDirProperty != null) {
                block49: {
                    $this$mapNotNullTo$iv$iv = versionedLocations;
                    destination$iv$iv = false;
                    $i$f$mapNotNullTo = $this$mapNotNullTo$iv$iv;
                    $this$forEach$iv$iv$iv = false;
                    for (Iterator<T> item$iv$iv : $i$f$mapNotNullTo) {
                        $dstr$location$_u24__u24 = (Pair)item$iv$iv;
                        $i$a$-find-NdkLocatorKt$findNdkPathImpl$ndkDirLocation$1 = false;
                        location = (Location)$dstr$location$_u24__u24.component1();
                        if (!(location.getType() == LocationType.NDK_DIR_LOCATION)) continue;
                        v9 = item$iv$iv;
                        break block49;
                    }
                    v9 = null;
                }
                ndkDirLocation = (Pair)v9;
                if (ndkDirLocation == null) {
                    LoggingEnvironmentKt.errorln("Location specified by ndk.dir (" + ndkDirProperty + ") did not contain a " + "valid NDK and so couldn't satisfy the required NDK version " + ndkVersionOrDefault, new Object[0]);
                    return null;
                }
                $i$f$mapNotNullTo = ndkDirLocation;
                $this$mapNotNullTo$iv$iv = (Location)$i$f$mapNotNullTo.component1();
                version = (SdkSourceProperties)$i$f$mapNotNullTo.component2();
                if (!NdkLocatorKt.isAcceptableNdkVersion(version.getRevision(), ndkVersionFromDslRevision)) {
                    LoggingEnvironmentKt.errorln("Requested NDK version " + ndkVersionOrDefault + " did not match the version " + version.getRevision() + " requested by ndk.dir at " + location.getNdkRoot(), new Object[0]);
                    return null;
                }
                LoggingEnvironmentKt.infoln("Choosing " + location.getNdkRoot() + " from ndk.dir which had the requested " + "version " + ndkVersionOrDefault, new Object[0]);
                return location.getNdkRoot();
            }
            $this$filter$iv = versionedLocations;
            $i$f$filter = false;
            $i$f$mapNotNullTo = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            for (T element$iv$iv : $this$filterTo$iv$iv) {
                $dstr$_u24__u24$sourceProperties = (Pair)element$iv$iv;
                $i$a$-filter-NdkLocatorKt$findNdkPathImpl$matchingLocations$1 = false;
                sourceProperties = (SdkSourceProperties)$dstr$_u24__u24$sourceProperties.component2();
                if (!NdkLocatorKt.isAcceptableNdkVersion(sourceProperties.getRevision(), ndkVersionFromDslRevision)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            matchingLocations = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
            if (matchingLocations.isEmpty()) {
                $this$onEach$iv = versionedLocations;
                $i$f$onEach = false;
                $this$filterTo$iv$iv = $this$onEach$iv;
                destination$iv$iv = false;
                var17_53 = false;
                $this$apply$iv = $this$filterTo$iv$iv;
                $i$a$-apply-CollectionsKt___CollectionsKt$onEach$1$iv = false;
                $dstr$_u24__u24$sourceProperties = $this$apply$iv.iterator();
                while ($dstr$_u24__u24$sourceProperties.hasNext()) {
                    element$iv = $dstr$_u24__u24$sourceProperties.next();
                    $dstr$location$version = (Pair)element$iv;
                    $i$a$-onEach-NdkLocatorKt$findNdkPathImpl$4 = false;
                    location = (Location)$dstr$location$version.component1();
                    version = (SdkSourceProperties)$dstr$location$version.component2();
                    findNdkPathImpl.1.INSTANCE.invoke(location, "that NDK had version " + version.getRevision() + " which didn't " + "match the requested version " + ndkVersionOrDefault);
                }
                $this$onEach$iv = versionedLocations;
                $i$f$onEach = false;
                if ($this$onEach$iv.isEmpty() == false) {
                    $this$sortedBy$iv = versionedLocations;
                    $i$f$sortedBy = false;
                    destination$iv$iv = $this$sortedBy$iv;
                    var17_53 = false;
                    $this$apply$iv = new Comparator<T>(){

                        public final int compare(T a, T b) {
                            boolean bl = false;
                            Pair $dstr$_u24__u24$version = (Pair)a;
                            boolean bl2 = false;
                            SdkSourceProperties version = (SdkSourceProperties)$dstr$_u24__u24$version.component2();
                            $dstr$_u24__u24$version = (Pair)b;
                            Comparable comparable = (Comparable)version.getRevision();
                            bl2 = false;
                            version = (SdkSourceProperties)$dstr$_u24__u24$version.component2();
                            Revision revision = version.getRevision();
                            return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)revision));
                        }
                    };
                    available = CollectionsKt.joinToString$default((Iterable)CollectionsKt.sortedWith((Iterable)destination$iv$iv, (Comparator)$this$apply$iv), (CharSequence)", ", null, null, (int)0, null, (Function1)findNdkPathImpl.available.2.INSTANCE, (int)30, null);
                    LoggingEnvironmentKt.errorln("No version of NDK matched the requested version " + ndkVersionOrDefault + ". Versions available locally: " + available, new Object[0]);
                } else {
                    LoggingEnvironmentKt.errorln("No version of NDK matched the requested version " + ndkVersionOrDefault, new Object[0]);
                }
                return null;
            }
            foundNdkRoot = ((Location)((Pair)CollectionsKt.first((List)matchingLocations)).getFirst()).getNdkRoot();
            if (matchingLocations.size() > 1) {
                LoggingEnvironmentKt.infoln("Found " + matchingLocations.size() + " NDK folders that matched requested " + "version " + ndkVersionFromDslRevision + ':', new Object[0]);
                $this$forEachIndexed$iv = matchingLocations;
                $i$f$forEachIndexed = false;
                index$iv = 0;
                for (T item$iv : $this$forEachIndexed$iv) {
                    $i$a$-apply-CollectionsKt___CollectionsKt$onEach$1$iv = index$iv++;
                    $dstr$_u24__u24$sourceProperties = false;
                    if ($i$a$-apply-CollectionsKt___CollectionsKt$onEach$1$iv < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    element$iv = $i$a$-apply-CollectionsKt___CollectionsKt$onEach$1$iv;
                    $dstr$location$version = (Pair)item$iv;
                    index = element$iv;
                    $i$a$-forEachIndexed-NdkLocatorKt$findNdkPathImpl$5 = false;
                    location = (Location)$dstr$location$_u24__u24.component1();
                    LoggingEnvironmentKt.infoln(" (" + (index + 1) + ") " + location.getNdkRoot() + ' ' + location.getType().getTag(), new Object[0]);
                }
                LoggingEnvironmentKt.infoln("  choosing " + foundNdkRoot, new Object[0]);
            } else {
                LoggingEnvironmentKt.infoln("Found requested NDK version " + ndkVersionFromDslRevision + " at " + foundNdkRoot, new Object[0]);
            }
            return foundNdkRoot;
        }
        if (ndkDirProperty != null) {
            block50: {
                foundNdkRoot = versionedLocations;
                $this$forEachIndexed$iv = false;
                var15_44 = foundNdkRoot;
                var16_51 = false;
                for (T var18_59 : var15_44) {
                    $dstr$location$_u24__u24 = (Pair)var18_59;
                    $i$a$-find-NdkLocatorKt$findNdkPathImpl$ndkDirLocation$2 = false;
                    location = (Location)$dstr$location$_u24__u24.component1();
                    if (!(location.getType() == LocationType.NDK_DIR_LOCATION)) continue;
                    v10 = var18_59;
                    break block50;
                }
                v10 = null;
            }
            ndkDirLocation = v10;
            if (ndkDirLocation == null) {
                LoggingEnvironmentKt.errorln("Location specified by ndk.dir (" + ndkDirProperty + ") did not contain a " + "valid NDK and and couldn't be used", new Object[0]);
                LoggingEnvironmentKt.infoln("Using " + ((Location)highest.getFirst()).getNdkRoot() + " which is " + "version " + ((SdkSourceProperties)highest.getSecond()).getRevision() + " as fallback but build will fail", new Object[0]);
                return null;
            }
            var15_44 = ndkDirLocation;
            foundNdkRoot = (Location)var15_44.component1();
            version = (SdkSourceProperties)var15_44.component2();
            LoggingEnvironmentKt.infoln("Found requested ndk.dir (" + location.getNdkRoot() + ") which has version " + version.getRevision(), new Object[0]);
            return location.getNdkRoot();
        }
        LoggingEnvironmentKt.infoln("No user requested version, choosing " + ((Location)highest.getFirst()).getNdkRoot() + " which is " + "version " + ((SdkSourceProperties)highest.getSecond()).getRevision(), new Object[0]);
        return ((Location)highest.getFirst()).getNdkRoot();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    @NotNull
    public static final NdkLocatorRecord findNdkPathWithRecord(@Nullable String ndkVersionFromDsl, @Nullable String ndkDirProperty, @Nullable String androidNdkHomeEnvironmentVariable, @Nullable File sdkFolder2, @NotNull Function1<? super File, ? extends List<String>> getNdkVersionedFolderNames, @NotNull Function1<? super File, SdkSourceProperties> getNdkSourceProperties) {
        Intrinsics.checkParameterIsNotNull(getNdkVersionedFolderNames, (String)"getNdkVersionedFolderNames");
        Intrinsics.checkParameterIsNotNull(getNdkSourceProperties, (String)"getNdkSourceProperties");
        AutoCloseable autoCloseable = new PassThroughDeduplicatingLoggingEnvironment();
        boolean bl = false;
        Throwable throwable = null;
        try {
            PassThroughDeduplicatingLoggingEnvironment loggingEnvironment = (PassThroughDeduplicatingLoggingEnvironment)autoCloseable;
            boolean bl2 = false;
            File ndkFolder2 = NdkLocatorKt.findNdkPathImpl(ndkDirProperty, androidNdkHomeEnvironmentVariable, sdkFolder2, ndkVersionFromDsl, getNdkVersionedFolderNames, getNdkSourceProperties);
            NdkLocatorRecord ndkLocatorRecord = new NdkLocatorRecord(ndkFolder2, loggingEnvironment.getRecord());
            return ndkLocatorRecord;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    private static final boolean isAcceptableNdkVersion(Revision sourcePropertiesRevision, Revision revisionFromDsl) {
        boolean bl;
        int[] parts = revisionFromDsl.toIntArray(true);
        switch (parts.length) {
            case 3: 
            case 4: {
                bl = Intrinsics.areEqual((Object)sourcePropertiesRevision, (Object)revisionFromDsl);
                break;
            }
            case 2: {
                if (revisionFromDsl.getMajor() == sourcePropertiesRevision.getMajor() && revisionFromDsl.getMinor() == sourcePropertiesRevision.getMinor()) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 1: {
                if (revisionFromDsl.getMajor() == sourcePropertiesRevision.getMajor()) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                throw (Throwable)new RuntimeException("Unexpected");
            }
        }
        return bl;
    }

    @VisibleForTesting
    @Nullable
    public static final SdkSourceProperties getNdkVersionInfo(@NotNull File ndkRoot) {
        SdkSourceProperties sdkSourceProperties;
        Intrinsics.checkParameterIsNotNull((Object)ndkRoot, (String)"ndkRoot");
        try {
            sdkSourceProperties = SdkSourceProperties.Companion.fromInstallFolder(ndkRoot);
        }
        catch (FileNotFoundException e) {
            sdkSourceProperties = null;
        }
        return sdkSourceProperties;
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    @NotNull
    public static final List<String> getNdkVersionedFolders(@NotNull File ndkVersionRoot) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)ndkVersionRoot, (String)"ndkVersionRoot");
        if (!ndkVersionRoot.isDirectory()) {
            boolean bl = false;
            return CollectionsKt.emptyList();
        }
        String[] stringArray = ndkVersionRoot.list();
        Intrinsics.checkExpressionValueIsNotNull((Object)stringArray, (String)"ndkVersionRoot.list()");
        String[] $this$filter$iv = stringArray;
        boolean $i$f$filter = false;
        String[] stringArray2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        void var6_7 = $this$filterTo$iv$iv;
        int n = ((void)var6_7).length;
        for (int j = 0; j < n; ++j) {
            void element$iv$iv;
            void it = element$iv$iv = var6_7[j];
            boolean bl = false;
            if (!new File(ndkVersionRoot, (String)it).isDirectory()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final NdkLocatorRecord findNdkPath(@NotNull EvalIssueReporter evalIssueReporter, @Nullable String ndkVersionFromDsl, @NotNull File projectDir) {
        Intrinsics.checkParameterIsNotNull((Object)evalIssueReporter, (String)"evalIssueReporter");
        Intrinsics.checkParameterIsNotNull((Object)projectDir, (String)"projectDir");
        AutoCloseable autoCloseable = new IssueReporterLoggingEnvironment(evalIssueReporter);
        boolean bl = false;
        Throwable throwable = null;
        try {
            IssueReporterLoggingEnvironment it = (IssueReporterLoggingEnvironment)autoCloseable;
            boolean bl2 = false;
            Properties properties = GradleLocalPropertiesKt.gradleLocalProperties(projectDir);
            File sdkPath = SdkLocator.getSdkDirectory(projectDir, evalIssueReporter);
            NdkLocatorRecord ndkLocatorRecord = NdkLocatorKt.findNdkPathWithRecord(ndkVersionFromDsl, properties.getProperty("ndk.dir"), System.getenv("ANDROID_NDK_HOME"), sdkPath, (Function1<? super File, ? extends List<String>>)((Function1)findNdkPath.1.1.INSTANCE), (Function1<? super File, SdkSourceProperties>)((Function1)findNdkPath.1.2.INSTANCE));
            return ndkLocatorRecord;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }
}

