/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.scope;

import com.android.build.FilterData;
import com.android.build.VariantOutput;
import com.android.build.api.artifact.ArtifactType;
import com.android.build.gradle.internal.api.artifact.ArtifactTypeUtils;
import com.android.build.gradle.internal.ide.FilterDataImpl;
import com.android.build.gradle.internal.scope.ApkData;
import com.android.build.gradle.internal.scope.BuildElements;
import com.android.build.gradle.internal.scope.BuildOutput;
import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.provider.Provider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\u0018\u0000 \u00042\u00020\u0001:\u0003\u0003\u0004\u0005B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0006"}, d2={"Lcom/android/build/gradle/internal/scope/ExistingBuildElements;", "", "()V", "ApkDataAdapter", "Companion", "OutputTypeTypeAdapter", "gradle"})
public final class ExistingBuildElements {
    private static final String METADATA_FILE_NAME = "output.json";
    public static final Companion Companion = new Companion(null);

    @JvmStatic
    @NotNull
    public static final BuildElements from(@NotNull ArtifactType<Directory> artifactType, @NotNull Provider<Directory> directoryProvider) {
        return Companion.from(artifactType, directoryProvider);
    }

    @JvmStatic
    @NotNull
    public static final BuildElements from(@NotNull ArtifactType<Directory> elementType, @NotNull FileCollection from) {
        return Companion.from(elementType, from);
    }

    @JvmStatic
    @NotNull
    public static final BuildElements from(@NotNull ArtifactType<Directory> elementType, @NotNull File from) {
        return Companion.from(elementType, from);
    }

    @JvmStatic
    @NotNull
    public static final BuildElements from(@NotNull File from) {
        return Companion.from(from);
    }

    @JvmStatic
    @Nullable
    public static final File getMetadataFileIfPresent(@NotNull File folder) {
        return Companion.getMetadataFileIfPresent(folder);
    }

    @JvmStatic
    @NotNull
    public static final File getMetadataFile(@NotNull File folder) {
        return Companion.getMetadataFile(folder);
    }

    @JvmStatic
    @NotNull
    public static final String persistApkList(@NotNull Collection<? extends ApkData> apkDatas) {
        return Companion.persistApkList(apkDatas);
    }

    @JvmStatic
    @NotNull
    public static final Collection<ApkData> loadApkList(@NotNull File file) throws FileNotFoundException {
        return Companion.loadApkList(file);
    }

    @JvmStatic
    @NotNull
    public static final Collection<BuildOutput> load(@NotNull Path projectPath, @Nullable ArtifactType<Directory> outputType, @NotNull Reader reader) {
        return Companion.load(projectPath, outputType, reader);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\u001a\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0002H\u0016\u00a8\u0006\u0010"}, d2={"Lcom/android/build/gradle/internal/scope/ExistingBuildElements$ApkDataAdapter;", "Lcom/google/gson/TypeAdapter;", "Lcom/android/build/gradle/internal/scope/ApkData;", "()V", "read", "reader", "Lcom/google/gson/stream/JsonReader;", "readFilters", "", "filters", "Lcom/google/common/collect/ImmutableList$Builder;", "Lcom/android/build/FilterData;", "write", "out", "Lcom/google/gson/stream/JsonWriter;", "value", "gradle"})
    public static final class ApkDataAdapter
    extends TypeAdapter<ApkData> {
        public void write(@NotNull JsonWriter out, @Nullable ApkData value) throws IOException {
            Intrinsics.checkParameterIsNotNull((Object)out, (String)"out");
            if (value == null) {
                out.nullValue();
                return;
            }
            out.beginObject();
            out.name("type").value(value.getType().toString());
            out.name("splits").beginArray();
            for (FilterData filter : value.getFilters()) {
                out.beginObject();
                JsonWriter jsonWriter = out.name("filterType");
                FilterData filterData = filter;
                Intrinsics.checkExpressionValueIsNotNull((Object)filterData, (String)"filter");
                jsonWriter.value(filterData.getFilterType());
                out.name("value").value(filter.getIdentifier());
                out.endObject();
            }
            out.endArray();
            out.name("versionCode").value((long)value.getVersionCode());
            if (value.getVersionName() != null) {
                out.name("versionName").value(value.getVersionName());
            }
            out.name("enabled").value(value.isEnabled());
            if (value.getFilterName() != null) {
                out.name("filterName").value(value.getFilterName());
            }
            if (value.getOutputFileName() != null) {
                out.name("outputFile").value(value.getOutputFileName());
            }
            out.name("fullName").value(value.getFullName());
            out.name("baseName").value(value.getBaseName());
            out.name("dirName").value(value.getDirName());
            out.endObject();
        }

        @NotNull
        public ApkData read(@NotNull JsonReader reader) throws IOException {
            String string;
            String string2;
            Intrinsics.checkParameterIsNotNull((Object)reader, (String)"reader");
            reader.beginObject();
            String outputType = null;
            ImmutableList.Builder filters = ImmutableList.builder();
            int versionCode = 0;
            String versionName = null;
            boolean enabled = true;
            String outputFile = null;
            String fullName = null;
            String baseName = null;
            String filterName = null;
            String dirName = null;
            while (reader.hasNext()) {
                String string3;
                if (reader.nextName() == null) continue;
                int n = -1;
                switch (string3.hashCode()) {
                    case -1274275299: {
                        if (!string3.equals("outputFile")) break;
                        n = 1;
                        break;
                    }
                    case -895858535: {
                        if (!string3.equals("splits")) break;
                        n = 2;
                        break;
                    }
                    case -1553252829: {
                        if (!string3.equals("filterName")) break;
                        n = 3;
                        break;
                    }
                    case 1330852282: {
                        if (!string3.equals("fullName")) break;
                        n = 4;
                        break;
                    }
                    case 3575610: {
                        if (!string3.equals("type")) break;
                        n = 5;
                        break;
                    }
                    case 688906115: {
                        if (!string3.equals("versionName")) break;
                        n = 6;
                        break;
                    }
                    case -1721686788: {
                        if (!string3.equals("baseName")) break;
                        n = 7;
                        break;
                    }
                    case 688591589: {
                        if (!string3.equals("versionCode")) break;
                        n = 8;
                        break;
                    }
                    case -1609594047: {
                        if (!string3.equals("enabled")) break;
                        n = 9;
                        break;
                    }
                    case 1669817528: {
                        if (!string3.equals("dirName")) break;
                        n = 10;
                        break;
                    }
                }
                switch (n) {
                    case 5: {
                        outputType = reader.nextString();
                        break;
                    }
                    case 2: {
                        ImmutableList.Builder builder = filters;
                        Intrinsics.checkExpressionValueIsNotNull((Object)builder, (String)"filters");
                        this.readFilters(reader, (ImmutableList.Builder<FilterData>)builder);
                        break;
                    }
                    case 8: {
                        versionCode = reader.nextInt();
                        break;
                    }
                    case 6: {
                        versionName = reader.nextString();
                        break;
                    }
                    case 9: {
                        enabled = reader.nextBoolean();
                        break;
                    }
                    case 1: {
                        outputFile = reader.nextString();
                        break;
                    }
                    case 3: {
                        filterName = reader.nextString();
                        break;
                    }
                    case 7: {
                        baseName = reader.nextString();
                        break;
                    }
                    case 4: {
                        fullName = reader.nextString();
                        break;
                    }
                    case 10: {
                        dirName = reader.nextString();
                    }
                }
            }
            reader.endObject();
            ImmutableList filterData = filters.build();
            String string4 = outputType;
            if (string4 == null) {
                Intrinsics.throwNpe();
            }
            VariantOutput.OutputType apkType = VariantOutput.OutputType.valueOf((String)string4);
            Collection collection = (Collection)filterData;
            String string5 = fullName;
            if (string5 == null) {
                string5 = "";
            }
            if ((string2 = baseName) == null) {
                string2 = "";
            }
            if ((string = dirName) == null) {
                string = "";
            }
            ApkData apkData = ApkData.of(apkType, collection, versionCode, versionName, filterName, outputFile, string5, string2, enabled, string);
            Intrinsics.checkExpressionValueIsNotNull((Object)apkData, (String)"ApkData.of(\n            \u2026           dirName ?: \"\")");
            return apkData;
        }

        private final void readFilters(JsonReader reader, ImmutableList.Builder<FilterData> filters) throws IOException {
            reader.beginArray();
            while (reader.hasNext()) {
                reader.beginObject();
                VariantOutput.FilterType filterType2 = null;
                String value = null;
                while (reader.hasNext()) {
                    String string;
                    if (reader.nextName() == null) continue;
                    int n = -1;
                    switch (string.hashCode()) {
                        case -1553050926: {
                            if (!string.equals("filterType")) break;
                            n = 1;
                            break;
                        }
                        case 111972721: {
                            if (!string.equals("value")) break;
                            n = 2;
                            break;
                        }
                    }
                    switch (n) {
                        case 1: {
                            String string2 = reader.nextString();
                            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"reader.nextString()");
                            filterType2 = VariantOutput.FilterType.valueOf((String)string2);
                            break;
                        }
                        case 2: {
                            value = reader.nextString();
                        }
                    }
                }
                if (filterType2 != null && value != null) {
                    filters.add((Object)new FilterDataImpl(filterType2, value));
                }
                reader.endObject();
            }
            reader.endArray();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00050\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001c\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0016\u00a8\u0006\r"}, d2={"Lcom/android/build/gradle/internal/scope/ExistingBuildElements$OutputTypeTypeAdapter;", "Lcom/google/gson/TypeAdapter;", "Lcom/android/build/api/artifact/ArtifactType;", "()V", "read", "Lorg/gradle/api/file/Directory;", "reader", "Lcom/google/gson/stream/JsonReader;", "write", "", "out", "Lcom/google/gson/stream/JsonWriter;", "value", "gradle"})
    public static final class OutputTypeTypeAdapter
    extends TypeAdapter<ArtifactType<?>> {
        public void write(@NotNull JsonWriter out, @NotNull ArtifactType<?> value) throws IOException {
            Intrinsics.checkParameterIsNotNull((Object)out, (String)"out");
            Intrinsics.checkParameterIsNotNull(value, (String)"value");
            out.beginObject();
            out.name("type").value(value.name());
            out.endObject();
        }

        @NotNull
        public ArtifactType<Directory> read(@NotNull JsonReader reader) throws IOException {
            String nextString;
            Intrinsics.checkParameterIsNotNull((Object)reader, (String)"reader");
            reader.beginObject();
            String string = reader.nextName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"reader.nextName()");
            if (!StringsKt.endsWith$default((String)string, (String)"type", (boolean)false, (int)2, null)) {
                throw (Throwable)new IOException("Invalid format");
            }
            String string2 = nextString = reader.nextString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"nextString");
            ArtifactType<?> artifactType = ArtifactTypeUtils.toArtifactType(string2);
            if (artifactType == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.android.build.api.artifact.ArtifactType<org.gradle.api.file.Directory>");
            }
            ArtifactType<?> outputType = artifactType;
            reader.endObject();
            return outputType;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0005\u001a\u00020\nH\u0007J\u001e\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0005\u001a\u00020\u000bH\u0007J$\u0010\u0005\u001a\u00020\u00062\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\u000eH\u0007J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\nH\u0007J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\nH\u0007J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0010\u001a\u00020\nH\u0007J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0012\u001a\u00020\u000bH\u0002J.\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u000e\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b2\u0006\u0010\u0019\u001a\u00020\u001aH\u0007J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00142\u0006\u0010\u001d\u001a\u00020\nH\u0007J\"\u0010\u001e\u001a\u00020\u00062\u000e\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b2\b\u0010\u001f\u001a\u0004\u0018\u00010\nH\u0002J\u0016\u0010 \u001a\u00020\u00042\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0014H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/android/build/gradle/internal/scope/ExistingBuildElements$Companion;", "", "()V", "METADATA_FILE_NAME", "", "from", "Lcom/android/build/gradle/internal/scope/BuildElements;", "elementType", "Lcom/android/build/api/artifact/ArtifactType;", "Lorg/gradle/api/file/Directory;", "Ljava/io/File;", "Lorg/gradle/api/file/FileCollection;", "artifactType", "directoryProvider", "Lorg/gradle/api/provider/Provider;", "getMetadataFile", "folder", "getMetadataFileIfPresent", "fileCollection", "load", "", "Lcom/android/build/gradle/internal/scope/BuildOutput;", "projectPath", "Ljava/nio/file/Path;", "outputType", "reader", "Ljava/io/Reader;", "loadApkList", "Lcom/android/build/gradle/internal/scope/ApkData;", "file", "loadFrom", "metadataFile", "persistApkList", "apkDatas", "gradle"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final BuildElements from(@NotNull ArtifactType<Directory> artifactType, @NotNull Provider<Directory> directoryProvider) {
            BuildElements buildElements;
            Intrinsics.checkParameterIsNotNull(artifactType, (String)"artifactType");
            Intrinsics.checkParameterIsNotNull(directoryProvider, (String)"directoryProvider");
            if (directoryProvider.isPresent()) {
                Object object = directoryProvider.get();
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"directoryProvider.get()");
                File file = ((Directory)object).getAsFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"directoryProvider.get().asFile");
                buildElements = this.from(artifactType, file);
            } else {
                boolean bl = false;
                List list = CollectionsKt.emptyList();
                Collection collection = list;
                buildElements = new BuildElements(collection);
            }
            return buildElements;
        }

        @JvmStatic
        @NotNull
        public final BuildElements from(@NotNull ArtifactType<Directory> elementType, @NotNull FileCollection from) {
            Intrinsics.checkParameterIsNotNull(elementType, (String)"elementType");
            Intrinsics.checkParameterIsNotNull((Object)from, (String)"from");
            File metadataFile = this.getMetadataFileIfPresent(from);
            return this.loadFrom(elementType, metadataFile);
        }

        @JvmStatic
        @NotNull
        public final BuildElements from(@NotNull ArtifactType<Directory> elementType, @NotNull File from) {
            Intrinsics.checkParameterIsNotNull(elementType, (String)"elementType");
            Intrinsics.checkParameterIsNotNull((Object)from, (String)"from");
            File metadataFile = this.getMetadataFileIfPresent(from);
            return this.loadFrom(elementType, metadataFile);
        }

        @JvmStatic
        @NotNull
        public final BuildElements from(@NotNull File from) {
            Intrinsics.checkParameterIsNotNull((Object)from, (String)"from");
            File metadataFile = this.getMetadataFileIfPresent(from);
            return this.loadFrom(null, metadataFile);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final BuildElements loadFrom(ArtifactType<Directory> elementType, File metadataFile) {
            if (metadataFile == null || !metadataFile.exists()) {
                ImmutableList immutableList = ImmutableList.of();
                Intrinsics.checkExpressionValueIsNotNull((Object)immutableList, (String)"ImmutableList.of()");
                return new BuildElements((Collection)immutableList);
            }
            try {
                Closeable closeable = new FileReader(metadataFile);
                boolean bl = false;
                Throwable throwable = null;
                try {
                    FileReader reader = (FileReader)closeable;
                    boolean bl2 = false;
                    Path path = metadataFile.getParentFile().toPath();
                    Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"metadataFile.parentFile.toPath()");
                    BuildElements buildElements = new BuildElements(Companion.load(path, elementType, reader));
                    return buildElements;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (IOException e) {
                ImmutableList immutableList = ImmutableList.of();
                Intrinsics.checkExpressionValueIsNotNull((Object)immutableList, (String)"ImmutableList.of<BuildOutput>()");
                return new BuildElements((Collection)immutableList);
            }
        }

        private final File getMetadataFileIfPresent(FileCollection fileCollection2) {
            Object v3;
            block1: {
                FileTree fileTree = fileCollection2.getAsFileTree();
                Intrinsics.checkExpressionValueIsNotNull((Object)fileTree, (String)"fileCollection.asFileTree");
                Set set = fileTree.getFiles();
                Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"fileCollection.asFileTree.files");
                Iterable iterable = set;
                boolean bl = false;
                Iterable iterable2 = iterable;
                boolean bl2 = false;
                for (Object t : iterable2) {
                    File it = (File)t;
                    boolean bl3 = false;
                    File file = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"it");
                    if (!Intrinsics.areEqual((Object)file.getName(), (Object)ExistingBuildElements.METADATA_FILE_NAME)) continue;
                    v3 = t;
                    break block1;
                }
                v3 = null;
            }
            return v3;
        }

        @JvmStatic
        @Nullable
        public final File getMetadataFileIfPresent(@NotNull File folder) {
            Intrinsics.checkParameterIsNotNull((Object)folder, (String)"folder");
            File outputFile = this.getMetadataFile(folder);
            return outputFile.exists() ? outputFile : null;
        }

        @JvmStatic
        @NotNull
        public final File getMetadataFile(@NotNull File folder) {
            Intrinsics.checkParameterIsNotNull((Object)folder, (String)"folder");
            return new File(folder, ExistingBuildElements.METADATA_FILE_NAME);
        }

        @JvmStatic
        @NotNull
        public final String persistApkList(@NotNull Collection<? extends ApkData> apkDatas) {
            Intrinsics.checkParameterIsNotNull(apkDatas, (String)"apkDatas");
            GsonBuilder gsonBuilder = new GsonBuilder();
            gsonBuilder.registerTypeHierarchyAdapter(ApkData.class, (Object)new ApkDataAdapter());
            Gson gson = gsonBuilder.create();
            String string = gson.toJson(apkDatas);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"gson.toJson(apkDatas)");
            return string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        @NotNull
        public final Collection<ApkData> loadApkList(@NotNull File file) throws FileNotFoundException {
            Collection collection;
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            GsonBuilder gsonBuilder = new GsonBuilder();
            gsonBuilder.registerTypeHierarchyAdapter(ApkData.class, (Object)new ApkDataAdapter());
            gsonBuilder.registerTypeAdapter((Type)((Object)ArtifactType.class), (Object)new OutputTypeTypeAdapter());
            Gson gson = gsonBuilder.create();
            Type recordType2 = new TypeToken<List<? extends ApkData>>(){}.getType();
            Closeable closeable = new FileReader(file);
            boolean bl = false;
            Throwable throwable = null;
            try {
                FileReader it = (FileReader)closeable;
                boolean bl2 = false;
                Object object = gson.fromJson((Reader)it, recordType2);
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"gson.fromJson(it, recordType)");
                Collection collection2 = (Collection)object;
                collection = collection2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"FileReader(file).use {\n \u2026recordType)\n            }");
            return collection;
        }

        @JvmStatic
        @NotNull
        public final Collection<BuildOutput> load(@NotNull Path projectPath, @Nullable ArtifactType<Directory> outputType, @NotNull Reader reader) {
            Collection buildOutputs;
            Intrinsics.checkParameterIsNotNull((Object)projectPath, (String)"projectPath");
            Intrinsics.checkParameterIsNotNull((Object)reader, (String)"reader");
            GsonBuilder gsonBuilder = new GsonBuilder();
            gsonBuilder.registerTypeAdapter((Type)((Object)ApkData.class), (Object)new ApkDataAdapter());
            gsonBuilder.registerTypeAdapter((Type)((Object)ArtifactType.class), (Object)new OutputTypeTypeAdapter());
            Gson gson = gsonBuilder.create();
            Type recordType2 = new TypeToken<List<? extends BuildOutput>>(){}.getType();
            Collection collection = buildOutputs = (Collection)gson.fromJson(reader, recordType2);
            Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"buildOutputs");
            return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)collection), (Function1)((Function1)new Function1<BuildOutput, Boolean>(outputType){
                final /* synthetic */ ArtifactType $outputType;

                public final boolean invoke(@NotNull BuildOutput it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return this.$outputType == null || Intrinsics.areEqual((Object)it.getType().name(), (Object)this.$outputType.name());
                }
                {
                    this.$outputType = artifactType;
                    super(1);
                }
            })), (Function1)((Function1)new Function1<BuildOutput, BuildOutput>(projectPath){
                final /* synthetic */ Path $projectPath;

                @NotNull
                public final BuildOutput invoke(@NotNull BuildOutput buildOutput) {
                    Intrinsics.checkParameterIsNotNull((Object)buildOutput, (String)"buildOutput");
                    return new BuildOutput(buildOutput.getType(), buildOutput.getApkData(), this.$projectPath.resolve(buildOutput.getOutputPath()), buildOutput.getProperties());
                }
                {
                    this.$projectPath = path;
                    super(1);
                }
            })));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

