/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.api.artifact.ArtifactType;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.packaging.JarCreatorFactory;
import com.android.build.gradle.internal.packaging.JarCreatorType;
import com.android.build.gradle.internal.pipeline.StreamFilter;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.BuildArtifactsHolder;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.MultipleArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.DexRelocator;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.PerModuleBundleTask;
import com.android.build.gradle.internal.tasks.PerModuleBundleTask$CreationAction$handleProvider$1;
import com.android.build.gradle.internal.tasks.PerModuleBundleTaskKt;
import com.android.build.gradle.internal.tasks.Relocator;
import com.android.build.gradle.internal.tasks.ResRelocator;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.utils.DesugarLibUtils;
import com.android.builder.files.NativeLibraryAbiPredicate;
import com.android.builder.packaging.JarCreator;
import com.android.builder.packaging.JarMerger;
import com.android.utils.FileUtils;
import java.io.Closeable;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001:\u00014B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J<\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+2\n\b\u0002\u0010-\u001a\u0004\u0018\u00010.2\u0010\b\u0002\u0010/\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u000100H\u0002J\b\u00101\u001a\u00020'H\u0016J\b\u00102\u001a\u000203H\u0002R0\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00062\u000e\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00068G@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00108gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00070\u00168gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0019\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00168G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0018R\u0014\u0010\u001c\u001a\u00020\u00108gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0012R\u0014\u0010\u001e\u001a\u00020\u00108gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0012R\u0014\u0010 \u001a\u00020\f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u000eR\u0014\u0010\"\u001a\u00020#8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%\u00a8\u00065"}, d2={"Lcom/android/build/gradle/internal/tasks/PerModuleBundleTask;", "Lcom/android/build/gradle/internal/tasks/NonIncrementalTask;", "objects", "Lorg/gradle/api/model/ObjectFactory;", "(Lorg/gradle/api/model/ObjectFactory;)V", "<set-?>", "", "", "abiFilters", "getAbiFilters", "()Ljava/util/Set;", "assetsFiles", "Lorg/gradle/api/file/DirectoryProperty;", "getAssetsFiles", "()Lorg/gradle/api/file/DirectoryProperty;", "dexFiles", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getDexFiles", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "featureDexFiles", "getFeatureDexFiles", "fileName", "Lorg/gradle/api/provider/Property;", "getFileName", "()Lorg/gradle/api/provider/Property;", "jarCreatorType", "Lcom/android/build/gradle/internal/packaging/JarCreatorType;", "getJarCreatorType", "javaResFiles", "getJavaResFiles", "nativeLibsFiles", "getNativeLibsFiles", "outputDir", "getOutputDir", "resFiles", "Lorg/gradle/api/file/RegularFileProperty;", "getResFiles", "()Lorg/gradle/api/file/RegularFileProperty;", "addHybridFolder", "", "jarCreator", "Lcom/android/builder/packaging/JarCreator;", "files", "", "Ljava/io/File;", "relocator", "Lcom/android/builder/packaging/JarCreator$Relocator;", "fileFilter", "Ljava/util/function/Predicate;", "doTaskAction", "hasFeatureDexFiles", "", "CreationAction", "gradle"})
public abstract class PerModuleBundleTask
extends NonIncrementalTask {
    @Nullable
    private Set<String> abiFilters;
    @NotNull
    private final Property<JarCreatorType> jarCreatorType;

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getOutputDir();

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public abstract ConfigurableFileCollection getDexFiles();

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public abstract ConfigurableFileCollection getFeatureDexFiles();

    @InputFile
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public abstract RegularFileProperty getResFiles();

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public abstract ConfigurableFileCollection getJavaResFiles();

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public abstract DirectoryProperty getAssetsFiles();

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public abstract ConfigurableFileCollection getNativeLibsFiles();

    @Input
    @Optional
    @Nullable
    public final Set<String> getAbiFilters() {
        return this.abiFilters;
    }

    @Input
    @NotNull
    public abstract Property<String> getFileName();

    @Input
    @NotNull
    public final Property<JarCreatorType> getJarCreatorType() {
        return this.jarCreatorType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doTaskAction() {
        Object object = this.getOutputDir().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"outputDir.get()");
        FileUtils.cleanOutputDir((File)((Directory)object).getAsFile());
        Object object2 = this.getOutputDir().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"outputDir.get()");
        Path path = new File(((Directory)object2).getAsFile(), (String)this.getFileName().get()).toPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"File(outputDir.get().asF\u2026 fileName.get()).toPath()");
        Object object3 = this.jarCreatorType.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"jarCreatorType.get()");
        JarCreator jarCreator = JarCreatorFactory.INSTANCE.make(path, (JarCreatorType)((Object)object3));
        jarCreator.setCompressionLevel(0);
        Set<String> filters = this.abiFilters;
        Predicate abiFilter = filters != null ? (Predicate)new NativeLibraryAbiPredicate(filters, false) : null;
        Closeable closeable = (Closeable)jarCreator;
        boolean bl = false;
        Throwable throwable = null;
        try {
            Set javaResFilesSet;
            Set set;
            Iterable $this$sortedBy$iv;
            boolean $i$f$sortedBy;
            Set dexFilesSet;
            JarCreator it = (JarCreator)closeable;
            boolean bl2 = false;
            Object object4 = this.getAssetsFiles().get();
            Intrinsics.checkExpressionValueIsNotNull((Object)object4, (String)"assetsFiles.get()");
            it.addDirectory(((Directory)object4).getAsFile().toPath(), null, null, (JarCreator.Relocator)new Relocator("assets"));
            Object object5 = this.getResFiles().get();
            Intrinsics.checkExpressionValueIsNotNull((Object)object5, (String)"resFiles.get()");
            it.addJar(((RegularFile)object5).getAsFile().toPath(), null, (JarCreator.Relocator)new ResRelocator());
            Set set2 = dexFilesSet = this.hasFeatureDexFiles() ? this.getFeatureDexFiles().getFiles() : this.getDexFiles().getFiles();
            if (dexFilesSet.size() == 1) {
                Set set3 = dexFilesSet;
                Intrinsics.checkExpressionValueIsNotNull((Object)set3, (String)"dexFilesSet");
                Iterable iterable = set3;
                JarCreator jarCreator2 = it;
                PerModuleBundleTask perModuleBundleTask = this;
                $i$f$sortedBy = false;
                Iterable iterable2 = $this$sortedBy$iv;
                boolean bl3 = false;
                Comparator comparator = new Comparator<T>(){

                    public final int compare(T a, T b) {
                        boolean bl = false;
                        File it = (File)a;
                        boolean bl2 = false;
                        File file = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"it");
                        it = (File)b;
                        Comparable comparable = (Comparable)((Object)file.getName());
                        bl2 = false;
                        File file2 = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"it");
                        String string = file2.getName();
                        return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)((Object)string)));
                    }
                };
                List list = CollectionsKt.sortedWith((Iterable)iterable2, (Comparator)comparator);
                perModuleBundleTask.addHybridFolder(jarCreator2, list, new Relocator("dex"), null);
            } else {
                Set set4 = dexFilesSet;
                Intrinsics.checkExpressionValueIsNotNull((Object)set4, (String)"dexFilesSet");
                $this$sortedBy$iv = set4;
                JarCreator jarCreator3 = it;
                PerModuleBundleTask perModuleBundleTask = this;
                $i$f$sortedBy = false;
                Iterable iterable = $this$sortedBy$iv;
                boolean bl4 = false;
                Comparator comparator = new Comparator<T>(){

                    public final int compare(T a, T b) {
                        boolean bl = false;
                        File it = (File)a;
                        boolean bl2 = false;
                        File file = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"it");
                        it = (File)b;
                        Comparable comparable = (Comparable)((Object)file.getName());
                        bl2 = false;
                        File file2 = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"it");
                        String string = file2.getName();
                        return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)((Object)string)));
                    }
                };
                List list = CollectionsKt.sortedWith((Iterable)iterable, (Comparator)comparator);
                perModuleBundleTask.addHybridFolder(jarCreator3, list, new DexRelocator("dex"), null);
            }
            if (this.hasFeatureDexFiles()) {
                boolean bl5 = false;
                set = SetsKt.emptySet();
            } else {
                set = this.getJavaResFiles().getFiles();
            }
            Set set5 = javaResFilesSet = set;
            Intrinsics.checkExpressionValueIsNotNull((Object)set5, (String)"javaResFilesSet");
            this.addHybridFolder(it, set5, new Relocator("root"), JarMerger.EXCLUDE_CLASSES);
            Set set6 = this.getNativeLibsFiles().getFiles();
            Intrinsics.checkExpressionValueIsNotNull((Object)set6, (String)"nativeLibsFiles.files");
            PerModuleBundleTask.addHybridFolder$default(this, it, set6, null, abiFilter, 4, null);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final void addHybridFolder(JarCreator jarCreator, Iterable<? extends File> files, JarCreator.Relocator relocator, Predicate<String> fileFilter) {
        for (File file : files) {
            if (file.isFile()) {
                String string = file.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.name");
                if (StringsKt.endsWith$default((String)string, (String)".jar", (boolean)false, (int)2, null)) {
                    jarCreator.addJar(file.toPath(), fileFilter, relocator);
                    continue;
                }
                if (fileFilter != null && !fileFilter.test(file.getName())) continue;
                if (relocator != null) {
                    jarCreator.addFile(relocator.relocate(file.getName()), file.toPath());
                    continue;
                }
                jarCreator.addFile(file.getName(), file.toPath());
                continue;
            }
            jarCreator.addDirectory(file.toPath(), fileFilter, null, relocator);
        }
    }

    static /* synthetic */ void addHybridFolder$default(PerModuleBundleTask perModuleBundleTask, JarCreator jarCreator, Iterable iterable, JarCreator.Relocator relocator, Predicate predicate2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addHybridFolder");
        }
        if ((n & 4) != 0) {
            relocator = null;
        }
        if ((n & 8) != 0) {
            predicate2 = null;
        }
        perModuleBundleTask.addHybridFolder(jarCreator, iterable, relocator, predicate2);
    }

    private final boolean hasFeatureDexFiles() {
        Set set = this.getFeatureDexFiles().getFiles();
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"featureDexFiles.files");
        Collection collection = set;
        boolean bl = false;
        return !collection.isEmpty();
    }

    @Inject
    public PerModuleBundleTask(@NotNull ObjectFactory objects) {
        Intrinsics.checkParameterIsNotNull((Object)objects, (String)"objects");
        Property property = objects.property(JarCreatorType.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)property, (String)"objects.property(JarCreatorType::class.java)");
        this.jarCreatorType = property;
    }

    public static final /* synthetic */ Set access$getAbiFilters$p(PerModuleBundleTask $this) {
        return $this.abiFilters;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0002H\u0016J\u0018\u0010\u0013\u001a\u00020\u00112\u000e\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u0015H\u0016R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0016"}, d2={"Lcom/android/build/gradle/internal/tasks/PerModuleBundleTask$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/PerModuleBundleTask;", "variantScope", "Lcom/android/build/gradle/internal/scope/VariantScope;", "packageCustomClassDependencies", "", "(Lcom/android/build/gradle/internal/scope/VariantScope;Z)V", "name", "", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "handleProvider", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "gradle"})
    public static final class CreationAction
    extends VariantTaskCreationAction<PerModuleBundleTask> {
        private final boolean packageCustomClassDependencies;

        @Override
        @NotNull
        public String getName() {
            String string = this.getVariantScope().getTaskName("build", "PreBundle");
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"variantScope.getTaskName(\"build\", \"PreBundle\")");
            return string;
        }

        @Override
        @NotNull
        public Class<PerModuleBundleTask> getType() {
            return PerModuleBundleTask.class;
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<? extends PerModuleBundleTask> taskProvider) {
            Intrinsics.checkParameterIsNotNull(taskProvider, (String)"taskProvider");
            super.handleProvider(taskProvider);
            BuildArtifactsHolder.producesDir$default(this.getVariantScope().getArtifacts(), InternalArtifactType.MODULE_BUNDLE.INSTANCE, taskProvider, (Function1)PerModuleBundleTask$CreationAction$handleProvider$1.INSTANCE, null, 8, null);
        }

        @Override
        public void configure(@NotNull PerModuleBundleTask task) {
            FileCollection fileCollection2;
            FileCollection fileCollection3;
            Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
            super.configure((Task)task);
            BuildArtifactsHolder buildArtifactsHolder = this.getVariantScope().getArtifacts();
            Intrinsics.checkExpressionValueIsNotNull((Object)buildArtifactsHolder, (String)"variantScope.artifacts");
            BuildArtifactsHolder artifacts2 = buildArtifactsHolder;
            if (this.getVariantScope().getType().isBaseModule()) {
                task.getFileName().set((Object)"base.zip");
            } else {
                task.getFileName().set(this.getVariantScope().getFeatureName().map((Transformer)configure.1.INSTANCE));
            }
            task.getFileName().disallowChanges();
            artifacts2.setTaskInputToFinalProduct((ArtifactType)InternalArtifactType.MERGED_ASSETS.INSTANCE, (Property)task.getAssetsFiles());
            task.getResFiles().set(this.getVariantScope().useResourceShrinker() ? artifacts2.getOperations().get((ArtifactType)InternalArtifactType.SHRUNK_LINKED_RES_FOR_BUNDLE.INSTANCE) : artifacts2.getOperations().get((ArtifactType)InternalArtifactType.LINKED_RES_FOR_BUNDLE.INSTANCE));
            task.getResFiles().disallowChanges();
            if (this.getVariantScope().getArtifacts().hasFinalProduct((ArtifactType)InternalArtifactType.BASE_DEX.INSTANCE)) {
                fileCollection3 = (FileCollection)this.getVariantScope().getArtifacts().getFinalProductAsFileCollection((ArtifactType)InternalArtifactType.BASE_DEX.INSTANCE).get();
            } else if (this.getVariantScope().getArtifacts().hasFinalProducts((ArtifactType)MultipleArtifactType.DEX.INSTANCE)) {
                GlobalScope globalScope = this.getVariantScope().getGlobalScope();
                Intrinsics.checkExpressionValueIsNotNull((Object)globalScope, (String)"variantScope.globalScope");
                fileCollection3 = (FileCollection)globalScope.getProject().files(new Object[]{this.getVariantScope().getArtifacts().getOperations().getAll((ArtifactType)MultipleArtifactType.DEX.INSTANCE)});
            } else {
                fileCollection3 = this.getVariantScope().getTransformManager().getPipelineOutputAsFileCollection(StreamFilter.DEX);
            }
            FileCollection programDexFiles = fileCollection3;
            FileCollection desugarLibDexFile = this.getVariantScope().getArtifacts().hasFinalProduct((ArtifactType)InternalArtifactType.DESUGAR_LIB_DEX.INSTANCE) ? (FileCollection)this.getVariantScope().getArtifacts().getFinalProductAsFileCollection((ArtifactType)InternalArtifactType.DESUGAR_LIB_DEX.INSTANCE).get() : DesugarLibUtils.getDesugarLibDexFromTransform(this.getVariantScope());
            task.getDexFiles().from(new Object[]{programDexFiles.plus(desugarLibDexFile)});
            ConfigurableFileCollection configurableFileCollection = task.getFeatureDexFiles();
            Object[] objectArray = new Object[1];
            VariantScope variantScope = this.getVariantScope();
            GlobalScope globalScope = this.getVariantScope().getGlobalScope();
            Intrinsics.checkExpressionValueIsNotNull((Object)globalScope, (String)"variantScope.globalScope");
            Project project2 = globalScope.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"variantScope.globalScope.project");
            objectArray[0] = variantScope.getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.PROJECT, AndroidArtifacts.ArtifactType.FEATURE_DEX, MapsKt.mapOf((Pair)TuplesKt.to(AndroidArtifacts.MODULE_PATH, (Object)project2.getPath())));
            configurableFileCollection.from(objectArray);
            ConfigurableFileCollection configurableFileCollection2 = task.getJavaResFiles();
            Object[] objectArray2 = new Object[1];
            if (this.getVariantScope().getArtifacts().hasFinalProduct((ArtifactType)InternalArtifactType.SHRUNK_JAVA_RES.INSTANCE)) {
                GlobalScope globalScope2 = this.getVariantScope().getGlobalScope();
                Intrinsics.checkExpressionValueIsNotNull((Object)globalScope2, (String)"variantScope.globalScope");
                Project project3 = globalScope2.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project3, (String)"variantScope.globalScope.project");
                fileCollection2 = project3.getLayout().files(new Object[]{artifacts2.getFinalProduct((ArtifactType)InternalArtifactType.SHRUNK_JAVA_RES.INSTANCE)});
            } else if (this.getVariantScope().getNeedsMergedJavaResStream()) {
                fileCollection2 = this.getVariantScope().getTransformManager().getPipelineOutputAsFileCollection(StreamFilter.RESOURCES);
            } else {
                GlobalScope globalScope3 = this.getVariantScope().getGlobalScope();
                Intrinsics.checkExpressionValueIsNotNull((Object)globalScope3, (String)"variantScope.globalScope");
                Project project4 = globalScope3.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project4, (String)"variantScope.globalScope.project");
                fileCollection2 = project4.getLayout().files(new Object[]{artifacts2.getFinalProduct((ArtifactType)InternalArtifactType.MERGED_JAVA_RES.INSTANCE)});
            }
            objectArray2[0] = fileCollection2;
            configurableFileCollection2.from(objectArray2);
            task.getNativeLibsFiles().from(new Object[]{PerModuleBundleTaskKt.getNativeLibsFiles(this.getVariantScope(), this.packageCustomClassDependencies)});
            GradleVariantConfiguration gradleVariantConfiguration = this.getVariantScope().getVariantConfiguration();
            Intrinsics.checkExpressionValueIsNotNull((Object)gradleVariantConfiguration, (String)"variantScope.variantConfiguration");
            task.abiFilters = gradleVariantConfiguration.getSupportedAbis();
            task.getJarCreatorType().set((Object)this.getVariantScope().getJarCreatorType());
            task.getJarCreatorType().disallowChanges();
        }

        public CreationAction(@NotNull VariantScope variantScope, boolean packageCustomClassDependencies) {
            Intrinsics.checkParameterIsNotNull((Object)variantScope, (String)"variantScope");
            super(variantScope);
            this.packageCustomClassDependencies = packageCustomClassDependencies;
        }
    }
}

