/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.errors;

import com.android.ide.common.blame.Message;
import com.android.ide.common.blame.SourceFilePosition;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000\u000e\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u00a8\u0006\u0004"}, d2={"humanReadableMessage", "", "message", "Lcom/android/ide/common/blame/Message;", "gradle"})
public final class MessageReceiverImplKt {
    @NotNull
    public static final String humanReadableMessage(@NotNull Message message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        StringBuilder errorStringBuilder = new StringBuilder();
        List positions = message.getSourceFilePositions();
        if (positions.size() != 1 || Intrinsics.areEqual((Object)SourceFilePosition.UNKNOWN, (Object)((SourceFilePosition)Iterables.getOnlyElement((Iterable)positions))) ^ true) {
            errorStringBuilder.append(Joiner.on((char)' ').join((Iterable)positions));
        }
        CharSequence charSequence = errorStringBuilder;
        boolean bl = false;
        if (charSequence.length() > 0) {
            errorStringBuilder.append(": ");
        }
        if (message.getToolName() != null) {
            errorStringBuilder.append(message.getToolName()).append(": ");
        }
        errorStringBuilder.append(message.getText());
        String rawMessage = message.getRawMessage();
        if (Intrinsics.areEqual((Object)message.getText(), (Object)message.getRawMessage()) ^ true) {
            String separator = System.lineSeparator();
            StringBuilder stringBuilder = errorStringBuilder.append("\n    ");
            String string = separator;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"separator");
            stringBuilder.append(StringsKt.replace$default((String)rawMessage, (String)string, (String)(separator + "    "), (boolean)false, (int)4, null));
        }
        String string = errorStringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"errorStringBuilder.toString()");
        return string;
    }
}

