/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.api.artifact.ArtifactType;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.dsl.CoreBuildType;
import com.android.build.gradle.internal.errors.MessageReceiverImpl;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.BuildArtifactsHolder;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.DexFileDependenciesTask;
import com.android.build.gradle.internal.tasks.DexFileDependenciesTask$CreationAction$handleProvider$1;
import com.android.build.gradle.internal.tasks.DexFileDependenciesTask$CreationAction$handleProvider$2;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.utils.DesugarLibUtils;
import com.android.build.gradle.options.SyncOptions;
import com.android.builder.dexing.ClassFileInput;
import com.android.builder.dexing.ClassFileInputs;
import com.android.builder.dexing.DexArchiveBuilder;
import com.android.builder.dexing.DexParameters;
import com.android.builder.dexing.r8.ClassFileProviderFactory;
import com.android.ide.common.blame.MessageReceiver;
import com.android.ide.common.workers.WorkerExecutorFacade;
import com.android.sdklib.AndroidVersion;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.stream.Stream;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.logging.Logging;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.CompileClasspath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001:\u0003$%&B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\"\u001a\u00020#H\u0014R\u0013\u0010\u0005\u001a\u00020\u00068G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\t\u001a\u00020\u00068G\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0013\u0010\u000b\u001a\u00020\u00068G\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\bR\u0019\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082.\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u000e8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0011R\u0019\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u000e8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0011R\u0013\u0010\u001a\u001a\u00020\u001b8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0013\u0010\u001e\u001a\u00020\u001f8G\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!\u00a8\u0006'"}, d2={"Lcom/android/build/gradle/internal/tasks/DexFileDependenciesTask;", "Lcom/android/build/gradle/internal/tasks/NonIncrementalTask;", "objectFactory", "Lorg/gradle/api/model/ObjectFactory;", "(Lorg/gradle/api/model/ObjectFactory;)V", "bootClasspath", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getBootClasspath", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "classes", "getClasses", "classpath", "getClasspath", "debuggable", "Lorg/gradle/api/provider/Property;", "", "getDebuggable", "()Lorg/gradle/api/provider/Property;", "errorFormatMode", "Lcom/android/build/gradle/options/SyncOptions$ErrorFormatMode;", "libConfiguration", "", "getLibConfiguration", "minSdkVersion", "", "getMinSdkVersion", "outputDirectory", "Lorg/gradle/api/file/DirectoryProperty;", "getOutputDirectory", "()Lorg/gradle/api/file/DirectoryProperty;", "outputKeepRules", "Lorg/gradle/api/file/RegularFileProperty;", "getOutputKeepRules", "()Lorg/gradle/api/file/RegularFileProperty;", "doTaskAction", "", "CreationAction", "DexFileDependenciesWorkerAction", "DexFileDependenciesWorkerActionParams", "gradle"})
public abstract class DexFileDependenciesTask
extends NonIncrementalTask {
    @NotNull
    private final DirectoryProperty outputDirectory;
    @NotNull
    private final RegularFileProperty outputKeepRules;
    @NotNull
    private final ConfigurableFileCollection classes;
    @NotNull
    private final ConfigurableFileCollection classpath;
    @NotNull
    private final ConfigurableFileCollection bootClasspath;
    @NotNull
    private final Property<Integer> minSdkVersion;
    @NotNull
    private final Property<Boolean> debuggable;
    @NotNull
    private final Property<String> libConfiguration;
    private SyncOptions.ErrorFormatMode errorFormatMode;

    @OutputDirectory
    @NotNull
    public final DirectoryProperty getOutputDirectory() {
        return this.outputDirectory;
    }

    @Optional
    @OutputFile
    @NotNull
    public final RegularFileProperty getOutputKeepRules() {
        return this.outputKeepRules;
    }

    @Classpath
    @NotNull
    public final ConfigurableFileCollection getClasses() {
        return this.classes;
    }

    @CompileClasspath
    @NotNull
    public final ConfigurableFileCollection getClasspath() {
        return this.classpath;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    @NotNull
    public final ConfigurableFileCollection getBootClasspath() {
        return this.bootClasspath;
    }

    @Input
    @NotNull
    public final Property<Integer> getMinSdkVersion() {
        return this.minSdkVersion;
    }

    @Input
    @NotNull
    public final Property<Boolean> getDebuggable() {
        return this.debuggable;
    }

    @Optional
    @Input
    @NotNull
    public final Property<String> getLibConfiguration() {
        return this.libConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    protected void doTaskAction() {
        Closeable closeable = (Closeable)this.getWorkerFacadeWithWorkers();
        boolean bl = false;
        Throwable throwable = null;
        try {
            WorkerExecutorFacade workerExecutorFacade = (WorkerExecutorFacade)closeable;
            boolean bl2 = false;
            Set set = this.classes.getFiles();
            Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"classes.files");
            List inputs = CollectionsKt.toList((Iterable)set);
            Collection collection = inputs;
            Set set2 = this.classpath.getFiles();
            Intrinsics.checkExpressionValueIsNotNull((Object)set2, (String)"classpath.files");
            List totalClasspath = CollectionsKt.plus((Collection)collection, (Iterable)set2);
            Object object = this.outputDirectory.get();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"outputDirectory.get()");
            File outDir = ((Directory)object).getAsFile();
            Iterable $this$forEachIndexed$iv = inputs;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void input;
                int n = index$iv++;
                boolean bl3 = false;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                int n2 = n;
                File file = (File)item$iv;
                int index = n2;
                boolean bl4 = false;
                Object object2 = this.minSdkVersion.get();
                Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"minSdkVersion.get()");
                int n3 = ((Number)object2).intValue();
                Object object3 = this.debuggable.get();
                Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"debuggable.get()");
                boolean bl5 = (Boolean)object3;
                Set set3 = this.bootClasspath.getFiles();
                Intrinsics.checkExpressionValueIsNotNull((Object)set3, (String)"bootClasspath.files");
                Collection collection2 = set3;
                Collection collection3 = totalClasspath;
                void v11 = input;
                Intrinsics.checkExpressionValueIsNotNull((Object)v11, (String)"input");
                File file2 = outDir;
                Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"outDir");
                File file3 = FilesKt.resolve((File)file2, (String)("" + index + '_' + input.getName()));
                SyncOptions.ErrorFormatMode errorFormatMode = this.errorFormatMode;
                if (errorFormatMode == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"errorFormatMode");
                }
                String string = (String)this.libConfiguration.getOrNull();
                Provider provider = this.outputKeepRules.getAsFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)provider, (String)"outputKeepRules.asFile");
                workerExecutorFacade.submit(DexFileDependenciesWorkerAction.class, (Serializable)new DexFileDependenciesWorkerActionParams(n3, bl5, collection2, collection3, (File)v11, file3, errorFormatMode, string, (File)provider.getOrNull()));
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @Inject
    public DexFileDependenciesTask(@NotNull ObjectFactory objectFactory) {
        Intrinsics.checkParameterIsNotNull((Object)objectFactory, (String)"objectFactory");
        DirectoryProperty directoryProperty = objectFactory.directoryProperty();
        Intrinsics.checkExpressionValueIsNotNull((Object)directoryProperty, (String)"objectFactory.directoryProperty()");
        this.outputDirectory = directoryProperty;
        RegularFileProperty regularFileProperty = objectFactory.fileProperty();
        Intrinsics.checkExpressionValueIsNotNull((Object)regularFileProperty, (String)"objectFactory.fileProperty()");
        this.outputKeepRules = regularFileProperty;
        ConfigurableFileCollection configurableFileCollection = objectFactory.fileCollection();
        Intrinsics.checkExpressionValueIsNotNull((Object)configurableFileCollection, (String)"objectFactory.fileCollection()");
        this.classes = configurableFileCollection;
        ConfigurableFileCollection configurableFileCollection2 = objectFactory.fileCollection();
        Intrinsics.checkExpressionValueIsNotNull((Object)configurableFileCollection2, (String)"objectFactory.fileCollection()");
        this.classpath = configurableFileCollection2;
        ConfigurableFileCollection configurableFileCollection3 = objectFactory.fileCollection();
        Intrinsics.checkExpressionValueIsNotNull((Object)configurableFileCollection3, (String)"objectFactory.fileCollection()");
        this.bootClasspath = configurableFileCollection3;
        Property property = objectFactory.property(Integer.TYPE);
        Intrinsics.checkExpressionValueIsNotNull((Object)property, (String)"objectFactory.property(Int::class.java)");
        this.minSdkVersion = property;
        Property property2 = objectFactory.property(Boolean.TYPE);
        Intrinsics.checkExpressionValueIsNotNull((Object)property2, (String)"objectFactory.property(Boolean::class.java)");
        this.debuggable = property2;
        Property property3 = objectFactory.property(String.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)property3, (String)"objectFactory.property(String::class.java)");
        this.libConfiguration = property3;
    }

    public static final /* synthetic */ SyncOptions.ErrorFormatMode access$getErrorFormatMode$p(DexFileDependenciesTask $this) {
        SyncOptions.ErrorFormatMode errorFormatMode = $this.errorFormatMode;
        if (errorFormatMode == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"errorFormatMode");
        }
        return errorFormatMode;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u001d\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B]\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\n\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u0012\b\u0010\u0010\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\u0011J\t\u0010!\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\"\u001a\u00020\u0005H\u00c6\u0003J\u000f\u0010#\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J\u000f\u0010$\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J\t\u0010%\u001a\u00020\bH\u00c6\u0003J\t\u0010&\u001a\u00020\bH\u00c6\u0003J\t\u0010'\u001a\u00020\rH\u00c6\u0003J\u000b\u0010(\u001a\u0004\u0018\u00010\u000fH\u00c6\u0003J\u000b\u0010)\u001a\u0004\u0018\u00010\bH\u00c6\u0003Js\u0010*\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\b\b\u0002\u0010\n\u001a\u00020\b2\b\b\u0002\u0010\u000b\u001a\u00020\b2\b\b\u0002\u0010\f\u001a\u00020\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\bH\u00c6\u0001J\u0013\u0010+\u001a\u00020\u00052\b\u0010,\u001a\u0004\u0018\u00010-H\u00d6\u0003J\t\u0010.\u001a\u00020\u0003H\u00d6\u0001J\t\u0010/\u001a\u00020\u000fH\u00d6\u0001R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\n\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u000b\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001aR\u0013\u0010\u0010\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001a\u00a8\u00060"}, d2={"Lcom/android/build/gradle/internal/tasks/DexFileDependenciesTask$DexFileDependenciesWorkerActionParams;", "Ljava/io/Serializable;", "minSdkVersion", "", "debuggable", "", "bootClasspath", "", "Ljava/io/File;", "classpath", "input", "outputFile", "errorFormatMode", "Lcom/android/build/gradle/options/SyncOptions$ErrorFormatMode;", "libConfiguration", "", "outputKeepRules", "(IZLjava/util/Collection;Ljava/util/Collection;Ljava/io/File;Ljava/io/File;Lcom/android/build/gradle/options/SyncOptions$ErrorFormatMode;Ljava/lang/String;Ljava/io/File;)V", "getBootClasspath", "()Ljava/util/Collection;", "getClasspath", "getDebuggable", "()Z", "getErrorFormatMode", "()Lcom/android/build/gradle/options/SyncOptions$ErrorFormatMode;", "getInput", "()Ljava/io/File;", "getLibConfiguration", "()Ljava/lang/String;", "getMinSdkVersion", "()I", "getOutputFile", "getOutputKeepRules", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "other", "", "hashCode", "toString", "gradle"})
    public static final class DexFileDependenciesWorkerActionParams
    implements Serializable {
        private final int minSdkVersion;
        private final boolean debuggable;
        @NotNull
        private final Collection<File> bootClasspath;
        @NotNull
        private final Collection<File> classpath;
        @NotNull
        private final File input;
        @NotNull
        private final File outputFile;
        @NotNull
        private final SyncOptions.ErrorFormatMode errorFormatMode;
        @Nullable
        private final String libConfiguration;
        @Nullable
        private final File outputKeepRules;

        public final int getMinSdkVersion() {
            return this.minSdkVersion;
        }

        public final boolean getDebuggable() {
            return this.debuggable;
        }

        @NotNull
        public final Collection<File> getBootClasspath() {
            return this.bootClasspath;
        }

        @NotNull
        public final Collection<File> getClasspath() {
            return this.classpath;
        }

        @NotNull
        public final File getInput() {
            return this.input;
        }

        @NotNull
        public final File getOutputFile() {
            return this.outputFile;
        }

        @NotNull
        public final SyncOptions.ErrorFormatMode getErrorFormatMode() {
            return this.errorFormatMode;
        }

        @Nullable
        public final String getLibConfiguration() {
            return this.libConfiguration;
        }

        @Nullable
        public final File getOutputKeepRules() {
            return this.outputKeepRules;
        }

        public DexFileDependenciesWorkerActionParams(int minSdkVersion, boolean debuggable, @NotNull Collection<? extends File> bootClasspath2, @NotNull Collection<? extends File> classpath, @NotNull File input, @NotNull File outputFile, @NotNull SyncOptions.ErrorFormatMode errorFormatMode, @Nullable String libConfiguration, @Nullable File outputKeepRules) {
            Intrinsics.checkParameterIsNotNull(bootClasspath2, (String)"bootClasspath");
            Intrinsics.checkParameterIsNotNull(classpath, (String)"classpath");
            Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
            Intrinsics.checkParameterIsNotNull((Object)outputFile, (String)"outputFile");
            Intrinsics.checkParameterIsNotNull((Object)((Object)errorFormatMode), (String)"errorFormatMode");
            this.minSdkVersion = minSdkVersion;
            this.debuggable = debuggable;
            this.bootClasspath = bootClasspath2;
            this.classpath = classpath;
            this.input = input;
            this.outputFile = outputFile;
            this.errorFormatMode = errorFormatMode;
            this.libConfiguration = libConfiguration;
            this.outputKeepRules = outputKeepRules;
        }

        public final int component1() {
            return this.minSdkVersion;
        }

        public final boolean component2() {
            return this.debuggable;
        }

        @NotNull
        public final Collection<File> component3() {
            return this.bootClasspath;
        }

        @NotNull
        public final Collection<File> component4() {
            return this.classpath;
        }

        @NotNull
        public final File component5() {
            return this.input;
        }

        @NotNull
        public final File component6() {
            return this.outputFile;
        }

        @NotNull
        public final SyncOptions.ErrorFormatMode component7() {
            return this.errorFormatMode;
        }

        @Nullable
        public final String component8() {
            return this.libConfiguration;
        }

        @Nullable
        public final File component9() {
            return this.outputKeepRules;
        }

        @NotNull
        public final DexFileDependenciesWorkerActionParams copy(int minSdkVersion, boolean debuggable, @NotNull Collection<? extends File> bootClasspath2, @NotNull Collection<? extends File> classpath, @NotNull File input, @NotNull File outputFile, @NotNull SyncOptions.ErrorFormatMode errorFormatMode, @Nullable String libConfiguration, @Nullable File outputKeepRules) {
            Intrinsics.checkParameterIsNotNull(bootClasspath2, (String)"bootClasspath");
            Intrinsics.checkParameterIsNotNull(classpath, (String)"classpath");
            Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
            Intrinsics.checkParameterIsNotNull((Object)outputFile, (String)"outputFile");
            Intrinsics.checkParameterIsNotNull((Object)((Object)errorFormatMode), (String)"errorFormatMode");
            return new DexFileDependenciesWorkerActionParams(minSdkVersion, debuggable, bootClasspath2, classpath, input, outputFile, errorFormatMode, libConfiguration, outputKeepRules);
        }

        public static /* synthetic */ DexFileDependenciesWorkerActionParams copy$default(DexFileDependenciesWorkerActionParams dexFileDependenciesWorkerActionParams, int n, boolean bl, Collection collection, Collection collection2, File file, File file2, SyncOptions.ErrorFormatMode errorFormatMode, String string, File file3, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = dexFileDependenciesWorkerActionParams.minSdkVersion;
            }
            if ((n2 & 2) != 0) {
                bl = dexFileDependenciesWorkerActionParams.debuggable;
            }
            if ((n2 & 4) != 0) {
                collection = dexFileDependenciesWorkerActionParams.bootClasspath;
            }
            if ((n2 & 8) != 0) {
                collection2 = dexFileDependenciesWorkerActionParams.classpath;
            }
            if ((n2 & 0x10) != 0) {
                file = dexFileDependenciesWorkerActionParams.input;
            }
            if ((n2 & 0x20) != 0) {
                file2 = dexFileDependenciesWorkerActionParams.outputFile;
            }
            if ((n2 & 0x40) != 0) {
                errorFormatMode = dexFileDependenciesWorkerActionParams.errorFormatMode;
            }
            if ((n2 & 0x80) != 0) {
                string = dexFileDependenciesWorkerActionParams.libConfiguration;
            }
            if ((n2 & 0x100) != 0) {
                file3 = dexFileDependenciesWorkerActionParams.outputKeepRules;
            }
            return dexFileDependenciesWorkerActionParams.copy(n, bl, collection, collection2, file, file2, errorFormatMode, string, file3);
        }

        @NotNull
        public String toString() {
            return "DexFileDependenciesWorkerActionParams(minSdkVersion=" + this.minSdkVersion + ", debuggable=" + this.debuggable + ", bootClasspath=" + this.bootClasspath + ", classpath=" + this.classpath + ", input=" + this.input + ", outputFile=" + this.outputFile + ", errorFormatMode=" + (Object)((Object)this.errorFormatMode) + ", libConfiguration=" + this.libConfiguration + ", outputKeepRules=" + this.outputKeepRules + ")";
        }

        public int hashCode() {
            int n = Integer.hashCode(this.minSdkVersion) * 31;
            int n2 = this.debuggable ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            Collection<File> collection = this.bootClasspath;
            Collection<File> collection2 = this.classpath;
            File file = this.input;
            File file2 = this.outputFile;
            SyncOptions.ErrorFormatMode errorFormatMode = this.errorFormatMode;
            String string = this.libConfiguration;
            File file3 = this.outputKeepRules;
            return (((((((n + n2) * 31 + (collection != null ? ((Object)collection).hashCode() : 0)) * 31 + (collection2 != null ? ((Object)collection2).hashCode() : 0)) * 31 + (file != null ? ((Object)file).hashCode() : 0)) * 31 + (file2 != null ? ((Object)file2).hashCode() : 0)) * 31 + (errorFormatMode != null ? ((Object)((Object)errorFormatMode)).hashCode() : 0)) * 31 + (string != null ? string.hashCode() : 0)) * 31 + (file3 != null ? ((Object)file3).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof DexFileDependenciesWorkerActionParams)) break block3;
                    DexFileDependenciesWorkerActionParams dexFileDependenciesWorkerActionParams = (DexFileDependenciesWorkerActionParams)object;
                    if (this.minSdkVersion != dexFileDependenciesWorkerActionParams.minSdkVersion || this.debuggable != dexFileDependenciesWorkerActionParams.debuggable || !Intrinsics.areEqual(this.bootClasspath, dexFileDependenciesWorkerActionParams.bootClasspath) || !Intrinsics.areEqual(this.classpath, dexFileDependenciesWorkerActionParams.classpath) || !Intrinsics.areEqual((Object)this.input, (Object)dexFileDependenciesWorkerActionParams.input) || !Intrinsics.areEqual((Object)this.outputFile, (Object)dexFileDependenciesWorkerActionParams.outputFile) || !Intrinsics.areEqual((Object)((Object)this.errorFormatMode), (Object)((Object)dexFileDependenciesWorkerActionParams.errorFormatMode)) || !Intrinsics.areEqual((Object)this.libConfiguration, (Object)dexFileDependenciesWorkerActionParams.libConfiguration) || !Intrinsics.areEqual((Object)this.outputKeepRules, (Object)dexFileDependenciesWorkerActionParams.outputKeepRules)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/android/build/gradle/internal/tasks/DexFileDependenciesTask$DexFileDependenciesWorkerAction;", "Ljava/lang/Runnable;", "params", "Lcom/android/build/gradle/internal/tasks/DexFileDependenciesTask$DexFileDependenciesWorkerActionParams;", "(Lcom/android/build/gradle/internal/tasks/DexFileDependenciesTask$DexFileDependenciesWorkerActionParams;)V", "run", "", "gradle"})
    public static final class DexFileDependenciesWorkerAction
    implements Runnable {
        private final DexFileDependenciesWorkerActionParams params;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void run() {
            void $this$mapTo$iv$iv;
            Path path;
            Collection collection;
            void $this$mapTo$iv$iv2;
            Iterable $this$map$iv = this.params.getBootClasspath();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void p1;
                File file = (File)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                path = p1.toPath();
                collection.add(path);
            }
            List bootClasspath2 = (List)destination$iv$iv;
            Iterable $this$map$iv2 = this.params.getClasspath();
            boolean $i$f$map2 = false;
            destination$iv$iv = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p1;
                File bl = (File)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl2 = false;
                path = p1.toPath();
                collection.add(path);
            }
            List classpath = (List)destination$iv$iv2;
            Closeable closeable = (Closeable)Closer.create();
            boolean bl = false;
            Throwable throwable = null;
            try {
                Closer closer = (Closer)closeable;
                boolean bl3 = false;
                Object object = new ClassFileProviderFactory((Collection)bootClasspath2);
                boolean bl4 = true;
                boolean bl5 = false;
                boolean bl6 = this.params.getDebuggable();
                int n = this.params.getMinSdkVersion();
                boolean bl7 = false;
                boolean bl8 = false;
                ClassFileProviderFactory it = object;
                boolean bl9 = false;
                closer.register((Closeable)it);
                ClassFileProviderFactory classFileProviderFactory = object;
                object = new ClassFileProviderFactory((Collection)classpath);
                bl7 = false;
                bl8 = false;
                it = object;
                boolean bl10 = false;
                closer.register((Closeable)it);
                ClassFileProviderFactory classFileProviderFactory2 = object;
                String string = this.params.getLibConfiguration();
                File file = this.params.getOutputKeepRules();
                SyncOptions.ErrorFormatMode errorFormatMode = this.params.getErrorFormatMode();
                org.gradle.api.logging.Logger logger = Logging.getLogger(DexFileDependenciesWorkerAction.class);
                Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logging.getLogger(DexFil\u2026WorkerAction::class.java)");
                MessageReceiver messageReceiver = new MessageReceiverImpl(errorFormatMode, (Logger)logger);
                File file2 = file;
                String string2 = string;
                ClassFileProviderFactory classFileProviderFactory3 = classFileProviderFactory2;
                ClassFileProviderFactory classFileProviderFactory4 = classFileProviderFactory;
                boolean bl11 = bl4;
                boolean bl12 = bl5;
                boolean bl13 = bl6;
                int n2 = n;
                DexArchiveBuilder d8DexBuilder = DexArchiveBuilder.createD8DexBuilder((DexParameters)new DexParameters(n2, bl13, bl12, bl11, classFileProviderFactory4, classFileProviderFactory3, string2, file2, messageReceiver));
                object = (Closeable)ClassFileInputs.fromPath((Path)this.params.getInput().toPath());
                bl7 = false;
                Throwable throwable2 = null;
                try {
                    ClassFileInput classFileInput = (ClassFileInput)object;
                    boolean bl14 = false;
                    AutoCloseable autoCloseable = classFileInput.entries((BiPredicate)run.1.1.1.INSTANCE);
                    boolean bl15 = false;
                    Throwable throwable3 = null;
                    try {
                        Stream classesInput = (Stream)autoCloseable;
                        boolean bl16 = false;
                        d8DexBuilder.convert(classesInput, this.params.getOutputFile().toPath());
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable4) {
                        throwable3 = throwable4;
                        throw throwable4;
                    }
                    finally {
                        AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable3);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable5) {
                    throwable2 = throwable5;
                    throw throwable5;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable2);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable6) {
                throwable = throwable6;
                throw throwable6;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }

        @Inject
        public DexFileDependenciesWorkerAction(@NotNull DexFileDependenciesWorkerActionParams params) {
            Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
            this.params = params;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\u0018\u0010\u0011\u001a\u00020\u000f2\u000e\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u0013H\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0014"}, d2={"Lcom/android/build/gradle/internal/tasks/DexFileDependenciesTask$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/DexFileDependenciesTask;", "variantScope", "Lcom/android/build/gradle/internal/scope/VariantScope;", "(Lcom/android/build/gradle/internal/scope/VariantScope;)V", "name", "", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "handleProvider", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "gradle"})
    public static final class CreationAction
    extends VariantTaskCreationAction<DexFileDependenciesTask> {
        @NotNull
        private final String name;
        @NotNull
        private final Class<DexFileDependenciesTask> type;

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        @NotNull
        public Class<DexFileDependenciesTask> getType() {
            return this.type;
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<? extends DexFileDependenciesTask> taskProvider) {
            Intrinsics.checkParameterIsNotNull(taskProvider, (String)"taskProvider");
            super.handleProvider(taskProvider);
            BuildArtifactsHolder.producesDir$default(this.getVariantScope().getArtifacts(), InternalArtifactType.EXTERNAL_FILE_LIB_DEX_ARCHIVES.INSTANCE, taskProvider, (Function1)DexFileDependenciesTask$CreationAction$handleProvider$1.INSTANCE, null, "out", 8, null);
            if (this.getVariantScope().getNeedsShrinkDesugarLibrary()) {
                this.getVariantScope().getArtifacts().getOperations().setInitialProvider$gradle(taskProvider, (Function1)DexFileDependenciesTask$CreationAction$handleProvider$2.INSTANCE).on((ArtifactType)InternalArtifactType.DESUGAR_LIB_EXTERNAL_FILE_LIB_KEEP_RULES.INSTANCE);
            }
        }

        @Override
        public void configure(@NotNull DexFileDependenciesTask task) {
            Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
            super.configure((Task)task);
            Property<Boolean> property = task.getDebuggable();
            GradleVariantConfiguration gradleVariantConfiguration = this.getVariantScope().getVariantConfiguration();
            Intrinsics.checkExpressionValueIsNotNull((Object)gradleVariantConfiguration, (String)"variantScope.variantConfiguration");
            CoreBuildType coreBuildType = (CoreBuildType)gradleVariantConfiguration.getBuildType();
            Intrinsics.checkExpressionValueIsNotNull((Object)coreBuildType, (String)"variantScope.variantConfiguration.buildType");
            property.set((Object)coreBuildType.isDebuggable());
            task.getClasses().from(new Object[]{this.getVariantScope().getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.FILE, AndroidArtifacts.ArtifactType.PROCESSED_JAR)});
            GradleVariantConfiguration gradleVariantConfiguration2 = this.getVariantScope().getVariantConfiguration();
            Intrinsics.checkExpressionValueIsNotNull((Object)gradleVariantConfiguration2, (String)"variantScope.variantConfiguration");
            AndroidVersion androidVersion = gradleVariantConfiguration2.getMinSdkVersionWithTargetDeviceApi();
            Intrinsics.checkExpressionValueIsNotNull((Object)androidVersion, (String)"variantScope.variantConf\u2026ersionWithTargetDeviceApi");
            int minSdkVersion = androidVersion.getFeatureLevel();
            task.getMinSdkVersion().set((Object)minSdkVersion);
            if (minSdkVersion < 24) {
                task.getClasspath().from(new Object[]{this.getVariantScope().getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.REPOSITORY_MODULE, AndroidArtifacts.ArtifactType.PROCESSED_JAR)});
                ConfigurableFileCollection configurableFileCollection = task.getBootClasspath();
                Object[] objectArray = new Object[1];
                GlobalScope globalScope = this.getVariantScope().getGlobalScope();
                Intrinsics.checkExpressionValueIsNotNull((Object)globalScope, (String)"variantScope.globalScope");
                objectArray[0] = globalScope.getBootClasspath();
                configurableFileCollection.from(objectArray);
            }
            GlobalScope globalScope = this.getVariantScope().getGlobalScope();
            Intrinsics.checkExpressionValueIsNotNull((Object)globalScope, (String)"variantScope.globalScope");
            SyncOptions.ErrorFormatMode errorFormatMode = SyncOptions.getErrorFormatMode(globalScope.getProjectOptions());
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)errorFormatMode), (String)"SyncOptions.getErrorForm\u2026obalScope.projectOptions)");
            task.errorFormatMode = errorFormatMode;
            if (this.getVariantScope().isCoreLibraryDesugaringEnabled()) {
                Property<String> property2 = task.getLibConfiguration();
                GlobalScope globalScope2 = this.getVariantScope().getGlobalScope();
                Intrinsics.checkExpressionValueIsNotNull((Object)globalScope2, (String)"variantScope.globalScope");
                Project project2 = globalScope2.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"variantScope.globalScope.project");
                property2.set(DesugarLibUtils.getDesugarLibConfig(project2));
            }
        }

        public CreationAction(@NotNull VariantScope variantScope) {
            Intrinsics.checkParameterIsNotNull((Object)variantScope, (String)"variantScope");
            super(variantScope);
            String string = variantScope.getTaskName("desugar", "FileDependencies");
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"variantScope.getTaskName\u2026gar\", \"FileDependencies\")");
            this.name = string;
            this.type = DexFileDependenciesTask.class;
        }
    }
}

