/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.api;

import com.android.build.FilterData;
import com.android.build.VariantOutput;
import com.android.build.api.variant.impl.VariantOutputImpl;
import com.android.build.gradle.api.ApkVariantOutput;
import com.android.build.gradle.internal.api.BaseVariantOutputImpl;
import com.android.build.gradle.internal.errors.DeprecationReporter;
import com.android.build.gradle.internal.scope.ApkData;
import com.android.build.gradle.internal.scope.TaskContainer;
import com.android.build.gradle.tasks.PackageAndroidArtifact;
import com.google.common.base.MoreObjects;
import java.io.File;
import javax.inject.Inject;
import org.gradle.api.Task;
import org.gradle.api.file.Directory;

public class ApkVariantOutputImpl
extends BaseVariantOutputImpl
implements ApkVariantOutput {
    @Inject
    public ApkVariantOutputImpl(ApkData apkData, TaskContainer taskContainer, DeprecationReporter deprecationReporter, VariantOutputImpl variantOutput) {
        super(apkData, taskContainer, deprecationReporter, variantOutput);
    }

    @Override
    public PackageAndroidArtifact getPackageApplication() {
        this.deprecationReporter.reportDeprecatedApi("variant.getPackageApplicationProvider()", "variantOutput.getPackageApplication()", "https://d.android.com/r/tools/task-configuration-avoidance", DeprecationReporter.DeprecationTarget.TASK_ACCESS_VIA_VARIANT);
        return (PackageAndroidArtifact)this.taskContainer.getPackageAndroidTask().getOrNull();
    }

    @Override
    public File getOutputFile() {
        PackageAndroidArtifact packageAndroidArtifact = (PackageAndroidArtifact)this.taskContainer.getPackageAndroidTask().getOrNull();
        if (packageAndroidArtifact != null) {
            return new File(((Directory)packageAndroidArtifact.getOutputDirectory().get()).getAsFile(), this.apkData.getOutputFileName());
        }
        return super.getOutputFile();
    }

    @Override
    public Task getZipAlign() {
        return this.getPackageApplication();
    }

    @Override
    public void setVersionCodeOverride(int versionCodeOverride) {
        this.variantOutput.getVersionCode().set((Object)versionCodeOverride);
    }

    @Override
    public int getVersionCodeOverride() {
        this.deprecationReporter.reportDeprecatedApi("VariantOutput.versionCode()", "ApkVariantOutput.getVersionCodeOverride()", "https://d.android.com/r/tools/use-properties", DeprecationReporter.DeprecationTarget.USE_PROPERTIES);
        return (Integer)this.variantOutput.getVersionCode().get();
    }

    @Override
    public void setVersionNameOverride(String versionNameOverride) {
        this.variantOutput.getVersionName().set((Object)versionNameOverride);
    }

    @Override
    public String getVersionNameOverride() {
        this.deprecationReporter.reportDeprecatedApi("VariantOutput.versionName()", "ApkVariantOutput.getVersionNameOverride()", "https://d.android.com/r/tools/use-properties", DeprecationReporter.DeprecationTarget.USE_PROPERTIES);
        return (String)this.variantOutput.getVersionName().getOrNull();
    }

    public int getVersionCode() {
        return this.apkData.getVersionCode();
    }

    @Override
    public String getFilter(VariantOutput.FilterType filterType2) {
        FilterData filterData = this.apkData.getFilter(filterType2);
        return filterData != null ? filterData.getIdentifier() : null;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("apkData", (Object)this.apkData).toString();
    }
}

