/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dsl;

import com.android.build.gradle.internal.api.dsl.DslScope;
import com.android.build.gradle.internal.dsl.CoreBuildType;
import com.android.build.gradle.internal.dsl.CoreNdkOptions;
import com.android.build.gradle.internal.dsl.CoreShaderOptions;
import com.android.build.gradle.internal.dsl.ExternalNativeBuildOptions;
import com.android.build.gradle.internal.dsl.JavaCompileOptions;
import com.android.build.gradle.internal.dsl.NdkOptions;
import com.android.build.gradle.internal.dsl.PostProcessingBlock;
import com.android.build.gradle.internal.dsl.ShaderOptions;
import com.android.build.gradle.internal.dsl.SigningConfig;
import com.android.build.gradle.internal.errors.DeprecationReporter;
import com.android.builder.core.AbstractBuildType;
import com.android.builder.errors.EvalIssueReporter;
import com.android.builder.internal.ClassFieldImpl;
import com.android.builder.model.BaseConfig;
import com.android.builder.model.ClassField;
import com.android.builder.model.CodeShrinker;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.Serializable;
import java.util.List;
import java.util.function.Supplier;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.Project;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Internal;

public class BuildType
extends AbstractBuildType
implements CoreBuildType,
Serializable,
com.android.build.api.dsl.BuildType {
    private static final long serialVersionUID = 1L;
    private static ThreadLocal<Boolean> dslChecksEnabled = ThreadLocal.withInitial(new Supplier<Boolean>(){

        @Override
        public Boolean get() {
            return true;
        }
    });
    private final Project project;
    private DslScope dslScope;
    private final NdkOptions ndkConfig;
    private final ExternalNativeBuildOptions externalNativeBuildOptions;
    private final JavaCompileOptions javaCompileOptions;
    private final ShaderOptions shaderOptions;
    private final PostProcessingBlock postProcessingBlock;
    private PostProcessingConfiguration postProcessingConfiguration;
    private String postProcessingDslMethodUsed;
    private boolean shrinkResources = false;
    private Boolean useProguard = false;
    private Boolean crunchPngs;
    private boolean isCrunchPngsDefault = true;
    private final Property<Boolean> isDefault;
    private ImmutableList<String> matchingFallbacks;

    @Inject
    public BuildType(String name2, Project project2, DslScope dslScope) {
        super(name2);
        this.project = project2;
        this.dslScope = dslScope;
        ObjectFactory objectFactory = dslScope.getObjectFactory();
        this.javaCompileOptions = (JavaCompileOptions)objectFactory.newInstance(JavaCompileOptions.class, new Object[]{objectFactory, dslScope.getDeprecationReporter()});
        this.shaderOptions = (ShaderOptions)objectFactory.newInstance(ShaderOptions.class, new Object[0]);
        this.ndkConfig = (NdkOptions)objectFactory.newInstance(NdkOptions.class, new Object[0]);
        this.externalNativeBuildOptions = (ExternalNativeBuildOptions)objectFactory.newInstance(ExternalNativeBuildOptions.class, new Object[]{objectFactory});
        this.postProcessingBlock = (PostProcessingBlock)objectFactory.newInstance(PostProcessingBlock.class, new Object[]{project2});
        this.isDefault = objectFactory.property(Boolean.class).convention((Object)false);
    }

    public void setMatchingFallbacks(String ... fallbacks) {
        this.matchingFallbacks = ImmutableList.copyOf((Object[])fallbacks);
    }

    public void setMatchingFallbacks(List<String> fallbacks) {
        this.matchingFallbacks = ImmutableList.copyOf(fallbacks);
    }

    public void setMatchingFallbacks(String fallback) {
        this.matchingFallbacks = ImmutableList.of((Object)fallback);
    }

    public List<String> getMatchingFallbacks() {
        if (this.matchingFallbacks == null) {
            return ImmutableList.of();
        }
        return this.matchingFallbacks;
    }

    @Override
    public CoreNdkOptions getNdkConfig() {
        return this.ndkConfig;
    }

    @Override
    public ExternalNativeBuildOptions getExternalNativeBuildOptions() {
        return this.externalNativeBuildOptions;
    }

    @Override
    public com.android.build.gradle.api.JavaCompileOptions getJavaCompileOptions() {
        return this.javaCompileOptions;
    }

    @Override
    public CoreShaderOptions getShaders() {
        return this.shaderOptions;
    }

    public void init(SigningConfig debugSigningConfig) {
        this.init();
        if ("debug".equals(this.getName())) {
            assert (debugSigningConfig != null);
            this.setSigningConfig((com.android.builder.model.SigningConfig)debugSigningConfig);
        }
    }

    public void init() {
        if ("debug".equals(this.getName())) {
            this.setDebuggable(true);
            this.setEmbedMicroApp(false);
            this.isCrunchPngsDefault = false;
        }
    }

    public SigningConfig getSigningConfig() {
        return (SigningConfig)super.getSigningConfig();
    }

    @Override
    public Property<Boolean> getIsDefault() {
        return this.isDefault;
    }

    protected void _initWith(BaseConfig that) {
        super._initWith(that);
        BuildType thatBuildType = (BuildType)that;
        this.ndkConfig._initWith(thatBuildType.getNdkConfig());
        this.javaCompileOptions.getAnnotationProcessorOptions()._initWith(thatBuildType.getJavaCompileOptions().getAnnotationProcessorOptions());
        this.shrinkResources = thatBuildType.isShrinkResources();
        this.shaderOptions._initWith(thatBuildType.getShaders());
        this.externalNativeBuildOptions._initWith(thatBuildType.getExternalNativeBuildOptions());
        this.useProguard = thatBuildType.isUseProguard();
        this.postProcessingBlock.initWith(((BuildType)that).getPostprocessing());
        this.crunchPngs = thatBuildType.isCrunchPngs();
        this.isCrunchPngsDefault = thatBuildType.isCrunchPngsDefault();
        this.matchingFallbacks = ImmutableList.copyOf(thatBuildType.getMatchingFallbacks());
        this.isDefault.set(thatBuildType.getIsDefault().get());
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public void buildConfigField(String type, String name2, String value) {
        ClassField alreadyPresent = (ClassField)this.getBuildConfigFields().get(name2);
        if (alreadyPresent != null) {
            String message = String.format("BuildType(%s): buildConfigField '%s' value is being replaced: %s -> %s", this.getName(), name2, alreadyPresent.getValue(), value);
            this.dslScope.getIssueReporter().reportWarning(EvalIssueReporter.Type.GENERIC, message);
        }
        this.addBuildConfigField((ClassField)new ClassFieldImpl(type, name2, value));
    }

    public void resValue(String type, String name2, String value) {
        ClassField alreadyPresent = (ClassField)this.getResValues().get(name2);
        if (alreadyPresent != null) {
            String message = String.format("BuildType(%s): resValue '%s' value is being replaced: %s -> %s", this.getName(), name2, alreadyPresent.getValue(), value);
            this.dslScope.getIssueReporter().reportWarning(EvalIssueReporter.Type.GENERIC, message);
        }
        this.addResValue((ClassField)new ClassFieldImpl(type, name2, value));
    }

    public BuildType proguardFile(Object proguardFile) {
        this.checkPostProcessingConfiguration(PostProcessingConfiguration.OLD_DSL, "proguardFile");
        this.getProguardFiles().add(this.project.file(proguardFile));
        return this;
    }

    public BuildType proguardFiles(Object ... files) {
        this.checkPostProcessingConfiguration(PostProcessingConfiguration.OLD_DSL, "proguardFiles");
        for (Object file : files) {
            this.proguardFile(file);
        }
        return this;
    }

    public BuildType setProguardFiles(Iterable<?> proguardFileIterable) {
        this.checkPostProcessingConfiguration(PostProcessingConfiguration.OLD_DSL, "setProguardFiles");
        this.getProguardFiles().clear();
        this.proguardFiles(Iterables.toArray(proguardFileIterable, Object.class));
        return this;
    }

    public BuildType testProguardFile(Object proguardFile) {
        this.checkPostProcessingConfiguration(PostProcessingConfiguration.OLD_DSL, "testProguardFile");
        this.getTestProguardFiles().add(this.project.file(proguardFile));
        return this;
    }

    public BuildType testProguardFiles(Object ... proguardFiles2) {
        this.checkPostProcessingConfiguration(PostProcessingConfiguration.OLD_DSL, "testProguardFiles");
        for (Object proguardFile : proguardFiles2) {
            this.testProguardFile(proguardFile);
        }
        return this;
    }

    public BuildType setTestProguardFiles(Iterable<?> files) {
        this.checkPostProcessingConfiguration(PostProcessingConfiguration.OLD_DSL, "setTestProguardFiles");
        this.getTestProguardFiles().clear();
        this.testProguardFiles(Iterables.toArray(files, Object.class));
        return this;
    }

    public BuildType consumerProguardFile(Object proguardFile) {
        this.checkPostProcessingConfiguration(PostProcessingConfiguration.OLD_DSL, "consumerProguardFile");
        this.getConsumerProguardFiles().add(this.project.file(proguardFile));
        return this;
    }

    public BuildType consumerProguardFiles(Object ... proguardFiles2) {
        this.checkPostProcessingConfiguration(PostProcessingConfiguration.OLD_DSL, "consumerProguardFiles");
        for (Object proguardFile : proguardFiles2) {
            this.consumerProguardFile(proguardFile);
        }
        return this;
    }

    public BuildType setConsumerProguardFiles(Iterable<?> proguardFileIterable) {
        this.checkPostProcessingConfiguration(PostProcessingConfiguration.OLD_DSL, "setConsumerProguardFiles");
        this.getConsumerProguardFiles().clear();
        this.consumerProguardFiles(Iterables.toArray(proguardFileIterable, Object.class));
        return this;
    }

    public void ndk(Action<NdkOptions> action) {
        action.execute((Object)this.ndkConfig);
    }

    public ExternalNativeBuildOptions externalNativeBuild(Action<ExternalNativeBuildOptions> action) {
        action.execute((Object)this.externalNativeBuildOptions);
        return this.externalNativeBuildOptions;
    }

    public void shaders(Action<ShaderOptions> action) {
        action.execute((Object)this.shaderOptions);
    }

    public com.android.builder.model.BuildType setMinifyEnabled(boolean enabled) {
        this.checkPostProcessingConfiguration(PostProcessingConfiguration.OLD_DSL, "setMinifyEnabled");
        return super.setMinifyEnabled(enabled);
    }

    public boolean isMinifyEnabled() {
        if (this.postProcessingConfiguration != PostProcessingConfiguration.POSTPROCESSING_BLOCK) {
            return super.isMinifyEnabled();
        }
        return this.postProcessingBlock.isRemoveUnusedCode() || this.postProcessingBlock.isObfuscate() || this.postProcessingBlock.isOptimizeCode();
    }

    @Override
    public boolean isShrinkResources() {
        if (this.postProcessingConfiguration != PostProcessingConfiguration.POSTPROCESSING_BLOCK) {
            return this.shrinkResources;
        }
        return this.postProcessingBlock.isRemoveUnusedResources();
    }

    public void setShrinkResources(boolean shrinkResources) {
        this.checkPostProcessingConfiguration(PostProcessingConfiguration.OLD_DSL, "setShrinkResources");
        this.shrinkResources = shrinkResources;
    }

    @Override
    public Boolean isUseProguard() {
        if (this.postProcessingConfiguration != PostProcessingConfiguration.POSTPROCESSING_BLOCK) {
            return this.useProguard;
        }
        return this.postProcessingBlock.getCodeShrinkerEnum() == CodeShrinker.PROGUARD;
    }

    public void setUseProguard(boolean useProguard) {
        this.checkPostProcessingConfiguration(PostProcessingConfiguration.OLD_DSL, "setUseProguard");
        if (dslChecksEnabled.get().booleanValue()) {
            this.dslScope.getDeprecationReporter().reportObsoleteUsage("useProguard", DeprecationReporter.DeprecationTarget.DSL_USE_PROGUARD);
        }
    }

    @Override
    public Boolean isCrunchPngs() {
        return this.crunchPngs;
    }

    public void setCrunchPngs(Boolean crunchPngs) {
        this.crunchPngs = crunchPngs;
    }

    @Override
    @Deprecated
    public boolean isCrunchPngsDefault() {
        return this.isCrunchPngsDefault;
    }

    @Incubating
    @Internal
    public PostProcessingBlock getPostprocessing() {
        this.checkPostProcessingConfiguration(PostProcessingConfiguration.POSTPROCESSING_BLOCK, "getPostProcessing");
        return this.postProcessingBlock;
    }

    @Incubating
    @Internal
    public void postprocessing(Action<PostProcessingBlock> action) {
        this.checkPostProcessingConfiguration(PostProcessingConfiguration.POSTPROCESSING_BLOCK, "postProcessing");
        action.execute((Object)this.postProcessingBlock);
    }

    public PostProcessingConfiguration getPostProcessingConfiguration() {
        return this.postProcessingConfiguration != null ? this.postProcessingConfiguration : PostProcessingConfiguration.OLD_DSL;
    }

    private void checkPostProcessingConfiguration(PostProcessingConfiguration used, String methodName) {
        if (!dslChecksEnabled.get().booleanValue()) {
            return;
        }
        if (this.postProcessingConfiguration == null) {
            this.postProcessingConfiguration = used;
            this.postProcessingDslMethodUsed = methodName;
        } else if (this.postProcessingConfiguration != used) {
            String message;
            assert (this.postProcessingDslMethodUsed != null);
            switch (used) {
                case POSTPROCESSING_BLOCK: {
                    message = String.format("The `postProcessing` block cannot be used with together with the `%s` method.", this.postProcessingDslMethodUsed);
                    break;
                }
                case OLD_DSL: {
                    message = String.format("The `%s` method cannot be used with together with the `postProcessing` block.", methodName);
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unknown value " + (Object)((Object)used)));
                }
            }
            this.dslScope.getIssueReporter().reportError(EvalIssueReporter.Type.GENERIC, message, methodName);
        }
    }

    public BuildType initWith(com.android.builder.model.BuildType that) {
        if (that == this) {
            return this;
        }
        dslChecksEnabled.set(false);
        try {
            BuildType buildType = (BuildType)super.initWith(that);
            return buildType;
        }
        finally {
            dslChecksEnabled.set(true);
        }
    }

    public static enum PostProcessingConfiguration {
        POSTPROCESSING_BLOCK,
        OLD_DSL;

    }
}

