/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.build.gradle.api.BaseVariant;
import com.android.build.gradle.internal.ConfigurationDependencies;
import com.android.build.gradle.internal.dependency.ConfigurationDependencyGraphs;
import com.android.build.gradle.internal.dsl.BuildType;
import com.android.build.gradle.internal.dsl.ProductFlavor;
import com.android.build.gradle.internal.errors.DeprecationReporter;
import com.android.build.gradle.internal.errors.DeprecationReporterImpl;
import com.android.build.gradle.internal.errors.MessageReceiverImpl;
import com.android.build.gradle.internal.errors.SyncIssueHandler;
import com.android.build.gradle.internal.errors.SyncIssueHandlerImpl;
import com.android.build.gradle.internal.ide.ArtifactMetaDataImpl;
import com.android.build.gradle.internal.ide.JavaArtifactImpl;
import com.android.build.gradle.internal.variant.DefaultSourceProviderContainer;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.options.SyncOptions;
import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.ArtifactMetaData;
import com.android.builder.model.JavaArtifact;
import com.android.builder.model.SourceProvider;
import com.android.builder.model.SourceProviderContainer;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.gradle.api.artifacts.Configuration;
import org.slf4j.Logger;

public class ExtraModelInfo {
    private final DeprecationReporter deprecationReporter;
    private final SyncIssueHandler syncIssueHandler;
    private final MessageReceiverImpl messageReceiver;
    private final Map<String, ArtifactMetaData> extraArtifactMap = Maps.newHashMap();
    private final ListMultimap<String, AndroidArtifact> extraAndroidArtifacts = ArrayListMultimap.create();
    private final ListMultimap<String, JavaArtifact> extraJavaArtifacts = ArrayListMultimap.create();
    private final ListMultimap<String, SourceProviderContainer> extraBuildTypeSourceProviders = ArrayListMultimap.create();
    private final ListMultimap<String, SourceProviderContainer> extraProductFlavorSourceProviders = ArrayListMultimap.create();
    private final ListMultimap<String, SourceProviderContainer> extraMultiFlavorSourceProviders = ArrayListMultimap.create();

    public ExtraModelInfo(String projectPath, ProjectOptions projectOptions, org.gradle.api.logging.Logger logger) {
        this.syncIssueHandler = new SyncIssueHandlerImpl(SyncOptions.getModelQueryMode(projectOptions), logger);
        this.deprecationReporter = new DeprecationReporterImpl(this.syncIssueHandler, projectOptions, projectPath);
        this.messageReceiver = new MessageReceiverImpl(SyncOptions.getErrorFormatMode(projectOptions), (Logger)logger);
    }

    public DeprecationReporter getDeprecationReporter() {
        return this.deprecationReporter;
    }

    public MessageReceiverImpl getMessageReceiver() {
        return this.messageReceiver;
    }

    public SyncIssueHandler getSyncIssueHandler() {
        return this.syncIssueHandler;
    }

    public Collection<ArtifactMetaData> getExtraArtifacts() {
        return this.extraArtifactMap.values();
    }

    public Collection<AndroidArtifact> getExtraAndroidArtifacts(String variantName) {
        return this.extraAndroidArtifacts.get((Object)variantName);
    }

    public Collection<JavaArtifact> getExtraJavaArtifacts(String variantName) {
        return this.extraJavaArtifacts.get((Object)variantName);
    }

    public Collection<SourceProviderContainer> getExtraFlavorSourceProviders(String flavorName2) {
        return this.extraProductFlavorSourceProviders.get((Object)flavorName2);
    }

    public Collection<SourceProviderContainer> getExtraBuildTypeSourceProviders(String buildTypeName) {
        return this.extraBuildTypeSourceProviders.get((Object)buildTypeName);
    }

    public void registerArtifactType(String name2, boolean isTest, int artifactType) {
        if (this.extraArtifactMap.get(name2) != null) {
            throw new IllegalArgumentException(String.format("Artifact with name %1$s already registered.", name2));
        }
        this.extraArtifactMap.put(name2, new ArtifactMetaDataImpl(name2, isTest, artifactType));
    }

    public void registerBuildTypeSourceProvider(String name2, BuildType buildType, SourceProvider sourceProvider) {
        if (this.extraArtifactMap.get(name2) == null) {
            throw new IllegalArgumentException(String.format("Artifact with name %1$s is not yet registered. Use registerArtifactType()", name2));
        }
        this.extraBuildTypeSourceProviders.put((Object)buildType.getName(), (Object)new DefaultSourceProviderContainer(name2, sourceProvider));
    }

    public void registerProductFlavorSourceProvider(String name2, ProductFlavor productFlavor, SourceProvider sourceProvider) {
        if (this.extraArtifactMap.get(name2) == null) {
            throw new IllegalArgumentException(String.format("Artifact with name %1$s is not yet registered. Use registerArtifactType()", name2));
        }
        this.extraProductFlavorSourceProviders.put((Object)productFlavor.getName(), (Object)new DefaultSourceProviderContainer(name2, sourceProvider));
    }

    public void registerMultiFlavorSourceProvider(String name2, String flavorName2, SourceProvider sourceProvider) {
        if (this.extraArtifactMap.get(name2) == null) {
            throw new IllegalArgumentException(String.format("Artifact with name %1$s is not yet registered. Use registerArtifactType()", name2));
        }
        this.extraMultiFlavorSourceProviders.put((Object)flavorName2, (Object)new DefaultSourceProviderContainer(name2, sourceProvider));
    }

    public void registerJavaArtifact(String name2, BaseVariant variant2, String assembleTaskName, String javaCompileTaskName, Collection<File> generatedSourceFolders, Iterable<String> ideSetupTaskNames, Configuration configuration2, File classesFolder, File javaResourcesFolder, SourceProvider sourceProvider) {
        ArtifactMetaData artifactMetaData = this.extraArtifactMap.get(name2);
        if (artifactMetaData == null) {
            throw new IllegalArgumentException(String.format("Artifact with name %1$s is not yet registered. Use registerArtifactType()", name2));
        }
        if (artifactMetaData.getType() != 2) {
            throw new IllegalArgumentException(String.format("Artifact with name %1$s is not of type JAVA", name2));
        }
        JavaArtifactImpl artifact = new JavaArtifactImpl(name2, assembleTaskName, javaCompileTaskName, ideSetupTaskNames, generatedSourceFolders, classesFolder, Collections.emptySet(), javaResourcesFolder, null, new ConfigurationDependencies(configuration2), new ConfigurationDependencyGraphs(configuration2), sourceProvider, null);
        this.extraJavaArtifacts.put((Object)variant2.getName(), (Object)artifact);
    }
}

