/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.Version;
import com.android.build.gradle.internal.SdkLocation;
import com.android.build.gradle.internal.SdkLocationSourceSet;
import com.android.build.gradle.internal.SdkLocator;
import com.android.build.gradle.internal.ndk.NdkHandler;
import com.android.builder.core.ToolsRevisionUtils;
import com.android.builder.errors.EvalIssueReporter;
import com.android.builder.sdk.DefaultSdkLoader;
import com.android.builder.sdk.InstallFailedException;
import com.android.builder.sdk.LicenceNotAcceptedException;
import com.android.builder.sdk.PlatformLoader;
import com.android.builder.sdk.SdkInfo;
import com.android.builder.sdk.SdkLibData;
import com.android.builder.sdk.SdkLoader;
import com.android.builder.sdk.TargetInfo;
import com.android.repository.Revision;
import com.android.repository.api.ConsoleProgressIndicator;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RepoPackage;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.utils.ILogger;
import com.android.utils.Pair;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import java.io.File;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class SdkHandler {
    private final ILogger logger;
    private final EvalIssueReporter evalIssueReporter;
    private SdkLocationSourceSet sdkLocationSourceSet;
    private SdkLibData sdkLibData = SdkLibData.dontDownload();
    private SdkLoader sdkLoader;

    public SdkHandler(SdkLocationSourceSet sdkLocationSourceSet, ILogger logger, EvalIssueReporter evalIssueReporter) {
        this.sdkLocationSourceSet = sdkLocationSourceSet;
        this.logger = logger;
        this.evalIssueReporter = evalIssueReporter;
    }

    public Pair<SdkInfo, TargetInfo> initTarget(String targetHash, Revision buildToolRevision) {
        TargetInfo targetInfo;
        Preconditions.checkNotNull((Object)targetHash, (Object)"android.compileSdkVersion is missing!");
        Preconditions.checkNotNull((Object)buildToolRevision, (Object)"android.buildToolsVersion is missing!");
        SdkLoader sdkLoader = this.getSdkLoader();
        if (sdkLoader == null) {
            return null;
        }
        if (buildToolRevision.compareTo(ToolsRevisionUtils.MIN_BUILD_TOOLS_REV) < 0) {
            this.evalIssueReporter.reportWarning(EvalIssueReporter.Type.BUILD_TOOLS_TOO_LOW, String.format("The specified Android SDK Build Tools version (%1$s) is ignored, as it is below the minimum supported version (%2$s) for Android Gradle Plugin %3$s.\nAndroid SDK Build Tools %4$s will be used.\nTo suppress this warning, remove \"buildToolsVersion '%1$s'\" from your build.gradle file, as each version of the Android Gradle Plugin now has a default version of the build tools.", buildToolRevision, ToolsRevisionUtils.MIN_BUILD_TOOLS_REV, Version.ANDROID_GRADLE_PLUGIN_VERSION, ToolsRevisionUtils.DEFAULT_BUILD_TOOLS_REVISION), ToolsRevisionUtils.DEFAULT_BUILD_TOOLS_REVISION.toString());
            buildToolRevision = ToolsRevisionUtils.DEFAULT_BUILD_TOOLS_REVISION;
        }
        Stopwatch stopwatch = Stopwatch.createStarted();
        SdkInfo sdkInfo = sdkLoader.getSdkInfo(this.logger);
        try {
            targetInfo = sdkLoader.getTargetInfo(targetHash, buildToolRevision, this.logger, this.sdkLibData);
        }
        catch (LicenceNotAcceptedException e) {
            this.evalIssueReporter.reportError(EvalIssueReporter.Type.MISSING_SDK_PACKAGE, e.getMessage(), e.getAffectedPackages().stream().map(RepoPackage::getPath).collect(Collectors.joining(" ")));
            return null;
        }
        catch (InstallFailedException e) {
            this.evalIssueReporter.reportError(EvalIssueReporter.Type.MISSING_SDK_PACKAGE, e.getMessage(), e.getAffectedPackages().stream().map(RepoPackage::getPath).collect(Collectors.joining(" ")));
            return null;
        }
        catch (IllegalStateException e) {
            this.evalIssueReporter.reportError(EvalIssueReporter.Type.MISSING_SDK_PACKAGE, (Exception)e);
            return null;
        }
        this.logger.verbose("SDK initialized in %1$d ms", new Object[]{stopwatch.elapsed(TimeUnit.MILLISECONDS)});
        return Pair.of((Object)sdkInfo, (Object)targetInfo);
    }

    public boolean ensurePlatformToolsIsInstalledWarnOnFailure() {
        ConsoleProgressIndicator progress = new ConsoleProgressIndicator();
        AndroidSdkHandler sdk = AndroidSdkHandler.getInstance((File)SdkLocator.getSdkLocation(this.sdkLocationSourceSet, this.evalIssueReporter).getDirectory());
        LocalPackage platformToolsPackage = sdk.getLatestLocalPackageForPrefix("platform-tools", null, true, (ProgressIndicator)progress);
        if (platformToolsPackage == null && this.sdkLoader != null) {
            if (this.sdkLibData.useSdkDownload()) {
                try {
                    this.sdkLoader.installSdkTool(this.sdkLibData, "platform-tools");
                    return true;
                }
                catch (LicenceNotAcceptedException e) {
                    this.evalIssueReporter.reportWarning(EvalIssueReporter.Type.MISSING_SDK_PACKAGE, "platform-tools package is not installed. Please accept the installation licence to continue", "platform-tools");
                }
                catch (InstallFailedException e) {
                    this.evalIssueReporter.reportWarning(EvalIssueReporter.Type.MISSING_SDK_PACKAGE, "platform-tools package is not installed, and automatic installation failed.", "platform-tools");
                }
            } else {
                this.evalIssueReporter.reportWarning(EvalIssueReporter.Type.MISSING_SDK_PACKAGE, "platform-tools package is not installed.", "platform-tools");
            }
        }
        return false;
    }

    private synchronized SdkLoader getSdkLoader() {
        if (this.sdkLoader == null) {
            SdkLocation sdkLocation = SdkLocator.getSdkLocation(this.sdkLocationSourceSet, this.evalIssueReporter);
            switch (sdkLocation.getType()) {
                case TEST: 
                case REGULAR: {
                    this.sdkLoader = DefaultSdkLoader.getLoader((File)sdkLocation.getDirectory());
                    break;
                }
                case PLATFORM: {
                    this.sdkLoader = PlatformLoader.getLoader((File)sdkLocation.getDirectory());
                    break;
                }
            }
        }
        return this.sdkLoader;
    }

    public synchronized void unload() {
        if (this.sdkLoader != null) {
            SdkLocation sdkLocation = SdkLocator.getSdkLocation(this.sdkLocationSourceSet, this.evalIssueReporter);
            switch (sdkLocation.getType()) {
                case TEST: 
                case REGULAR: {
                    DefaultSdkLoader.unload();
                    break;
                }
                case PLATFORM: {
                    PlatformLoader.unload();
                    break;
                }
            }
            this.sdkLoader = null;
        }
    }

    public void setSdkLibData(SdkLibData sdkLibData) {
        this.sdkLibData = sdkLibData;
    }

    public void installNdk(NdkHandler ndkHandler) {
        if (!this.sdkLibData.useSdkDownload()) {
            return;
        }
        SdkLoader loader = this.getSdkLoader();
        if (loader == null) {
            return;
        }
        loader.getSdkInfo(this.logger);
        ndkHandler.installFromSdk(loader, this.sdkLibData);
    }

    public void installCMake(String version) {
        if (!this.sdkLibData.useSdkDownload()) {
            return;
        }
        try {
            SdkLoader loader = this.getSdkLoader();
            if (loader == null) {
                return;
            }
            loader.getSdkInfo(this.logger);
            loader.installSdkTool(this.sdkLibData, "cmake;" + version);
        }
        catch (InstallFailedException | LicenceNotAcceptedException e) {
            throw new RuntimeException(e);
        }
    }
}

