/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.ide;

import com.android.build.FilterData;
import com.android.build.OutputFile;
import com.android.build.VariantOutput;
import com.android.build.api.artifact.ArtifactType;
import com.android.build.gradle.internal.ide.EarlySyncBuildOutput;
import com.android.build.gradle.internal.scope.ApkData;
import com.android.build.gradle.internal.scope.BuildElements;
import com.android.build.gradle.internal.scope.BuildOutput;
import com.android.build.gradle.internal.scope.ExistingBuildElements;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.gradle.api.file.FileSystemLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u001f\n\u0002\b\u0005\b\u0086\b\u0018\u0000 02\u00020\u00012\u00020\u0002:\u00010B7\u0012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\r\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u0004H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0006H\u00c6\u0003J\u000f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u000bH\u00c6\u0003J\t\u0010\u001d\u001a\u00020\rH\u00c6\u0003JE\u0010\u001e\u001a\u00020\u00002\f\b\u0002\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\rH\u00c6\u0001J\u0013\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\"H\u00d6\u0003J\u0010\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020$J\u000e\u0010&\u001a\b\u0012\u0004\u0012\u00020$0\bH\u0016J\u000e\u0010'\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016J\b\u0010(\u001a\u00020\u0002H\u0016J\b\u0010)\u001a\u00020\rH\u0016J\b\u0010*\u001a\u00020$H\u0016J\u0010\u0010+\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020,H\u0016J\b\u0010-\u001a\u00020\u000bH\u0016J\t\u0010.\u001a\u00020\u000bH\u00d6\u0001J\t\u0010/\u001a\u00020$H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0015\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u00061"}, d2={"Lcom/android/build/gradle/internal/ide/EarlySyncBuildOutput;", "Ljava/io/Serializable;", "Lcom/android/build/OutputFile;", "type", "Lcom/android/build/api/artifact/ArtifactType;", "apkType", "Lcom/android/build/VariantOutput$OutputType;", "filtersData", "", "Lcom/android/build/FilterData;", "version", "", "output", "Ljava/io/File;", "(Lcom/android/build/api/artifact/ArtifactType;Lcom/android/build/VariantOutput$OutputType;Ljava/util/Collection;ILjava/io/File;)V", "getApkType", "()Lcom/android/build/VariantOutput$OutputType;", "getFiltersData", "()Ljava/util/Collection;", "getOutput", "()Ljava/io/File;", "getType", "()Lcom/android/build/api/artifact/ArtifactType;", "getVersion", "()I", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "", "getFilter", "", "filterType", "getFilterTypes", "getFilters", "getMainOutputFile", "getOutputFile", "getOutputType", "getOutputs", "", "getVersionCode", "hashCode", "toString", "Companion", "gradle"})
public final class EarlySyncBuildOutput
implements Serializable,
OutputFile {
    @NotNull
    private final ArtifactType<?> type;
    @NotNull
    private final VariantOutput.OutputType apkType;
    @NotNull
    private final Collection<FilterData> filtersData;
    private final int version;
    @NotNull
    private final File output;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public File getOutputFile() {
        return this.output;
    }

    @NotNull
    public String getOutputType() {
        return this.apkType.name();
    }

    @NotNull
    public Collection<String> getFilterTypes() {
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)this.filtersData), (Function1)getFilterTypes.1.INSTANCE));
    }

    @NotNull
    public Collection<FilterData> getFilters() {
        return this.filtersData;
    }

    @NotNull
    public OutputFile getMainOutputFile() {
        return this;
    }

    @NotNull
    public Collection<? extends OutputFile> getOutputs() {
        ImmutableList immutableList = ImmutableList.of((Object)this);
        Intrinsics.checkExpressionValueIsNotNull((Object)immutableList, (String)"ImmutableList.of<OutputFile>(this)");
        return (Collection)immutableList;
    }

    public int getVersionCode() {
        return this.version;
    }

    @Nullable
    public final String getFilter(@NotNull String filterType2) {
        Object v0;
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)filterType2, (String)"filterType");
            Sequence sequence = CollectionsKt.asSequence((Iterable)this.filtersData);
            boolean bl = false;
            Sequence sequence2 = sequence;
            boolean bl2 = false;
            for (Object e : sequence2) {
                FilterData it = (FilterData)e;
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)it.getFilterType(), (Object)filterType2)) continue;
                v0 = e;
                break block1;
            }
            v0 = null;
        }
        FilterData filterData = v0;
        return filterData != null ? filterData.getIdentifier() : null;
    }

    @NotNull
    public final ArtifactType<?> getType() {
        return this.type;
    }

    @NotNull
    public final VariantOutput.OutputType getApkType() {
        return this.apkType;
    }

    @NotNull
    public final Collection<FilterData> getFiltersData() {
        return this.filtersData;
    }

    public final int getVersion() {
        return this.version;
    }

    @NotNull
    public final File getOutput() {
        return this.output;
    }

    public EarlySyncBuildOutput(@NotNull ArtifactType<?> type, @NotNull VariantOutput.OutputType apkType, @NotNull Collection<? extends FilterData> filtersData, int version, @NotNull File output2) {
        Intrinsics.checkParameterIsNotNull(type, (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)apkType, (String)"apkType");
        Intrinsics.checkParameterIsNotNull(filtersData, (String)"filtersData");
        Intrinsics.checkParameterIsNotNull((Object)output2, (String)"output");
        this.type = type;
        this.apkType = apkType;
        this.filtersData = filtersData;
        this.version = version;
        this.output = output2;
    }

    @NotNull
    public final ArtifactType<?> component1() {
        return this.type;
    }

    @NotNull
    public final VariantOutput.OutputType component2() {
        return this.apkType;
    }

    @NotNull
    public final Collection<FilterData> component3() {
        return this.filtersData;
    }

    public final int component4() {
        return this.version;
    }

    @NotNull
    public final File component5() {
        return this.output;
    }

    @NotNull
    public final EarlySyncBuildOutput copy(@NotNull ArtifactType<?> type, @NotNull VariantOutput.OutputType apkType, @NotNull Collection<? extends FilterData> filtersData, int version, @NotNull File output2) {
        Intrinsics.checkParameterIsNotNull(type, (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)apkType, (String)"apkType");
        Intrinsics.checkParameterIsNotNull(filtersData, (String)"filtersData");
        Intrinsics.checkParameterIsNotNull((Object)output2, (String)"output");
        return new EarlySyncBuildOutput(type, apkType, filtersData, version, output2);
    }

    public static /* synthetic */ EarlySyncBuildOutput copy$default(EarlySyncBuildOutput earlySyncBuildOutput, ArtifactType artifactType, VariantOutput.OutputType outputType, Collection collection, int n, File file, int n2, Object object) {
        if ((n2 & 1) != 0) {
            artifactType = earlySyncBuildOutput.type;
        }
        if ((n2 & 2) != 0) {
            outputType = earlySyncBuildOutput.apkType;
        }
        if ((n2 & 4) != 0) {
            collection = earlySyncBuildOutput.filtersData;
        }
        if ((n2 & 8) != 0) {
            n = earlySyncBuildOutput.version;
        }
        if ((n2 & 0x10) != 0) {
            file = earlySyncBuildOutput.output;
        }
        return earlySyncBuildOutput.copy(artifactType, outputType, collection, n, file);
    }

    @NotNull
    public String toString() {
        return "EarlySyncBuildOutput(type=" + this.type + ", apkType=" + this.apkType + ", filtersData=" + this.filtersData + ", version=" + this.version + ", output=" + this.output + ")";
    }

    public int hashCode() {
        ArtifactType<?> artifactType = this.type;
        VariantOutput.OutputType outputType = this.apkType;
        Collection<FilterData> collection = this.filtersData;
        File file = this.output;
        return ((((artifactType != null ? artifactType.hashCode() : 0) * 31 + (outputType != null ? outputType.hashCode() : 0)) * 31 + (collection != null ? ((Object)collection).hashCode() : 0)) * 31 + Integer.hashCode(this.version)) * 31 + (file != null ? ((Object)file).hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof EarlySyncBuildOutput)) break block3;
                EarlySyncBuildOutput earlySyncBuildOutput = (EarlySyncBuildOutput)object;
                if (!Intrinsics.areEqual(this.type, earlySyncBuildOutput.type) || !Intrinsics.areEqual((Object)this.apkType, (Object)earlySyncBuildOutput.apkType) || !Intrinsics.areEqual(this.filtersData, earlySyncBuildOutput.filtersData) || this.version != earlySyncBuildOutput.version || !Intrinsics.areEqual((Object)this.output, (Object)earlySyncBuildOutput.output)) break block3;
            }
            return true;
        }
        return false;
    }

    @JvmStatic
    @NotNull
    public static final Collection<EarlySyncBuildOutput> load(@NotNull File folder) {
        return Companion.load(folder);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\t\u001a\u00020\u0007H\u0002\u00a8\u0006\n"}, d2={"Lcom/android/build/gradle/internal/ide/EarlySyncBuildOutput$Companion;", "", "()V", "load", "", "Lcom/android/build/gradle/internal/ide/EarlySyncBuildOutput;", "folder", "Ljava/io/File;", "loadFile", "metadataFile", "gradle"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final Collection<EarlySyncBuildOutput> load(@NotNull File folder) {
            Collection collection;
            Intrinsics.checkParameterIsNotNull((Object)folder, (String)"folder");
            File metadataFile = ExistingBuildElements.Companion.getMetadataFileIfPresent(folder);
            if (metadataFile == null || !metadataFile.exists()) {
                ImmutableList immutableList = ImmutableList.of();
                Intrinsics.checkExpressionValueIsNotNull((Object)immutableList, (String)"ImmutableList.of<EarlySyncBuildOutput>()");
                return (Collection)immutableList;
            }
            try {
                collection = this.loadFile(metadataFile);
            }
            catch (IOException e) {
                ImmutableList immutableList = ImmutableList.of();
                Intrinsics.checkExpressionValueIsNotNull((Object)immutableList, (String)"ImmutableList.of<EarlySyncBuildOutput>()");
                collection = (Collection)immutableList;
            }
            return collection;
        }

        private final Collection<EarlySyncBuildOutput> loadFile(File metadataFile) {
            boolean bl;
            BuildElements buildElements;
            block4: {
                File file = metadataFile.getParentFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"metadataFile.parentFile");
                buildElements = ExistingBuildElements.Companion.from(file);
                Iterable $this$any$iv = buildElements;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        BuildOutput it = (BuildOutput)element$iv;
                        boolean bl2 = false;
                        if (!(it.getApkData() == null)) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
            }
            if (bl) {
                throw (Throwable)new IllegalStateException(StringsKt.trimIndent((String)("\n                        Invalid file found (empty apk data).\n                        Try to remove " + metadataFile.getAbsolutePath() + " or clean your build directory.\n                        If the error persists, report this issue via Help > Submit Feedback.\n                    ")));
            }
            Path projectPath = metadataFile.getParentFile().toPath();
            return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)buildElements), (Function1)((Function1)new Function1<BuildOutput, EarlySyncBuildOutput>(projectPath){
                final /* synthetic */ Path $projectPath;

                @NotNull
                public final EarlySyncBuildOutput invoke(@NotNull BuildOutput buildOutput) {
                    Intrinsics.checkParameterIsNotNull((Object)buildOutput, (String)"buildOutput");
                    ArtifactType<FileSystemLocation> artifactType = buildOutput.getType();
                    Intrinsics.checkExpressionValueIsNotNull(artifactType, (String)"buildOutput.type");
                    ApkData apkData = buildOutput.getApkData();
                    Intrinsics.checkExpressionValueIsNotNull((Object)apkData, (String)"buildOutput.apkData");
                    VariantOutput.OutputType outputType = apkData.getType();
                    Intrinsics.checkExpressionValueIsNotNull((Object)outputType, (String)"buildOutput.apkData.type");
                    ApkData apkData2 = buildOutput.getApkData();
                    Intrinsics.checkExpressionValueIsNotNull((Object)apkData2, (String)"buildOutput.apkData");
                    Collection<FilterData> collection = apkData2.getFilters();
                    Intrinsics.checkExpressionValueIsNotNull(collection, (String)"buildOutput.apkData.filters");
                    ApkData apkData3 = buildOutput.getApkData();
                    Intrinsics.checkExpressionValueIsNotNull((Object)apkData3, (String)"buildOutput.apkData");
                    int n = apkData3.getVersionCode();
                    File file = this.$projectPath.resolve(buildOutput.getOutputPath()).toFile();
                    Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"projectPath.resolve(buil\u2026tput.outputPath).toFile()");
                    return new EarlySyncBuildOutput(artifactType, outputType, collection, n, file);
                }
                {
                    this.$projectPath = path;
                    super(1);
                }
            })));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

