/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.ide.dependencies;

import com.android.build.gradle.internal.errors.SyncIssueHandler;
import com.android.build.gradle.internal.ide.AndroidLibraryImpl;
import com.android.build.gradle.internal.ide.DependenciesImpl;
import com.android.build.gradle.internal.ide.DependencyFailureHandler;
import com.android.build.gradle.internal.ide.JavaLibraryImpl;
import com.android.build.gradle.internal.ide.dependencies.ArtifactUtils;
import com.android.build.gradle.internal.ide.dependencies.BuildMappingUtils;
import com.android.build.gradle.internal.ide.dependencies.DependencyGraphBuilder;
import com.android.build.gradle.internal.ide.dependencies.LibraryUtils;
import com.android.build.gradle.internal.ide.dependencies.MavenCoordinatesUtils;
import com.android.build.gradle.internal.ide.dependencies.ResolvedArtifact;
import com.android.build.gradle.internal.ide.level2.FullDependencyGraphsImpl;
import com.android.build.gradle.internal.ide.level2.GraphItemImpl;
import com.android.build.gradle.internal.ide.level2.SimpleDependencyGraphsImpl;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.Dependencies;
import com.android.builder.model.JavaLibrary;
import com.android.builder.model.level2.DependencyGraphs;
import com.android.builder.model.level2.GraphItem;
import com.android.utils.ImmutableCollectors;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;

class ArtifactDependencyGraph
implements DependencyGraphBuilder {
    private DependencyFailureHandler dependencyFailureHandler = new DependencyFailureHandler();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DependencyGraphs createLevel4DependencyGraph(VariantScope variantScope, boolean withFullDependency, ImmutableMap<String, String> buildMapping, SyncIssueHandler syncIssueHandler) {
        try {
            Set<ResolvedArtifact> compileArtifacts = ArtifactUtils.getAllArtifacts(variantScope, AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH, this.dependencyFailureHandler, buildMapping);
            if (!withFullDependency) {
                ArtifactCollection runtimeArtifactCollection = variantScope.getArtifactCollectionForToolingModel(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.JAR);
                Set runtimeArtifacts = runtimeArtifactCollection.getArtifacts();
                HashSet runtimeIdentifiers = Sets.newHashSetWithExpectedSize((int)runtimeArtifacts.size());
                for (ResolvedArtifactResult result : runtimeArtifacts) {
                    runtimeIdentifiers.add(result.getId().getComponentIdentifier());
                }
                ArrayList providedAddresses = Lists.newArrayList();
                ArrayList compileItems = Lists.newArrayListWithCapacity((int)compileArtifacts.size());
                for (ResolvedArtifact artifact : compileArtifacts) {
                    GraphItemImpl graphItem = new GraphItemImpl(artifact.computeModelAddress(), (List<GraphItem>)ImmutableList.of());
                    compileItems.add(graphItem);
                    LibraryUtils.getLibraryCache().get((Object)artifact);
                    if (runtimeIdentifiers.contains(artifact.getComponentIdentifier())) continue;
                    providedAddresses.add(graphItem.getArtifactAddress());
                }
                SimpleDependencyGraphsImpl simpleDependencyGraphsImpl = new SimpleDependencyGraphsImpl(compileItems, providedAddresses);
                return simpleDependencyGraphsImpl;
            }
            ArrayList compileItems = Lists.newArrayListWithCapacity((int)compileArtifacts.size());
            for (ResolvedArtifact artifact : compileArtifacts) {
                compileItems.add(new GraphItemImpl(artifact.computeModelAddress(), (List<GraphItem>)ImmutableList.of()));
                LibraryUtils.getLibraryCache().get((Object)artifact);
            }
            Set<ResolvedArtifact> runtimeArtifacts = ArtifactUtils.getAllArtifacts(variantScope, AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, this.dependencyFailureHandler, buildMapping);
            ArrayList runtimeItems = Lists.newArrayListWithCapacity((int)runtimeArtifacts.size());
            Iterator providedAddresses = runtimeArtifacts.iterator();
            while (providedAddresses.hasNext()) {
                ResolvedArtifact artifact = (ResolvedArtifact)providedAddresses.next();
                runtimeItems.add(new GraphItemImpl(artifact.computeModelAddress(), (List<GraphItem>)ImmutableList.of()));
                LibraryUtils.getLibraryCache().get((Object)artifact);
            }
            ArrayList providedItems = Lists.newArrayList((Iterable)compileItems);
            providedItems.removeAll(runtimeItems);
            ImmutableList providedAddresses2 = (ImmutableList)providedItems.stream().map(GraphItem::getArtifactAddress).collect(ImmutableCollectors.toImmutableList());
            FullDependencyGraphsImpl fullDependencyGraphsImpl = new FullDependencyGraphsImpl(compileItems, runtimeItems, (List<String>)providedAddresses2, (List<String>)ImmutableList.of());
            return fullDependencyGraphsImpl;
        }
        finally {
            this.dependencyFailureHandler.registerIssues(syncIssueHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DependenciesImpl createDependencies(VariantScope variantScope, ImmutableMap<String, String> buildMapping, SyncIssueHandler syncIssueHandler) {
        try {
            ImmutableList.Builder projects = ImmutableList.builder();
            ImmutableList.Builder androidLibraries = ImmutableList.builder();
            ImmutableList.Builder javaLibrary = ImmutableList.builder();
            ImmutableSet<ComponentIdentifier> runtimeIdentifiers = ArtifactDependencyGraph.getRuntimeComponentIdentifiers(variantScope);
            Set<ResolvedArtifact> artifacts2 = ArtifactUtils.getAllArtifacts(variantScope, AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH, this.dependencyFailureHandler, buildMapping);
            for (ResolvedArtifact artifact : artifacts2) {
                File extractedFolder;
                ComponentIdentifier id = artifact.getComponentIdentifier();
                boolean isProvided = !runtimeIdentifiers.contains((Object)id);
                boolean isSubproject = id instanceof ProjectComponentIdentifier;
                String projectPath = null;
                String buildId = null;
                if (isSubproject) {
                    ProjectComponentIdentifier projectId = (ProjectComponentIdentifier)id;
                    projectPath = projectId.getProjectPath();
                    buildId = BuildMappingUtils.getBuildId(projectId, buildMapping);
                }
                if (artifact.getDependencyType() == ResolvedArtifact.DependencyType.JAVA) {
                    if (projectPath != null) {
                        projects.add((Object)new DependenciesImpl.ProjectIdentifierImpl(buildId, projectPath));
                        continue;
                    }
                    javaLibrary.add((Object)new JavaLibraryImpl(artifact.getArtifactFile(), null, null, (List<JavaLibrary>)ImmutableList.of(), null, MavenCoordinatesUtils.getMavenCoordinates(artifact), false, isProvided));
                    continue;
                }
                if (artifact.isWrappedModule()) {
                    buildId = null;
                    projectPath = null;
                }
                if ((extractedFolder = artifact.getExtractedFolder()) == null) {
                    extractedFolder = artifact.getArtifactFile();
                }
                androidLibraries.add((Object)new AndroidLibraryImpl(MavenCoordinatesUtils.getMavenCoordinates(artifact), buildId, projectPath, artifact.getArtifactFile(), extractedFolder, LibraryUtils.findResStaticLibrary(variantScope, artifact), artifact.getVariantName(), isProvided, false, (List<AndroidLibrary>)ImmutableList.of(), (Collection<JavaLibrary>)ImmutableList.of(), (Collection)LibraryUtils.getLocalJarCache().get((Object)extractedFolder)));
            }
            Set compileIdentifiers = artifacts2.stream().map(ResolvedArtifact::getComponentIdentifier).collect(Collectors.toSet());
            ImmutableMultimap<ComponentIdentifier, ResolvedArtifactResult> projectRuntime = ArtifactUtils.asMultiMap(variantScope.getArtifactCollectionForToolingModel(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.PROJECT, AndroidArtifacts.ArtifactType.JAR));
            ImmutableMultimap<ComponentIdentifier, ResolvedArtifactResult> externalRuntime = ArtifactUtils.asMultiMap(variantScope.getArtifactCollectionForToolingModel(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.EXTERNAL, AndroidArtifacts.ArtifactType.PROCESSED_JAR));
            ImmutableList.Builder runtimeOnlyClasspathBuilder = ImmutableList.builder();
            for (ComponentIdentifier runtimeIdentifier : runtimeIdentifiers) {
                if (compileIdentifiers.contains(runtimeIdentifier)) continue;
                for (ResolvedArtifactResult resolvedArtifactResult : projectRuntime.get((Object)runtimeIdentifier)) {
                    runtimeOnlyClasspathBuilder.add((Object)resolvedArtifactResult.getFile());
                }
                for (ResolvedArtifactResult resolvedArtifactResult : externalRuntime.get((Object)runtimeIdentifier)) {
                    runtimeOnlyClasspathBuilder.add((Object)resolvedArtifactResult.getFile());
                }
            }
            ImmutableList runtimeOnlyClasspath = runtimeOnlyClasspathBuilder.build();
            DependenciesImpl dependenciesImpl = new DependenciesImpl((List<AndroidLibrary>)androidLibraries.build(), (List<JavaLibrary>)javaLibrary.build(), (List<Dependencies.ProjectIdentifier>)projects.build(), (List<File>)runtimeOnlyClasspath);
            return dependenciesImpl;
        }
        finally {
            this.dependencyFailureHandler.registerIssues(syncIssueHandler);
        }
    }

    private static ImmutableSet<ComponentIdentifier> getRuntimeComponentIdentifiers(VariantScope variantScope) {
        ArtifactCollection runtimeArtifactCollection = variantScope.getArtifactCollectionForToolingModel(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.AAR_OR_JAR);
        ImmutableSet.Builder runtimeIdentifiersBuilder = ImmutableSet.builder();
        for (ResolvedArtifactResult result : runtimeArtifactCollection.getArtifacts()) {
            runtimeIdentifiersBuilder.add((Object)result.getId().getComponentIdentifier());
        }
        return runtimeIdentifiersBuilder.build();
    }

    ArtifactDependencyGraph() {
    }
}

