/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.ide.dependencies;

import com.android.build.gradle.internal.ide.DependencyFailureHandler;
import com.android.build.gradle.internal.ide.dependencies.ArtifactCollections;
import com.android.build.gradle.internal.ide.dependencies.ResolvedArtifact;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.VariantScope;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.artifacts.result.ResolvedVariantResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000:\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a:\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\n\u001a\u0016\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r*\u00020\u0010\u00a8\u0006\u0011"}, d2={"getAllArtifacts", "", "Lcom/android/build/gradle/internal/ide/dependencies/ResolvedArtifact;", "variantScope", "Lcom/android/build/gradle/internal/scope/VariantScope;", "consumedConfigType", "Lcom/android/build/gradle/internal/publishing/AndroidArtifacts$ConsumedConfigType;", "dependencyFailureHandler", "Lcom/android/build/gradle/internal/ide/DependencyFailureHandler;", "buildMapping", "Lcom/google/common/collect/ImmutableMap;", "", "asMultiMap", "Lcom/google/common/collect/ImmutableMultimap;", "Lorg/gradle/api/artifacts/component/ComponentIdentifier;", "Lorg/gradle/api/artifacts/result/ResolvedArtifactResult;", "Lorg/gradle/api/artifacts/ArtifactCollection;", "gradle"})
@JvmName(name="ArtifactUtils")
public final class ArtifactUtils {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Set<ResolvedArtifact> getAllArtifacts(@NotNull VariantScope variantScope, @NotNull AndroidArtifacts.ConsumedConfigType consumedConfigType, @Nullable DependencyFailureHandler dependencyFailureHandler, @NotNull ImmutableMap<String, String> buildMapping) {
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)variantScope, (String)"variantScope");
        Intrinsics.checkParameterIsNotNull((Object)((Object)consumedConfigType), (String)"consumedConfigType");
        Intrinsics.checkParameterIsNotNull(buildMapping, (String)"buildMapping");
        ArtifactCollections collections = new ArtifactCollections(variantScope, consumedConfigType);
        ArtifactCollection incomingArtifacts = collections.getAll();
        ImmutableMultimap manifests = collections.getNonNamespacedManifests() != null ? ImmutableMultimap.builder().putAll((Multimap)ArtifactUtils.asMultiMap(collections.getManifests())).putAll((Multimap)ArtifactUtils.asMultiMap(collections.getNonNamespacedManifests())).build() : ArtifactUtils.asMultiMap(collections.getManifests());
        ImmutableMultimap<ComponentIdentifier, ResolvedArtifactResult> explodedAars = ArtifactUtils.asMultiMap(collections.getExplodedAars());
        ImmutableMultimap<ComponentIdentifier, ResolvedArtifactResult> projectJars = ArtifactUtils.asMultiMap(collections.getProjectJars());
        if (dependencyFailureHandler != null) {
            Collection failures = incomingArtifacts.getFailures();
            StringBuilder stringBuilder = new StringBuilder();
            GlobalScope globalScope = variantScope.getGlobalScope();
            Intrinsics.checkExpressionValueIsNotNull((Object)globalScope, (String)"variantScope.globalScope");
            Project project2 = globalScope.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"variantScope.globalScope.project");
            String string = stringBuilder.append(project2.getPath()).append("@").append(variantScope.getFullVariantName()).append("/").append(consumedConfigType.getName()).toString();
            Collection collection = failures;
            Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"failures");
            dependencyFailureHandler.addErrors(string, collection);
        }
        ImmutableSet immutableSet = explodedAars.keySet();
        Intrinsics.checkExpressionValueIsNotNull((Object)immutableSet, (String)"explodedAars.keySet()");
        Iterable $this$filterIsInstance$iv = (Iterable)immutableSet;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof ProjectComponentIdentifier)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List aarWrappedAsProjects = (List)destination$iv$iv;
        Set resolvedArtifactResults = incomingArtifacts.getArtifacts();
        LinkedHashSet artifacts2 = Sets.newLinkedHashSetWithExpectedSize((int)resolvedArtifactResults.size());
        Iterator iterator = resolvedArtifactResults.iterator();
        while (iterator.hasNext()) {
            boolean bl;
            ResolvedArtifactResult resolvedComponentResult;
            ResolvedArtifactResult resolvedArtifactResult = resolvedComponentResult = (ResolvedArtifactResult)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)resolvedArtifactResult, (String)"resolvedComponentResult");
            ComponentArtifactIdentifier componentArtifactIdentifier = resolvedArtifactResult.getId();
            Intrinsics.checkExpressionValueIsNotNull((Object)componentArtifactIdentifier, (String)"resolvedComponentResult.id");
            ComponentIdentifier componentIdentifier = componentArtifactIdentifier.getComponentIdentifier();
            boolean isAarWrappedAsProject = CollectionsKt.contains((Iterable)aarWrappedAsProjects, (Object)componentIdentifier);
            ResolvedArtifact.DependencyType dependencyType = null;
            ImmutableCollection immutableCollection = explodedAars.get((Object)componentIdentifier);
            Intrinsics.checkExpressionValueIsNotNull((Object)immutableCollection, (String)"explodedAars[componentIdentifier]");
            Collection extractedAar = (Collection)immutableCollection;
            ImmutableCollection immutableCollection2 = manifests.get((Object)componentIdentifier);
            Intrinsics.checkExpressionValueIsNotNull((Object)immutableCollection2, (String)"manifests[componentIdentifier]");
            Collection manifest = (Collection)immutableCollection2;
            Collection mainArtifacts = null;
            ResolvedVariantResult resolvedVariantResult = resolvedComponentResult.getVariant();
            Intrinsics.checkExpressionValueIsNotNull((Object)resolvedVariantResult, (String)"resolvedComponentResult.variant");
            String artifactType = (String)resolvedVariantResult.getAttributes().getAttribute(AndroidArtifacts.ARTIFACT_TYPE);
            Object object = artifactType;
            if (Intrinsics.areEqual((Object)object, (Object)AndroidArtifacts.ArtifactType.AAR.getType())) {
                dependencyType = ResolvedArtifact.DependencyType.ANDROID;
                mainArtifacts = CollectionsKt.listOf((Object)resolvedComponentResult);
            } else if (Intrinsics.areEqual((Object)object, (Object)AndroidArtifacts.ArtifactType.JAR.getType())) {
                Collection collection = manifest;
                bl = false;
                if (!collection.isEmpty()) {
                    dependencyType = ResolvedArtifact.DependencyType.ANDROID;
                    mainArtifacts = manifest;
                } else {
                    ImmutableCollection projectJar;
                    dependencyType = ResolvedArtifact.DependencyType.JAVA;
                    ImmutableCollection immutableCollection3 = projectJar = projectJars.get((Object)componentIdentifier);
                    Intrinsics.checkExpressionValueIsNotNull((Object)immutableCollection3, (String)"projectJar");
                    Collection collection2 = (Collection)immutableCollection3;
                    boolean bl2 = false;
                    mainArtifacts = !collection2.isEmpty() ? (Collection)projectJar : (Collection)CollectionsKt.listOf((Object)resolvedComponentResult);
                }
            } else {
                throw (Throwable)new IllegalStateException("Internal error: Artifact type " + artifactType + " not expected, only jar or aar are handled.");
            }
            object = mainArtifacts;
            boolean bl3 = false;
            boolean bl4 = !object.isEmpty();
            bl3 = false;
            bl = false;
            if (!bl4) {
                boolean bl5 = false;
                StringBuilder stringBuilder = new StringBuilder().append("Internal Error: No artifact found for artifactType '").append(componentIdentifier).append("'\n            | context: ");
                GlobalScope globalScope = variantScope.getGlobalScope();
                Intrinsics.checkExpressionValueIsNotNull((Object)globalScope, (String)"variantScope.globalScope");
                Project project3 = globalScope.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project3, (String)"variantScope.globalScope.project");
                String string = StringsKt.trimMargin$default((String)stringBuilder.append(project3.getPath()).append(' ').append(variantScope.getFullVariantName()).append("\n            | manifests = ").append(manifests).append("\n            | explodedAars = ").append(explodedAars).append("\n            | projectJars = ").append(projectJars).append("\n        ").toString(), null, (int)1, null);
                throw (Throwable)new IllegalStateException(string.toString());
            }
            for (ResolvedArtifactResult mainArtifact : mainArtifacts) {
                artifacts2.add(new ResolvedArtifact(mainArtifact, (ResolvedArtifactResult)CollectionsKt.firstOrNull((Iterable)extractedAar), dependencyType, isAarWrappedAsProject, buildMapping));
            }
        }
        LinkedHashSet linkedHashSet = artifacts2;
        Intrinsics.checkExpressionValueIsNotNull((Object)linkedHashSet, (String)"artifacts");
        return linkedHashSet;
    }

    @NotNull
    public static final ImmutableMultimap<ComponentIdentifier, ResolvedArtifactResult> asMultiMap(@NotNull ArtifactCollection $this$asMultiMap) {
        Intrinsics.checkParameterIsNotNull((Object)$this$asMultiMap, (String)"$this$asMultiMap");
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        boolean bl = false;
        boolean bl2 = false;
        ImmutableMultimap.Builder builder2 = builder;
        boolean bl3 = false;
        Iterator iterator = $this$asMultiMap.getArtifacts().iterator();
        while (iterator.hasNext()) {
            ResolvedArtifactResult artifact;
            ResolvedArtifactResult resolvedArtifactResult = artifact = (ResolvedArtifactResult)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)resolvedArtifactResult, (String)"artifact");
            ComponentArtifactIdentifier componentArtifactIdentifier = resolvedArtifactResult.getId();
            Intrinsics.checkExpressionValueIsNotNull((Object)componentArtifactIdentifier, (String)"artifact.id");
            builder2.put((Object)componentArtifactIdentifier.getComponentIdentifier(), (Object)artifact);
        }
        ImmutableMultimap immutableMultimap = builder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)immutableMultimap, (String)"ImmutableMultimap.builde\u2026      }\n        }.build()");
        return immutableMultimap;
    }
}

