/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.scope;

import com.android.build.FilterData;
import com.android.build.VariantOutput;
import com.android.build.gradle.internal.core.VariantDslInfo;
import com.android.build.gradle.internal.ide.FilterDataImpl;
import com.android.build.gradle.internal.scope.ApkData;
import com.android.utils.Pair;
import com.android.utils.StringHelper;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;

public class OutputFactory {
    static final String UNIVERSAL = "universal";
    private final String projectBaseName;
    private final VariantDslInfo variantDslInfo;
    private final AtomicBoolean mainSplitAdded = new AtomicBoolean(false);
    private final AtomicBoolean apkDataListFinalized = new AtomicBoolean(false);
    private final List<ApkData> apkDataList = new ArrayList<ApkData>();

    public OutputFactory(String projectBaseName, VariantDslInfo variantDslInfo) {
        this.projectBaseName = projectBaseName;
        this.variantDslInfo = variantDslInfo;
    }

    private String getOutputFileName(String baseName2) {
        String suffix = this.variantDslInfo.isSigningReady() || !this.variantDslInfo.getVariantType().isBaseModule() ? ".apk" : "-unsigned.apk";
        return this.projectBaseName + "-" + baseName2 + suffix;
    }

    public ApkData addMainOutput(String defaultFilename) {
        Main mainOutput = new Main(this.variantDslInfo.getBaseName(), this.variantDslInfo.getFullName(), defaultFilename);
        this.checkMainSplitExistenceAndAdd(mainOutput);
        return mainOutput;
    }

    public ApkData addMainApk() {
        return this.addMainOutput(this.getOutputFileName(this.variantDslInfo.getBaseName()));
    }

    public ApkData addUniversalApk() {
        String baseName2 = this.variantDslInfo.computeBaseNameWithSplits(UNIVERSAL);
        Universal mainApk = new Universal(baseName2, this.variantDslInfo.computeFullNameWithSplits(UNIVERSAL), this.getOutputFileName(baseName2));
        this.checkMainSplitExistenceAndAdd(mainApk);
        return mainApk;
    }

    public ApkData addFullSplit(ImmutableList<Pair<VariantOutput.FilterType, String>> filters) {
        ImmutableList filtersList = ImmutableList.copyOf((Collection)filters.stream().map(filter -> new FilterDataImpl((VariantOutput.FilterType)filter.getFirst(), (String)filter.getSecond())).collect(Collectors.toList()));
        String filterName = FullSplit._getFilterName((ImmutableList<FilterData>)filtersList);
        String baseName2 = this.variantDslInfo.computeBaseNameWithSplits(filterName);
        FullSplit apkData = new FullSplit(filterName, baseName2, this.variantDslInfo.computeFullNameWithSplits(filterName), this.getOutputFileName(baseName2), filtersList);
        this.addApkDataToList(apkData);
        return apkData;
    }

    private synchronized void addApkDataToList(ApkData apkData) {
        if (this.apkDataListFinalized.get()) {
            throw new RuntimeException("APK list already finalized.");
        }
        this.apkDataList.add(apkData);
    }

    private synchronized void checkMainSplitExistenceAndAdd(ApkData apkData) {
        if (this.mainSplitAdded.get()) {
            throw new RuntimeException("Cannot add " + apkData + " in a scope that already has " + this.apkDataList.stream().filter(it -> it.getType() == VariantOutput.OutputType.MAIN).map(ApkData::toString).collect(Collectors.joining(",")));
        }
        this.mainSplitAdded.set(true);
        this.addApkDataToList(apkData);
    }

    public synchronized List<ApkData> finalizeApkDataList() {
        this.apkDataListFinalized.set(true);
        return ImmutableList.sortedCopyOf(this.apkDataList);
    }

    static class FullSplit
    extends Universal {
        private final ImmutableList<FilterData> filters;
        private final String filterName;

        private FullSplit(String filterName, String baseName2, String fullName, String fileName, ImmutableList<FilterData> filters) {
            super(baseName2, fullName, fileName);
            this.filterName = filterName;
            this.filters = filters;
        }

        private static String _getFilterName(ImmutableList<FilterData> filters) {
            String abiFilter;
            StringBuilder sb = new StringBuilder();
            String densityFilter = ApkData.getFilter(filters, VariantOutput.FilterType.DENSITY);
            if (densityFilter != null) {
                sb.append(densityFilter);
            }
            if ((abiFilter = FullSplit.getFilter(filters, VariantOutput.FilterType.ABI)) != null) {
                StringHelper.appendCamelCase((StringBuilder)sb, (String)abiFilter);
            }
            return sb.toString();
        }

        @Override
        public VariantOutput.OutputType getType() {
            return VariantOutput.OutputType.FULL_SPLIT;
        }

        public ImmutableList<FilterData> getFilters() {
            return this.filters;
        }

        @Override
        public String getFilterName() {
            return this.filterName;
        }

        @Override
        public String getDirName() {
            StringBuilder sb = new StringBuilder();
            for (FilterData filter : this.getFilters()) {
                sb.append(filter.getIdentifier()).append(File.separatorChar);
            }
            return sb.toString();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            FullSplit that = (FullSplit)o;
            return Objects.equals(this.filterName, that.filterName) && Objects.equals(this.filters, that.filters);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.filterName, this.filters);
        }
    }

    private static class Universal
    extends ApkData {
        private final String baseName;
        private final String fullName;

        private Universal(String baseName2, String fullName, String fileName) {
            this.baseName = baseName2;
            this.fullName = fullName;
            this.setOutputFileName(fileName);
        }

        @Override
        public VariantOutput.OutputType getType() {
            return VariantOutput.OutputType.FULL_SPLIT;
        }

        @Override
        public String getFilterName() {
            return OutputFactory.UNIVERSAL;
        }

        @Override
        public String getBaseName() {
            return this.baseName;
        }

        @Override
        public String getFullName() {
            return this.fullName;
        }

        @Override
        public boolean isUniversal() {
            return true;
        }

        @Override
        public String getDirName() {
            Preconditions.checkState((boolean)this.getFilters().isEmpty(), (Object)"Universal APKs shouldn't have any filters set.");
            return OutputFactory.UNIVERSAL;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Universal that = (Universal)o;
            return Objects.equals(this.baseName, that.baseName) && Objects.equals(this.fullName, that.fullName);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.baseName, this.fullName);
        }
    }

    private static final class Main
    extends ApkData {
        private final String baseName;
        private final String fullName;

        private Main(String baseName2, String fullName, String fileName) {
            this.baseName = baseName2;
            this.fullName = fullName;
            this.setOutputFileName(fileName);
        }

        @Override
        public VariantOutput.OutputType getType() {
            return VariantOutput.OutputType.MAIN;
        }

        @Override
        public String getFilterName() {
            return null;
        }

        @Override
        public String getBaseName() {
            return this.baseName;
        }

        @Override
        public String getFullName() {
            return this.fullName;
        }

        @Override
        public String getDirName() {
            return "";
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.baseName, this.fullName);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Main that = (Main)o;
            return Objects.equals(this.baseName, that.baseName) && Objects.equals(this.fullName, that.fullName);
        }
    }
}

