/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks.databinding;

import android.databinding.tool.LayoutXmlProcessor;
import android.databinding.tool.processing.Scope;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.options.BooleanOption;
import java.io.File;
import javax.inject.Inject;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskProvider;

@CacheableTask
public abstract class DataBindingExportBuildInfoTask
extends NonIncrementalTask {
    private final Property<LayoutXmlProcessor> xmlProcessor;
    private boolean useAndroidX;
    private File emptyClassOutDir;

    @Inject
    public DataBindingExportBuildInfoTask(ObjectFactory objectFactory) {
        this.xmlProcessor = objectFactory.property(LayoutXmlProcessor.class);
    }

    @Input
    public boolean isUseAndroidX() {
        return this.useAndroidX;
    }

    @OutputDirectory
    public File getEmptyClassOutDir() {
        return this.emptyClassOutDir;
    }

    @Override
    protected void doTaskAction() {
        ((LayoutXmlProcessor)this.xmlProcessor.get()).writeEmptyInfoClass(this.useAndroidX);
        Scope.assertNoError();
    }

    public static class CreationAction
    extends VariantTaskCreationAction<DataBindingExportBuildInfoTask> {
        public CreationAction(VariantScope variantScope) {
            super(variantScope);
        }

        @Override
        public String getName() {
            return this.getVariantScope().getTaskName("dataBindingExportBuildInfo");
        }

        @Override
        public Class<DataBindingExportBuildInfoTask> getType() {
            return DataBindingExportBuildInfoTask.class;
        }

        @Override
        public void handleProvider(TaskProvider<? extends DataBindingExportBuildInfoTask> taskProvider) {
            super.handleProvider(taskProvider);
            this.getVariantScope().getTaskContainer().setDataBindingExportBuildInfoTask(taskProvider);
        }

        @Override
        public void configure(DataBindingExportBuildInfoTask task) {
            super.configure(task);
            VariantScope variantScope = this.getVariantScope();
            task.xmlProcessor.set(variantScope.getGlobalScope().getProject().provider(variantScope.getVariantData()::getLayoutXmlProcessor));
            task.xmlProcessor.disallowChanges();
            task.useAndroidX = variantScope.getGlobalScope().getProjectOptions().get(BooleanOption.USE_ANDROID_X);
            task.emptyClassOutDir = variantScope.getClassOutputForDataBinding();
            task.dependsOn(new Object[]{variantScope.getTaskContainer().getSourceGenTask()});
        }
    }
}

