/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.variant;

import com.android.build.gradle.internal.errors.SyncIssueHandler;
import com.android.build.gradle.internal.variant.FlavorCombination;
import com.android.builder.core.VariantType;
import com.android.builder.errors.EvalIssueReporter;
import com.android.utils.StringHelper;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000<\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\u001a(\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001aZ\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00010\u00032\u0018\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u00030\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u000e2\b\b\u0002\u0010\u0012\u001a\u00020\u0013H\u0002\u00a8\u0006\u0014"}, d2={"computeVariantName", "", "flavorNames", "", "buildType", "type", "Lcom/android/builder/core/VariantType;", "createProductFlavorCombinations", "", "flavorDimensionList", "flavorMap", "", "comboList", "Lcom/google/common/collect/ImmutableList$Builder;", "Lcom/android/build/gradle/internal/variant/FlavorCombination;", "errorReporter", "Lcom/android/build/gradle/internal/errors/SyncIssueHandler;", "currentFlavorCombo", "dimensionIndex", "", "gradle"})
public final class VariantCombinatorKt {
    private static final void createProductFlavorCombinations(List<String> flavorDimensionList, Map<String, ? extends List<String>> flavorMap2, ImmutableList.Builder<FlavorCombination> comboList, SyncIssueHandler errorReporter, FlavorCombination currentFlavorCombo, int dimensionIndex) {
        if (dimensionIndex == flavorDimensionList.size()) {
            comboList.add((Object)currentFlavorCombo);
            return;
        }
        String dimension = flavorDimensionList.get(dimensionIndex);
        List<String> flavorList = flavorMap2.get(dimension);
        if (flavorList == null || flavorList.isEmpty()) {
            EvalIssueReporter.reportError$default((EvalIssueReporter)errorReporter, (EvalIssueReporter.Type)EvalIssueReporter.Type.GENERIC, (String)("No flavor is associated with flavor dimension '" + dimension + "'."), null, null, (int)12, null);
        } else {
            for (String flavor : flavorList) {
                FlavorCombination newCombo = currentFlavorCombo.add(dimension, flavor);
                VariantCombinatorKt.createProductFlavorCombinations(flavorDimensionList, flavorMap2, comboList, errorReporter, newCombo, dimensionIndex + 1);
            }
        }
    }

    static /* synthetic */ void createProductFlavorCombinations$default(List list, Map map, ImmutableList.Builder builder, SyncIssueHandler syncIssueHandler, FlavorCombination flavorCombination, int n, int n2, Object object) {
        if ((n2 & 0x10) != 0) {
            flavorCombination = new FlavorCombination(null, 1, null);
        }
        if ((n2 & 0x20) != 0) {
            n = 0;
        }
        VariantCombinatorKt.createProductFlavorCombinations(list, map, (ImmutableList.Builder<FlavorCombination>)builder, syncIssueHandler, flavorCombination, n);
    }

    private static final String computeVariantName(List<String> flavorNames, String buildType, VariantType type) {
        StringBuilder sb = new StringBuilder();
        Collection collection = flavorNames;
        boolean bl = false;
        if (!collection.isEmpty()) {
            sb.append(StringHelper.combineAsCamelCase((Iterable)flavorNames));
            if (buildType != null) {
                StringHelper.appendCapitalized((StringBuilder)sb, (String)buildType);
            }
        } else if (buildType != null) {
            sb.append(buildType);
        } else {
            throw (Throwable)new IllegalStateException("build type cannot be null with no flavors");
        }
        if (type.isTestComponent()) {
            sb.append(type.getSuffix());
        }
        String string = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
        return string;
    }

    public static final /* synthetic */ String access$computeVariantName(List flavorNames, String buildType, VariantType type) {
        return VariantCombinatorKt.computeVariantName(flavorNames, buildType, type);
    }
}

