/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.SdkConstants;
import com.android.build.gradle.internal.core.VariantDslInfo;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.utils.AndroidXDependency;
import com.android.tools.lint.gradle.api.ExtractAnnotationRequest;
import com.android.tools.lint.gradle.api.ReflectiveLintRunner;
import com.android.utils.FileUtils;
import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.file.EmptyFileVisitor;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.file.RelativePath;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.CompileClasspath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskProvider;

@CacheableTask
public abstract class ExtractAnnotations
extends NonIncrementalTask {
    private static final AndroidXDependency ANDROIDX_ANNOTATIONS = AndroidXDependency.fromPreAndroidXDependency("com.android.support", "support-annotations");
    private FileCollection bootClasspath;
    private String encoding;
    private FileCollection classDir;
    private ArtifactCollection libraries;
    FileCollection lintClassPath;
    private final List<Object> sources = new ArrayList<Object>();
    private FileCollection classpath;

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileCollection getLintClassPath() {
        return this.lintClassPath;
    }

    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    @InputFiles
    public FileTree getSource() {
        return this.getProject().files(new Object[]{this.sources}).getAsFileTree();
    }

    @CompileClasspath
    public FileCollection getClasspath() {
        return this.classpath;
    }

    public void source(Object source) {
        this.sources.add(source);
    }

    @CompileClasspath
    public FileCollection getBootClasspath() {
        return this.bootClasspath;
    }

    public void setBootClasspath(FileCollection bootClasspath2) {
        this.bootClasspath = bootClasspath2;
    }

    @CompileClasspath
    public FileCollection getLibraries() {
        return this.libraries.getArtifactFiles();
    }

    @OutputFile
    public abstract RegularFileProperty getOutput();

    @OutputFile
    public abstract RegularFileProperty getTypedefFile();

    @Input
    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Optional
    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileCollection getClassDir() {
        return this.classDir;
    }

    public void setClassDir(FileCollection classDir) {
        this.classDir = classDir;
    }

    @Override
    protected void doTaskAction() {
        SourceFileVisitor fileVisitor = new SourceFileVisitor();
        this.getSource().visit((FileVisitor)fileVisitor);
        List sourceFiles = fileVisitor.sourceUnits;
        if (!ExtractAnnotations.containsTypeDefs(sourceFiles)) {
            ExtractAnnotations.writeEmptyTypeDefFile(((RegularFile)this.getTypedefFile().get()).getAsFile());
            return;
        }
        List<File> roots = fileVisitor.getSourceRoots();
        FileCollection classpath = this.getClasspath();
        if (classpath != null) {
            for (File jar : classpath) {
                roots.add(jar);
            }
        }
        roots.addAll(this.getBootClasspath().getFiles());
        ExtractAnnotationRequest request2 = new ExtractAnnotationRequest(((RegularFile)this.getTypedefFile().get()).getAsFile(), this.getLogger(), this.getClassDir(), ((RegularFile)this.getOutput().get()).getAsFile(), sourceFiles, roots);
        FileCollection lintClassPath = this.getLintClassPath();
        if (lintClassPath != null) {
            new ReflectiveLintRunner().extractAnnotations(this.getProject().getGradle(), request2, lintClassPath.getFiles());
        }
    }

    private static void writeEmptyTypeDefFile(File file) {
        if (file == null) {
            return;
        }
        try {
            FileUtils.deleteIfExists((File)file);
            Files.createParentDirs((File)file);
            Files.asCharSink((File)file, (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)"");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static boolean containsTypeDefs(List<File> sourceFiles) {
        for (File file : sourceFiles) {
            if (!ExtractAnnotations.containsTypeDefs(file)) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean containsTypeDefs(File file) {
        try (Stream lines = Files.asCharSource((File)file, (Charset)StandardCharsets.UTF_8).lines();){
            boolean bl = lines.anyMatch(line -> line.contains("Def") && (line.contains(SdkConstants.INT_DEF_ANNOTATION.oldName()) || line.contains(SdkConstants.INT_DEF_ANNOTATION.newName()) || line.contains(SdkConstants.LONG_DEF_ANNOTATION.oldName()) || line.contains(SdkConstants.LONG_DEF_ANNOTATION.newName()) || line.contains(SdkConstants.STRING_DEF_ANNOTATION.oldName()) || line.contains(SdkConstants.STRING_DEF_ANNOTATION.newName())));
            return bl;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Input
    public boolean getHasAndroidAnnotations() {
        for (ResolvedArtifactResult artifact : this.libraries.getArtifacts()) {
            ModuleComponentIdentifier moduleId;
            ComponentIdentifier id = artifact.getId().getComponentIdentifier();
            if (!(id instanceof ModuleComponentIdentifier) || (!(moduleId = (ModuleComponentIdentifier)id).getGroup().equals(ANDROIDX_ANNOTATIONS.getGroup()) || !moduleId.getModule().equals(ANDROIDX_ANNOTATIONS.getModule())) && (!moduleId.getGroup().equals(ANDROIDX_ANNOTATIONS.getOldGroup()) || !moduleId.getModule().equals(ANDROIDX_ANNOTATIONS.getOldModule()))) continue;
            return true;
        }
        return false;
    }

    private static class SourceFileVisitor
    extends EmptyFileVisitor {
        private final List<File> sourceUnits = Lists.newArrayListWithExpectedSize((int)100);
        private final List<File> sourceRoots = Lists.newArrayList();
        private String mostRecentRoot = "\u0000";
        private static final String BUILD_GENERATED = File.separator + "build" + File.separator + "generated" + File.separator;

        public List<File> getSourceFiles() {
            return this.sourceUnits;
        }

        public List<File> getSourceRoots() {
            return this.sourceRoots;
        }

        public void visitFile(FileVisitDetails details) {
            File file = details.getFile();
            String path = file.getPath();
            if (path.endsWith(".java") && !path.contains(BUILD_GENERATED)) {
                if (!path.startsWith(this.mostRecentRoot)) {
                    String root;
                    File rootFile;
                    RelativePath relativePath = details.getRelativePath();
                    String pathString = relativePath.getPathString();
                    if (path.endsWith(pathString = pathString.replace('/', File.separatorChar)) && !this.sourceRoots.contains(rootFile = new File(root = path.substring(0, path.length() - pathString.length())))) {
                        this.mostRecentRoot = rootFile.getPath();
                        this.sourceRoots.add(rootFile);
                    }
                }
                this.sourceUnits.add(file);
            }
        }
    }

    public static class CreationAction
    extends VariantTaskCreationAction<ExtractAnnotations> {
        public CreationAction(VariantScope variantScope) {
            super(variantScope);
        }

        @Override
        public String getName() {
            return this.getVariantScope().getTaskName("extract", "Annotations");
        }

        @Override
        public Class<ExtractAnnotations> getType() {
            return ExtractAnnotations.class;
        }

        @Override
        public void handleProvider(TaskProvider<? extends ExtractAnnotations> taskProvider) {
            super.handleProvider(taskProvider);
            this.getVariantScope().getTaskContainer().setGenerateAnnotationsTask(taskProvider);
            this.getVariantScope().getArtifacts().producesFile(InternalArtifactType.ANNOTATIONS_ZIP.INSTANCE, taskProvider, ExtractAnnotations::getOutput, "annotations.zip");
            this.getVariantScope().getArtifacts().producesFile(InternalArtifactType.ANNOTATIONS_TYPEDEF_FILE.INSTANCE, taskProvider, ExtractAnnotations::getTypedefFile, "typedefs.txt");
        }

        @Override
        public void configure(ExtractAnnotations task) {
            super.configure(task);
            VariantScope variantScope = this.getVariantScope();
            VariantDslInfo variantDslInfo = variantScope.getVariantDslInfo();
            task.setDescription("Extracts Android annotations for the " + variantDslInfo.getFullName() + " variant into the archive file");
            task.setGroup("build");
            task.setClassDir(variantScope.getArtifacts().getAllClasses());
            task.source(variantScope.getVariantData().getJavaSources());
            task.setEncoding(variantScope.getGlobalScope().getExtension().getCompileOptions().getEncoding());
            task.classpath = variantScope.getJavaClasspath(AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH, AndroidArtifacts.ArtifactType.CLASSES_JAR);
            task.libraries = variantScope.getArtifactCollection(AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH, AndroidArtifacts.ArtifactScope.EXTERNAL, AndroidArtifacts.ArtifactType.CLASSES_JAR);
            GlobalScope globalScope = variantScope.getGlobalScope();
            task.setBootClasspath(globalScope.getFilteredBootClasspath());
            task.lintClassPath = globalScope.getProject().getConfigurations().getByName("lintClassPath");
        }
    }
}

