/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.api.artifact.ArtifactType;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.SingleArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.tasks.PackageAndroidArtifact;
import com.android.builder.profile.ProcessProfileWriter;
import com.google.wireless.android.sdk.stats.GradleBuildProjectMetrics;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import kotlin.jvm.functions.Function1;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskProvider;

public abstract class PackageApplication
extends PackageAndroidArtifact {
    ArtifactType<Directory> expectedOutputType;

    @Override
    @Internal
    protected ArtifactType<Directory> getInternalArtifactType() {
        return this.expectedOutputType;
    }

    public static void recordMetrics(String projectPath, File apkOutputFile, File resourcesApFile) {
        Long resourcesApSize;
        long metricsStartTime = System.nanoTime();
        GradleBuildProjectMetrics.Builder metrics = GradleBuildProjectMetrics.newBuilder();
        Long apkSize = PackageApplication.getSize(apkOutputFile);
        if (apkSize != null) {
            metrics.setApkSize(apkSize.longValue());
        }
        if ((resourcesApSize = PackageApplication.getSize(resourcesApFile)) != null) {
            metrics.setResourcesApSize(resourcesApSize.longValue());
        }
        metrics.setMetricsTimeNs(System.nanoTime() - metricsStartTime);
        ProcessProfileWriter.getProject((String)projectPath).setMetrics(metrics);
    }

    private static Long getSize(File file) {
        if (file == null) {
            return null;
        }
        try {
            return Files.size(file.toPath());
        }
        catch (IOException e) {
            return null;
        }
    }

    public static class CreationAction
    extends PackageAndroidArtifact.CreationAction<PackageApplication> {
        private final File outputDirectory;

        public CreationAction(VariantScope packagingScope, File outputDirectory, SingleArtifactType<Directory> inputResourceFilesType, Provider<Directory> manifests, ArtifactType<Directory> manifestType, boolean packageCustomClassDependencies) {
            super(packagingScope, inputResourceFilesType, manifests, manifestType, packageCustomClassDependencies);
            this.outputDirectory = outputDirectory;
        }

        @Override
        public String getName() {
            return this.getVariantScope().getTaskName("package");
        }

        @Override
        public Class<PackageApplication> getType() {
            return PackageApplication.class;
        }

        @Override
        public void handleProvider(TaskProvider<? extends PackageApplication> taskProvider) {
            super.handleProvider(taskProvider);
            this.getVariantScope().getTaskContainer().setPackageAndroidTask(taskProvider);
            this.getVariantScope().getArtifacts().producesDir(InternalArtifactType.APK.INSTANCE, taskProvider, PackageAndroidArtifact::getOutputDirectory, this.outputDirectory.getAbsolutePath(), "");
            this.getVariantScope().getArtifacts().getOperations().setInitialProvider(taskProvider, PackageAndroidArtifact::getIdeModelOutputFile).atLocation((Function1<? extends PackageApplication, DirectoryProperty>)((Function1)PackageAndroidArtifact::getOutputDirectory)).withName("output.json").on(InternalArtifactType.APK_IDE_MODEL.INSTANCE);
        }

        @Override
        protected void finalConfigure(PackageApplication task) {
            super.finalConfigure(task);
            task.expectedOutputType = InternalArtifactType.APK.INSTANCE;
        }
    }
}

