/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.SdkConstants;
import com.android.build.gradle.internal.core.Abi;
import com.android.build.gradle.internal.cxx.configure.CmakeLocatorKt;
import com.android.build.gradle.internal.cxx.configure.ExternalNativeJsonGenerationUtilKt;
import com.android.build.gradle.internal.cxx.configure.JsonGenerationInvalidationState;
import com.android.build.gradle.internal.cxx.json.AndroidBuildGradleJsons;
import com.android.build.gradle.internal.cxx.json.NativeBuildConfigValueMini;
import com.android.build.gradle.internal.cxx.json.NativeLibraryValueMini;
import com.android.build.gradle.internal.cxx.logging.IssueReporterLoggingEnvironment;
import com.android.build.gradle.internal.cxx.logging.LoggingEnvironmentKt;
import com.android.build.gradle.internal.cxx.logging.PassThroughDeduplicatingLoggingEnvironmentKt;
import com.android.build.gradle.internal.cxx.logging.PassThroughPrefixingLoggingEnvironment;
import com.android.build.gradle.internal.cxx.model.CreateCxxAbiModelKt;
import com.android.build.gradle.internal.cxx.model.CreateCxxVariantModelKt;
import com.android.build.gradle.internal.cxx.model.CxxAbiModel;
import com.android.build.gradle.internal.cxx.model.CxxAbiModelKt;
import com.android.build.gradle.internal.cxx.model.CxxBuildModel;
import com.android.build.gradle.internal.cxx.model.CxxCmakeModuleModel;
import com.android.build.gradle.internal.cxx.model.CxxModuleModel;
import com.android.build.gradle.internal.cxx.model.CxxVariantModel;
import com.android.build.gradle.internal.cxx.model.CxxVariantModelKt;
import com.android.build.gradle.internal.cxx.model.GetCxxBuildModelKt;
import com.android.build.gradle.internal.cxx.model.PrefabConfigurationState;
import com.android.build.gradle.internal.cxx.services.CxxBuildModelListenerServiceKt;
import com.android.build.gradle.internal.cxx.services.CxxCompleteModelServiceKt;
import com.android.build.gradle.internal.cxx.services.CxxEvalIssueReporterServiceKt;
import com.android.build.gradle.internal.cxx.services.CxxModelDependencyServiceKt;
import com.android.build.gradle.internal.cxx.services.CxxSyncListenerServiceKt;
import com.android.build.gradle.internal.cxx.settings.CxxAbiModelCMakeSettingsRewriterKt;
import com.android.build.gradle.internal.profile.AnalyticsUtil;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.tasks.CmakeAndroidNinjaExternalNativeJsonGenerator;
import com.android.build.gradle.tasks.CmakeServerExternalNativeJsonGenerator;
import com.android.build.gradle.tasks.GeneratePrefabPackagesKt;
import com.android.build.gradle.tasks.NativeBuildSystem;
import com.android.build.gradle.tasks.NdkBuildExternalNativeJsonGenerator;
import com.android.builder.profile.ProcessProfileWriter;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessInfoBuilder;
import com.android.repository.Revision;
import com.android.utils.FileUtils;
import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import com.google.wireless.android.sdk.stats.GradleBuildVariant;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFiles;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.process.ExecResult;
import org.gradle.process.ExecSpec;
import org.gradle.process.JavaExecSpec;

public abstract class ExternalNativeJsonGenerator {
    protected final CxxBuildModel build;
    protected final CxxVariantModel variant;
    protected final List<CxxAbiModel> abis;
    protected final GradleBuildVariant.Builder stats;

    ExternalNativeJsonGenerator(CxxBuildModel build2, CxxVariantModel variant2, List<CxxAbiModel> abis, GradleBuildVariant.Builder stats) {
        this.build = build2;
        this.variant = variant2;
        this.abis = abis;
        this.stats = stats;
    }

    protected static boolean isWindows() {
        return SdkConstants.CURRENT_PLATFORM == 2;
    }

    private List<File> getDependentBuildFiles(File json) throws IOException {
        ArrayList result = Lists.newArrayList();
        if (!json.exists()) {
            return result;
        }
        NativeBuildConfigValueMini config2 = AndroidBuildGradleJsons.getNativeBuildMiniConfig(json, this.stats);
        for (File pkgDir : this.variant.getPrefabPackageDirectoryList()) {
            Files.walk(pkgDir.toPath(), new FileVisitOption[0]).forEach(it -> result.add(it.toFile()));
        }
        result.addAll(config2.buildFiles);
        return result;
    }

    public void build(Function<Action<? super ExecSpec>, ExecResult> execOperation, Function<Action<? super JavaExecSpec>, ExecResult> javaExecOperation) throws IOException, ProcessException {
        this.buildAndPropagateException(false, execOperation, javaExecOperation);
    }

    public void build(boolean forceJsonGeneration, Function<Action<? super ExecSpec>, ExecResult> execOperation, Function<Action<? super JavaExecSpec>, ExecResult> javaExecOperation) {
        try {
            LoggingEnvironmentKt.infoln("building json with force flag %s", forceJsonGeneration);
            this.buildAndPropagateException(forceJsonGeneration, execOperation, javaExecOperation);
        }
        catch (IOException | GradleException e) {
            LoggingEnvironmentKt.errorln("exception while building Json $%s", e.getMessage());
        }
        catch (ProcessException e) {
            LoggingEnvironmentKt.errorln("executing external native build for %s %s", this.getNativeBuildSystem().getTag(), this.variant.getModule().getMakeFile());
        }
    }

    public List<Callable<Void>> parallelBuild(boolean forceJsonGeneration, Function<Action<? super ExecSpec>, ExecResult> execOperation, Function<Action<? super JavaExecSpec>, ExecResult> javaExecOperation) {
        ArrayList<Callable<Void>> buildSteps = new ArrayList<Callable<Void>>(this.abis.size());
        this.variant.getPrefabPackageDirectoryList();
        for (CxxAbiModel abi : this.abis) {
            buildSteps.add(() -> this.buildForOneConfigurationConvertExceptions(forceJsonGeneration, abi, execOperation, javaExecOperation));
        }
        return buildSteps;
    }

    private Void buildForOneConfigurationConvertExceptions(boolean forceJsonGeneration, CxxAbiModel abi, Function<Action<? super ExecSpec>, ExecResult> execOperation, Function<Action<? super JavaExecSpec>, ExecResult> javaExecOperation) {
        try (IssueReporterLoggingEnvironment ignore = new IssueReporterLoggingEnvironment(CxxEvalIssueReporterServiceKt.issueReporter(abi.getVariant().getModule()));){
            try {
                this.buildForOneConfiguration(forceJsonGeneration, abi, execOperation, javaExecOperation);
            }
            catch (IOException | GradleException e) {
                LoggingEnvironmentKt.errorln("exception while building Json %s", e.getMessage());
            }
            catch (ProcessException e) {
                LoggingEnvironmentKt.errorln("executing external native build for %s %s", this.getNativeBuildSystem().getTag(), this.variant.getModule().getMakeFile());
            }
            Void void_ = null;
            return void_;
        }
    }

    private static String getPreviousBuildCommand(File commandFile) throws IOException {
        if (!commandFile.exists()) {
            return "";
        }
        return new String(Files.readAllBytes(commandFile.toPath()), Charsets.UTF_8);
    }

    private static PrefabConfigurationState getPreviousPrefabConfigurationState(File prefabStateFile) throws IOException {
        if (!prefabStateFile.exists()) {
            return new PrefabConfigurationState(false, null, Collections.emptyList());
        }
        return PrefabConfigurationState.fromJson(new String(Files.readAllBytes(prefabStateFile.toPath()), Charsets.UTF_8));
    }

    protected void checkPrefabConfig() {
    }

    private void buildAndPropagateException(boolean forceJsonGeneration, Function<Action<? super ExecSpec>, ExecResult> execOperation, Function<Action<? super JavaExecSpec>, ExecResult> javaExecOperation) throws IOException, ProcessException {
        Throwable firstException = null;
        for (CxxAbiModel abi : this.abis) {
            try {
                this.buildForOneConfiguration(forceJsonGeneration, abi, execOperation, javaExecOperation);
            }
            catch (ProcessException | IOException | GradleException e) {
                if (firstException != null) continue;
                firstException = e;
            }
        }
        if (firstException != null) {
            if (firstException instanceof GradleException) {
                throw (GradleException)firstException;
            }
            if (firstException instanceof IOException) {
                throw (IOException)firstException;
            }
            throw (ProcessException)firstException;
        }
    }

    public void buildForOneAbiName(boolean forceJsonGeneration, String abiName, Function<Action<? super ExecSpec>, ExecResult> execOperation, Function<Action<? super JavaExecSpec>, ExecResult> javaExecOperation) {
        int built = 0;
        for (CxxAbiModel abi : this.abis) {
            if (!abi.getAbi().getTag().equals(abiName)) continue;
            ++built;
            this.buildForOneConfigurationConvertExceptions(forceJsonGeneration, abi, execOperation, javaExecOperation);
        }
        assert (built == 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildForOneConfiguration(boolean forceJsonGeneration, CxxAbiModel abi, Function<Action<? super ExecSpec>, ExecResult> execOperation, Function<Action<? super JavaExecSpec>, ExecResult> javaExecOperation) throws GradleException, IOException, ProcessException {
        try (PassThroughPrefixingLoggingEnvironment recorder = new PassThroughPrefixingLoggingEnvironment(abi.getVariant().getModule().getMakeFile(), abi.getVariant().getVariantName() + "|" + abi.getAbi().getTag());){
            GradleBuildVariant.NativeBuildConfigInfo.Builder variantStats = GradleBuildVariant.NativeBuildConfigInfo.newBuilder();
            variantStats.setAbi(AnalyticsUtil.getAbi(abi.getAbi().getTag()));
            variantStats.setDebuggable(this.variant.isDebuggableEnabled());
            long startTime = System.currentTimeMillis();
            variantStats.setGenerationStartMs(startTime);
            try {
                LoggingEnvironmentKt.infoln("Start JSON generation. Platform version: %s min SDK version: %s", abi.getAbiPlatformVersion(), abi.getAbi().getTag(), abi.getAbiPlatformVersion());
                if (!CxxBuildModelListenerServiceKt.executeListenersOnceBeforeJsonGeneration(this.build)) {
                    LoggingEnvironmentKt.infoln("Errors seen in validation before JSON generation started", new Object[0]);
                    return;
                }
                ProcessInfoBuilder processBuilder = this.getProcessBuilder(abi);
                String currentBuildCommand = processBuilder.toString() + "Build command args:" + CxxAbiModelCMakeSettingsRewriterKt.getBuildCommandArguments(abi) + "\n";
                PrefabConfigurationState prefabState = new PrefabConfigurationState(abi.getVariant().getModule().getProject().isPrefabEnabled(), abi.getVariant().getModule().getProject().getPrefabClassPath(), this.variant.getPrefabPackageDirectoryList());
                PrefabConfigurationState previousPrefabState = ExternalNativeJsonGenerator.getPreviousPrefabConfigurationState(CxxAbiModelKt.getPrefabConfigFile(abi));
                JsonGenerationInvalidationState invalidationState = new JsonGenerationInvalidationState(forceJsonGeneration, CxxAbiModelKt.getJsonFile(abi), CxxAbiModelKt.getBuildCommandFile(abi), currentBuildCommand, ExternalNativeJsonGenerator.getPreviousBuildCommand(CxxAbiModelKt.getBuildCommandFile(abi)), this.getDependentBuildFiles(CxxAbiModelKt.getJsonFile(abi)), prefabState, previousPrefabState);
                if (invalidationState.getRebuild()) {
                    LoggingEnvironmentKt.infoln("rebuilding JSON %s due to:", CxxAbiModelKt.getJsonFile(abi));
                    for (String reason : invalidationState.getRebuildReasons()) {
                        LoggingEnvironmentKt.infoln(reason, new Object[0]);
                    }
                    if (CxxAbiModelKt.shouldGeneratePrefabPackages(abi)) {
                        this.checkPrefabConfig();
                        GeneratePrefabPackagesKt.generatePrefabPackages(this.getNativeBuildSystem(), this.variant.getModule(), abi, this.variant.getPrefabPackageDirectoryList(), javaExecOperation);
                    }
                    if (abi.getCxxBuildFolder().getParentFile().exists()) {
                        if (invalidationState.getSoftRegeneration()) {
                            LoggingEnvironmentKt.infoln("keeping json folder '%s' but regenerating project", abi.getCxxBuildFolder());
                        } else {
                            LoggingEnvironmentKt.infoln("removing stale contents from '%s'", abi.getCxxBuildFolder());
                            FileUtils.deletePath((File)abi.getCxxBuildFolder());
                        }
                    }
                    if (abi.getCxxBuildFolder().mkdirs()) {
                        LoggingEnvironmentKt.infoln("created folder '%s'", abi.getCxxBuildFolder());
                    }
                    LoggingEnvironmentKt.infoln("executing %s %s", this.getNativeBuildSystem().getTag(), processBuilder);
                    String buildOutput = this.executeProcess(abi, execOperation);
                    LoggingEnvironmentKt.infoln("done executing %s", this.getNativeBuildSystem().getTag());
                    LoggingEnvironmentKt.infoln("write build output %s", CxxAbiModelKt.getBuildOutputFile(abi).getAbsolutePath());
                    Files.write(CxxAbiModelKt.getBuildOutputFile(abi).toPath(), buildOutput.getBytes(Charsets.UTF_8), new OpenOption[0]);
                    this.processBuildOutput(buildOutput, abi);
                    if (!CxxAbiModelKt.getJsonFile(abi).exists()) {
                        throw new GradleException(String.format("Expected json generation to create '%s' but it didn't", CxxAbiModelKt.getJsonFile(abi)));
                    }
                    GradleBuildVariant.Builder builder = this.stats;
                    synchronized (builder) {
                        ExternalNativeJsonGenerator.removeUnexpectedSoFiles(CxxAbiModelKt.getSoFolder(abi), AndroidBuildGradleJsons.getNativeBuildMiniConfig(CxxAbiModelKt.getJsonFile(abi), this.stats));
                    }
                    LoggingEnvironmentKt.infoln("write command file %s", CxxAbiModelKt.getBuildCommandFile(abi).getAbsolutePath());
                    Files.write(CxxAbiModelKt.getBuildCommandFile(abi).toPath(), currentBuildCommand.getBytes(Charsets.UTF_8), new OpenOption[0]);
                    Files.write(CxxAbiModelKt.getPrefabConfigFile(abi).toPath(), prefabState.toJsonString().getBytes(Charsets.UTF_8), new OpenOption[0]);
                    variantStats.setOutcome(GradleBuildVariant.NativeBuildConfigInfo.GenerationOutcome.SUCCESS_BUILT);
                } else {
                    LoggingEnvironmentKt.infoln("JSON '%s' was up-to-date", CxxAbiModelKt.getJsonFile(abi));
                    variantStats.setOutcome(GradleBuildVariant.NativeBuildConfigInfo.GenerationOutcome.SUCCESS_UP_TO_DATE);
                }
                LoggingEnvironmentKt.infoln("JSON generation completed without problems", new Object[0]);
            }
            catch (ProcessException | IOException | GradleException e) {
                variantStats.setOutcome(GradleBuildVariant.NativeBuildConfigInfo.GenerationOutcome.FAILED);
                LoggingEnvironmentKt.infoln("JSON generation completed with problem. Exception: " + e.toString(), new Object[0]);
                throw e;
            }
            finally {
                variantStats.setGenerationDurationMs(System.currentTimeMillis() - startTime);
                GradleBuildVariant.Builder builder = this.stats;
                synchronized (builder) {
                    this.stats.addNativeBuildConfig(variantStats);
                }
                CxxAbiModelKt.getJsonGenerationLoggingRecordFile(abi).getParentFile().mkdirs();
                Files.write(CxxAbiModelKt.getJsonGenerationLoggingRecordFile(abi).toPath(), PassThroughDeduplicatingLoggingEnvironmentKt.toJsonString(recorder.getRecord()).getBytes(Charsets.UTF_8), new OpenOption[0]);
                CxxSyncListenerServiceKt.executeListenersOnceAfterJsonGeneration(abi);
            }
        }
    }

    private static void removeUnexpectedSoFiles(File expectedOutputFolder, NativeBuildConfigValueMini config2) throws IOException {
        if (!expectedOutputFolder.isDirectory()) {
            return;
        }
        ArrayList expectedSoFiles = Lists.newArrayList();
        for (NativeLibraryValueMini library : config2.libraries.values()) {
            assert (library.output != null);
            expectedSoFiles.add(library.output.toPath());
        }
        try (Stream<Path> paths = Files.walk(expectedOutputFolder.toPath(), new FileVisitOption[0]);){
            paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.toString().endsWith(".so")).filter(path -> !expectedSoFiles.contains(path)).forEach(path -> {
                if (path.toFile().delete()) {
                    LoggingEnvironmentKt.infoln("deleted unexpected build output %s in incremental regenerate", path);
                }
            });
        }
    }

    abstract void processBuildOutput(String var1, CxxAbiModel var2) throws IOException;

    abstract ProcessInfoBuilder getProcessBuilder(CxxAbiModel var1);

    abstract String executeProcess(CxxAbiModel var1, Function<Action<? super ExecSpec>, ExecResult> var2) throws ProcessException, IOException;

    @Input
    public abstract NativeBuildSystem getNativeBuildSystem();

    @Internal(value="Temporary to suppress Gradle warnings (bug 135900510), may need more investigation")
    abstract Map<Abi, File> getStlSharedObjectFiles();

    @Input
    public String getVariantName() {
        return this.variant.getVariantName();
    }

    public static ExternalNativeJsonGenerator create(CxxModuleModel module2, VariantScope scope) {
        try (IssueReporterLoggingEnvironment ignore = new IssueReporterLoggingEnvironment(CxxEvalIssueReporterServiceKt.issueReporter(module2));){
            ExternalNativeJsonGenerator externalNativeJsonGenerator = ExternalNativeJsonGenerator.createImpl(module2, scope);
            return externalNativeJsonGenerator;
        }
    }

    private static ExternalNativeJsonGenerator createImpl(CxxModuleModel module2, VariantScope scope) {
        CxxVariantModel variant2 = CreateCxxVariantModelKt.createCxxVariantModel(module2, scope);
        ArrayList abis = Lists.newArrayList();
        CxxBuildModel cxxBuildModel = GetCxxBuildModelKt.getCxxBuildModel(scope.getGlobalScope().getProject().getGradle());
        for (Abi abi : variant2.getValidAbiList()) {
            CxxAbiModel model2 = CxxAbiModelCMakeSettingsRewriterKt.rewriteCxxAbiModelWithCMakeSettings(CreateCxxAbiModelKt.createCxxAbiModel(variant2, abi, scope.getGlobalScope(), scope.getVariantData()));
            abis.add(model2);
            CxxCompleteModelServiceKt.registerAbi(cxxBuildModel, model2);
            ExternalNativeJsonGenerationUtilKt.registerWriteModelAfterJsonGeneration(model2);
        }
        GradleBuildVariant.Builder stats = ProcessProfileWriter.getOrCreateVariant((String)module2.getGradleModulePathName(), (String)scope.getName());
        switch (module2.getBuildSystem()) {
            case NDK_BUILD: {
                return new NdkBuildExternalNativeJsonGenerator(cxxBuildModel, variant2, abis, stats);
            }
            case CMAKE: {
                CxxCmakeModuleModel cmake2 = Objects.requireNonNull(variant2.getModule().getCmake());
                Revision cmakeRevision = cmake2.getMinimumCmakeVersion();
                stats.setNativeCmakeVersion(cmakeRevision.toString());
                if (CmakeLocatorKt.isCmakeForkVersion(cmakeRevision)) {
                    return new CmakeAndroidNinjaExternalNativeJsonGenerator(cxxBuildModel, variant2, abis, stats);
                }
                if (cmakeRevision.getMajor() < 3 || cmakeRevision.getMajor() == 3 && cmakeRevision.getMinor() <= 6) {
                    throw new RuntimeException("Unexpected/unsupported CMake version " + cmakeRevision.toString() + ". Try 3.7.0 or later.");
                }
                return new CmakeServerExternalNativeJsonGenerator(cxxBuildModel, variant2, abis, stats);
            }
        }
        throw new IllegalArgumentException("Unknown ExternalNativeJsonGenerator type");
    }

    public void forEachNativeBuildConfiguration(Consumer<JsonReader> callback) throws IOException {
        try (IssueReporterLoggingEnvironment ignore = new IssueReporterLoggingEnvironment(CxxEvalIssueReporterServiceKt.issueReporter(this.variant.getModule()));){
            List<File> files = this.getNativeBuildConfigurationsJsons();
            LoggingEnvironmentKt.infoln("streaming %s JSON files", files.size());
            for (File file : this.getNativeBuildConfigurationsJsons()) {
                if (file.exists()) {
                    LoggingEnvironmentKt.infoln("string JSON file %s", file.getAbsolutePath());
                    try {
                        JsonReader reader = new JsonReader((Reader)new FileReader(file));
                        Throwable throwable = null;
                        try {
                            callback.accept(reader);
                            continue;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (reader == null) continue;
                            if (throwable != null) {
                                try {
                                    reader.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            reader.close();
                            continue;
                        }
                    }
                    catch (Throwable e) {
                        LoggingEnvironmentKt.infoln("Error parsing: %s", String.join((CharSequence)"\r\n", Files.readAllLines(file.toPath())));
                        throw e;
                    }
                }
                LoggingEnvironmentKt.infoln("streaming fallback JSON for %s", file.getAbsolutePath());
                NativeBuildConfigValueMini fallback = new NativeBuildConfigValueMini();
                fallback.buildFiles = Lists.newArrayList((Object[])new File[]{this.variant.getModule().getMakeFile()});
                JsonReader reader = new JsonReader((Reader)new StringReader(new Gson().toJson((Object)fallback)));
                Throwable throwable = null;
                try {
                    callback.accept(reader);
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (reader == null) continue;
                    if (throwable != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                        continue;
                    }
                    reader.close();
                }
            }
        }
    }

    @Internal(value="Temporary to suppress Gradle warnings (bug 135900510), may need more investigation")
    public CxxVariantModel getVariant() {
        return this.variant;
    }

    @InputFile
    @PathSensitive(value=PathSensitivity.ABSOLUTE)
    public File getMakefile() {
        return this.variant.getModule().getMakeFile();
    }

    @Input
    public String getObjFolder() {
        return this.variant.getObjFolder().getPath();
    }

    @Input
    public String getNdkFolder() {
        return this.variant.getModule().getNdkFolder().getPath();
    }

    @Input
    public boolean isDebuggable() {
        return this.variant.isDebuggableEnabled();
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileCollection getJsonGenerationDependencyFiles() {
        return CxxModelDependencyServiceKt.jsonGenerationInputDependencyFileCollection(this.variant.getModule(), this.abis);
    }

    @Optional
    @Input
    public List<String> getBuildArguments() {
        return this.variant.getBuildSystemArgumentList();
    }

    @Optional
    @Input
    public List<String> getcFlags() {
        return this.variant.getCFlagsList();
    }

    @Optional
    @Input
    public List<String> getCppFlags() {
        return this.variant.getCppFlagsList();
    }

    @OutputFiles
    public List<File> getNativeBuildConfigurationsJsons() {
        ArrayList<File> generatedJsonFiles = new ArrayList<File>();
        for (CxxAbiModel abi : this.abis) {
            generatedJsonFiles.add(CxxAbiModelKt.getJsonFile(abi));
        }
        return generatedJsonFiles;
    }

    @Input
    public String getSoFolder() {
        return CxxVariantModelKt.getSoFolder(this.variant).getPath();
    }

    @Input
    public String getSdkFolder() {
        return this.variant.getModule().getProject().getSdkFolder().getPath();
    }

    @Input
    public Collection<Abi> getAbis() {
        ArrayList result = Lists.newArrayList();
        for (CxxAbiModel abi : this.abis) {
            result.add(abi.getAbi());
        }
        return result;
    }
}

