/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.Version;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.options.StringOption;
import com.android.builder.utils.FileCache;
import com.android.builder.utils.SynchronizedFile;
import com.android.ide.common.repository.GradleVersion;
import com.android.prefs.AndroidLocation;
import com.android.utils.FileUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.Duration;
import java.util.function.Function;
import java.util.function.Supplier;
import org.gradle.api.Project;

public final class BuildCacheUtils {
    public static final String BUILD_CACHE_TROUBLESHOOTING_MESSAGE = "To troubleshoot the issue or learn how to disable the build cache, go to https://d.android.com/r/tools/build-cache.html.\nIf you are unable to fix the issue, please file a bug at https://d.android.com/studio/report-bugs.html.";
    private static final long CACHE_ENTRY_DAYS_TO_LIVE = 30L;
    private static final long CACHE_DIRECTORY_DAYS_TO_LIVE = 30L;
    private static final long DAYS_BETWEEN_CACHE_EVICTION_RUNS = 1L;
    private static final String CACHE_EVICTION_MARKER_FILE_NAME = ".cache-eviction-marker";
    @VisibleForTesting
    static final String CACHE_USE_MARKER_FILE_NAME = ".cache-use-marker";

    public static FileCache createBuildCacheIfEnabled(Project project2, ProjectOptions projectOptions) {
        if (!projectOptions.get(BooleanOption.ENABLE_BUILD_CACHE)) {
            return null;
        }
        Supplier<File> defaultBuildCacheDirSupplier = () -> {
            try {
                return new File(AndroidLocation.getFolder(), "build-cache");
            }
            catch (AndroidLocation.AndroidLocationException e) {
                throw new RuntimeException(e);
            }
        };
        FileCache buildCache = BuildCacheUtils.createBuildCache(projectOptions.get(StringOption.BUILD_CACHE_DIR), arg_0 -> ((Project)project2.getRootProject()).file(arg_0), defaultBuildCacheDirSupplier, Version.ANDROID_GRADLE_PLUGIN_VERSION);
        File sharedBuildCacheDir = buildCache.getCacheDirectory().getParentFile();
        boolean shouldRunCacheEviction = BuildCacheUtils.shouldRunCacheEviction(buildCache, Duration.ofDays(1L));
        if (shouldRunCacheEviction) {
            BuildCacheUtils.deleteOldCacheEntries(buildCache, Duration.ofDays(30L));
            BuildCacheUtils.deleteOldCacheDirectories(sharedBuildCacheDir, Duration.ofDays(30L));
            BuildCacheUtils.deleteOldCacheEntries(FileCache.getInstanceWithMultiProcessLocking((File)sharedBuildCacheDir), Duration.ofDays(30L));
        }
        BuildCacheUtils.updateMarkerFile(new File(buildCache.getCacheDirectory(), CACHE_USE_MARKER_FILE_NAME));
        return buildCache;
    }

    @VisibleForTesting
    static FileCache createBuildCache(String buildCacheDir, Function<Object, File> pathToFileResolver, Supplier<File> defaultBuildCacheDirSupplier, String pluginVersion) {
        File sharedBuildCacheDir = buildCacheDir != null ? pathToFileResolver.apply(buildCacheDir) : defaultBuildCacheDirSupplier.get();
        return FileCache.getInstanceWithMultiProcessLocking((File)new File(sharedBuildCacheDir, pluginVersion));
    }

    @VisibleForTesting
    static boolean shouldRunCacheEviction(FileCache buildCache, Duration cacheEvictionInterval) {
        boolean shouldRunCacheEviction;
        File markerFile = new File(buildCache.getCacheDirectory(), CACHE_EVICTION_MARKER_FILE_NAME);
        long lastEvictionTimestamp = markerFile.lastModified();
        boolean bl = shouldRunCacheEviction = lastEvictionTimestamp == 0L || Duration.ofMillis(System.currentTimeMillis() - lastEvictionTimestamp).compareTo(cacheEvictionInterval) >= 0;
        if (shouldRunCacheEviction) {
            BuildCacheUtils.updateMarkerFile(markerFile);
        }
        return shouldRunCacheEviction;
    }

    @VisibleForTesting
    static void deleteOldCacheEntries(FileCache buildCache, Duration cacheEntryLifeTime) {
        buildCache.deleteOldCacheEntries(System.currentTimeMillis() - cacheEntryLifeTime.toMillis());
    }

    @VisibleForTesting
    static void deleteOldCacheDirectories(File sharedBuildCacheDir, Duration cacheDirectoryLifeTime) {
        GradleVersion currentPluginVersion = (GradleVersion)Verify.verifyNotNull((Object)GradleVersion.tryParseAndroidGradlePluginVersion((String)Version.ANDROID_GRADLE_PLUGIN_VERSION));
        for (File buildCacheDir : (File[])Preconditions.checkNotNull((Object)sharedBuildCacheDir.listFiles())) {
            GradleVersion pluginVersion;
            if (!buildCacheDir.isDirectory() || (pluginVersion = GradleVersion.tryParseAndroidGradlePluginVersion((String)buildCacheDir.getName())) == null || pluginVersion.compareTo(currentPluginVersion) >= 0) continue;
            File markerFile = new File(buildCacheDir, CACHE_USE_MARKER_FILE_NAME);
            long lastUsedTimestamp = markerFile.lastModified();
            if (lastUsedTimestamp == 0L) {
                lastUsedTimestamp = buildCacheDir.lastModified();
            }
            if (lastUsedTimestamp == 0L || Duration.ofMillis(System.currentTimeMillis() - lastUsedTimestamp).compareTo(cacheDirectoryLifeTime) < 0) continue;
            try {
                FileCache.getInstanceWithMultiProcessLocking((File)buildCacheDir).delete();
                FileUtils.deleteIfExists((File)SynchronizedFile.getLockFile((File)buildCacheDir));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    private static void updateMarkerFile(File markerFile) {
        FileUtils.mkdirs((File)markerFile.getParentFile());
        try {
            markerFile.createNewFile();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        markerFile.setLastModified(System.currentTimeMillis());
    }
}

