/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.api.variant.BuiltArtifact;
import com.android.build.api.variant.impl.BuiltArtifactsLoaderImpl;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.builder.testing.api.TestServer;
import com.android.utils.StringHelper;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;

public abstract class TestServerTask
extends NonIncrementalTask {
    TestServer testServer;

    @Override
    protected void doTaskAction() {
        ImmutableList testedApkFiles;
        Object object = testedApkFiles = this.getTestedApks().isPresent() ? new BuiltArtifactsLoaderImpl().load((Directory)this.getTestedApks().get()).getElements().stream().map(BuiltArtifact::getOutputFile).map(Path::toFile).collect(Collectors.toList()) : ImmutableList.of();
        if (testedApkFiles.size() > 1) {
            throw new RuntimeException("Cannot handle split APKs");
        }
        File testedApkFile = testedApkFiles.isEmpty() ? null : (File)testedApkFiles.get(0);
        List testApkFiles = new BuiltArtifactsLoaderImpl().load((Directory)this.getTestApks().get()).getElements().stream().map(BuiltArtifact::getOutputFile).map(Path::toFile).collect(Collectors.toList());
        if (testApkFiles.size() > 1) {
            throw new RuntimeException("Cannot handle split APKs in test APKs");
        }
        this.testServer.uploadApks(this.getVariantName(), (File)testApkFiles.get(0), testedApkFile);
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public abstract DirectoryProperty getTestApks();

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @Optional
    public abstract DirectoryProperty getTestedApks();

    @Override
    @Input
    public String getVariantName() {
        return super.getVariantName();
    }

    public void setTestServer(TestServer testServer) {
        this.testServer = testServer;
    }

    public static class TestServerTaskCreationAction
    extends VariantTaskCreationAction<TestServerTask> {
        private final TestServer testServer;

        public TestServerTaskCreationAction(VariantScope scope, TestServer testServer) {
            super(scope);
            this.testServer = testServer;
        }

        @Override
        public String getName() {
            return this.getVariantScope().getVariantDslInfo().hasFlavors() ? this.getVariantScope().getTaskName(this.testServer.getName() + "Upload") : this.testServer.getName() + "Upload";
        }

        @Override
        public Class<TestServerTask> getType() {
            return TestServerTask.class;
        }

        @Override
        public void configure(TestServerTask task) {
            super.configure(task);
            VariantScope scope = this.getVariantScope();
            BaseVariantData testedVariantData = scope.getTestedVariantData();
            String variantName = scope.getName();
            task.setDescription("Uploads APKs for Build '" + variantName + "' to Test Server '" + StringHelper.usLocaleCapitalize((String)this.testServer.getName()) + "'.");
            task.setGroup("verification");
            task.setTestServer(this.testServer);
            if (testedVariantData != null && testedVariantData.getScope().getArtifacts().hasFinalProduct(InternalArtifactType.APK.INSTANCE)) {
                testedVariantData.getScope().getArtifacts().setTaskInputToFinalProduct(InternalArtifactType.APK.INSTANCE, task.getTestedApks());
            }
            scope.getArtifacts().setTaskInputToFinalProduct(InternalArtifactType.APK.INSTANCE, task.getTestApks());
            if (!this.testServer.isConfigured()) {
                task.setEnabled(false);
            }
        }
    }
}

