/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.profile;

import com.android.build.gradle.internal.profile.BuildMBeanImpl;
import com.android.build.gradle.internal.profile.ProfileMBeanImpl;
import com.android.build.gradle.internal.profile.RecordingBuildListener;
import com.android.ide.common.workers.BuildMBean;
import com.android.ide.common.workers.GradlePluginMBeans;
import com.android.ide.common.workers.ProfileMBean;
import java.lang.management.ManagementFactory;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J1\u0010\b\u001a\u00020\t\"\u0004\b\u0000\u0010\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\n0\u000e2\u0006\u0010\u000f\u001a\u0002H\nH\u0002\u00a2\u0006\u0002\u0010\u0010J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010\u0015\u001a\u00020\tR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/android/build/gradle/internal/profile/ProfileAgent;", "", "()V", "logger", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "mbs", "Ljavax/management/MBeanServer;", "register", "", "T", "objectName", "Ljavax/management/ObjectName;", "beanInterface", "Ljava/lang/Class;", "bean", "(Ljavax/management/ObjectName;Ljava/lang/Class;Ljava/lang/Object;)V", "projectName", "", "buildListener", "Lcom/android/build/gradle/internal/profile/RecordingBuildListener;", "unregister", "gradle"})
public final class ProfileAgent {
    private static final MBeanServer mbs;
    private static final Logger logger;
    public static final ProfileAgent INSTANCE;

    public final synchronized void register(@NotNull String projectName, @NotNull RecordingBuildListener buildListener) {
        Intrinsics.checkParameterIsNotNull((Object)projectName, (String)"projectName");
        Intrinsics.checkParameterIsNotNull((Object)buildListener, (String)"buildListener");
        try {
            this.register(GradlePluginMBeans.MBeanName.BUILD.getObjectName(), BuildMBean.class, new BuildMBeanImpl());
            this.register(GradlePluginMBeans.MBeanName.PROFILING.getProjectSpecificObjectName(projectName), ProfileMBean.class, new ProfileMBeanImpl(buildListener));
        }
        catch (Throwable t) {
            logger.warning("Profiling not available : " + t);
        }
    }

    private final <T> void register(ObjectName objectName, Class<T> beanInterface, T bean) {
        try {
            Set<ObjectInstance> mbeans = mbs.queryMBeans(objectName, null);
            if (mbeans.isEmpty()) {
                StandardMBean mbean = new StandardMBean(bean, beanInterface, false);
                mbs.registerMBean(mbean, objectName);
            }
        }
        catch (Throwable t) {
            logger.warning("Profiling not available : " + t);
        }
    }

    public final synchronized void unregister() {
        Iterator<ObjectInstance> iterator = mbs.queryMBeans(new ObjectName("domain:type=Gradle.agp,*"), null).iterator();
        while (iterator.hasNext()) {
            ObjectInstance queryMBean;
            ObjectInstance objectInstance = queryMBean = iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)objectInstance, (String)"queryMBean");
            mbs.unregisterMBean(objectInstance.getObjectName());
        }
    }

    private ProfileAgent() {
    }

    static {
        ProfileAgent profileAgent;
        INSTANCE = profileAgent = new ProfileAgent();
        mbs = ManagementFactory.getPlatformMBeanServer();
        logger = Logger.getLogger(Reflection.getOrCreateKotlinClass(ProfileAgent.class).getQualifiedName());
    }
}

