/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.res;

import com.android.build.gradle.internal.res.ParseLibraryResourcesTask;
import com.android.build.gradle.internal.res.ParseLibraryResourcesTaskKt;
import com.android.build.gradle.internal.res.SymbolTableWithContextPath;
import com.android.builder.files.SerializableChange;
import com.android.builder.internal.aapt.v2.Aapt2RenamingConventions;
import com.android.ide.common.resources.FileStatus;
import com.android.ide.common.symbols.IdProvider;
import com.android.ide.common.symbols.ResourceDirectoryParseException;
import com.android.ide.common.symbols.ResourceDirectoryParser;
import com.android.ide.common.symbols.SymbolIo;
import com.android.ide.common.symbols.SymbolTable;
import com.android.resources.FolderTypeRelationship;
import com.android.resources.ResourceFolderType;
import com.android.utils.FileUtils;
import com.google.common.collect.ImmutableCollection;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000F\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\u0002\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0018\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u001a\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u001a \u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\b2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0000\u001a\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\bH\u0002\u001a\u001e\u0010\u0016\u001a\u00020\n2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00100\u00182\u0006\u0010\u0019\u001a\u00020\bH\u0000\u00a8\u0006\u001a"}, d2={"canBeProcessedIncrementally", "", "fileChange", "Lcom/android/builder/files/SerializableChange;", "canGenerateSymbols", "type", "Lcom/android/resources/ResourceFolderType;", "file", "Ljava/io/File;", "doFullTaskAction", "", "parseResourcesParams", "Lcom/android/build/gradle/internal/res/ParseLibraryResourcesTask$ParseResourcesParams;", "doIncrementalTaskAction", "generateResourceSymbolTables", "Ljava/util/SortedSet;", "Lcom/android/build/gradle/internal/res/SymbolTableWithContextPath;", "resourceDirectory", "platformAttrsSymbolTable", "Lcom/android/ide/common/symbols/SymbolTable;", "getAndroidAttrSymbols", "platformAttrsRTxt", "savePartialRFilesToDirectory", "symbolTableWithContextPaths", "", "directory", "gradle"})
public final class ParseLibraryResourcesTaskKt {
    /*
     * WARNING - void declaration
     */
    public static final void doFullTaskAction(@NotNull ParseLibraryResourcesTask.ParseResourcesParams parseResourcesParams) {
        Intrinsics.checkParameterIsNotNull((Object)parseResourcesParams, (String)"parseResourcesParams");
        if (parseResourcesParams.getEnablePartialRIncrementalBuilds() && parseResourcesParams.getPartialRDir() != null) {
            Collection<SymbolTable> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            SymbolTable androidPlatformAttrSymbolTable = ParseLibraryResourcesTaskKt.getAndroidAttrSymbols(parseResourcesParams.getPlatformAttrsRTxt());
            SortedSet<SymbolTableWithContextPath> resourceFileSymbolTables = ParseLibraryResourcesTaskKt.generateResourceSymbolTables(parseResourcesParams.getInputResDir(), androidPlatformAttrSymbolTable);
            ParseLibraryResourcesTaskKt.savePartialRFilesToDirectory((Collection<SymbolTableWithContextPath>)resourceFileSymbolTables, parseResourcesParams.getPartialRDir());
            Iterable iterable = resourceFileSymbolTables;
            SymbolTable.Companion companion = SymbolTable.Companion;
            boolean $i$f$map = false;
            void var6_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                SymbolTableWithContextPath symbolTableWithContextPath = (SymbolTableWithContextPath)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                SymbolTable symbolTable = it.getSymbolTable();
                collection.add(symbolTable);
            }
            collection = (List)destination$iv$iv;
            SymbolTable mergedSymbolTable = companion.merge((List)collection);
            SymbolIo.writeRDef((SymbolTable)mergedSymbolTable, (Path)parseResourcesParams.getLibrarySymbolsFile().toPath());
        } else {
            SymbolTable symbolTable = ResourceDirectoryParser.parseResourceSourceSetDirectory((File)parseResourcesParams.getInputResDir(), (IdProvider)IdProvider.Companion.constant(), (SymbolTable)ParseLibraryResourcesTaskKt.getAndroidAttrSymbols(parseResourcesParams.getPlatformAttrsRTxt()), (String)"local");
            SymbolIo.writeRDef((SymbolTable)symbolTable, (Path)parseResourcesParams.getLibrarySymbolsFile().toPath());
        }
    }

    public static final void doIncrementalTaskAction(@NotNull ParseLibraryResourcesTask.ParseResourcesParams parseResourcesParams) {
        DocumentBuilder documentBuilder;
        Intrinsics.checkParameterIsNotNull((Object)parseResourcesParams, (String)"parseResourcesParams");
        SymbolTable currentSymbols = SymbolIo.readRDef((Path)parseResourcesParams.getLibrarySymbolsFile().toPath());
        SymbolTable.Builder newSymbols = SymbolTable.Companion.builder().tablePackage("local");
        SymbolTable platformSymbols = ParseLibraryResourcesTaskKt.getAndroidAttrSymbols(parseResourcesParams.getPlatformAttrsRTxt());
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw (Throwable)new ResourceDirectoryParseException("Failed to instantiate DOM parser", (Throwable)e);
        }
        DocumentBuilder documentBuilder2 = documentBuilder;
        Iterable $this$forEach$iv = parseResourcesParams.getChangedResources();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ResourceFolderType type;
            SerializableChange fileChange = (SerializableChange)element$iv;
            boolean bl = false;
            File file = fileChange.getFile();
            File file2 = file.getParentFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"file.parentFile");
            if (ResourceFolderType.getFolderType((String)file2.getName()) == null) {
                Intrinsics.throwNpe();
            }
            if (fileChange.getFileStatus() != FileStatus.NEW) continue;
            DocumentBuilder documentBuilder3 = documentBuilder2;
            Intrinsics.checkExpressionValueIsNotNull((Object)documentBuilder3, (String)"documentBuilder");
            ResourceDirectoryParser.parseResourceFile$default((File)file, (ResourceFolderType)type, (SymbolTable.Builder)newSymbols, (DocumentBuilder)documentBuilder3, (SymbolTable)platformSymbols, null, (int)32, null);
        }
        if (!newSymbols.isEmpty()) {
            ImmutableCollection immutableCollection = currentSymbols.getSymbols().values();
            Intrinsics.checkExpressionValueIsNotNull((Object)immutableCollection, (String)"currentSymbols.symbols.values()");
            newSymbols.addAllIfNotExist((Collection)immutableCollection);
            Files.delete(parseResourcesParams.getLibrarySymbolsFile().toPath());
            SymbolIo.writeRDef((SymbolTable)newSymbols.build(), (Path)parseResourcesParams.getLibrarySymbolsFile().toPath());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean canGenerateSymbols(@NotNull ResourceFolderType type, @NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        if (type == ResourceFolderType.VALUES) return true;
        if (!FolderTypeRelationship.isIdGeneratingFolderType((ResourceFolderType)type)) return false;
        String string = file.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.name");
        if (!StringsKt.endsWith((String)string, (String)".xml", (boolean)true)) return false;
        return true;
    }

    public static final boolean canBeProcessedIncrementally(@NotNull SerializableChange fileChange) {
        Intrinsics.checkParameterIsNotNull((Object)fileChange, (String)"fileChange");
        if (fileChange.getFileStatus() == FileStatus.REMOVED) {
            return false;
        }
        if (fileChange.getFileStatus() == FileStatus.CHANGED) {
            File file = fileChange.getFile();
            File file2 = file.getParentFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"file.parentFile");
            ResourceFolderType resourceFolderType = ResourceFolderType.getFolderType((String)file2.getName());
            if (resourceFolderType == null) {
                StringBuilder stringBuilder = new StringBuilder().append("Invalid type '");
                File file3 = file.getParentFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)file3, (String)"file.parentFile");
                String string = stringBuilder.append(file3.getName()).append("' for file ").append(file.getAbsolutePath()).toString();
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            ResourceFolderType folderType = resourceFolderType;
            if (ParseLibraryResourcesTaskKt.canGenerateSymbols(folderType, file)) {
                return false;
            }
        }
        return true;
    }

    private static final SymbolTable getAndroidAttrSymbols(File platformAttrsRTxt) {
        SymbolTable symbolTable;
        if (platformAttrsRTxt.exists()) {
            SymbolTable symbolTable2 = SymbolIo.readFromAapt((File)platformAttrsRTxt, (String)"android");
            symbolTable = symbolTable2;
            Intrinsics.checkExpressionValueIsNotNull((Object)symbolTable2, (String)"SymbolIo.readFromAapt(pl\u2026formAttrsRTxt, \"android\")");
        } else {
            symbolTable = SymbolTable.Companion.builder().tablePackage("android").build();
        }
        return symbolTable;
    }

    @NotNull
    public static final SortedSet<SymbolTableWithContextPath> generateResourceSymbolTables(@NotNull File resourceDirectory, @Nullable SymbolTable platformAttrsSymbolTable) {
        Intrinsics.checkParameterIsNotNull((Object)resourceDirectory, (String)"resourceDirectory");
        TreeSet<SymbolTableWithContextPath> resourceSymbolTables2 = new TreeSet<SymbolTableWithContextPath>(generateResourceSymbolTables.resourceSymbolTables.1.INSTANCE);
        DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Sequence $this$forEach$iv = (Sequence)FilesKt.walkTopDown((File)resourceDirectory);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl = false;
            File file = it.getParentFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"it.parentFile");
            ResourceFolderType folderType = ResourceFolderType.getFolderType((String)file.getName());
            if (folderType == null) continue;
            SymbolTable.Builder symbolTable = SymbolTable.Companion.builder();
            symbolTable.tablePackage("local");
            DocumentBuilder documentBuilder2 = documentBuilder;
            Intrinsics.checkExpressionValueIsNotNull((Object)documentBuilder2, (String)"documentBuilder");
            ResourceDirectoryParser.parseResourceFile$default((File)it, (ResourceFolderType)folderType, (SymbolTable.Builder)symbolTable, (DocumentBuilder)documentBuilder2, (SymbolTable)platformAttrsSymbolTable, null, (int)32, null);
            String string = FilesKt.relativeTo((File)it, (File)resourceDirectory).getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.relativeTo(resourceDirectory).path");
            resourceSymbolTables2.add(new SymbolTableWithContextPath(string, symbolTable.build()));
        }
        return resourceSymbolTables2;
    }

    /*
     * WARNING - void declaration
     */
    public static final void savePartialRFilesToDirectory(@NotNull Collection<SymbolTableWithContextPath> symbolTableWithContextPaths, @NotNull File directory2) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkParameterIsNotNull(symbolTableWithContextPaths, (String)"symbolTableWithContextPaths");
        Intrinsics.checkParameterIsNotNull((Object)directory2, (String)"directory");
        Iterable $this$filter$iv = symbolTableWithContextPaths;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            SymbolTableWithContextPath it = (SymbolTableWithContextPath)element$iv$iv;
            boolean bl = false;
            if (!ResourceDirectoryParser.shouldBeParsed((String)StringsKt.substringBefore$default((String)it.getPath(), (char)File.separatorChar, null, (int)2, null))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SymbolTableWithContextPath it = (SymbolTableWithContextPath)element$iv;
            boolean bl = false;
            File namedPartialRFile = new File(directory2, Aapt2RenamingConventions.compilationRename((File)new File(directory2, it.getPath())) + "-R.txt");
            FileUtils.createFile((File)namedPartialRFile, (String)"");
            SymbolIo.writePartialR((SymbolTable)it.getSymbolTable(), (Path)namedPartialRFile.toPath());
        }
    }
}

