/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.gradle.internal.cxx.logging.LoggingEnvironmentKt;
import com.android.build.gradle.internal.cxx.model.CxxAbiModel;
import com.android.build.gradle.internal.cxx.model.CxxAbiModelKt;
import com.android.build.gradle.internal.cxx.model.CxxModuleModel;
import com.android.build.gradle.internal.cxx.services.CxxProcessServiceKt;
import com.android.build.gradle.internal.ndk.Stl;
import com.android.build.gradle.tasks.GeneratePrefabPackagesKt$WhenMappings;
import com.android.build.gradle.tasks.NativeBuildSystem;
import com.android.ide.common.process.ProcessInfoBuilder;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.process.BaseExecSpec;
import org.gradle.process.ExecResult;
import org.gradle.process.JavaExecSpec;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u00006\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001aH\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u001a\u0010\u000b\u001a\u0016\u0012\f\u0012\n\u0012\u0006\b\u0000\u0012\u00020\u000e0\r\u0012\u0004\u0012\u00020\u000f0\f\u00a8\u0006\u0010"}, d2={"generatePrefabPackages", "", "nativeBuildSystem", "Lcom/android/build/gradle/tasks/NativeBuildSystem;", "moduleModel", "Lcom/android/build/gradle/internal/cxx/model/CxxModuleModel;", "abiModel", "Lcom/android/build/gradle/internal/cxx/model/CxxAbiModel;", "packages", "", "Ljava/io/File;", "execOperation", "Ljava/util/function/Function;", "Lorg/gradle/api/Action;", "Lorg/gradle/process/JavaExecSpec;", "Lorg/gradle/process/ExecResult;", "gradle"})
public final class GeneratePrefabPackagesKt {
    /*
     * WARNING - void declaration
     */
    public static final void generatePrefabPackages(@NotNull NativeBuildSystem nativeBuildSystem, @NotNull CxxModuleModel moduleModel, @NotNull CxxAbiModel abiModel, @NotNull List<? extends File> packages, @NotNull Function<Action<? super JavaExecSpec>, ExecResult> execOperation) {
        String selectedStl;
        int n;
        Object object;
        Object v3;
        CharSequence it22;
        Object object2;
        boolean item$iv$iv2;
        String[] stringArray;
        File prefabClassPath2;
        int osVersion;
        String buildSystem2;
        List packagePaths;
        String string;
        Collection collection;
        block19: {
            String string2;
            String string3;
            boolean bl;
            Object object3;
            void $this$mapTo$iv$iv;
            Intrinsics.checkParameterIsNotNull((Object)((Object)nativeBuildSystem), (String)"nativeBuildSystem");
            Intrinsics.checkParameterIsNotNull((Object)moduleModel, (String)"moduleModel");
            Intrinsics.checkParameterIsNotNull((Object)abiModel, (String)"abiModel");
            Intrinsics.checkParameterIsNotNull(packages, (String)"packages");
            Intrinsics.checkParameterIsNotNull(execOperation, (String)"execOperation");
            Iterable $this$map$iv = packages;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
                void it;
                object3 = (File)item$iv$iv2;
                collection = destination$iv$iv;
                bl = false;
                string = it.getPath();
                collection.add(string);
            }
            packagePaths = (List)destination$iv$iv;
            switch (GeneratePrefabPackagesKt$WhenMappings.$EnumSwitchMapping$0[nativeBuildSystem.ordinal()]) {
                case 1: {
                    string3 = "ndk-build";
                    break;
                }
                case 2: {
                    string3 = "cmake";
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            buildSystem2 = string3;
            osVersion = abiModel.getAbiPlatformVersion();
            File file = abiModel.getVariant().getModule().getProject().getPrefabClassPath();
            if (file == null) {
                throw (Throwable)new RuntimeException("CxxAbiModule.prefabClassPath cannot be null when Prefab is enabled");
            }
            prefabClassPath2 = file;
            switch (GeneratePrefabPackagesKt$WhenMappings.$EnumSwitchMapping$1[nativeBuildSystem.ordinal()]) {
                case 1: {
                    string2 = "APP_STL=";
                    break;
                }
                case 2: {
                    string2 = "-DANDROID_STL=";
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            String stlArgumentPrefix = string2;
            stringArray = abiModel.getVariant().getBuildSystemArgumentList();
            item$iv$iv2 = false;
            object3 = stringArray;
            bl = false;
            object2 = object3.listIterator(object3.size());
            while (object2.hasPrevious()) {
                Object e = object2.previous();
                it22 = (String)e;
                boolean bl2 = false;
                if (!StringsKt.startsWith$default((String)it22, (String)stlArgumentPrefix, (boolean)false, (int)2, null)) continue;
                v3 = e;
                break block19;
            }
            v3 = null;
        }
        String string4 = (object = (String)v3) != null && (object = StringsKt.split$default((CharSequence)((CharSequence)object), (String[])(stringArray = new String[]{"="}), (boolean)(item$iv$iv2 = false), (int)(n = 2), (int)2, null)) != null ? (String)CollectionsKt.last((List)object) : (selectedStl = null);
        if (selectedStl == null && nativeBuildSystem == NativeBuildSystem.NDK_BUILD) {
            File applicationMk = FilesKt.resolveSibling((File)moduleModel.getMakeFile(), (String)"Application.mk");
            for (String line : StringsKt.lines((CharSequence)FilesKt.readText$default((File)applicationMk, null, (int)1, null))) {
                MatchResult match2;
                object2 = line;
                collection = new Regex("^APP_STL\\s*:?=\\s*(.*)$");
                boolean bl = false;
                Object object4 = object2;
                if (object4 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                string = ((Object)StringsKt.trim((CharSequence)((CharSequence)object4))).toString();
                if (Regex.find$default((Regex)collection, (CharSequence)string, (int)0, (int)2, null) == null) {
                    continue;
                }
                MatchGroup appStlMatch = match2.getGroups().get(1);
                bl = appStlMatch != null;
                boolean it22 = false;
                boolean bl3 = false;
                bl3 = false;
                boolean bl4 = false;
                if (!bl) {
                    boolean bl5 = false;
                    String string5 = "Failed requirement.";
                    throw (Throwable)new IllegalArgumentException(string5.toString());
                }
                String appStl = appStlMatch.getValue();
                it22 = appStl;
                bl3 = false;
                if (it22.length() == 0) {
                    selectedStl = null;
                    continue;
                }
                Stl stl = Stl.Companion.fromArgumentName(appStlMatch.getValue());
                if (stl == null) {
                    LoggingEnvironmentKt.errorln("Unable to parse APP_STL from " + applicationMk + ": " + appStl, new Object[0]);
                    return;
                }
                selectedStl = stl.getArgumentName();
            }
        }
        String defaultStl = abiModel.getVariant().getModule().getNdkDefaultStl().getArgumentName();
        ProcessInfoBuilder processInfoBuilder = new ProcessInfoBuilder().setClasspath(prefabClassPath2.toString()).setMain("com.google.prefab.cli.AppKt").addArgs("--build-system", buildSystem2).addArgs("--platform", "android").addArgs("--abi", abiModel.getAbi().getTag()).addArgs("--os-version", String.valueOf(osVersion));
        String string6 = selectedStl;
        if (string6 == null) {
            string6 = defaultStl;
        }
        ProcessInfoBuilder builder = processInfoBuilder.addArgs("--stl", string6).addArgs("--ndk-version", String.valueOf(abiModel.getVariant().getModule().getNdkVersion().getMajor())).addArgs("--output", FilesKt.resolve((File)abiModel.getPrefabFolder(), (String)"prefab").toString()).addArgs(packagePaths);
        File file = CxxAbiModelKt.getSoFolder(abiModel);
        String string7 = "prefab_" + buildSystem2 + '_' + abiModel.getAbi().getTag();
        ProcessInfoBuilder processInfoBuilder2 = builder;
        Intrinsics.checkExpressionValueIsNotNull((Object)processInfoBuilder2, (String)"builder");
        CxxProcessServiceKt.createProcessOutputJunction(moduleModel, file, string7, processInfoBuilder2, "prefab").javaProcess().logStderrToInfo().execute((Function1<? super Action<? super BaseExecSpec>, ? extends ExecResult>)((Function1)new Function1<Action<? super JavaExecSpec>, ExecResult>(execOperation){

            @NotNull
            public final ExecResult invoke(@NotNull Action<? super JavaExecSpec> p1) {
                Intrinsics.checkParameterIsNotNull(p1, (String)"p1");
                return (ExecResult)((Function)this.receiver).apply(p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(Function.class);
            }

            public final String getName() {
                return "apply";
            }

            public final String getSignature() {
                return "apply(Ljava/lang/Object;)Ljava/lang/Object;";
            }
        }));
    }
}

