/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.api.artifact.ArtifactType;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.core.VariantDslInfo;
import com.android.build.gradle.internal.core.VariantSources;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.ApkData;
import com.android.build.gradle.internal.scope.BuildArtifactsHolder;
import com.android.build.gradle.internal.scope.BuildElements;
import com.android.build.gradle.internal.scope.BuildOutput;
import com.android.build.gradle.internal.scope.ExistingBuildElements;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.tasks.ManifestProcessorTask;
import com.android.build.gradle.tasks.ProcessApplicationManifest;
import com.android.builder.internal.TestManifestGenerator;
import com.android.manifmerger.ManifestMerger2;
import com.android.manifmerger.ManifestProvider;
import com.android.manifmerger.ManifestSystemProperty;
import com.android.manifmerger.MergingReport;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskProvider;

public abstract class ProcessTestManifest
extends ManifestProcessorTask {
    private FileCollection testTargetMetadata;
    private boolean onlyTestApk;
    private File tmpDir;
    private ArtifactCollection manifests;
    private ApkData apkData;
    private FileCollection navigationJsons;

    @Inject
    public ProcessTestManifest(ObjectFactory objectFactory) {
        super(objectFactory);
    }

    @Nested
    @Optional
    public ApkData getApkData() {
        return this.apkData;
    }

    @Override
    protected void doFullTaskAction() throws IOException {
        if (this.getTestedApplicationId().getOrNull() == null && this.testTargetMetadata == null) {
            throw new RuntimeException("testedApplicationId and testTargetMetadata are null");
        }
        String testedApplicationId = (String)this.getTestedApplicationId().getOrNull();
        if (!this.onlyTestApk && this.testTargetMetadata != null) {
            BuildElements manifestOutputs = ExistingBuildElements.from((ArtifactType<Directory>)InternalArtifactType.MERGED_MANIFESTS.INSTANCE, this.testTargetMetadata.getSingleFile());
            if (manifestOutputs.isEmpty()) {
                throw new RuntimeException("Cannot find merged manifest, please file a bug.");
            }
            BuildOutput mainSplit = manifestOutputs.iterator().next();
            testedApplicationId = mainSplit.getProperties().get("packageId");
        }
        File manifestOutputFolder = Strings.isNullOrEmpty((String)this.apkData.getDirName()) ? ((Directory)this.getManifestOutputDirectory().get()).getAsFile() : ((Directory)this.getManifestOutputDirectory().get()).file(this.apkData.getDirName()).getAsFile();
        FileUtils.mkdirs((File)manifestOutputFolder);
        File manifestOutputFile = new File(manifestOutputFolder, "AndroidManifest.xml");
        ArrayList navJsons = this.navigationJsons == null ? Collections.emptyList() : Lists.newArrayList((Iterable)this.navigationJsons);
        this.mergeManifestsForTestVariant((String)this.getTestApplicationId().get(), (String)this.getMinSdkVersion().get(), (String)this.getTargetSdkVersion().get(), testedApplicationId, (String)this.getInstrumentationRunner().get(), (Boolean)this.getHandleProfiling().get(), (Boolean)this.getFunctionalTest().get(), (String)this.getTestLabel().getOrNull(), (File)this.getTestManifestFile().getOrNull(), this.computeProviders(), (Map)this.getPlaceholdersValues().get(), navJsons, manifestOutputFile, this.getTmpDir());
        new BuildElements(1, (String)this.getTestApplicationId().get(), (String)this.getVariantType().get(), (Collection<BuildOutput>)ImmutableList.of((Object)new BuildOutput(InternalArtifactType.MERGED_MANIFESTS.INSTANCE, this.apkData, manifestOutputFile))).save(((Directory)this.getManifestOutputDirectory().get()).getAsFile());
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void mergeManifestsForTestVariant(String testApplicationId, String minSdkVersion, String targetSdkVersion, String testedApplicationId, String instrumentationRunner, Boolean handleProfiling, Boolean functionalTest, String testLabel, File testManifestFile, List<? extends ManifestProvider> manifestProviders, Map<String, Object> manifestPlaceholders, List<File> navigationJsons, File outManifest, File tmpDir) {
        Preconditions.checkNotNull((Object)testApplicationId, (Object)"testApplicationId cannot be null.");
        Preconditions.checkNotNull((Object)testedApplicationId, (Object)"testedApplicationId cannot be null.");
        Preconditions.checkNotNull((Object)instrumentationRunner, (Object)"instrumentationRunner cannot be null.");
        Preconditions.checkNotNull((Object)handleProfiling, (Object)"handleProfiling cannot be null.");
        Preconditions.checkNotNull((Object)functionalTest, (Object)"functionalTest cannot be null.");
        Preconditions.checkNotNull(manifestProviders, (Object)"manifestProviders cannot be null.");
        Preconditions.checkNotNull((Object)outManifest, (Object)"outManifestLocation cannot be null.");
        LoggerWrapper logger = new LoggerWrapper(this.getLogger());
        File tempFile1 = null;
        File tempFile2 = null;
        try {
            FileUtils.mkdirs((File)tmpDir);
            File generatedTestManifest = manifestProviders.isEmpty() && testManifestFile == null ? outManifest : (tempFile1 = File.createTempFile("manifestMerger", ".xml", tmpDir));
            logger.verbose("Generating in %1$s", new Object[]{generatedTestManifest.getAbsolutePath()});
            ProcessTestManifest.generateTestManifest(testApplicationId, minSdkVersion, targetSdkVersion.equals("-1") ? null : targetSdkVersion, testedApplicationId, instrumentationRunner, handleProfiling, functionalTest, generatedTestManifest);
            if (testManifestFile != null && testManifestFile.exists()) {
                ManifestMerger2.Invoker invoker = ManifestMerger2.newMerger((File)testManifestFile, (ILogger)logger, (ManifestMerger2.MergeType)ManifestMerger2.MergeType.APPLICATION).setPlaceHolderValues(manifestPlaceholders).setPlaceHolderValue("instrumentationRunner", instrumentationRunner).addLibraryManifest(generatedTestManifest).addNavigationJsons(navigationJsons);
                invoker.setOverride(ManifestSystemProperty.PACKAGE, testApplicationId);
                invoker.setOverride(ManifestSystemProperty.MIN_SDK_VERSION, minSdkVersion);
                invoker.setOverride(ManifestSystemProperty.NAME, instrumentationRunner);
                invoker.setOverride(ManifestSystemProperty.TARGET_PACKAGE, testedApplicationId);
                invoker.setOverride(ManifestSystemProperty.FUNCTIONAL_TEST, functionalTest.toString());
                invoker.setOverride(ManifestSystemProperty.HANDLE_PROFILING, handleProfiling.toString());
                if (testLabel != null) {
                    invoker.setOverride(ManifestSystemProperty.LABEL, testLabel);
                }
                if (!targetSdkVersion.equals("-1")) {
                    invoker.setOverride(ManifestSystemProperty.TARGET_SDK_VERSION, targetSdkVersion);
                }
                MergingReport mergingReport = invoker.merge();
                if (manifestProviders.isEmpty()) {
                    this.handleMergingResult(mergingReport, outManifest, logger);
                } else {
                    tempFile2 = File.createTempFile("manifestMerger", ".xml", tmpDir);
                    this.handleMergingResult(mergingReport, tempFile2, logger);
                    generatedTestManifest = tempFile2;
                }
            }
            if (!manifestProviders.isEmpty()) {
                MergingReport mergingReport = ManifestMerger2.newMerger((File)generatedTestManifest, (ILogger)logger, (ManifestMerger2.MergeType)ManifestMerger2.MergeType.APPLICATION).withFeatures(new ManifestMerger2.Invoker.Feature[]{ManifestMerger2.Invoker.Feature.REMOVE_TOOLS_DECLARATIONS}).setOverride(ManifestSystemProperty.PACKAGE, testApplicationId).addManifestProviders(manifestProviders).setPlaceHolderValues(manifestPlaceholders).addNavigationJsons(navigationJsons).merge();
                this.handleMergingResult(mergingReport, outManifest, logger);
            }
        }
        catch (IOException e) {
            try {
                throw new RuntimeException("Unable to create the temporary file", e);
                catch (ManifestMerger2.MergeFailureException e2) {
                    throw new RuntimeException("Manifest merging exception", e2);
                }
            }
            catch (Throwable throwable) {
                try {
                    if (tempFile1 != null) {
                        FileUtils.delete(tempFile1);
                    }
                    if (tempFile2 == null) throw throwable;
                    FileUtils.delete(tempFile2);
                    throw throwable;
                }
                catch (IOException e3) {
                    logger.error(e3, "Unable to clean up the temporary files.", new Object[0]);
                }
                throw throwable;
            }
        }
        try {
            if (tempFile1 != null) {
                FileUtils.delete((File)tempFile1);
            }
            if (tempFile2 == null) return;
            FileUtils.delete(tempFile2);
            return;
        }
        catch (IOException e) {
            logger.error(e, "Unable to clean up the temporary files.", new Object[0]);
            return;
        }
    }

    private void handleMergingResult(MergingReport mergingReport, File outFile, ILogger logger) throws IOException {
        ProcessTestManifest.outputMergeBlameContents(mergingReport, ((RegularFile)this.getMergeBlameFile().get()).getAsFile());
        switch (mergingReport.getResult()) {
            case WARNING: {
                mergingReport.log(logger);
            }
            case SUCCESS: {
                try {
                    String annotatedDocument = mergingReport.getMergedDocument(MergingReport.MergedManifestKind.BLAME);
                    if (annotatedDocument != null) {
                        logger.verbose(annotatedDocument, new Object[0]);
                    } else {
                        logger.verbose("No blaming records from manifest merger", new Object[0]);
                    }
                }
                catch (Exception e) {
                    logger.error((Throwable)e, "cannot print resulting xml", new Object[0]);
                }
                String finalMergedDocument = mergingReport.getMergedDocument(MergingReport.MergedManifestKind.MERGED);
                if (finalMergedDocument == null) {
                    throw new RuntimeException("No result from manifest merger");
                }
                try {
                    Files.asCharSink((File)outFile, (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)finalMergedDocument);
                }
                catch (IOException e) {
                    logger.error((Throwable)e, "Cannot write resulting xml", new Object[0]);
                    throw new RuntimeException(e);
                }
                logger.verbose("Merged manifest saved to " + outFile, new Object[0]);
                break;
            }
            case ERROR: {
                mergingReport.log(logger);
                throw new RuntimeException(mergingReport.getReportString());
            }
            default: {
                throw new RuntimeException("Unhandled result type : " + mergingReport.getResult());
            }
        }
    }

    private static void generateTestManifest(String testApplicationId, String minSdkVersion, String targetSdkVersion, String testedApplicationId, String instrumentationRunner, Boolean handleProfiling, Boolean functionalTest, File outManifestLocation) {
        TestManifestGenerator generator = new TestManifestGenerator(outManifestLocation, testApplicationId, minSdkVersion, targetSdkVersion, testedApplicationId, instrumentationRunner, handleProfiling, functionalTest);
        try {
            generator.generate();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public File getAaptFriendlyManifestOutputFile() {
        return null;
    }

    @InputFile
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @Optional
    public abstract Property<File> getTestManifestFile();

    @Internal
    public File getTmpDir() {
        return this.tmpDir;
    }

    public void setTmpDir(File tmpDir) {
        this.tmpDir = tmpDir;
    }

    @Input
    public abstract Property<String> getTestApplicationId();

    @Input
    @Optional
    public abstract Property<String> getTestedApplicationId();

    @Input
    public abstract Property<String> getMinSdkVersion();

    @Input
    public abstract Property<String> getTargetSdkVersion();

    @Input
    public abstract Property<String> getInstrumentationRunner();

    @Input
    public abstract Property<Boolean> getHandleProfiling();

    @Input
    public abstract Property<Boolean> getFunctionalTest();

    @Input
    public abstract Property<String> getVariantType();

    @Input
    @Optional
    public abstract Property<String> getTestLabel();

    @Input
    public abstract MapProperty<String, Object> getPlaceholdersValues();

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @Optional
    public FileCollection getTestTargetMetadata() {
        return this.testTargetMetadata;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @Optional
    public FileCollection getNavigationJsons() {
        return this.navigationJsons;
    }

    public List<ManifestProvider> computeProviders() {
        Set artifacts2 = this.manifests.getArtifacts();
        ArrayList providers = Lists.newArrayListWithCapacity((int)artifacts2.size());
        for (ResolvedArtifactResult artifact : artifacts2) {
            providers.add(new ProcessApplicationManifest.CreationAction.ManifestProviderImpl(artifact.getFile(), ProcessApplicationManifest.getArtifactName(artifact)));
        }
        return providers;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileCollection getManifests() {
        return this.manifests.getArtifactFiles();
    }

    public static class CreationAction
    extends VariantTaskCreationAction<ProcessTestManifest> {
        private final FileCollection testTargetMetadata;

        public CreationAction(VariantScope scope, FileCollection testTargetMetadata) {
            super(scope);
            this.testTargetMetadata = testTargetMetadata;
        }

        @Override
        public String getName() {
            return this.getVariantScope().getTaskName("process", "Manifest");
        }

        @Override
        public Class<ProcessTestManifest> getType() {
            return ProcessTestManifest.class;
        }

        @Override
        public void preConfigure(String taskName) {
            super.preConfigure(taskName);
            this.getVariantScope().getArtifacts().republish(InternalArtifactType.MERGED_MANIFESTS.INSTANCE, InternalArtifactType.MANIFEST_METADATA.INSTANCE);
        }

        @Override
        public void handleProvider(TaskProvider<? extends ProcessTestManifest> taskProvider) {
            super.handleProvider(taskProvider);
            this.getVariantScope().getTaskContainer().setProcessManifestTask(taskProvider);
            BuildArtifactsHolder artifacts2 = this.getVariantScope().getArtifacts();
            artifacts2.producesDir(InternalArtifactType.MERGED_MANIFESTS.INSTANCE, taskProvider, ManifestProcessorTask::getManifestOutputDirectory, "");
            artifacts2.producesFile(InternalArtifactType.MANIFEST_MERGE_BLAME_FILE.INSTANCE, taskProvider, ManifestProcessorTask::getMergeBlameFile, "manifest-merger-blame-" + this.getVariantScope().getVariantDslInfo().getBaseName() + "-report.txt");
        }

        @Override
        public void configure(ProcessTestManifest task) {
            super.configure(task);
            Project project2 = task.getProject();
            VariantDslInfo variantDslInfo = this.getVariantScope().getVariantDslInfo();
            VariantSources variantSources = this.getVariantScope().getVariantSources();
            task.getTestManifestFile().set(project2.provider(variantSources::getMainManifestIfExists));
            task.getTestManifestFile().disallowChanges();
            task.apkData = this.getVariantScope().getVariantData().getPublicVariantPropertiesApi().getOutputs().getMainSplit().getApkData();
            task.getVariantType().set((Object)this.getVariantScope().getVariantData().getType().toString());
            task.getVariantType().disallowChanges();
            task.setTmpDir(FileUtils.join((File)this.getVariantScope().getGlobalScope().getIntermediatesDir(), (String[])new String[]{"tmp", "manifest", this.getVariantScope().getDirName()}));
            task.getMinSdkVersion().set(project2.provider(() -> variantDslInfo.getMinSdkVersion().getApiString()));
            task.getMinSdkVersion().disallowChanges();
            task.getTargetSdkVersion().set(project2.provider(() -> variantDslInfo.getTargetSdkVersion().getApiString()));
            task.getTargetSdkVersion().disallowChanges();
            task.testTargetMetadata = this.testTargetMetadata;
            task.getTestApplicationId().set(project2.provider(variantDslInfo::getTestApplicationId));
            task.getTestApplicationId().disallowChanges();
            task.getTestedApplicationId().set(project2.provider(variantDslInfo::getTestedApplicationId));
            task.getTestedApplicationId().disallowChanges();
            VariantDslInfo testedConfig = variantDslInfo.getTestedVariant();
            task.onlyTestApk = testedConfig != null && testedConfig.getVariantType().isAar();
            task.getInstrumentationRunner().set(project2.provider(variantDslInfo::getInstrumentationRunner));
            task.getInstrumentationRunner().disallowChanges();
            task.getHandleProfiling().set(project2.provider(variantDslInfo::getHandleProfiling));
            task.getHandleProfiling().disallowChanges();
            task.getFunctionalTest().set(project2.provider(variantDslInfo::getFunctionalTest));
            task.getFunctionalTest().disallowChanges();
            task.getTestLabel().set(project2.provider(variantDslInfo::getTestLabel));
            task.getTestLabel().disallowChanges();
            task.manifests = this.getVariantScope().getArtifactCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.MANIFEST);
            task.getPlaceholdersValues().set(project2.provider(variantDslInfo::getManifestPlaceholders));
            task.getPlaceholdersValues().disallowChanges();
            if (!this.getVariantScope().getGlobalScope().getExtension().getAaptOptions().getNamespaced()) {
                task.navigationJsons = (FileCollection)project2.files(new Object[]{this.getVariantScope().getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.NAVIGATION_JSON)});
            }
        }
    }
}

