/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.build.api.component.impl.ComponentPropertiesImpl;
import com.android.build.gradle.internal.ide.dependencies.ArtifactUtils;
import com.android.build.gradle.internal.ide.dependencies.BuildMappingUtils;
import com.android.build.gradle.internal.ide.dependencies.ResolvedArtifact;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.tasks.diagnostics.internal.TextReportRenderer;
import org.gradle.internal.graph.GraphRenderer;
import org.gradle.internal.logging.text.StyledTextOutput;

public class AndroidDependenciesRenderer
extends TextReportRenderer {
    private boolean hasConfigs;
    private boolean hasCyclicDependencies;
    private GraphRenderer renderer;

    public void startProject(Project project2) {
        super.startProject(project2);
        this.hasConfigs = false;
        this.hasCyclicDependencies = false;
    }

    public void completeProject(Project project2) {
        if (!this.hasConfigs) {
            this.getTextOutput().withStyle(StyledTextOutput.Style.Info).println((Object)"No dependencies");
        }
        super.completeProject(project2);
    }

    public void startComponent(ComponentPropertiesImpl componentProperties) {
        if (this.hasConfigs) {
            this.getTextOutput().println();
        }
        this.hasConfigs = true;
        this.renderer = new GraphRenderer(this.getTextOutput());
        this.renderer.visit(styledTextOutput -> this.getTextOutput().withStyle(StyledTextOutput.Style.Header).text((Object)componentProperties.getName()), true);
    }

    public void render(ComponentPropertiesImpl componentProperties) {
        ImmutableMap<String, String> buildMapping = BuildMappingUtils.computeBuildMapping(componentProperties.getGlobalScope().getProject().getGradle());
        Set<ResolvedArtifact> compileArtifacts = ArtifactUtils.getAllArtifacts(componentProperties, AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH, null, buildMapping);
        this.getTextOutput().withStyle(StyledTextOutput.Style.Identifier).text((Object)componentProperties.getVariantDependencies().getCompileClasspath().getName());
        this.getTextOutput().withStyle(StyledTextOutput.Style.Description).text((Object)" - Dependencies for compilation");
        this.getTextOutput().println();
        this.renderer.startChildren();
        this.render((List<ResolvedArtifact>)ImmutableList.copyOf(compileArtifacts));
        this.renderer.completeChildren();
        Set<ResolvedArtifact> runtimeArtifacts = ArtifactUtils.getAllArtifacts(componentProperties, AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, null, buildMapping);
        this.getTextOutput().println();
        this.getTextOutput().withStyle(StyledTextOutput.Style.Identifier).text((Object)componentProperties.getVariantDependencies().getRuntimeClasspath().getName());
        this.getTextOutput().withStyle(StyledTextOutput.Style.Description).text((Object)" - Dependencies for runtime/packaging");
        this.getTextOutput().println();
        this.renderer.startChildren();
        this.render((List<ResolvedArtifact>)ImmutableList.copyOf(runtimeArtifacts));
        this.renderer.completeChildren();
    }

    public void complete() {
        if (this.hasCyclicDependencies) {
            this.getTextOutput().withStyle(StyledTextOutput.Style.Info).println((Object)"\n(*) - dependencies omitted (listed previously)");
        }
        super.complete();
    }

    private void render(List<ResolvedArtifact> artifacts2) {
        int count = artifacts2.size();
        for (int i2 = 0; i2 < count; ++i2) {
            ResolvedArtifact artifact = artifacts2.get(i2);
            this.renderer.visit(styledTextOutput -> {
                String text;
                ComponentIdentifier id = artifact.getComponentIdentifier();
                if (id instanceof ProjectComponentIdentifier) {
                    if (artifact.isWrappedModule()) {
                        String project2 = ((ProjectComponentIdentifier)id).getProjectPath();
                        String file = artifact.getArtifactFile().getAbsolutePath();
                        text = String.format("%s (file: %s)", project2, file);
                    } else if (artifact.getDependencyType() == ResolvedArtifact.DependencyType.ANDROID) {
                        String project3 = ((ProjectComponentIdentifier)id).getProjectPath();
                        String variant2 = artifact.getVariantName();
                        text = String.format("%s (variant: %s)", project3, variant2);
                    } else {
                        text = ((ProjectComponentIdentifier)id).getProjectPath();
                    }
                } else {
                    text = id instanceof ModuleComponentIdentifier ? artifact.computeModelAddress() : artifact.getArtifactFile().getAbsolutePath();
                }
                this.getTextOutput().text((Object)text);
            }, i2 == count - 1);
        }
    }
}

