/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dependency;

import com.android.build.api.variant.impl.VariantPropertiesImpl;
import com.android.build.gradle.internal.dependency.FilteredArtifactCollection;
import com.android.build.gradle.internal.dependency.FilteringSpec;
import com.android.build.gradle.internal.dependency.SubtractingArtifactCollection;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.ProjectOptions;
import com.android.builder.core.VariantType;
import com.android.builder.core.VariantTypeImpl;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.file.FileCollection;
import org.gradle.api.specs.Spec;

public class VariantDependencies {
    public static final String CONFIG_NAME_COMPILE = "compile";
    public static final String CONFIG_NAME_PUBLISH = "publish";
    public static final String CONFIG_NAME_APK = "apk";
    public static final String CONFIG_NAME_PROVIDED = "provided";
    public static final String CONFIG_NAME_WEAR_APP = "wearApp";
    public static final String CONFIG_NAME_ANDROID_APIS = "androidApis";
    public static final String CONFIG_NAME_ANNOTATION_PROCESSOR = "annotationProcessor";
    public static final String CONFIG_NAME_API = "api";
    public static final String CONFIG_NAME_COMPILE_ONLY = "compileOnly";
    public static final String CONFIG_NAME_IMPLEMENTATION = "implementation";
    public static final String CONFIG_NAME_RUNTIME_ONLY = "runtimeOnly";
    @Deprecated
    public static final String CONFIG_NAME_FEATURE = "feature";
    public static final String CONFIG_NAME_APPLICATION = "application";
    public static final String CONFIG_NAME_LINTCHECKS = "lintChecks";
    public static final String CONFIG_NAME_LINTPUBLISH = "lintPublish";
    public static final String CONFIG_NAME_TESTED_APKS = "testedApks";
    public static final String CONFIG_NAME_CORE_LIBRARY_DESUGARING = "coreLibraryDesugaring";
    private final String variantName;
    private final VariantType variantType;
    private final VariantPropertiesImpl testedVariant;
    private final Configuration compileClasspath;
    private final Configuration runtimeClasspath;
    private final Collection<Configuration> sourceSetRuntimeConfigurations;
    private final Collection<Configuration> sourceSetImplementationConfigurations;
    private final Configuration annotationProcessorConfiguration;
    private final Configuration wearAppConfiguration;
    private final Configuration reverseMetadataValuesConfiguration;
    private final ImmutableMap<AndroidArtifacts.PublishedConfigType, Configuration> elements;
    private final Project project;
    private final ProjectOptions projectOptions;

    VariantDependencies(String variantName, VariantType variantType, Configuration compileClasspath, Configuration runtimeClasspath, Collection<Configuration> sourceSetRuntimeConfigurations, Collection<Configuration> sourceSetImplementationConfigurations, Map<AndroidArtifacts.PublishedConfigType, Configuration> elements, Configuration annotationProcessorConfiguration, Configuration reverseMetadataValuesConfiguration, Configuration wearAppConfiguration, VariantPropertiesImpl testedVariant, Project project2, ProjectOptions projectOptions) {
        Preconditions.checkState((!variantType.isTestComponent() || testedVariant != null ? 1 : 0) != 0, (Object)"testedVariantDependencies null for test component");
        this.variantName = variantName;
        this.variantType = variantType;
        this.compileClasspath = compileClasspath;
        this.runtimeClasspath = runtimeClasspath;
        this.sourceSetRuntimeConfigurations = sourceSetRuntimeConfigurations;
        this.sourceSetImplementationConfigurations = sourceSetImplementationConfigurations;
        this.elements = Maps.immutableEnumMap(elements);
        this.annotationProcessorConfiguration = annotationProcessorConfiguration;
        this.reverseMetadataValuesConfiguration = reverseMetadataValuesConfiguration;
        this.wearAppConfiguration = wearAppConfiguration;
        this.testedVariant = testedVariant;
        this.project = project2;
        this.projectOptions = projectOptions;
    }

    public String getName() {
        return this.variantName;
    }

    public Configuration getCompileClasspath() {
        return this.compileClasspath;
    }

    public Configuration getRuntimeClasspath() {
        return this.runtimeClasspath;
    }

    public Collection<Dependency> getIncomingRuntimeDependencies() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Configuration classpath : this.sourceSetRuntimeConfigurations) {
            builder.addAll((Iterable)classpath.getIncoming().getDependencies());
        }
        return builder.build();
    }

    public Configuration getElements(AndroidArtifacts.PublishedConfigType configType) {
        return (Configuration)this.elements.get((Object)configType);
    }

    public Configuration getAnnotationProcessorConfiguration() {
        return this.annotationProcessorConfiguration;
    }

    public Configuration getWearAppConfiguration() {
        return this.wearAppConfiguration;
    }

    public Configuration getReverseMetadataValuesConfiguration() {
        return this.reverseMetadataValuesConfiguration;
    }

    public Collection<Configuration> getSourceSetImplementationConfigurations() {
        return this.sourceSetImplementationConfigurations;
    }

    public Collection<Configuration> getSourceSetRuntimeConfigurations() {
        return this.sourceSetRuntimeConfigurations;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.variantName).toString();
    }

    public FileCollection getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType configType, AndroidArtifacts.ArtifactScope scope, AndroidArtifacts.ArtifactType artifactType) {
        return this.getArtifactFileCollection(configType, scope, artifactType, null);
    }

    public FileCollection getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType configType, AndroidArtifacts.ArtifactScope scope, AndroidArtifacts.ArtifactType artifactType, Map<Attribute<String>, String> attributeMap) {
        FileCollection fileCollection2;
        if (configType.needsTestedComponents()) {
            return this.getArtifactCollection(configType, scope, artifactType, attributeMap).getArtifactFiles();
        }
        ArtifactCollection artifacts2 = this.computeArtifactCollection(configType, scope, artifactType, attributeMap);
        if (configType == AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH && this.isArtifactTypeExcluded(artifactType)) {
            FileCollection excludedDirectories = this.computeArtifactCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.PROJECT, AndroidArtifacts.ArtifactType.PACKAGED_DEPENDENCIES, attributeMap).getArtifactFiles();
            fileCollection2 = new FilteringSpec(artifacts2, excludedDirectories).getFilteredFileCollection(this.project);
        } else {
            fileCollection2 = artifacts2.getArtifactFiles();
        }
        return fileCollection2;
    }

    public ArtifactCollection getArtifactCollection(AndroidArtifacts.ConsumedConfigType configType, AndroidArtifacts.ArtifactScope scope, AndroidArtifacts.ArtifactType artifactType) {
        return this.getArtifactCollection(configType, scope, artifactType, null);
    }

    public ArtifactCollection getArtifactCollection(AndroidArtifacts.ConsumedConfigType configType, AndroidArtifacts.ArtifactScope scope, AndroidArtifacts.ArtifactType artifactType, Map<Attribute<String>, String> attributeMap) {
        ArtifactCollection artifacts2 = this.computeArtifactCollection(configType, scope, artifactType, attributeMap);
        if (configType == AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH && this.isArtifactTypeExcluded(artifactType)) {
            FileCollection excludedDirectories = this.computeArtifactCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.PROJECT, AndroidArtifacts.ArtifactType.PACKAGED_DEPENDENCIES, null).getArtifactFiles();
            artifacts2 = new FilteredArtifactCollection(this.project, new FilteringSpec(artifacts2, excludedDirectories));
        }
        if (!configType.needsTestedComponents() || !this.variantType.isTestComponent()) {
            return artifacts2;
        }
        if (this.testedVariant == null) {
            return artifacts2;
        }
        if (this.testedVariant.getVariantType() == VariantTypeImpl.BASE_APK && configType == AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH && this.variantType.isApk() && artifactType != AndroidArtifacts.ArtifactType.ANDROID_RES && artifactType != AndroidArtifacts.ArtifactType.COMPILED_DEPENDENCIES_RESOURCES) {
            ArtifactCollection testedArtifactCollection = this.testedVariant.getVariantDependencies().getArtifactCollection(configType, scope, artifactType, attributeMap);
            artifacts2 = new SubtractingArtifactCollection(artifacts2, testedArtifactCollection);
        }
        return artifacts2;
    }

    private boolean isArtifactTypeExcluded(AndroidArtifacts.ArtifactType artifactType) {
        return this.variantType.isDynamicFeature() && artifactType != AndroidArtifacts.ArtifactType.PACKAGED_DEPENDENCIES && artifactType != AndroidArtifacts.ArtifactType.FEATURE_DEX && artifactType != AndroidArtifacts.ArtifactType.FEATURE_NAME;
    }

    private Configuration getConfiguration(AndroidArtifacts.ConsumedConfigType configType) {
        switch (configType) {
            case COMPILE_CLASSPATH: {
                return this.getCompileClasspath();
            }
            case RUNTIME_CLASSPATH: {
                return this.getRuntimeClasspath();
            }
            case ANNOTATION_PROCESSOR: {
                return this.getAnnotationProcessorConfiguration();
            }
            case REVERSE_METADATA_VALUES: {
                return (Configuration)Preconditions.checkNotNull((Object)this.getReverseMetadataValuesConfiguration());
            }
        }
        throw new RuntimeException("unknown ConfigType value " + (Object)((Object)configType));
    }

    public ArtifactCollection getArtifactCollectionForToolingModel(AndroidArtifacts.ConsumedConfigType configType, AndroidArtifacts.ArtifactScope scope, AndroidArtifacts.ArtifactType artifactType) {
        return this.computeArtifactCollection(configType, scope, artifactType, null);
    }

    private ArtifactCollection computeArtifactCollection(AndroidArtifacts.ConsumedConfigType configType, AndroidArtifacts.ArtifactScope scope, AndroidArtifacts.ArtifactType artifactType, Map<Attribute<String>, String> attributeMap) {
        Configuration configuration2 = this.getConfiguration(configType);
        Action attributes2 = container -> {
            container.attribute(AndroidArtifacts.ARTIFACT_TYPE, (Object)artifactType.getType());
            if (attributeMap != null) {
                for (Attribute attribute : attributeMap.keySet()) {
                    container.attribute(attribute, attributeMap.get(attribute));
                }
            }
        };
        Spec<ComponentIdentifier> filter2 = VariantDependencies.getComponentFilter(scope);
        boolean lenientMode = Boolean.TRUE.equals(this.projectOptions.get(BooleanOption.IDE_BUILD_MODEL_ONLY));
        return configuration2.getIncoming().artifactView(config2 -> {
            config2.attributes(attributes2);
            if (filter2 != null) {
                config2.componentFilter(filter2);
            }
            config2.lenient(lenientMode);
        }).getArtifacts();
    }

    private static Spec<ComponentIdentifier> getComponentFilter(AndroidArtifacts.ArtifactScope scope) {
        switch (scope) {
            case ALL: {
                return null;
            }
            case EXTERNAL: {
                return id -> !(id instanceof ProjectComponentIdentifier);
            }
            case PROJECT: {
                return id -> id instanceof ProjectComponentIdentifier;
            }
            case REPOSITORY_MODULE: {
                return id -> id instanceof ModuleComponentIdentifier;
            }
            case FILE: {
                return id -> !(id instanceof ProjectComponentIdentifier) && !(id instanceof ModuleComponentIdentifier);
            }
        }
        throw new RuntimeException("unknown ArtifactScope value");
    }
}

