/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.api.component.impl.ComponentPropertiesImpl;
import com.android.build.gradle.internal.tasks.ClasspathComparisonTask;
import com.android.build.gradle.internal.tasks.factory.TaskCreationAction;
import com.android.ide.common.repository.GradleVersion;
import com.android.utils.FileUtils;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.tasks.CacheableTask;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b'\u0018\u00002\u00020\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006H\u0014\u00a8\u0006\u000b"}, d2={"Lcom/android/build/gradle/internal/tasks/AppClasspathCheckTask;", "Lcom/android/build/gradle/internal/tasks/ClasspathComparisonTask;", "()V", "onDifferentVersionsFound", "", "group", "", "module", "runtimeVersion", "compileVersion", "CreationAction", "gradle"})
public abstract class AppClasspathCheckTask
extends ClasspathComparisonTask {
    @Override
    protected void onDifferentVersionsFound(@NotNull String group, @NotNull String module2, @NotNull String runtimeVersion, @NotNull String compileVersion) {
        Object runtime;
        Intrinsics.checkParameterIsNotNull((Object)group, (String)"group");
        Intrinsics.checkParameterIsNotNull((Object)module2, (String)"module");
        Intrinsics.checkParameterIsNotNull((Object)runtimeVersion, (String)"runtimeVersion");
        Intrinsics.checkParameterIsNotNull((Object)compileVersion, (String)"compileVersion");
        try {
            runtime = GradleVersion.parse((String)runtimeVersion);
            GradleVersion compile = GradleVersion.parse((String)compileVersion);
            runtime = runtime.compareTo(compile) > 0 ? runtimeVersion : compileVersion;
        }
        catch (Throwable e) {
            runtime = runtimeVersion;
        }
        Object suggestedVersion = runtime;
        StringBuilder stringBuilder = new StringBuilder().append("Conflict with dependency '").append(group).append(':').append(module2).append("' in project '");
        Project project2 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
        StringBuilder stringBuilder2 = stringBuilder.append(project2.getPath()).append("'.\nResolved versions for runtime classpath (").append(runtimeVersion).append(") and compile classpath (").append(compileVersion).append(") differ.\nThis can lead to runtime crashes.\nTo resolve this issue follow advice at https://developer.android.com/studio/build/gradle-tips#configure-project-wide-properties.\nAlternatively, you can try to fix the problem by adding this snippet to ");
        Project project3 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project3, (String)"project");
        String message = stringBuilder2.append(project3.getBuildFile()).append(":\n\ndependencies {\n    implementation(\"").append(group).append(':').append(module2).append(':').append((String)suggestedVersion).append("\")\n}\n").toString();
        throw (Throwable)new RuntimeException(message);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0011"}, d2={"Lcom/android/build/gradle/internal/tasks/AppClasspathCheckTask$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/TaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/AppClasspathCheckTask;", "componentProperties", "Lcom/android/build/api/component/impl/ComponentPropertiesImpl;", "(Lcom/android/build/api/component/impl/ComponentPropertiesImpl;)V", "name", "", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "gradle"})
    public static final class CreationAction
    extends TaskCreationAction<AppClasspathCheckTask> {
        private final ComponentPropertiesImpl componentProperties;

        @Override
        @NotNull
        public String getName() {
            return this.componentProperties.computeTaskName("check", "Classpath");
        }

        @Override
        @NotNull
        public Class<AppClasspathCheckTask> getType() {
            return AppClasspathCheckTask.class;
        }

        @Override
        public void configure(@NotNull AppClasspathCheckTask task) {
            Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
            String string = this.componentProperties.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"componentProperties.name");
            task.setVariantName(string);
            Configuration configuration2 = this.componentProperties.getVariantDependencies().getRuntimeClasspath();
            Intrinsics.checkExpressionValueIsNotNull((Object)configuration2, (String)"componentProperties.vari\u2026ndencies.runtimeClasspath");
            task.setRuntimeClasspath(configuration2);
            Configuration configuration3 = this.componentProperties.getVariantDependencies().getCompileClasspath();
            Intrinsics.checkExpressionValueIsNotNull((Object)configuration3, (String)"componentProperties.vari\u2026ndencies.compileClasspath");
            task.setCompileClasspath(configuration3);
            task.setFakeOutputDirectory(FileUtils.join((File)this.componentProperties.getGlobalScope().getIntermediatesDir(), (String[])new String[]{this.getName(), this.componentProperties.getDirName()}));
        }

        public CreationAction(@NotNull ComponentPropertiesImpl componentProperties) {
            Intrinsics.checkParameterIsNotNull((Object)componentProperties, (String)"componentProperties");
            this.componentProperties = componentProperties;
        }
    }
}

