/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.workeractions.WorkerActionServiceRegistry;
import com.android.builder.utils.ZipEntryUtils;
import com.android.ide.common.resources.FileStatus;
import com.android.ide.common.workers.WorkerExecutorFacade;
import com.android.utils.FileUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.hash.Hashing;
import com.google.common.io.ByteStreams;
import com.google.common.io.Closer;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileTime;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.inject.Inject;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public class FixStackFramesDelegate {
    private static final LoggerWrapper logger = LoggerWrapper.getLogger(FixStackFramesDelegate.class);
    private static final FileTime ZERO = FileTime.fromMillis(0L);
    private static final WorkerActionServiceRegistry sharedState = new WorkerActionServiceRegistry();
    private final Set<File> bootClasspath;
    private final Set<File> classesToFix;
    private final Set<File> referencedClasses;
    private final File outFolder;

    public FixStackFramesDelegate(Set<File> bootClasspath2, Set<File> classesToFix, Set<File> referencedClasses, File outFolder) {
        this.bootClasspath = bootClasspath2;
        this.classesToFix = classesToFix;
        this.referencedClasses = referencedClasses;
        this.outFolder = outFolder;
    }

    private URLClassLoader createClassLoader() throws MalformedURLException {
        ImmutableList.Builder urls = new ImmutableList.Builder();
        for (File file : this.bootClasspath) {
            if (!file.exists()) continue;
            urls.add((Object)file.toURI().toURL());
        }
        for (File file : Iterables.concat(this.classesToFix, this.referencedClasses)) {
            if (!file.isDirectory() && !file.isFile()) continue;
            urls.add((Object)file.toURI().toURL());
        }
        ImmutableList allUrls = urls.build();
        URL[] classLoaderUrls = (URL[])allUrls.toArray((Object[])new URL[0]);
        return new URLClassLoader(classLoaderUrls);
    }

    private String getUniqueName(File input) {
        return Hashing.sha256().hashBytes(input.getAbsolutePath().getBytes(StandardCharsets.UTF_8)).toString() + ".jar";
    }

    private void processFiles(WorkerExecutorFacade workers, Map<File, FileStatus> changedInput) throws IOException {
        try (Closer closer = Closer.create();){
            closer.register((Closeable)workers);
            URLClassLoader classLoader = this.createClassLoader();
            closer.register((Closeable)classLoader);
            ClassLoaderKey classLoaderKey = new ClassLoaderKey("classLoader" + this.hashCode());
            closer.register(sharedState.registerServiceAsCloseable(classLoaderKey, classLoader));
            for (Map.Entry<File, FileStatus> entry : changedInput.entrySet()) {
                File out = new File(this.outFolder, this.getUniqueName(entry.getKey()));
                Files.deleteIfExists(out.toPath());
                if (entry.getValue() != FileStatus.NEW && entry.getValue() != FileStatus.CHANGED) continue;
                workers.submit(FixStackFramesRunnable.class, (Serializable)new Params(entry.getKey(), out, classLoaderKey));
            }
            workers.await();
        }
    }

    public void doFullRun(WorkerExecutorFacade workers) throws IOException {
        FileUtils.cleanOutputDir((File)this.outFolder);
        Map<File, FileStatus> inputToProcess = this.classesToFix.stream().collect(Collectors.toMap(f -> f, f -> FileStatus.NEW));
        this.processFiles(workers, inputToProcess);
    }

    public void doIncrementalRun(WorkerExecutorFacade workers, Map<File, FileStatus> changedInput) throws IOException {
        Set jarsToProcess = this.classesToFix.stream().filter(File::isFile).collect(Collectors.toSet());
        Map<File, FileStatus> inputToProcess = changedInput.entrySet().stream().filter(e -> e.getValue() == FileStatus.REMOVED || jarsToProcess.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        this.processFiles(workers, inputToProcess);
    }

    private static class FixStackFramesRunnable
    implements Runnable {
        private final Params params;

        @Inject
        public FixStackFramesRunnable(Params params) {
            this.params = params;
        }

        @Override
        public void run() {
            try {
                URLClassLoader classLoader = sharedState.getService(this.params.classLoaderKey).getService();
                FixStackFramesRunnable.createFile(this.params.input, this.params.output, classLoader);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }

        private static void createFile(File input, File output2, URLClassLoader classLoader) throws IOException {
            try (ZipFile inputZip = new ZipFile(input);
                 ZipOutputStream outputZip = new ZipOutputStream(new BufferedOutputStream(Files.newOutputStream(output2.toPath(), new OpenOption[0])));){
                Enumeration<? extends ZipEntry> inEntries = inputZip.entries();
                while (inEntries.hasMoreElements()) {
                    ZipEntry entry = inEntries.nextElement();
                    if (!ZipEntryUtils.isValidZipEntryName((ZipEntry)entry)) {
                        throw new InvalidPathException(entry.getName(), "Entry name contains invalid characters");
                    }
                    if (!entry.getName().endsWith(".class")) continue;
                    BufferedInputStream originalFile = new BufferedInputStream(inputZip.getInputStream(entry));
                    ZipEntry outEntry = new ZipEntry(entry.getName());
                    byte[] newEntryContent = FixStackFramesRunnable.getFixedClass(originalFile, classLoader);
                    CRC32 crc32 = new CRC32();
                    crc32.update(newEntryContent);
                    outEntry.setCrc(crc32.getValue());
                    outEntry.setMethod(0);
                    outEntry.setSize(newEntryContent.length);
                    outEntry.setCompressedSize(newEntryContent.length);
                    outEntry.setLastAccessTime(ZERO);
                    outEntry.setLastModifiedTime(ZERO);
                    outEntry.setCreationTime(ZERO);
                    outputZip.putNextEntry(outEntry);
                    outputZip.write(newEntryContent);
                    outputZip.closeEntry();
                }
            }
        }

        private static byte[] getFixedClass(InputStream originalFile, URLClassLoader classLoader) throws IOException {
            byte[] bytes = ByteStreams.toByteArray((InputStream)originalFile);
            try {
                ClassReader classReader = new ClassReader(bytes);
                FixFramesVisitor classWriter = new FixFramesVisitor(2, classLoader);
                classReader.accept((ClassVisitor)classWriter, 4);
                return classWriter.toByteArray();
            }
            catch (Throwable t) {
                logger.verbose(t.getMessage(), new Object[0]);
                return bytes;
            }
        }
    }

    private static class Params
    implements Serializable {
        private final File input;
        private final File output;
        private final ClassLoaderKey classLoaderKey;

        private Params(File input, File output2, ClassLoaderKey classLoaderKey) {
            this.input = input;
            this.output = output2;
            this.classLoaderKey = classLoaderKey;
        }
    }

    static class ClassLoaderKey
    extends BaseKey
    implements WorkerActionServiceRegistry.ServiceKey<URLClassLoader> {
        public ClassLoaderKey(String name2) {
            super(name2);
        }

        @Override
        public Class<URLClassLoader> getType() {
            return URLClassLoader.class;
        }
    }

    private static class BaseKey
    implements Serializable {
        private final String name;

        public BaseKey(String name2) {
            this.name = name2;
        }

        public boolean equals(Object other) {
            if (other instanceof BaseKey) {
                return this.name.equals(((BaseKey)other).name);
            }
            return false;
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }

    private static class FixFramesVisitor
    extends ClassWriter {
        private final URLClassLoader classLoader;

        public FixFramesVisitor(int flags, URLClassLoader classLoader) {
            super(flags);
            this.classLoader = classLoader;
        }

        protected String getCommonSuperClass(String type1, String type2) {
            Class<?> d;
            Class<?> c;
            URLClassLoader classLoader = this.classLoader;
            try {
                c = Class.forName(type1.replace('/', '.'), false, classLoader);
                d = Class.forName(type2.replace('/', '.'), false, classLoader);
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Unable to find common supper type for %s and %s.", type1, type2), e);
            }
            if (c.isAssignableFrom(d)) {
                return type1;
            }
            if (d.isAssignableFrom(c)) {
                return type2;
            }
            if (c.isInterface() || d.isInterface()) {
                return "java/lang/Object";
            }
            while (!(c = c.getSuperclass()).isAssignableFrom(d)) {
            }
            return c.getName().replace('.', '/');
        }
    }
}

