/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.variant;

import com.android.build.VariantOutput;
import com.android.build.api.component.ComponentIdentity;
import com.android.build.api.component.impl.AndroidTestImpl;
import com.android.build.api.component.impl.AndroidTestPropertiesImpl;
import com.android.build.api.component.impl.ComponentPropertiesImpl;
import com.android.build.api.component.impl.UnitTestImpl;
import com.android.build.api.component.impl.UnitTestPropertiesImpl;
import com.android.build.api.variant.impl.VariantImpl;
import com.android.build.api.variant.impl.VariantPropertiesImpl;
import com.android.build.gradle.internal.BuildTypeData;
import com.android.build.gradle.internal.ProductFlavorData;
import com.android.build.gradle.internal.api.BaseVariantImpl;
import com.android.build.gradle.internal.api.ReadOnlyObjectProvider;
import com.android.build.gradle.internal.core.VariantDslInfo;
import com.android.build.gradle.internal.core.VariantSources;
import com.android.build.gradle.internal.dependency.VariantDependencies;
import com.android.build.gradle.internal.dsl.BuildType;
import com.android.build.gradle.internal.dsl.DefaultConfig;
import com.android.build.gradle.internal.dsl.ProductFlavor;
import com.android.build.gradle.internal.dsl.SigningConfig;
import com.android.build.gradle.internal.errors.SyncIssueReporter;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.build.gradle.internal.scope.BuildArtifactsHolder;
import com.android.build.gradle.internal.scope.BuildFeatureValues;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.services.BaseServices;
import com.android.build.gradle.internal.services.BaseServicesImpl;
import com.android.build.gradle.internal.services.ProjectServices;
import com.android.build.gradle.internal.services.TaskCreationServices;
import com.android.build.gradle.internal.services.VariantApiServices;
import com.android.build.gradle.internal.services.VariantPropertiesApiServices;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.TestVariantData;
import com.android.build.gradle.internal.variant.VariantFactory;
import com.android.build.gradle.internal.variant.VariantInputModel;
import com.android.build.gradle.internal.variant.VariantPathHelper;
import com.android.build.gradle.options.BooleanOption;
import com.android.builder.errors.IssueReporter;
import org.gradle.api.Project;

public abstract class BaseVariantFactory<VariantT extends VariantImpl<VariantPropertiesT>, VariantPropertiesT extends VariantPropertiesImpl>
implements VariantFactory<VariantT, VariantPropertiesT> {
    protected final ProjectServices projectServices;
    protected final GlobalScope globalScope;
    @Deprecated
    private final BaseServices servicesForOldVariantObjectsOnly;

    public BaseVariantFactory(ProjectServices projectServices, GlobalScope globalScope) {
        this.projectServices = projectServices;
        this.globalScope = globalScope;
        this.servicesForOldVariantObjectsOnly = new BaseServicesImpl(projectServices);
    }

    @Override
    public UnitTestImpl createUnitTestObject(ComponentIdentity componentIdentity, VariantDslInfo variantDslInfo, VariantApiServices variantApiServices) {
        return (UnitTestImpl)this.projectServices.getObjectFactory().newInstance(UnitTestImpl.class, new Object[]{variantDslInfo, componentIdentity, variantApiServices});
    }

    @Override
    public AndroidTestImpl createAndroidTestObject(ComponentIdentity componentIdentity, VariantDslInfo variantDslInfo, VariantApiServices variantApiServices) {
        return (AndroidTestImpl)this.projectServices.getObjectFactory().newInstance(AndroidTestImpl.class, new Object[]{variantDslInfo, componentIdentity, variantApiServices});
    }

    @Override
    public UnitTestPropertiesImpl createUnitTestProperties(ComponentIdentity componentIdentity, BuildFeatureValues buildFeatures, VariantDslInfo variantDslInfo, VariantDependencies variantDependencies, VariantSources variantSources, VariantPathHelper paths, BuildArtifactsHolder artifacts2, VariantScope variantScope, TestVariantData variantData, VariantPropertiesImpl testedVariantProperties, TransformManager transformManager, VariantPropertiesApiServices variantPropertiesApiServices, TaskCreationServices taskCreationServices) {
        UnitTestPropertiesImpl unitTestProperties2 = (UnitTestPropertiesImpl)this.projectServices.getObjectFactory().newInstance(UnitTestPropertiesImpl.class, new Object[]{componentIdentity, buildFeatures, variantDslInfo, variantDependencies, variantSources, paths, artifacts2, variantScope, variantData, testedVariantProperties, transformManager, variantPropertiesApiServices, taskCreationServices, this.globalScope});
        unitTestProperties2.addVariantOutput(variantData.getOutputFactory().addMainApk());
        return unitTestProperties2;
    }

    @Override
    public AndroidTestPropertiesImpl createAndroidTestProperties(ComponentIdentity componentIdentity, BuildFeatureValues buildFeatures, VariantDslInfo variantDslInfo, VariantDependencies variantDependencies, VariantSources variantSources, VariantPathHelper paths, BuildArtifactsHolder artifacts2, VariantScope variantScope, TestVariantData variantData, VariantPropertiesImpl testedVariantProperties, TransformManager transformManager, VariantPropertiesApiServices variantPropertiesApiServices, TaskCreationServices taskCreationServices) {
        AndroidTestPropertiesImpl androidTestProperties2 = (AndroidTestPropertiesImpl)this.projectServices.getObjectFactory().newInstance(AndroidTestPropertiesImpl.class, new Object[]{componentIdentity, buildFeatures, variantDslInfo, variantDependencies, variantSources, paths, artifacts2, variantScope, variantData, testedVariantProperties, transformManager, variantPropertiesApiServices, taskCreationServices, this.globalScope});
        androidTestProperties2.addVariantOutput(variantData.getOutputFactory().addMainApk());
        return androidTestProperties2;
    }

    @Override
    public BaseVariantImpl createVariantApi(GlobalScope globalScope, ComponentPropertiesImpl componentProperties, BaseVariantData variantData, ReadOnlyObjectProvider readOnlyObjectProvider) {
        Class<BaseVariantImpl> implementationClass = this.getVariantImplementationClass(variantData);
        return (BaseVariantImpl)this.projectServices.getObjectFactory().newInstance(implementationClass, new Object[]{variantData, componentProperties, this.servicesForOldVariantObjectsOnly, readOnlyObjectProvider, globalScope.getProject().container(VariantOutput.class)});
    }

    @Override
    @Deprecated
    public BaseServices getServicesForOldVariantObjectsOnly() {
        return this.servicesForOldVariantObjectsOnly;
    }

    @Override
    public void preVariantWork(Project project2) {
        if (project2.getPluginManager().hasPlugin("com.neenbedankt.android-apt")) {
            this.projectServices.getIssueReporter().reportError(IssueReporter.Type.INCOMPATIBLE_PLUGIN, "android-apt plugin is incompatible with the Android Gradle plugin.  Please use 'annotationProcessor' configuration instead.", "android-apt");
        }
    }

    @Override
    public void validateModel(VariantInputModel<DefaultConfig, BuildType, ProductFlavor, SigningConfig> model2) {
        this.validateBuildConfig(model2);
        this.validateResValues(model2);
    }

    void validateBuildConfig(VariantInputModel<DefaultConfig, BuildType, ProductFlavor, SigningConfig> model2) {
        Boolean buildConfig = this.globalScope.getExtension().getBuildFeatures().getBuildConfig();
        if (buildConfig == null) {
            buildConfig = this.projectServices.getProjectOptions().get(BooleanOption.BUILD_FEATURE_BUILDCONFIG);
        }
        if (!buildConfig.booleanValue()) {
            SyncIssueReporter issueReporter = this.projectServices.getIssueReporter();
            if (!model2.getDefaultConfigData().getDefaultConfig().getBuildConfigFields().isEmpty()) {
                issueReporter.reportError(IssueReporter.Type.GENERIC, "defaultConfig contains custom BuildConfig fields, but the feature is disabled.");
            }
            for (BuildTypeData<BuildType> buildTypeData : model2.getBuildTypes().values()) {
                if (buildTypeData.getBuildType().getBuildConfigFields().isEmpty()) continue;
                issueReporter.reportError(IssueReporter.Type.GENERIC, String.format("Build Type '%s' contains custom BuildConfig fields, but the feature is disabled.", buildTypeData.getBuildType().getName()));
            }
            for (ProductFlavorData productFlavorData : model2.getProductFlavors().values()) {
                if (((ProductFlavor)productFlavorData.getProductFlavor()).getBuildConfigFields().isEmpty()) continue;
                issueReporter.reportError(IssueReporter.Type.GENERIC, String.format("Product Flavor '%s' contains custom BuildConfig fields, but the feature is disabled.", ((ProductFlavor)productFlavorData.getProductFlavor()).getName()));
            }
        }
    }

    void validateResValues(VariantInputModel<DefaultConfig, BuildType, ProductFlavor, SigningConfig> model2) {
        Boolean resValues = this.globalScope.getExtension().getBuildFeatures().getResValues();
        if (resValues == null) {
            resValues = this.projectServices.getProjectOptions().get(BooleanOption.BUILD_FEATURE_RESVALUES);
        }
        if (!resValues.booleanValue()) {
            SyncIssueReporter issueReporter = this.projectServices.getIssueReporter();
            if (!model2.getDefaultConfigData().getDefaultConfig().getResValues().isEmpty()) {
                issueReporter.reportError(IssueReporter.Type.GENERIC, "defaultConfig contains custom resource values, but the feature is disabled.");
            }
            for (BuildTypeData<BuildType> buildTypeData : model2.getBuildTypes().values()) {
                if (buildTypeData.getBuildType().getResValues().isEmpty()) continue;
                issueReporter.reportError(IssueReporter.Type.GENERIC, String.format("Build Type '%s' contains custom resource values, but the feature is disabled.", buildTypeData.getBuildType().getName()));
            }
            for (ProductFlavorData productFlavorData : model2.getProductFlavors().values()) {
                if (((ProductFlavor)productFlavorData.getProductFlavor()).getResValues().isEmpty()) continue;
                issueReporter.reportError(IssueReporter.Type.GENERIC, String.format("Product Flavor '%s' contains custom resource values, but the feature is disabled.", ((ProductFlavor)productFlavorData.getProductFlavor()).getName()));
            }
        }
    }
}

