/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.mlkit;

import com.android.tools.mlkit.MetadataExtractor;
import org.tensorflow.lite.support.metadata.schema.AssociatedFile;
import org.tensorflow.lite.support.metadata.schema.ModelMetadata;
import org.tensorflow.lite.support.metadata.schema.TensorMetadata;
import tflite.Tensor;

public class TensorInfo {
    private String name;
    private int[] shape;
    private DataType dataType;
    private String fileName;
    private FileType fileType;
    private Source source;
    private ContentType contentType;
    private String description;
    private MetadataExtractor.NormalizationParams normalizationParams;
    private MetadataExtractor.QuantizationParams quantizationParams;

    public String getName() {
        return this.name;
    }

    public int[] getShape() {
        return this.shape;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public String getFileName() {
        return this.fileName;
    }

    public FileType getFileType() {
        return this.fileType;
    }

    public Source getSource() {
        return this.source;
    }

    public ContentType getContentType() {
        return this.contentType;
    }

    public String getDescription() {
        return this.description;
    }

    public MetadataExtractor.NormalizationParams getNormalizationParams() {
        return this.normalizationParams;
    }

    public MetadataExtractor.QuantizationParams getQuantizationParams() {
        return this.quantizationParams;
    }

    public static TensorInfo parseFrom(MetadataExtractor extractor, Source source, int index) {
        Builder builder = new Builder();
        if (source == Source.INPUT) {
            builder.setShape(extractor.getInputTensorShape(0, index));
            builder.setDataType(DataType.fromByte(extractor.getInputTensorType(0, index)));
        } else {
            builder.setShape(extractor.getOutputTensorShape(0, index));
            builder.setDataType(DataType.fromByte(extractor.getOutputTensorType(0, index)));
        }
        ModelMetadata metadata = extractor.getModelMetaData();
        TensorMetadata tensorMetadata = source == Source.INPUT ? metadata.subgraphMetadata(0).inputTensorMetadata(index) : metadata.subgraphMetadata(0).outputTensorMetadata(index);
        Tensor tensor = source == Source.INPUT ? extractor.getInputTensor(0, index) : extractor.getOutputTensor(0, index);
        AssociatedFile file = tensorMetadata.associatedFiles(0);
        if (file != null) {
            builder.setFileName(file.name());
            builder.setFileType(FileType.fromByte(file.type()));
        }
        builder.setContentType(ContentType.fromByte(tensorMetadata.contentType()));
        builder.setName(tensorMetadata.name() == null ? "data" + index : tensorMetadata.name());
        builder.setDescription(tensorMetadata.description());
        builder.setQuantizationParams(extractor.getQuantizationParams(tensor));
        builder.setSource(source);
        if (tensorMetadata.stats() != null && tensorMetadata.stats().meanAsByteBuffer() != null) {
            builder.setNormalizationParams(new MetadataExtractor.NormalizationParams(tensorMetadata.stats().meanAsByteBuffer().asFloatBuffer(), tensorMetadata.stats().stdAsByteBuffer().asFloatBuffer()));
        }
        return builder.build();
    }

    static /* synthetic */ int[] access$102(TensorInfo x0, int[] x1) {
        x0.shape = x1;
        return x1;
    }

    public static class Builder {
        private String name;
        private int[] shape;
        private DataType dataType;
        private String fileName;
        private FileType fileType = FileType.UNKNOWN;
        private Source source;
        private ContentType contentType = ContentType.UNKNOWN;
        private String description;
        private MetadataExtractor.NormalizationParams normalizationParams;
        private MetadataExtractor.QuantizationParams quantizationParams;

        public Builder setName(String name2) {
            this.name = name2;
            return this;
        }

        public Builder setShape(int[] shape) {
            this.shape = shape;
            return this;
        }

        public Builder setDataType(DataType dataType) {
            this.dataType = dataType;
            return this;
        }

        public Builder setFileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        public Builder setFileType(FileType fileType) {
            this.fileType = fileType;
            return this;
        }

        public Builder setContentType(ContentType contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder setNormalizationParams(MetadataExtractor.NormalizationParams normalizationParams) {
            this.normalizationParams = normalizationParams;
            return this;
        }

        public Builder setQuantizationParams(MetadataExtractor.QuantizationParams quantizationParams) {
            this.quantizationParams = quantizationParams;
            return this;
        }

        public Builder setSource(Source source) {
            this.source = source;
            return this;
        }

        public TensorInfo build() {
            TensorInfo tensorInfo = new TensorInfo();
            tensorInfo.name = this.name;
            TensorInfo.access$102(tensorInfo, this.shape);
            tensorInfo.dataType = this.dataType;
            tensorInfo.fileName = this.fileName;
            tensorInfo.fileType = this.fileType;
            tensorInfo.source = this.source;
            tensorInfo.contentType = this.contentType;
            tensorInfo.description = this.description;
            tensorInfo.normalizationParams = this.normalizationParams;
            tensorInfo.quantizationParams = this.quantizationParams;
            return tensorInfo;
        }
    }

    public static enum ContentType {
        UNKNOWN(0),
        FEATURE(1),
        IMAGE(2);

        private int id;

        private ContentType(int id) {
            this.id = id;
        }

        public static ContentType fromByte(byte id) {
            for (ContentType type : ContentType.values()) {
                if (type.id != id) continue;
                return type;
            }
            return null;
        }
    }

    public static enum FileType {
        UNKNOWN(0),
        DESCRIPTIONS(1),
        TENSOR_AXIS_LABELS(2);

        private int id;

        private FileType(int id) {
            this.id = id;
        }

        public static FileType fromByte(byte id) {
            for (FileType type : FileType.values()) {
                if (type.id != id) continue;
                return type;
            }
            return null;
        }
    }

    public static enum Source {
        INPUT,
        OUTPUT;

    }

    public static enum DataType {
        FLOAT32(0),
        INT32(2),
        UINT8(3),
        INT64(4);

        private int id;

        private DataType(int id) {
            this.id = id;
        }

        public static DataType fromByte(byte id) {
            for (DataType type : DataType.values()) {
                if (type.id != id) continue;
                return type;
            }
            return null;
        }
    }
}

