/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dsl;

import com.android.build.api.dsl.ApplicationBuildFeatures;
import com.android.build.api.dsl.BuildFeatures;
import com.android.build.api.dsl.DataBinding;
import com.android.build.api.dsl.DynamicFeatureBuildFeatures;
import com.android.build.api.dsl.LibraryBuildFeatures;
import com.android.build.gradle.internal.errors.DeprecationReporter;
import com.android.build.gradle.internal.services.DslServices;
import com.android.build.gradle.options.BooleanOption;
import java.util.function.Supplier;
import javax.inject.Inject;

public class DataBindingOptions
implements com.android.builder.model.DataBindingOptions,
DataBinding {
    private final Supplier<BuildFeatures> featuresProvider;
    private final DslServices dslServices;
    private String version;
    private boolean addDefaultAdapters = true;
    private boolean enabledForTests = false;

    @Inject
    public DataBindingOptions(Supplier<BuildFeatures> featuresProvider, DslServices dslServices) {
        this.featuresProvider = featuresProvider;
        this.dslServices = dslServices;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @Deprecated
    public boolean isEnabled() {
        this.dslServices.getDeprecationReporter().reportDeprecatedUsage("android.buildFeatures.dataBinding", "android.dataBinding.enabled", DeprecationReporter.DeprecationTarget.VERSION_5_0);
        BuildFeatures buildFeatures = this.featuresProvider.get();
        Boolean bool = false;
        if (buildFeatures instanceof ApplicationBuildFeatures) {
            bool = ((ApplicationBuildFeatures)buildFeatures).getDataBinding();
        } else if (buildFeatures instanceof LibraryBuildFeatures) {
            bool = ((LibraryBuildFeatures)buildFeatures).getDataBinding();
        } else if (buildFeatures instanceof DynamicFeatureBuildFeatures) {
            bool = ((DynamicFeatureBuildFeatures)buildFeatures).getDataBinding();
        }
        if (bool != null) {
            return bool;
        }
        return this.dslServices.getProjectOptions().get(BooleanOption.BUILD_FEATURE_DATABINDING);
    }

    @Deprecated
    public void setEnabled(boolean enabled) {
        this.dslServices.getDeprecationReporter().reportDeprecatedUsage("android.buildFeatures.dataBinding", "android.dataBinding.enabled", DeprecationReporter.DeprecationTarget.VERSION_5_0);
        BuildFeatures buildFeatures = this.featuresProvider.get();
        if (buildFeatures instanceof ApplicationBuildFeatures) {
            ((ApplicationBuildFeatures)buildFeatures).setDataBinding(Boolean.valueOf(enabled));
        } else if (buildFeatures instanceof LibraryBuildFeatures) {
            ((LibraryBuildFeatures)buildFeatures).setDataBinding(Boolean.valueOf(enabled));
        } else if (buildFeatures instanceof DynamicFeatureBuildFeatures) {
            ((DynamicFeatureBuildFeatures)buildFeatures).setDataBinding(Boolean.valueOf(enabled));
        } else {
            this.dslServices.getLogger().warn("dataBinding.setEnabled has no impact on this sub-project type");
        }
    }

    public boolean getAddDefaultAdapters() {
        return this.addDefaultAdapters;
    }

    public void setAddDefaultAdapters(boolean addDefaultAdapters) {
        this.addDefaultAdapters = addDefaultAdapters;
    }

    public boolean isEnabledForTests() {
        return this.enabledForTests;
    }

    public void setEnabledForTests(boolean enabledForTests) {
        this.enabledForTests = enabledForTests;
    }
}

