/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.ide.dependencies;

import com.android.build.gradle.internal.dependency.ConfigurationDependencyGraphs;
import com.android.build.gradle.internal.ide.dependencies.BuildMappingUtils;
import com.android.build.gradle.internal.ide.dependencies.LibraryDependencyCacheBuildService;
import com.android.build.gradle.internal.ide.dependencies.ResolvedArtifact;
import com.android.build.gradle.internal.ide.level2.AndroidLibraryImpl;
import com.android.build.gradle.internal.ide.level2.EmptyDependencyGraphs;
import com.android.build.gradle.internal.ide.level2.FullDependencyGraphsImpl;
import com.android.build.gradle.internal.ide.level2.JavaLibraryImpl;
import com.android.build.gradle.internal.ide.level2.ModuleLibraryImpl;
import com.android.build.gradle.internal.ide.level2.SimpleDependencyGraphsImpl;
import com.android.build.gradle.internal.services.ServiceRegistrationAction;
import com.android.builder.model.level2.DependencyGraphs;
import com.android.builder.model.level2.GraphItem;
import com.android.builder.model.level2.Library;
import com.android.ide.common.caching.CreatingCache;
import com.android.utils.FileUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0004\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001$B\u0005\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00070\u00112\u0006\u0010\u001d\u001a\u00020\u0010H\u0002J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u001f\u001a\u00020\fH\u0002J\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\t0!J\u0010\u0010\"\u001a\u00020\t2\u0006\u0010#\u001a\u00020\fH\u0002RN\u0010\u0005\u001aB\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0012\f\u0012\n \b*\u0004\u0018\u00010\t0\t \b* \u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0012\f\u0012\n \b*\u0004\u0018\u00010\t0\t\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R-\u0010\n\u001a\u001e\u0012\f\u0012\n \b*\u0004\u0018\u00010\f0\f\u0012\f\u0012\n \b*\u0004\u0018\u00010\t0\t0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR#\u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u00110\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000e\u00a8\u0006%"}, d2={"Lcom/android/build/gradle/internal/ide/dependencies/LibraryDependencyCacheBuildService;", "Lorg/gradle/api/services/BuildService;", "Lorg/gradle/api/services/BuildServiceParameters$None;", "Ljava/lang/AutoCloseable;", "()V", "globalLibrary", "Ljava/util/HashMap;", "", "kotlin.jvm.PlatformType", "Lcom/android/builder/model/level2/Library;", "libraryCache", "Lcom/android/ide/common/caching/CreatingCache;", "Lcom/android/build/gradle/internal/ide/dependencies/ResolvedArtifact;", "getLibraryCache", "()Lcom/android/ide/common/caching/CreatingCache;", "localJarCache", "Ljava/io/File;", "", "getLocalJarCache", "clone", "Lcom/android/builder/model/level2/DependencyGraphs;", "dependencyGraphs", "modelLevel", "", "modelWithFullDependency", "", "close", "", "findLocalJarsAsStrings", "folder", "findResStaticLibrary", "explodedAar", "getGlobalLibMap", "", "instantiateLibrary", "artifact", "RegistrationAction", "gradle"})
public abstract class LibraryDependencyCacheBuildService
implements BuildService<BuildServiceParameters.None>,
AutoCloseable {
    @NotNull
    private final CreatingCache<ResolvedArtifact, Library> libraryCache = new CreatingCache((CreatingCache.ValueFactory)new CreatingCache.ValueFactory<ResolvedArtifact, Library>(this){
        final /* synthetic */ LibraryDependencyCacheBuildService this$0;

        @NotNull
        public final Library create(ResolvedArtifact it) {
            ResolvedArtifact resolvedArtifact = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)resolvedArtifact, (String)"it");
            return LibraryDependencyCacheBuildService.access$instantiateLibrary(this.this$0, resolvedArtifact);
        }
        {
            this.this$0 = libraryDependencyCacheBuildService;
        }
    });
    private final HashMap<String, Library> globalLibrary = Maps.newHashMap();
    @NotNull
    private final CreatingCache<File, List<File>> localJarCache = new CreatingCache((CreatingCache.ValueFactory)localJarCache.1.INSTANCE);

    @NotNull
    public final CreatingCache<ResolvedArtifact, Library> getLibraryCache() {
        return this.libraryCache;
    }

    @NotNull
    public final CreatingCache<File, List<File>> getLocalJarCache() {
        return this.localJarCache;
    }

    @NotNull
    public final Map<String, Library> getGlobalLibMap() {
        ImmutableMap immutableMap = ImmutableMap.copyOf((Map)this.globalLibrary);
        Intrinsics.checkExpressionValueIsNotNull((Object)immutableMap, (String)"ImmutableMap.copyOf(globalLibrary)");
        return (Map)immutableMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final DependencyGraphs clone(@NotNull DependencyGraphs dependencyGraphs, int modelLevel, boolean modelWithFullDependency) {
        Intrinsics.checkParameterIsNotNull((Object)dependencyGraphs, (String)"dependencyGraphs");
        if (modelLevel < 4) {
            DependencyGraphs dependencyGraphs2 = EmptyDependencyGraphs.EMPTY;
            Intrinsics.checkExpressionValueIsNotNull((Object)dependencyGraphs2, (String)"EmptyDependencyGraphs.EMPTY");
            return dependencyGraphs2;
        }
        Preconditions.checkState((boolean)(dependencyGraphs instanceof ConfigurationDependencyGraphs));
        ConfigurationDependencyGraphs cdg = (ConfigurationDependencyGraphs)dependencyGraphs;
        List<Library> list = cdg.getLibraries();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"cdg.libraries");
        List<Library> libs = list;
        HashMap<String, Library> hashMap = this.globalLibrary;
        Intrinsics.checkExpressionValueIsNotNull(hashMap, (String)"globalLibrary");
        HashMap<String, Library> hashMap2 = hashMap;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (hashMap2) {
            boolean bl3 = false;
            for (Library library : libs) {
                HashMap<String, Library> hashMap3 = this.globalLibrary;
                Intrinsics.checkExpressionValueIsNotNull(hashMap3, (String)"globalLibrary");
                Map map = hashMap3;
                Library library2 = library;
                Intrinsics.checkExpressionValueIsNotNull((Object)library2, (String)"library");
                map.put(library2.getArtifactAddress(), library);
            }
            Unit unit = Unit.INSTANCE;
        }
        List<GraphItem> list2 = cdg.getCompileDependencies();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"cdg.compileDependencies");
        List<GraphItem> nodes = list2;
        return modelWithFullDependency ? (DependencyGraphs)new FullDependencyGraphsImpl(nodes, nodes, (List)ImmutableList.of(), (List)ImmutableList.of()) : (DependencyGraphs)new SimpleDependencyGraphsImpl(nodes, cdg.getProvidedLibraries());
    }

    @Override
    public void close() {
        this.libraryCache.clear();
        this.globalLibrary.clear();
        this.localJarCache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Library instantiateLibrary(ResolvedArtifact artifact) {
        Library library = null;
        ComponentIdentifier id = artifact.getComponentIdentifier();
        String address = artifact.computeModelAddress();
        if (!(id instanceof ProjectComponentIdentifier) || artifact.isWrappedModule()) {
            if (artifact.getDependencyType() == ResolvedArtifact.DependencyType.ANDROID) {
                File extractedFolder = (File)Preconditions.checkNotNull((Object)artifact.getExtractedFolder());
                File file = artifact.getArtifactFile();
                File file2 = this.findResStaticLibrary(artifact);
                File file3 = extractedFolder;
                Intrinsics.checkExpressionValueIsNotNull((Object)file3, (String)"extractedFolder");
                library = new AndroidLibraryImpl(address, file, extractedFolder, file2, this.findLocalJarsAsStrings(file3));
            } else {
                library = new JavaLibraryImpl(address, artifact.getArtifactFile());
            }
        } else {
            String buildId;
            String string = buildId = BuildMappingUtils.getBuildId((ProjectComponentIdentifier)id, artifact.getBuildMapping());
            if (string == null) {
                Intrinsics.throwNpe();
            }
            library = new ModuleLibraryImpl(address, string, ((ProjectComponentIdentifier)id).getProjectPath(), artifact.getVariantName());
        }
        HashMap<String, Library> hashMap = this.globalLibrary;
        Intrinsics.checkExpressionValueIsNotNull(hashMap, (String)"globalLibrary");
        HashMap<String, Library> hashMap2 = hashMap;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (hashMap2) {
            boolean bl3 = false;
            HashMap<String, Library> hashMap3 = this.globalLibrary;
            Intrinsics.checkExpressionValueIsNotNull(hashMap3, (String)"globalLibrary");
            ((Map)hashMap3).put(library.getArtifactAddress(), library);
            Unit unit = Unit.INSTANCE;
        }
        return library;
    }

    private final List<String> findLocalJarsAsStrings(File folder) {
        File localJarRoot;
        File file = localJarRoot = FileUtils.join((File)folder, (String[])new String[]{"jars", "libs"});
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"localJarRoot");
        if (!file.isDirectory()) {
            ImmutableList immutableList = ImmutableList.of();
            Intrinsics.checkExpressionValueIsNotNull((Object)immutableList, (String)"ImmutableList.of()");
            return (List)immutableList;
        }
        String[] jarFiles2 = localJarRoot.list(findLocalJarsAsStrings.jarFiles.1.INSTANCE);
        if (jarFiles2 != null) {
            String[] stringArray = jarFiles2;
            boolean bl = false;
            String[] stringArray2 = stringArray;
            boolean bl2 = false;
            if (!(stringArray2.length == 0)) {
                ImmutableList.Builder list = ImmutableList.builder();
                for (String jarFile : jarFiles2) {
                    list.add((Object)("jars" + File.separatorChar + "libs" + File.separatorChar + jarFile));
                }
                ImmutableList immutableList = list.build();
                Intrinsics.checkExpressionValueIsNotNull((Object)immutableList, (String)"list.build()");
                return (List)immutableList;
            }
        }
        ImmutableList immutableList = ImmutableList.of();
        Intrinsics.checkExpressionValueIsNotNull((Object)immutableList, (String)"ImmutableList.of()");
        return (List)immutableList;
    }

    private final File findResStaticLibrary(ResolvedArtifact explodedAar) {
        if (explodedAar.getExtractedFolder() == null) {
            return null;
        }
        File file = new File(explodedAar.getExtractedFolder(), "res.apk");
        return !file.exists() ? null : file;
    }

    public static final /* synthetic */ Library access$instantiateLibrary(LibraryDependencyCacheBuildService $this, ResolvedArtifact artifact) {
        return $this.instantiateLibrary(artifact);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003H\u0016\u00a8\u0006\n"}, d2={"Lcom/android/build/gradle/internal/ide/dependencies/LibraryDependencyCacheBuildService$RegistrationAction;", "Lcom/android/build/gradle/internal/services/ServiceRegistrationAction;", "Lcom/android/build/gradle/internal/ide/dependencies/LibraryDependencyCacheBuildService;", "Lorg/gradle/api/services/BuildServiceParameters$None;", "project", "Lorg/gradle/api/Project;", "(Lorg/gradle/api/Project;)V", "configure", "", "parameters", "gradle"})
    public static final class RegistrationAction
    extends ServiceRegistrationAction<LibraryDependencyCacheBuildService, BuildServiceParameters.None> {
        @Override
        public void configure(@NotNull BuildServiceParameters.None parameters) {
            Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
        }

        public RegistrationAction(@NotNull Project project2) {
            Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
            super(project2, LibraryDependencyCacheBuildService.class);
        }
    }
}

