/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.api.variant.impl.LibraryVariantPropertiesImpl;
import com.android.build.gradle.internal.component.BaseCreationConfig;
import com.android.build.gradle.internal.core.Abi;
import com.android.build.gradle.internal.cxx.configure.NdkMetaPlatforms;
import com.android.build.gradle.internal.cxx.json.AndroidBuildGradleJsons;
import com.android.build.gradle.internal.cxx.json.NativeBuildConfigValueMini;
import com.android.build.gradle.internal.cxx.json.NativeLibraryValueMini;
import com.android.build.gradle.internal.cxx.logging.LoggingEnvironmentKt;
import com.android.build.gradle.internal.cxx.model.CxxAbiModel;
import com.android.build.gradle.internal.cxx.model.CxxAbiModelKt;
import com.android.build.gradle.internal.cxx.model.CxxVariantModel;
import com.android.build.gradle.internal.cxx.model.CxxVariantModelKt;
import com.android.build.gradle.internal.cxx.model.DetermineUsedStlResult;
import com.android.build.gradle.internal.ndk.Stl;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.tasks.AndroidAbiMetadata;
import com.android.build.gradle.internal.tasks.JsonSerializer;
import com.android.build.gradle.internal.tasks.ModuleMetadataV1;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.PackageMetadataV1;
import com.android.build.gradle.internal.tasks.PrefabAbiData;
import com.android.build.gradle.internal.tasks.PrefabModuleTaskData;
import com.android.build.gradle.internal.tasks.PrefabPackageTask$CreationAction$handleProvider$1;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.sdklib.AndroidVersion;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001:\u0001'B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0005H\u0002J\u0018\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u0019H\u0002J\u0018\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\u0019H\u0002J\u0010\u0010 \u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\u0019H\u0002J\b\u0010!\u001a\u00020\u0017H\u0014J\u0018\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u0005H\u0002J\u0018\u0010%\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\u0019H\u0002J\u0018\u0010&\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\u0019H\u0002R,\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048G@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR,\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u00042\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\t0\u00048G@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\bR\u0014\u0010\f\u001a\u00020\r8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR \u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0003\u001a\u00020\u00108G@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R \u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0003\u001a\u00020\u00108G@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013\u00a8\u0006("}, d2={"Lcom/android/build/gradle/internal/tasks/PrefabPackageTask;", "Lcom/android/build/gradle/internal/tasks/NonIncrementalTask;", "()V", "<set-?>", "", "Lcom/android/build/gradle/internal/tasks/PrefabAbiData;", "abiData", "getAbiData", "()Ljava/util/List;", "Lcom/android/build/gradle/internal/tasks/PrefabModuleTaskData;", "modules", "getModules", "outputDirectory", "Lorg/gradle/api/file/DirectoryProperty;", "getOutputDirectory", "()Lorg/gradle/api/file/DirectoryProperty;", "", "packageName", "getPackageName", "()Ljava/lang/String;", "packageVersion", "getPackageVersion", "createLibraryMetadata", "", "libDir", "Ljava/io/File;", "abi", "createModule", "module", "packageDir", "createModuleMetadata", "installDir", "createPackageMetadata", "doTaskAction", "findLibraryForAbi", "Lcom/android/build/gradle/internal/cxx/json/NativeLibraryValueMini;", "moduleName", "installHeaders", "installLibs", "CreationAction", "gradle"})
public abstract class PrefabPackageTask
extends NonIncrementalTask {
    @NotNull
    private String packageName;
    @NotNull
    private String packageVersion;
    @NotNull
    private List<PrefabAbiData> abiData;
    @NotNull
    private List<PrefabModuleTaskData> modules;

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getOutputDirectory();

    @Input
    @NotNull
    public final String getPackageName() {
        String string = this.packageName;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"packageName");
        }
        return string;
    }

    @Input
    @NotNull
    public final String getPackageVersion() {
        String string = this.packageVersion;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"packageVersion");
        }
        return string;
    }

    @Nested
    @NotNull
    public final List<PrefabAbiData> getAbiData() {
        List<PrefabAbiData> list = this.abiData;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"abiData");
        }
        return list;
    }

    @Nested
    @NotNull
    public final List<PrefabModuleTaskData> getModules() {
        List<PrefabModuleTaskData> list = this.modules;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"modules");
        }
        return list;
    }

    @Override
    protected void doTaskAction() {
        File installDir;
        Object object = this.getOutputDirectory().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"outputDirectory.get()");
        File file = ((Directory)object).getAsFile();
        boolean bl = false;
        boolean bl2 = false;
        File $this$apply = file;
        boolean bl3 = false;
        $this$apply.mkdirs();
        File file2 = installDir = file;
        Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"installDir");
        this.createPackageMetadata(file2);
        List<PrefabModuleTaskData> list = this.modules;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"modules");
        }
        for (PrefabModuleTaskData module2 : list) {
            this.createModule(module2, installDir);
        }
    }

    private final void createPackageMetadata(File installDir) {
        String string;
        File file = FilesKt.resolve((File)installDir, (String)"prefab.json");
        JsonSerializer jsonSerializer = new JsonSerializer();
        String string2 = this.packageName;
        if (string2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"packageName");
        }
        String string3 = this.packageVersion;
        if (string3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"packageVersion");
        }
        Object object = string3;
        int n = 1;
        String string4 = string2;
        JsonSerializer jsonSerializer2 = jsonSerializer;
        File file2 = file;
        boolean bl = false;
        boolean bl2 = false;
        String it = object;
        boolean bl3 = false;
        String string5 = Intrinsics.areEqual((Object)it, (Object)"unspecified") ^ true ? object : null;
        object = CollectionsKt.emptyList();
        String string6 = string = string5;
        Object object2 = object;
        int n2 = n;
        String string7 = string4;
        FilesKt.writeText$default((File)file2, (String)jsonSerializer2.toJson(new PackageMetadataV1(string7, n2, (List<String>)object2, string6)), null, (int)2, null);
    }

    private final void createModule(PrefabModuleTaskData module2, File packageDir) {
        File file = FilesKt.resolve((File)packageDir, (String)("modules/" + module2.getName()));
        boolean bl = false;
        boolean bl2 = false;
        File $this$apply = file;
        boolean bl3 = false;
        $this$apply.mkdirs();
        File installDir = file;
        this.createModuleMetadata(module2, installDir);
        this.installHeaders(module2, installDir);
        this.installLibs(module2, installDir);
    }

    private final void createModuleMetadata(PrefabModuleTaskData module2, File installDir) {
        FilesKt.writeText$default((File)FilesKt.resolve((File)installDir, (String)"module.json"), (String)new JsonSerializer().toJson(new ModuleMetadataV1(CollectionsKt.emptyList(), module2.getLibraryName(), null, 4, null)), null, (int)2, null);
    }

    private final void installHeaders(PrefabModuleTaskData module2, File installDir) {
        block0: {
            File file = FilesKt.resolve((File)installDir, (String)"include");
            boolean bl = false;
            boolean bl2 = false;
            File $this$apply = file;
            boolean bl3 = false;
            FilesKt.deleteRecursively((File)$this$apply);
            File includeDir = file;
            File file2 = module2.getHeaders();
            if (file2 == null) break block0;
            file = file2;
            bl = false;
            bl2 = false;
            File it = file;
            boolean bl4 = false;
            FilesKt.copyRecursively$default((File)it, (File)includeDir, (boolean)false, null, (int)6, null);
            LoggingEnvironmentKt.infoln("Installing " + it + " to " + includeDir, new Object[0]);
        }
    }

    private final NativeLibraryValueMini findLibraryForAbi(String moduleName, PrefabAbiData abi) {
        NativeBuildConfigValueMini nativeBuildConfigValueMini = AndroidBuildGradleJsons.getNativeBuildMiniConfig((File)abi.getNativeBuildJson().get(), null);
        Intrinsics.checkExpressionValueIsNotNull((Object)nativeBuildConfigValueMini, (String)"AndroidBuildGradleJsons.\u2026iveBuildJson.get(), null)");
        NativeBuildConfigValueMini config2 = nativeBuildConfigValueMini;
        Map<String, NativeLibraryValueMini> map = config2.libraries;
        Intrinsics.checkExpressionValueIsNotNull(map, (String)"config.libraries");
        Map<String, NativeLibraryValueMini> $this$filterKeys$iv = map;
        boolean $i$f$filterKeys = false;
        LinkedHashMap<String, NativeLibraryValueMini> result$iv = new LinkedHashMap<String, NativeLibraryValueMini>();
        Map<String, NativeLibraryValueMini> map2 = $this$filterKeys$iv;
        boolean bl = false;
        for (Map.Entry<String, NativeLibraryValueMini> entry$iv : map2.entrySet()) {
            String it = entry$iv.getKey();
            boolean bl2 = false;
            String string = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it");
            if (!StringsKt.startsWith$default((String)string, (String)(moduleName + '-'), (boolean)false, (int)2, null)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        Collection matchingLibs = ((Map)result$iv).values();
        if (matchingLibs.isEmpty()) {
            LoggingEnvironmentKt.errorln("No libraries found for " + moduleName, new Object[0]);
        }
        Object object = CollectionsKt.single((Iterable)matchingLibs);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"matchingLibs.single()");
        return (NativeLibraryValueMini)object;
    }

    private final void installLibs(PrefabModuleTaskData module2, File installDir) {
        File file = FilesKt.resolve((File)installDir, (String)"libs");
        boolean bl = false;
        boolean bl2 = false;
        File $this$apply = file;
        boolean bl3 = false;
        FilesKt.deleteRecursively((File)$this$apply);
        File libsDir = file;
        List<PrefabAbiData> list = this.abiData;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"abiData");
        }
        for (PrefabAbiData abiData : list) {
            File srcLibrary = this.findLibraryForAbi((String)module2.getName(), (PrefabAbiData)abiData).output;
            if (srcLibrary != null) {
                File libDir = FilesKt.resolve((File)libsDir, (String)("android." + abiData.getAbi().getTag()));
                String string = srcLibrary.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"srcLibrary.name");
                File dest = FilesKt.resolve((File)libDir, (String)string);
                LoggingEnvironmentKt.infoln("Installing " + srcLibrary + " to " + dest, new Object[0]);
                FilesKt.copyTo$default((File)srcLibrary, (File)dest, (boolean)false, (int)0, (int)6, null);
                this.createLibraryMetadata(libDir, abiData);
                continue;
            }
            LoggingEnvironmentKt.warnln(module2.getName() + "} has no library output", new Object[0]);
        }
    }

    private final void createLibraryMetadata(File libDir, PrefabAbiData abi) {
        File file = FilesKt.resolve((File)libDir, (String)"abi.json");
        JsonSerializer jsonSerializer = new JsonSerializer();
        String string = abi.getAbi().getTag();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"abi.abi.tag");
        FilesKt.writeText$default((File)file, (String)jsonSerializer.toJson(new AndroidAbiMetadata(string, abi.getMinSdkVersion(), abi.getNdkMajorVersion(), abi.getStl())), null, (int)2, null);
    }

    public static final /* synthetic */ String access$getPackageName$p(PrefabPackageTask $this) {
        String string = $this.packageName;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"packageName");
        }
        return string;
    }

    public static final /* synthetic */ String access$getPackageVersion$p(PrefabPackageTask $this) {
        String string = $this.packageVersion;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"packageVersion");
        }
        return string;
    }

    public static final /* synthetic */ List access$getModules$p(PrefabPackageTask $this) {
        List<PrefabModuleTaskData> list = $this.modules;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"modules");
        }
        return list;
    }

    public static final /* synthetic */ List access$getAbiData$p(PrefabPackageTask $this) {
        List<PrefabAbiData> list = $this.abiData;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"abiData");
        }
        return list;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B1\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0006\u0010\f\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0002H\u0016J\u0016\u0010\u0019\u001a\u00020\u00172\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00020\u001bH\u0016R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/android/build/gradle/internal/tasks/PrefabPackageTask$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/PrefabPackageTask;", "Lcom/android/build/api/variant/impl/LibraryVariantPropertiesImpl;", "modules", "", "Lcom/android/build/gradle/internal/tasks/PrefabModuleTaskData;", "variantModel", "Lcom/android/build/gradle/internal/cxx/model/CxxVariantModel;", "abiModels", "", "Lcom/android/build/gradle/internal/cxx/model/CxxAbiModel;", "componentProperties", "(Ljava/util/List;Lcom/android/build/gradle/internal/cxx/model/CxxVariantModel;Ljava/util/Collection;Lcom/android/build/api/variant/impl/LibraryVariantPropertiesImpl;)V", "name", "", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "handleProvider", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "gradle"})
    public static final class CreationAction
    extends VariantTaskCreationAction<PrefabPackageTask, LibraryVariantPropertiesImpl> {
        private final List<PrefabModuleTaskData> modules;
        private final CxxVariantModel variantModel;
        private final Collection<CxxAbiModel> abiModels;

        @Override
        @NotNull
        public String getName() {
            return this.computeTaskName("prefab", "Package");
        }

        @Override
        @NotNull
        public Class<PrefabPackageTask> getType() {
            return PrefabPackageTask.class;
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<PrefabPackageTask> taskProvider) {
            Intrinsics.checkParameterIsNotNull(taskProvider, (String)"taskProvider");
            super.handleProvider(taskProvider);
            ((LibraryVariantPropertiesImpl)this.creationConfig).getArtifacts().setInitialProvider(taskProvider, (Function1)PrefabPackageTask$CreationAction$handleProvider$1.INSTANCE).withName("prefab").on(InternalArtifactType.PREFAB_PACKAGE.INSTANCE);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void configure(@NotNull PrefabPackageTask task) {
            Collection<PrefabAbiData> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
            super.configure((Task)task);
            task.setDescription("Creates a Prefab package for inclusion in an AAR");
            Project project2 = ((LibraryVariantPropertiesImpl)this.creationConfig).getGlobalScope().getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"creationConfig.globalScope.project");
            Project project3 = project2;
            String string = project3.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"project.name");
            task.packageName = string;
            task.packageVersion = project3.getVersion().toString();
            task.modules = this.modules;
            Object result = CxxVariantModelKt.determineUsedStl(this.variantModel);
            if (!(result instanceof DetermineUsedStlResult.Success)) {
                if (result instanceof DetermineUsedStlResult.Failure) {
                    LoggingEnvironmentKt.errorln(((DetermineUsedStlResult.Failure)result).getError(), new Object[0]);
                    return;
                }
                throw new NoWhenBranchMatchedException();
            }
            Stl stl = ((DetermineUsedStlResult.Success)result).getStl();
            result = this.abiModels;
            PrefabPackageTask prefabPackageTask = task;
            boolean $i$f$map = false;
            void var6_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Provider provider2;
                int n;
                int n2;
                void it;
                CxxAbiModel cxxAbiModel = (CxxAbiModel)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                int ndkVersion2 = it.getVariant().getModule().getNdkVersion().getMajor();
                NdkMetaPlatforms metaPlatforms = it.getVariant().getModule().getNdkMetaPlatforms();
                if (it.getAbi().supports64Bits()) {
                    AndroidVersion androidVersion = AndroidVersion.SUPPORTS_64_BIT;
                    Intrinsics.checkExpressionValueIsNotNull((Object)androidVersion, (String)"AndroidVersion.SUPPORTS_64_BIT");
                    n2 = androidVersion.getApiLevel();
                } else {
                    n2 = 1;
                }
                int minVersionForAbi = n2;
                int minVersionForNdk = metaPlatforms != null ? metaPlatforms.getMin() : (ndkVersion2 < 12 ? 1 : (ndkVersion2 < 15 ? 9 : (ndkVersion2 < 18 ? 14 : 16)));
                int n3 = it.getAbiPlatformVersion();
                Abi abi = it.getAbi();
                int n4 = 0;
                n4 = n = Math.max(minVersionForAbi, minVersionForNdk);
                boolean bl2 = false;
                n = Math.max(n3, n4);
                String string2 = stl.getArgumentName();
                Intrinsics.checkExpressionValueIsNotNull((Object)project3.provider((Callable)new Callable<File>((CxxAbiModel)it){
                    final /* synthetic */ CxxAbiModel $it;

                    @NotNull
                    public final File call() {
                        return CxxAbiModelKt.getJsonFile(this.$it);
                    }
                    {
                        this.$it = cxxAbiModel;
                    }
                }), (String)"project.provider { it.jsonFile }");
                String string3 = string2;
                int n5 = ndkVersion2;
                int n6 = n;
                Abi abi2 = abi;
                PrefabAbiData prefabAbiData = new PrefabAbiData(abi2, n6, n5, string3, (Provider<File>)provider2);
                collection.add(prefabAbiData);
            }
            collection = (List)destination$iv$iv;
            prefabPackageTask.abiData = (List)collection;
        }

        public CreationAction(@NotNull List<PrefabModuleTaskData> modules, @NotNull CxxVariantModel variantModel, @NotNull Collection<? extends CxxAbiModel> abiModels, @NotNull LibraryVariantPropertiesImpl componentProperties) {
            Intrinsics.checkParameterIsNotNull(modules, (String)"modules");
            Intrinsics.checkParameterIsNotNull((Object)variantModel, (String)"variantModel");
            Intrinsics.checkParameterIsNotNull(abiModels, (String)"abiModels");
            Intrinsics.checkParameterIsNotNull((Object)componentProperties, (String)"componentProperties");
            super((BaseCreationConfig)componentProperties);
            this.modules = modules;
            this.variantModel = variantModel;
            this.abiModels = abiModels;
        }
    }
}

