/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.res.shrinker;

import com.android.build.gradle.internal.res.shrinker.ApkFormat;
import com.android.build.gradle.internal.res.shrinker.DummyContent;
import com.android.build.gradle.internal.res.shrinker.ResourceShrinker;
import com.android.build.gradle.internal.res.shrinker.ResourceShrinkerModel;
import com.android.build.gradle.internal.res.shrinker.ShrinkerDebugReporter;
import com.android.build.gradle.internal.res.shrinker.gatherer.ResourcesGatherer;
import com.android.build.gradle.internal.res.shrinker.graph.ResourcesGraphBuilder;
import com.android.build.gradle.internal.res.shrinker.obfuscation.ObfuscationMappingsRecorder;
import com.android.build.gradle.internal.res.shrinker.usages.ResourceUsageRecorder;
import com.android.ide.common.resources.usage.ResourceUsageModel;
import com.android.resources.FolderTypeRelationship;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.jvm.functions.Function0;

public class ResourceShrinkerImpl
implements ResourceShrinker {
    private final ResourcesGatherer resourcesGatherer;
    private final ObfuscationMappingsRecorder obfuscationMappingsRecorder;
    private final List<ResourceUsageRecorder> usageRecorders;
    private final ResourcesGraphBuilder graphBuilder;
    private final ShrinkerDebugReporter debugReporter;
    private final ApkFormat apkFormat;
    @VisibleForTesting
    final ResourceShrinkerModel model;
    List<ResourceUsageModel.Resource> unused = null;

    public ResourceShrinkerImpl(ResourcesGatherer resourcesGatherer, ObfuscationMappingsRecorder obfuscationMappingsRecorder, List<ResourceUsageRecorder> usageRecorders, ResourcesGraphBuilder graphBuilder, ShrinkerDebugReporter debugReporter, ApkFormat apkFormat) {
        this.resourcesGatherer = resourcesGatherer;
        this.obfuscationMappingsRecorder = obfuscationMappingsRecorder;
        this.usageRecorders = usageRecorders;
        this.graphBuilder = graphBuilder;
        this.debugReporter = debugReporter;
        this.apkFormat = apkFormat;
        this.model = new ResourceShrinkerModel(debugReporter);
    }

    @Override
    public void analyze() throws IOException {
        this.resourcesGatherer.gatherResourceValues(this.model);
        if (this.obfuscationMappingsRecorder != null) {
            this.obfuscationMappingsRecorder.recordObfuscationMappings(this.model);
        }
        for (ResourceUsageRecorder usageRecorder : this.usageRecorders) {
            usageRecorder.recordUsages(this.model);
        }
        this.graphBuilder.buildGraph(this.model);
        this.model.getUsageModel().processToolsAttributes();
        this.model.keepPossiblyReferencedResources();
        this.debugReporter.debug((Function0<String>)((Function0)() -> this.model.getUsageModel().dumpResourceModel()));
        this.unused = this.model.findUnused();
    }

    @Override
    public void close() throws Exception {
        this.debugReporter.close();
    }

    @Override
    public int getUnusedResourceCount() {
        return this.unused.size();
    }

    @Override
    public void rewriteResourceZip(File source, File dest) throws IOException {
        boolean deleted;
        if (dest.exists() && !(deleted = dest.delete())) {
            throw new IOException("Could not delete " + dest);
        }
        try (ZipFile zipFile = new ZipFile(source);
             JarOutputStream zos = new JarOutputStream(new BufferedOutputStream(new FileOutputStream(dest)));){
            zos.setLevel(9);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry current = entries.nextElement();
                if (this.shouldBeReplacedWithDummy(current)) {
                    this.replaceWithDummyEntry(zos, current);
                    continue;
                }
                ResourceShrinkerImpl.copyToOutput(zipFile.getInputStream(current), zos, current);
            }
        }
        long before = source.length();
        long after = dest.length();
        if (after > before) {
            this.debugReporter.info((Function0<String>)((Function0)() -> "Resource shrinking did not work (grew from " + before + " to " + after + "); using original instead"));
            Files.copy((File)source, (File)dest);
        }
    }

    private boolean shouldBeReplacedWithDummy(ZipEntry entry) {
        if (entry.isDirectory() || !entry.getName().startsWith("res/")) {
            return false;
        }
        ResourceUsageModel.Resource resource = this.getResourceByJarPath(entry.getName());
        Preconditions.checkNotNull((Object)resource, (Object)("Resource for entry '" + entry.getName() + "' was not gathered."));
        return !resource.isReachable();
    }

    private void replaceWithDummyEntry(JarOutputStream zos, ZipEntry entry) throws IOException {
        long crc;
        byte[] bytes2;
        String name2;
        block7: {
            block9: {
                block8: {
                    block6: {
                        name2 = entry.getName();
                        if (!name2.endsWith(".9.png")) break block6;
                        bytes2 = DummyContent.TINY_9PNG;
                        crc = 289995143L;
                        break block7;
                    }
                    if (!name2.endsWith(".png")) break block8;
                    bytes2 = DummyContent.TINY_PNG;
                    crc = 2293408688L;
                    break block7;
                }
                if (!name2.endsWith(".xml")) break block9;
                switch (this.apkFormat) {
                    case BINARY: {
                        bytes2 = DummyContent.TINY_BINARY_XML;
                        crc = 3622196803L;
                        break block7;
                    }
                    case PROTO: {
                        bytes2 = DummyContent.TINY_PROTO_XML;
                        crc = 3204905971L;
                        break block7;
                    }
                    default: {
                        throw new IllegalStateException("");
                    }
                }
            }
            bytes2 = new byte[]{};
            crc = 0L;
        }
        JarEntry outEntry = new JarEntry(name2);
        if (entry.getTime() != -1L) {
            outEntry.setTime(entry.getTime());
        }
        if (entry.getMethod() == 0) {
            outEntry.setMethod(0);
            outEntry.setSize(bytes2.length);
            outEntry.setCrc(crc);
        }
        zos.putNextEntry(outEntry);
        zos.write(bytes2);
        zos.closeEntry();
        this.debugReporter.info((Function0<String>)((Function0)() -> "Skipped unused resource " + name2 + ": " + entry.getSize() + " bytes (replaced with small dummy file of size " + bytes2.length + " bytes)"));
    }

    private static void copyToOutput(InputStream zis, JarOutputStream zos, ZipEntry entry) throws IOException {
        byte[] bytes2;
        JarEntry outEntry;
        if (entry.getMethod() == 0) {
            outEntry = new JarEntry(entry);
        } else {
            outEntry = new JarEntry(entry.getName());
            if (entry.getTime() != -1L) {
                outEntry.setTime(entry.getTime());
            }
        }
        zos.putNextEntry(outEntry);
        if (!entry.isDirectory() && (bytes2 = ByteStreams.toByteArray((InputStream)zis)) != null) {
            zos.write(bytes2);
        }
        zos.closeEntry();
    }

    private ResourceUsageModel.Resource getResourceByJarPath(String path) {
        if (!path.startsWith("res/")) {
            return null;
        }
        int folderStart = 4;
        int folderEnd = path.indexOf(47, folderStart);
        if (folderEnd == -1) {
            return null;
        }
        String folderName = path.substring(folderStart, folderEnd);
        ResourceFolderType folderType = ResourceFolderType.getFolderType((String)folderName);
        if (folderType == null) {
            return null;
        }
        int nameStart = folderEnd + 1;
        int nameEnd = path.indexOf(46, nameStart);
        if (nameEnd == -1) {
            nameEnd = path.length();
        }
        String name2 = path.substring(nameStart, nameEnd);
        for (ResourceType type : FolderTypeRelationship.getRelatedResourceTypes((ResourceFolderType)folderType)) {
            ResourceUsageModel.Resource resource;
            if (type == ResourceType.ID || (resource = this.model.getUsageModel().getResource(type, name2)) == null) continue;
            return resource;
        }
        return null;
    }
}

