/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.api.component.impl.ComponentPropertiesImpl;
import com.android.build.api.variant.impl.VariantPropertiesImpl;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.tasks.LintBaseTask;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;

public abstract class LintGlobalTask
extends LintBaseTask {
    private Map<String, LintBaseTask.VariantInputs> variantInputMap;
    private ConfigurableFileCollection allInputs;

    @InputFiles
    @PathSensitive(value=PathSensitivity.ABSOLUTE)
    @Optional
    public FileCollection getAllInputs() {
        return this.allInputs;
    }

    @TaskAction
    public void lint() {
        this.runLint(new LintGlobalTaskDescriptor());
    }

    public static class GlobalCreationAction
    extends LintBaseTask.BaseCreationAction<LintGlobalTask> {
        private final Collection<? extends VariantPropertiesImpl> variants;

        public GlobalCreationAction(GlobalScope globalScope, Collection<? extends VariantPropertiesImpl> variants) {
            super(globalScope);
            this.variants = variants;
        }

        @Override
        public String getName() {
            return "lint";
        }

        @Override
        public Class<LintGlobalTask> getType() {
            return LintGlobalTask.class;
        }

        @Override
        public void configure(LintGlobalTask lintTask) {
            super.configure(lintTask);
            lintTask.setDescription("Runs lint on all variants.");
            lintTask.allInputs = this.getGlobalScope().getProject().files(new Object[0]);
            lintTask.variantInputMap = this.variants.stream().map(variantProperties -> {
                LintBaseTask.VariantInputs inputs = new LintBaseTask.VariantInputs((ComponentPropertiesImpl)variantProperties);
                lintTask.allInputs.from(new Object[]{inputs.getAllInputs()});
                return inputs;
            }).collect(Collectors.toMap(LintBaseTask.VariantInputs::getName, Function.identity()));
        }
    }

    private class LintGlobalTaskDescriptor
    extends LintBaseTask.LintBaseTaskDescriptor {
        public String getVariantName() {
            return null;
        }

        public LintBaseTask.VariantInputs getVariantInputs(String variantName) {
            return (LintBaseTask.VariantInputs)LintGlobalTask.this.variantInputMap.get(variantName);
        }

        public Set<String> getVariantNames() {
            return LintGlobalTask.this.variantInputMap.keySet();
        }
    }
}

