/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.res.shrinker.graph;

import com.android.build.gradle.internal.res.shrinker.ResourceShrinkerModel;
import com.android.build.gradle.internal.res.shrinker.graph.ResourcesGraphBuilder;
import com.android.resources.ResourceFolderType;
import com.android.utils.ImmutableCollectors;
import com.android.utils.SdkUtils;
import com.android.utils.XmlUtils;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class RawResourcesGraphBuilder
implements ResourcesGraphBuilder {
    private final Path resourceDir;

    public RawResourcesGraphBuilder(Path resourceDir) {
        this.resourceDir = resourceDir;
    }

    @Override
    public void buildGraph(ResourceShrinkerModel model2) throws IOException {
        ImmutableList subDirs = (ImmutableList)Files.list(this.resourceDir).filter(path -> Files.isDirectory(path, new LinkOption[0])).collect(ImmutableCollectors.toImmutableList());
        for (Path subDir : subDirs) {
            ResourceFolderType folderType = ResourceFolderType.getFolderType((String)subDir.getFileName().toString());
            if (folderType == null) continue;
            this.recordResources(model2, folderType, subDir);
        }
    }

    private void recordResources(ResourceShrinkerModel model2, ResourceFolderType folderType, Path folder) throws IOException {
        ImmutableList resourceFiles = (ImmutableList)Files.list(folder).filter(path -> Files.isRegularFile(path, new LinkOption[0])).collect(ImmutableCollectors.toImmutableList());
        for (Path resourceFile : resourceFiles) {
            File file = resourceFile.toFile();
            String path2 = resourceFile.toString();
            model2.getUsageModel().file = file;
            try {
                boolean isXml = SdkUtils.endsWithIgnoreCase((String)path2, (String)".xml");
                if (isXml) {
                    String xml = new String(Files.readAllBytes(resourceFile), StandardCharsets.UTF_8);
                    Document document = XmlUtils.parseDocument((String)xml, (boolean)true);
                    model2.getUsageModel().visitXmlDocument(file, folderType, document);
                    continue;
                }
                model2.getUsageModel().visitBinaryResource(folderType, file);
            }
            catch (SAXException e) {
                throw new IOException(e);
            }
            finally {
                model2.getUsageModel().file = null;
            }
        }
    }
}

