/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.builder.utils.ZipEntryUtils;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000\u0018\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\u001a$\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00030\u0005H\u0000\u00a8\u0006\u0007"}, d2={"extractSingleFile", "", "inputJar", "Ljava/io/File;", "outputLocation", "Lkotlin/Function1;", "", "gradle-core"})
public final class ExtractProfilerNativeDependenciesTaskKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void extractSingleFile(@NotNull File inputJar, @NotNull Function1<? super String, ? extends File> outputLocation) {
        Intrinsics.checkParameterIsNotNull((Object)inputJar, (String)"inputJar");
        Intrinsics.checkParameterIsNotNull(outputLocation, (String)"outputLocation");
        Closeable closeable = new ZipInputStream(new FileInputStream(inputJar));
        boolean bl = false;
        Throwable throwable = null;
        try {
            ZipInputStream zis = (ZipInputStream)closeable;
            boolean bl2 = false;
            Pattern pattern = Pattern.compile("dependencies/(.*)\\.jar");
            ZipEntry entry = zis.getNextEntry();
            while (entry != null && ZipEntryUtils.isValidZipEntryName((ZipEntry)entry)) {
                Matcher matcher = pattern.matcher(entry.getName());
                if (matcher.matches()) {
                    String name2;
                    String string = name2 = matcher.group(1);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name");
                    File outputJar = (File)outputLocation.invoke((Object)string);
                    Files.createParentDirs((File)outputJar);
                    Closeable closeable2 = new FileOutputStream(outputJar);
                    boolean bl3 = false;
                    Throwable throwable2 = null;
                    try {
                        FileOutputStream fos = (FileOutputStream)closeable2;
                        boolean bl4 = false;
                        long l = ByteStreams.copy((InputStream)zis, (OutputStream)fos);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                    }
                }
                zis.closeEntry();
                entry = zis.getNextEntry();
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }
}

