/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks.mlkit.codegen.codeinjector.fields;

import com.android.build.gradle.internal.tasks.mlkit.codegen.ClassNames;
import com.android.build.gradle.internal.tasks.mlkit.codegen.CodeUtils;
import com.android.build.gradle.internal.tasks.mlkit.codegen.codeinjector.CodeInjector;
import com.android.tools.mlkit.TensorInfo;
import com.google.common.base.Strings;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import javax.lang.model.element.Modifier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0003H\u0016\u00a8\u0006\t"}, d2={"Lcom/android/build/gradle/internal/tasks/mlkit/codegen/codeinjector/fields/FieldInjector;", "Lcom/android/build/gradle/internal/tasks/mlkit/codegen/codeinjector/CodeInjector;", "Lcom/squareup/javapoet/TypeSpec$Builder;", "Lcom/android/tools/mlkit/TensorInfo;", "()V", "inject", "", "classBuilder", "tensorInfo", "gradle-core"})
public final class FieldInjector
implements CodeInjector<TypeSpec.Builder, TensorInfo> {
    @Override
    public void inject(@NotNull TypeSpec.Builder classBuilder, @NotNull TensorInfo tensorInfo) {
        FieldSpec fieldName;
        Intrinsics.checkParameterIsNotNull((Object)classBuilder, (String)"classBuilder");
        Intrinsics.checkParameterIsNotNull((Object)tensorInfo, (String)"tensorInfo");
        if (!tensorInfo.isMetadataExisted()) {
            return;
        }
        if (!Strings.isNullOrEmpty((String)tensorInfo.getFileName())) {
            TypeName typeName = (TypeName)ClassNames.LIST_OF_STRING;
            String string = tensorInfo.getFileName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"tensorInfo.fileName");
            fieldName = FieldSpec.builder((TypeName)typeName, (String)CodeUtils.getIdentifierFromFileName(string), (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).addAnnotation(ClassNames.NON_NULL).build();
            classBuilder.addField(fieldName);
        }
        if (tensorInfo.isRGBImage()) {
            FieldSpec processorField = FieldSpec.builder((TypeName)((TypeName)ClassNames.IMAGE_PROCESSOR), (String)CodeUtils.getProcessorName(tensorInfo), (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).addAnnotation(ClassNames.NON_NULL).build();
            classBuilder.addField(processorField);
            FieldSpec imageHeightField = FieldSpec.builder((TypeName)TypeName.INT, (String)CodeUtils.getImageHeightFieldName(tensorInfo), (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE}).build();
            classBuilder.addField(imageHeightField);
            FieldSpec imageWidthField = FieldSpec.builder((TypeName)TypeName.INT, (String)CodeUtils.getImageWidthFieldName(tensorInfo), (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE}).build();
            classBuilder.addField(imageWidthField);
        } else {
            fieldName = FieldSpec.builder((TypeName)((TypeName)ClassNames.TENSOR_PROCESSOR), (String)CodeUtils.getProcessorName(tensorInfo), (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).addAnnotation(ClassNames.NON_NULL).build();
            classBuilder.addField(fieldName);
        }
    }
}

