/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.testing;

import com.android.build.gradle.internal.testing.BaseTestRunner;
import com.android.build.gradle.internal.testing.CustomTestRunListener;
import com.android.build.gradle.internal.testing.StaticTestData;
import com.android.builder.testing.api.DeviceConnector;
import com.android.builder.testing.api.DeviceException;
import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.DdmPreferences;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.InstallException;
import com.android.ddmlib.MultiLineReceiver;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.TimeoutException;
import com.android.ddmlib.testrunner.IRemoteAndroidTestRunner;
import com.android.ddmlib.testrunner.ITestRunListener;
import com.android.ddmlib.testrunner.RemoteAndroidTestRunner;
import com.android.ddmlib.testrunner.TestIdentifier;
import com.android.ddmlib.testrunner.TestRunResult;
import com.android.ide.common.workers.WorkerExecutorFacade;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.inject.Inject;

public class SimpleTestRunnable
implements WorkerExecutorFacade.WorkAction {
    public static final String FILE_COVERAGE_EC = "coverage.ec";
    private static final String TMP = "/data/local/tmp/";
    private final RemoteAndroidTestRunner runner;
    private final String projectName;
    private final DeviceConnector device;
    private final String flavorName;
    private final StaticTestData testData;
    private final File resultsDir;
    private final File additionalTestOutputDir;
    private final File coverageDir;
    private final List<File> testedApks;
    private final Collection<String> installOptions;
    private final ILogger logger;
    private final Set<File> helperApks;
    private final BaseTestRunner.TestResult testResult;
    private final int timeoutInMs;
    private final boolean additionalTestOutputEnabled;

    @Inject
    public SimpleTestRunnable(SimpleTestParams params) {
        this.projectName = params.projectName;
        this.device = params.device;
        this.runner = params.runner;
        this.flavorName = params.flavorName;
        this.helperApks = params.helperApks;
        this.resultsDir = params.resultsDir;
        this.additionalTestOutputDir = params.additionalTestOutputDir;
        this.coverageDir = params.coverageDir;
        this.testedApks = params.testedApks;
        this.testData = params.testData;
        this.timeoutInMs = params.timeoutInMs;
        this.installOptions = params.installOptions;
        this.logger = params.logger;
        this.testResult = params.testResult;
        this.additionalTestOutputEnabled = params.additionalTestOutputEnabled;
    }

    /*
     * Could not resolve type clashes
     * Loose catch block
     */
    public void run() {
        String additionalTestOutputDir;
        String coverageFile;
        boolean success;
        long time;
        CustomTestRunListener runListener;
        boolean isInstalled;
        String deviceName;
        block59: {
            block60: {
                TestRunResult testRunResult;
                block56: {
                    block57: {
                        block58: {
                            deviceName = this.device.getName();
                            isInstalled = false;
                            runListener = new CustomTestRunListener(deviceName, this.projectName, this.flavorName, this.logger);
                            runListener.setReportDir(this.resultsDir);
                            time = System.currentTimeMillis();
                            success = false;
                            coverageFile = this.getCoverageFile();
                            additionalTestOutputDir = null;
                            this.device.connect(this.timeoutInMs, this.logger);
                            if (!this.testedApks.isEmpty()) {
                                this.logger.verbose("DeviceConnector '%s': installing %s", new Object[]{deviceName, Joiner.on((String)", ").join(this.testedApks)});
                                if (this.testedApks.size() > 1 && this.device.getApiLevel() < 21) {
                                    throw new InstallException("Internal error, file a bug, multi-apk applications require a device with API level 21+");
                                }
                                if (this.testedApks.size() > 1) {
                                    this.device.installPackages(this.testedApks, this.installOptions, this.timeoutInMs, this.logger);
                                } else {
                                    this.device.installPackage(this.testedApks.get(0), this.installOptions, this.timeoutInMs, this.logger);
                                }
                            }
                            if (!this.helperApks.isEmpty()) {
                                ArrayList<String> helperApkInstallOptions = new ArrayList<String>(this.installOptions);
                                int apiLevel = this.device.getApiLevel();
                                if (apiLevel >= 23) {
                                    helperApkInstallOptions.add("-g");
                                }
                                if (apiLevel >= 30) {
                                    helperApkInstallOptions.add("--force-queryable");
                                }
                                for (File helperApk : this.helperApks) {
                                    this.logger.verbose("DeviceConnector '%s': installing helper APK %s", new Object[]{deviceName, helperApk});
                                    this.device.installPackage(helperApk, (Collection)helperApkInstallOptions, this.timeoutInMs, this.logger);
                                }
                            }
                            this.logger.verbose("DeviceConnector '%s': installing %s", new Object[]{deviceName, this.testData.getTestApk()});
                            this.device.installPackage(this.testData.getTestApk(), this.installOptions, this.timeoutInMs, this.logger);
                            isInstalled = true;
                            for (Map.Entry argument : this.testData.getInstrumentationRunnerArguments().entrySet()) {
                                this.runner.addInstrumentationArg((String)argument.getKey(), (String)argument.getValue());
                            }
                            if (this.additionalTestOutputEnabled && this.device.getApiLevel() >= 16) {
                                additionalTestOutputDir = this.queryAdditionalTestOutputLocation().toString();
                                MultiLineReceiver receiver = this.getOutputReceiver();
                                String mkdirp = "mkdir -p " + additionalTestOutputDir;
                                this.executeShellCommand(mkdirp, receiver);
                                this.setUpDirectories(additionalTestOutputDir);
                                this.runner.setAdditionalTestOutputLocation(additionalTestOutputDir);
                            }
                            if (this.testData.isTestCoverageEnabled()) {
                                this.runner.addInstrumentationArg("coverage", "true");
                                if (this.runner.getCoverageOutputType() == IRemoteAndroidTestRunner.CoverageOutput.DIR) {
                                    this.setUpDirectories(coverageFile);
                                }
                                this.runner.setCoverageReportLocation(coverageFile);
                            }
                            if (this.testData.getAnimationsDisabled()) {
                                this.runner.setRunOptions("--no_window_animation");
                            }
                            this.runner.setRunName(deviceName);
                            this.runner.setMaxtimeToOutputResponse(this.timeoutInMs);
                            this.runner.run(new ITestRunListener[]{runListener});
                            testRunResult = runListener.getRunResult();
                            success = true;
                            if (testRunResult.getNumTests() != 0) break block56;
                            CustomTestRunListener fakeRunListener = new CustomTestRunListener(deviceName, this.projectName, this.flavorName, this.logger);
                            fakeRunListener.setReportDir(this.resultsDir);
                            Map<String, String> emptyMetrics = Collections.emptyMap();
                            TestIdentifier fakeTest = new TestIdentifier(this.device.getClass().getName(), "No tests found.");
                            fakeRunListener.testStarted(fakeTest);
                            fakeRunListener.testFailed(fakeTest, "No tests found. This usually means that your test classes are not in the form that your test runner expects (e.g. don't inherit from TestCase or lack @Test annotations).");
                            fakeRunListener.testEnded(fakeTest, emptyMetrics);
                            fakeRunListener.testRunEnded(System.currentTimeMillis() - time, emptyMetrics);
                            this.testResult.setTestResult(BaseTestRunner.TestResult.Result.FAILED);
                            if (!isInstalled) break block57;
                            if (!success || !this.additionalTestOutputEnabled || additionalTestOutputDir == null) break block58;
                            try {
                                this.pullTestData(deviceName, additionalTestOutputDir);
                            }
                            catch (Throwable e) {
                                throw new RuntimeException(e);
                            }
                        }
                        if (success && this.testData.isTestCoverageEnabled()) {
                            try {
                                this.pullCoverageData(deviceName, coverageFile, this.runner.getCoverageOutputType());
                            }
                            catch (Throwable e) {
                                throw new RuntimeException(e);
                            }
                        }
                        try {
                            this.uninstall(this.testData.getTestApk(), this.testData.getApplicationId(), deviceName);
                        }
                        catch (DeviceException e) {
                            throw new RuntimeException(e);
                        }
                        for (File testedApk : this.testedApks) {
                            try {
                                this.uninstall(testedApk, this.testData.getTestedApplicationId(), deviceName);
                            }
                            catch (DeviceException e) {
                                throw new RuntimeException(e);
                            }
                        }
                    }
                    try {
                        this.device.disconnect(this.timeoutInMs, this.logger);
                    }
                    catch (TimeoutException e) {
                        throw new RuntimeException(e);
                    }
                    return;
                }
                this.testResult.setTestResult(testRunResult.hasFailedTests() || testRunResult.isRunFailure() ? BaseTestRunner.TestResult.Result.FAILED : BaseTestRunner.TestResult.Result.SUCCEEDED);
                if (!isInstalled) break block59;
                if (!success || !this.additionalTestOutputEnabled || additionalTestOutputDir == null) break block60;
                try {
                    this.pullTestData(deviceName, additionalTestOutputDir);
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
            if (success && this.testData.isTestCoverageEnabled()) {
                try {
                    this.pullCoverageData(deviceName, coverageFile, this.runner.getCoverageOutputType());
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
            try {
                this.uninstall(this.testData.getTestApk(), this.testData.getApplicationId(), deviceName);
            }
            catch (DeviceException e) {
                throw new RuntimeException(e);
            }
            for (File testedApk : this.testedApks) {
                try {
                    this.uninstall(testedApk, this.testData.getTestedApplicationId(), deviceName);
                }
                catch (DeviceException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        try {
            this.device.disconnect(this.timeoutInMs, this.logger);
        }
        catch (TimeoutException e) {
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            try {
                Map<String, String> emptyMetrics = Collections.emptyMap();
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                PrintWriter pw = new PrintWriter(baos, true);
                e.printStackTrace(pw);
                TestIdentifier fakeTest = new TestIdentifier(this.device.getClass().getName(), "runTests");
                runListener.testStarted(fakeTest);
                runListener.testFailed(fakeTest, baos.toString());
                runListener.testEnded(fakeTest, emptyMetrics);
                runListener.testRunEnded(System.currentTimeMillis() - time, emptyMetrics);
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                if (isInstalled) {
                    if (success && this.additionalTestOutputEnabled && additionalTestOutputDir != null) {
                        try {
                            this.pullTestData(deviceName, additionalTestOutputDir);
                        }
                        catch (Throwable e2) {
                            throw new RuntimeException(e2);
                        }
                    }
                    if (success && this.testData.isTestCoverageEnabled()) {
                        try {
                            this.pullCoverageData(deviceName, coverageFile, this.runner.getCoverageOutputType());
                        }
                        catch (Throwable e3) {
                            throw new RuntimeException(e3);
                        }
                    }
                    try {
                        this.uninstall(this.testData.getTestApk(), this.testData.getApplicationId(), deviceName);
                    }
                    catch (DeviceException e4) {
                        throw new RuntimeException(e4);
                    }
                    for (File testedApk : this.testedApks) {
                        try {
                            this.uninstall(testedApk, this.testData.getTestedApplicationId(), deviceName);
                        }
                        catch (DeviceException e5) {
                            throw new RuntimeException(e5);
                        }
                    }
                }
                try {
                    this.device.disconnect(this.timeoutInMs, this.logger);
                }
                catch (TimeoutException e6) {
                    throw new RuntimeException(e6);
                }
                throw throwable;
            }
        }
    }

    private MultiLineReceiver getOutputReceiver() {
        return new MultiLineReceiver(){

            public void processNewLines(String[] lines) {
                for (String line : lines) {
                    SimpleTestRunnable.this.logger.verbose(line, new Object[0]);
                }
            }

            public boolean isCancelled() {
                return false;
            }
        };
    }

    private static String cleanUpDir(String path) {
        return String.format("if [ -d %s ]; then rm -r %s; fi && mkdir %s", path, path, path);
    }

    private Path queryAdditionalTestOutputLocation() throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException, InstallException {
        if (this.device.getApiLevel() < 16) {
            throw new InstallException("additionalTestOutput is not supported on devices running API level < 16");
        }
        final String[] result2 = new String[1];
        MultiLineReceiver receiver = new MultiLineReceiver(){

            public void processNewLines(String[] lines) {
                for (String row : lines) {
                    if (row.isEmpty() || !row.startsWith("Row:")) break;
                    result2[0] = row.split("_data=")[1].trim();
                }
            }

            public boolean isCancelled() {
                return false;
            }
        };
        this.executeShellCommand("content query --uri content://media/external/file --projection _data --where \"_data LIKE '%/Android'\"", receiver);
        receiver.flush();
        return Paths.get(result2[0], "data", this.testData.getTestedApplicationId(), "files/test_data");
    }

    private void setUpDirectories(String userCoverageDir) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        MultiLineReceiver receiver = this.getOutputReceiver();
        String cleanUpTmp = SimpleTestRunnable.cleanUpDir(this.getCoverageTmp());
        this.executeShellCommand(cleanUpTmp, receiver);
        String cleanUpUser = SimpleTestRunnable.cleanUpDir(userCoverageDir);
        this.execAsScript(cleanUpUser, "tmpScript.sh", true);
    }

    private void execAsScript(String command, String scriptName, boolean withRunAs) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        String scriptPath = this.getCoverageTmp() + "/" + scriptName;
        MultiLineReceiver receiver = this.getOutputReceiver();
        this.executeShellCommand("echo '" + command + "' > " + scriptPath, receiver);
        String finalCommand = "sh " + scriptPath;
        if (withRunAs) {
            finalCommand = this.asTestedApplication(finalCommand);
        }
        this.executeShellCommand(finalCommand, receiver);
    }

    @VisibleForTesting
    String getCoverageFile() {
        Supplier<String> defaultDir = () -> {
            switch (this.runner.getCoverageOutputType()) {
                case DIR: {
                    return "/data/data/" + this.testData.getTestedApplicationId() + "/coverage_data/";
                }
                case FILE: {
                    return String.format("/data/data/%s/%s", this.testData.getTestedApplicationId(), FILE_COVERAGE_EC);
                }
            }
            throw new AssertionError((Object)"Unknown coverage type.");
        };
        return this.testData.getInstrumentationRunnerArguments().getOrDefault("coverageFile", defaultDir.get());
    }

    private String asTestedApplication(String ... command) {
        Iterator iterator = Arrays.stream(command).map(s -> "run-as " + this.testData.getTestedApplicationId() + " " + s).iterator();
        return Joiner.on((String)" && ").join(iterator);
    }

    private void pullTestData(final String deviceName, final String additionalTestOutputDir) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        if (this.additionalTestOutputDir == null) {
            throw new RuntimeException("Attempt to pull additional test output without an output directory set");
        }
        final File hostDir = new File(this.additionalTestOutputDir, deviceName);
        FileUtils.cleanOutputDir((File)hostDir);
        MultiLineReceiver reportPathReceiver = new MultiLineReceiver(){

            public void processNewLines(String[] lines) {
                for (String report : lines) {
                    if (report.isEmpty() || report.startsWith("ls")) break;
                    SimpleTestRunnable.this.logger.verbose("DeviceConnector '%s': fetching test data %s", new Object[]{deviceName, report});
                    File hostSingleReport = new File(hostDir, report);
                    try {
                        SimpleTestRunnable.this.device.pullFile(Paths.get(additionalTestOutputDir, report).toString(), hostSingleReport.getPath());
                    }
                    catch (IOException e) {
                        SimpleTestRunnable.this.logger.error((Throwable)e, "Error while pulling test data from device.", new Object[0]);
                    }
                }
            }

            public boolean isCancelled() {
                return false;
            }
        };
        this.logger.verbose("DeviceConnector '%s': fetching additional test data from %s", new Object[]{deviceName, additionalTestOutputDir});
        this.executeShellCommand("ls -1 " + additionalTestOutputDir, reportPathReceiver);
        reportPathReceiver.flush();
    }

    private void pullCoverageData(String deviceName, String coverageFile, IRemoteAndroidTestRunner.CoverageOutput coverageOutput) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        switch (coverageOutput) {
            case DIR: {
                this.pullCoverageFromDir(deviceName, coverageFile);
                break;
            }
            case FILE: {
                this.pullSingleCoverageFile(deviceName, coverageFile);
                break;
            }
            default: {
                throw new AssertionError((Object)"Unknown coverage type.");
            }
        }
    }

    private void pullSingleCoverageFile(String deviceName, String coverageFile) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        String temporaryCoverageCopy = TMP + this.testData.getTestedApplicationId() + "." + FILE_COVERAGE_EC;
        MultiLineReceiver outputReceiver = this.getOutputReceiver();
        this.logger.verbose("DeviceConnector '%s': fetching coverage data from %s", new Object[]{deviceName, coverageFile});
        this.executeShellCommand(this.asTestedApplication(" cat " + coverageFile) + " | cat > " + temporaryCoverageCopy, outputReceiver);
        this.device.pullFile(temporaryCoverageCopy, new File(this.coverageDir, deviceName + "-" + FILE_COVERAGE_EC).getPath());
        this.executeShellCommand("rm " + temporaryCoverageCopy, outputReceiver);
    }

    private void pullCoverageFromDir(String deviceName, String coverageDir) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        String coverageTmp = this.getCoverageTmp();
        MultiLineReceiver outputReceiver = this.getOutputReceiver();
        this.logger.verbose("DeviceConnector '%s': fetching coverage dir from %s", new Object[]{deviceName, coverageDir});
        String listFiles = this.asTestedApplication("ls " + coverageDir);
        String copyScript = String.format("for i in $(%s); do run-as %s cat %s$i > %s/$i; done", listFiles, this.testData.getTestedApplicationId(), coverageDir, coverageTmp);
        this.execAsScript(copyScript, "copyFromUser.sh", false);
        String coveragePaths = coverageTmp + "/paths.txt";
        this.executeShellCommand("ls " + coverageTmp + " > " + coveragePaths, outputReceiver);
        File hostCoverage = new File(this.coverageDir, deviceName);
        FileUtils.cleanOutputDir((File)hostCoverage);
        File hostCoveragePaths = new File(hostCoverage, "coverage_file_paths.txt");
        this.device.pullFile(coveragePaths, hostCoveragePaths.getPath());
        List<String> reportPaths = Files.readAllLines(hostCoveragePaths.toPath());
        for (String reportPath : reportPaths) {
            if (!reportPath.endsWith(".ec")) continue;
            File hostSingleReport = new File(hostCoverage, reportPath);
            this.device.pullFile(coverageTmp + "/" + reportPath, hostSingleReport.getPath());
        }
        FileUtils.delete((File)hostCoveragePaths);
        this.executeShellCommand("rm -r " + coverageTmp, outputReceiver);
    }

    private void executeShellCommand(String command, MultiLineReceiver receiver) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        this.device.executeShellCommand(command, (IShellOutputReceiver)receiver, (long)DdmPreferences.getTimeOut(), TimeUnit.MILLISECONDS);
    }

    private String getCoverageTmp() {
        return TMP + this.testData.getTestedApplicationId() + "-coverage_data";
    }

    private void uninstall(File apkFile, String packageName2, String deviceName) throws DeviceException {
        if (packageName2 != null) {
            this.logger.verbose("DeviceConnector '%s': uninstalling %s", new Object[]{deviceName, packageName2});
            this.device.uninstallPackage(packageName2, this.timeoutInMs, this.logger);
        } else {
            this.logger.verbose("DeviceConnector '%s': unable to uninstall %s: unable to get package name", new Object[]{deviceName, apkFile});
        }
    }

    public static class SimpleTestParams
    implements Serializable {
        private final RemoteAndroidTestRunner runner;
        private final String projectName;
        private final DeviceConnector device;
        private final String flavorName;
        private final StaticTestData testData;
        private final File resultsDir;
        private final boolean additionalTestOutputEnabled;
        private final File additionalTestOutputDir;
        private final File coverageDir;
        private final List<File> testedApks;
        private final Collection<String> installOptions;
        private final ILogger logger;
        private final Set<File> helperApks;
        private final BaseTestRunner.TestResult testResult;
        private final int timeoutInMs;

        public SimpleTestParams(DeviceConnector device, String projectName, RemoteAndroidTestRunner runner, String flavorName2, List<File> testedApks, StaticTestData testData, Set<File> helperApks, File resultsDir, boolean additionalTestOutputEnabled, File additionalTestOutputDir, File coverageDir, int timeoutInMs, Collection<String> installOptions, ILogger logger, BaseTestRunner.TestResult testResult) {
            this.projectName = projectName;
            this.device = device;
            this.runner = runner;
            this.flavorName = flavorName2;
            this.helperApks = helperApks;
            this.resultsDir = resultsDir;
            this.additionalTestOutputDir = additionalTestOutputDir;
            this.coverageDir = coverageDir;
            this.testedApks = testedApks;
            this.testData = testData;
            this.timeoutInMs = timeoutInMs;
            this.installOptions = installOptions;
            this.logger = logger;
            this.testResult = testResult;
            this.additionalTestOutputEnabled = additionalTestOutputEnabled;
        }
    }
}

