/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.testing.utp;

import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Locale;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.streams.jdk8.StreamsKt;
import kotlin.text.StringsKt;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000\"\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\n\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002\u001a\u000e\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u000b\u001a\n\u0010\f\u001a\u0004\u0018\u00010\u000bH\u0002\"\u0016\u0010\u0000\u001a\u00020\u00018\u0006X\u0087T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0002\u0010\u0003\"\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"DEFAULT_EMULATOR_GRPC_PORT", "", "getDEFAULT_EMULATOR_GRPC_PORT$annotations", "()V", "LOG", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "computeRegistrationDirectoryContainer", "Ljava/nio/file/Path;", "findGrpcPort", "deviceSerial", "", "getUid", "gradle-core"})
public final class IceboxConfigUtilsKt {
    public static final int DEFAULT_EMULATOR_GRPC_PORT = 8554;
    private static final Logger LOG = Logger.getLogger("IceboxConfigUtils");

    @VisibleForTesting
    public static /* synthetic */ void getDEFAULT_EMULATOR_GRPC_PORT$annotations() {
    }

    private static final Path computeRegistrationDirectoryContainer() {
        String string = System.getProperty("os.name");
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"System.getProperty(\"os.name\")");
        String string2 = string;
        Locale locale = Locale.ROOT;
        Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.ROOT");
        Locale locale2 = locale;
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.toLowerCase(locale2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).toLowerCase(locale)");
        String os = string4;
        if (StringsKt.startsWith$default((String)os, (String)"mac", (boolean)false, (int)2, null)) {
            String string5 = System.getProperty("HOME");
            if (string5 == null) {
                string5 = "/";
            }
            return Paths.get(string5, "Library", "Caches", "TemporaryItems");
        }
        if (StringsKt.startsWith$default((String)os, (String)"win", (boolean)false, (int)2, null)) {
            String string6 = System.getProperty("LOCALAPPDATA");
            if (string6 == null) {
                string6 = "/";
            }
            return Paths.get(string6, "Temp");
        }
        String[] stringArray = new String[3];
        stringArray[0] = System.getProperty("XDG_RUNTIME_DIR");
        stringArray[1] = "/run/user/" + IceboxConfigUtilsKt.getUid();
        StringBuilder stringBuilder = new StringBuilder();
        String string7 = System.getProperty("HOME");
        if (string7 == null) {
            string7 = "/";
        }
        stringArray[2] = stringBuilder.append(string7).append(".android").toString();
        for (String dirstr : stringArray) {
            if (dirstr == null) continue;
            try {
                Path dir = Paths.get(dirstr, new String[0]);
                if (!Files.isDirectory(dir, new LinkOption[0])) continue;
                return dir;
            }
            catch (InvalidPathException exception) {
                LOG.finer("Failed to parse dir " + dirstr + ", exception " + exception);
            }
        }
        File file = FileUtils.getTempDirectory();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"FileUtils.getTempDirectory()");
        return Paths.get(file.getAbsolutePath(), "android-" + System.getProperty("USER"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String getUid() {
        try {
            Process process2;
            String userName = System.getProperty("user.name");
            String command = "id -u " + userName;
            Process process3 = process2 = Runtime.getRuntime().exec(command);
            Intrinsics.checkExpressionValueIsNotNull((Object)process3, (String)"process");
            Closeable closeable = process3.getInputStream();
            boolean bl = false;
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl2 = false;
                InputStream inputStream = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"it");
                Object object = ByteStreamsKt.readBytes((InputStream)inputStream);
                Charset charset = StandardCharsets.UTF_8;
                Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"StandardCharsets.UTF_8");
                Charset charset2 = charset;
                boolean bl3 = false;
                object = new String((byte[])object, charset2);
                boolean bl4 = false;
                String result2 = ((Object)StringsKt.trim((CharSequence)((CharSequence)object))).toString();
                object = result2;
                bl4 = false;
                if (object.length() == 0) {
                    String string = null;
                    return string;
                }
                String string = result2;
                return string;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (IOException e) {
            return null;
        }
    }

    public static final int findGrpcPort(@NotNull String deviceSerial) {
        Intrinsics.checkParameterIsNotNull((Object)deviceSerial, (String)"deviceSerial");
        try {
            Pattern fileNamePattern = Pattern.compile("pid_\\d+.ini");
            Path path = IceboxConfigUtilsKt.computeRegistrationDirectoryContainer();
            Path directory2 = path != null ? path.resolve("avd/running") : null;
            Stream<Path> stream2 = Files.list(directory2);
            Intrinsics.checkExpressionValueIsNotNull(stream2, (String)"Files.list(directory)");
            Integer n = (Integer)SequencesKt.firstOrNull((Sequence)SequencesKt.filterNotNull((Sequence)SequencesKt.map((Sequence)StreamsKt.asSequence(stream2), (Function1)((Function1)new Function1<Path, Integer>(fileNamePattern, deviceSerial){
                final /* synthetic */ Pattern $fileNamePattern;
                final /* synthetic */ String $deviceSerial;

                @Nullable
                public final Integer invoke(Path file) {
                    int currentGrpcPort = 8554;
                    boolean matchedAvd = false;
                    Path path = file;
                    Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"file");
                    if (this.$fileNamePattern.matcher(((Object)path.getFileName()).toString()).matches()) {
                        List<String> list = Files.readAllLines(file);
                        Intrinsics.checkExpressionValueIsNotNull(list, (String)"Files.readAllLines(file)");
                        Iterable $this$forEach$iv = list;
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            String serial;
                            int n;
                            String line = (String)element$iv;
                            boolean bl = false;
                            String string = line;
                            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"line");
                            if (StringsKt.startsWith$default((String)string, (String)"grpc.port=", (boolean)false, (int)2, null)) {
                                String string2 = line;
                                int n2 = "grpc.port=".length();
                                n = 0;
                                String string3 = string2.substring(n2);
                                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
                                currentGrpcPort = Integer.parseInt(string3, 10);
                                continue;
                            }
                            if (!StringsKt.startsWith$default((String)line, (String)"port.serial=", (boolean)false, (int)2, null)) continue;
                            String string4 = line;
                            n = "port.serial=".length();
                            boolean bl2 = false;
                            Intrinsics.checkExpressionValueIsNotNull((Object)string4.substring(n), (String)"(this as java.lang.String).substring(startIndex)");
                            matchedAvd = Intrinsics.areEqual((Object)("emulator-" + serial), (Object)this.$deviceSerial);
                        }
                    }
                    return matchedAvd ? Integer.valueOf(currentGrpcPort) : null;
                }
                {
                    this.$fileNamePattern = pattern;
                    this.$deviceSerial = string;
                    super(1);
                }
            }))));
            return n != null ? n : 8554;
        }
        catch (Throwable exception) {
            LOG.fine("Failed to parse emulator gRPC port, fallback to default," + " exception " + exception);
            return 8554;
        }
    }
}

