/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.mlkit;

import com.android.utils.StringHelper;
import com.google.common.base.CaseFormat;
import com.google.common.base.CharMatcher;
import com.google.common.base.Charsets;
import com.google.common.hash.Hashing;
import com.google.common.io.MoreFiles;
import com.google.common.primitives.UnsignedBytes;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.lang.model.SourceVersion;

public class MlNames {
    public static final String OUTPUTS = "Outputs";
    public static final String PACKAGE_SUFFIX = ".ml";
    private static final String MODEL_NAME_PREFIX = "AutoModel";

    public static String formatGetterName(String propertyName, String type) {
        return "get" + StringHelper.usLocaleCapitalize((String)propertyName) + "As" + StringHelper.usLocaleCapitalize((String)type);
    }

    public static String formatGroupGetterName(String propertyName) {
        return "get" + StringHelper.usLocaleCapitalize((String)propertyName) + "List";
    }

    public static String computeModelClassName(String relativeModelFilePath) {
        Path filePath = Paths.get(relativeModelFilePath, new String[0]);
        String formattedName = MoreFiles.getNameWithoutExtension((Path)filePath).trim().replaceAll("[- ]+", "_");
        formattedName = formattedName.contains("_") ? CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, formattedName) : StringHelper.usLocaleCapitalize((String)formattedName);
        CharMatcher classNameMatcher = CharMatcher.inRange((char)'0', (char)'9').or(CharMatcher.inRange((char)'A', (char)'Z')).or(CharMatcher.inRange((char)'a', (char)'z'));
        String className = classNameMatcher.retainFrom((CharSequence)formattedName);
        if (className.isEmpty()) {
            return MODEL_NAME_PREFIX + MlNames.getHashValue(relativeModelFilePath);
        }
        if (filePath.getParent() != null) {
            className = className + MlNames.getHashValue(relativeModelFilePath);
        }
        if (SourceVersion.isIdentifier(className) && !SourceVersion.isKeyword(className)) {
            return className;
        }
        return MODEL_NAME_PREFIX + className;
    }

    public static String computeIdentifierName(String name2, String defaultName) {
        CharMatcher classNameMatcher;
        String matchedName;
        if (name2.isEmpty()) {
            return defaultName;
        }
        String formattedName = name2.replaceAll("[- ]+", "_");
        if (formattedName.contains("_")) {
            formattedName = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, formattedName.trim());
        }
        if (SourceVersion.isIdentifier(matchedName = (classNameMatcher = CharMatcher.inRange((char)'0', (char)'9').or(CharMatcher.inRange((char)'A', (char)'Z')).or(CharMatcher.inRange((char)'a', (char)'z'))).retainFrom((CharSequence)formattedName)) && !SourceVersion.isKeyword(matchedName)) {
            return matchedName;
        }
        return defaultName;
    }

    private static String getHashValue(String name2) {
        return UnsignedBytes.toString((byte)Hashing.murmur3_32().hashString((CharSequence)name2, Charsets.UTF_8).asBytes()[0]);
    }

    public static String computeIdentifierName(String name2) {
        String defaultName = "name" + MlNames.getHashValue(name2);
        return MlNames.computeIdentifierName(name2, defaultName);
    }
}

