/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dependency;

import com.android.build.api.attributes.BuildTypeAttr;
import com.android.build.api.attributes.ProductFlavorAttr;
import com.android.build.api.attributes.VariantAttr;
import com.android.build.api.variant.impl.VariantImpl;
import com.android.build.gradle.internal.api.DefaultAndroidSourceSet;
import com.android.build.gradle.internal.core.VariantDslInfo;
import com.android.build.gradle.internal.dependency.AndroidXDependencyCheck;
import com.android.build.gradle.internal.dependency.ConstraintHandler;
import com.android.build.gradle.internal.dependency.VariantDependencies;
import com.android.build.gradle.internal.dsl.ProductFlavor;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.services.StringCachingBuildService;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.ProjectOptions;
import com.android.builder.core.VariantType;
import com.android.builder.errors.IssueReporter;
import com.android.utils.StringHelper;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.ResolutionStrategy;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.attributes.Bundling;
import org.gradle.api.attributes.Category;
import org.gradle.api.attributes.LibraryElements;
import org.gradle.api.attributes.Usage;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Provider;

public class VariantDependenciesBuilder {
    private final Project project;
    private final ProjectOptions projectOptions;
    private final IssueReporter issueReporter;
    private final VariantDslInfo variantDslInfo;
    private Map<Attribute<ProductFlavorAttr>, ProductFlavorAttr> flavorSelection;
    private final Set<Configuration> compileClasspaths = Sets.newLinkedHashSet();
    private final Set<Configuration> apiClasspaths = Sets.newLinkedHashSet();
    private final Set<Configuration> implementationConfigurations = Sets.newLinkedHashSet();
    private final Set<Configuration> runtimeClasspaths = Sets.newLinkedHashSet();
    private final Set<Configuration> annotationConfigs = Sets.newLinkedHashSet();
    private final Set<Configuration> wearAppConfigs = Sets.newLinkedHashSet();
    private VariantImpl testedVariant;
    private Set<String> featureList;

    public static VariantDependenciesBuilder builder(Project project, ProjectOptions projectOptions, IssueReporter errorReporter, VariantDslInfo variantDslInfo) {
        return new VariantDependenciesBuilder(project, projectOptions, errorReporter, variantDslInfo);
    }

    protected VariantDependenciesBuilder(Project project, ProjectOptions projectOptions, IssueReporter issueReporter2, VariantDslInfo variantDslInfo) {
        this.project = project;
        this.projectOptions = projectOptions;
        this.issueReporter = issueReporter2;
        this.variantDslInfo = variantDslInfo;
    }

    public VariantDependenciesBuilder addSourceSets(DefaultAndroidSourceSet ... sourceSets) {
        for (DefaultAndroidSourceSet sourceSet : sourceSets) {
            this.addSourceSet(sourceSet);
        }
        return this;
    }

    public VariantDependenciesBuilder addSourceSets(Collection<DefaultAndroidSourceSet> sourceSets) {
        for (DefaultAndroidSourceSet sourceSet : sourceSets) {
            this.addSourceSet(sourceSet);
        }
        return this;
    }

    public VariantDependenciesBuilder setTestedVariant(VariantImpl testedVariant) {
        this.testedVariant = testedVariant;
        return this;
    }

    public VariantDependenciesBuilder setFeatureList(Set<String> featureList) {
        this.featureList = featureList;
        return this;
    }

    public VariantDependenciesBuilder addSourceSet(DefaultAndroidSourceSet sourceSet) {
        if (sourceSet != null) {
            ConfigurationContainer configs = this.project.getConfigurations();
            this.compileClasspaths.add(configs.getByName(sourceSet.getCompileOnlyConfigurationName()));
            this.runtimeClasspaths.add(configs.getByName(sourceSet.getRuntimeOnlyConfigurationName()));
            Configuration implementationConfig = configs.getByName(sourceSet.getImplementationConfigurationName());
            this.compileClasspaths.add(implementationConfig);
            this.runtimeClasspaths.add(implementationConfig);
            this.implementationConfigurations.add(implementationConfig);
            String apiConfigName = sourceSet.getApiConfigurationName();
            if (apiConfigName != null) {
                this.apiClasspaths.add(configs.getByName(apiConfigName));
            }
            this.annotationConfigs.add(configs.getByName(sourceSet.getAnnotationProcessorConfigurationName()));
            this.wearAppConfigs.add(configs.getByName(sourceSet.getWearAppConfigurationName()));
        }
        return this;
    }

    public VariantDependenciesBuilder setFlavorSelection(Map<Attribute<ProductFlavorAttr>, ProductFlavorAttr> flavorSelection) {
        this.flavorSelection = flavorSelection;
        return this;
    }

    public VariantDependencies build() {
        Configuration providedClasspath;
        ObjectFactory factory2 = this.project.getObjects();
        Usage apiUsage = (Usage)factory2.named(Usage.class, "java-api");
        Usage runtimeUsage = (Usage)factory2.named(Usage.class, "java-runtime");
        Usage reverseMetadataUsage = (Usage)factory2.named(Usage.class, "android-reverse-meta-data");
        String variantName = this.variantDslInfo.getComponentIdentity().getName();
        VariantType variantType = this.variantDslInfo.getVariantType();
        String buildType = this.variantDslInfo.getComponentIdentity().getBuildType();
        Map<Attribute<ProductFlavorAttr>, ProductFlavorAttr> consumptionFlavorMap = this.getFlavorAttributes(this.flavorSelection);
        ConfigurationContainer configurations = this.project.getConfigurations();
        String compileClasspathName = variantName + "CompileClasspath";
        Configuration compileClasspath = (Configuration)configurations.maybeCreate(compileClasspathName);
        compileClasspath.setVisible(false);
        compileClasspath.setDescription("Resolved configuration for compilation for variant: " + variantName);
        compileClasspath.setExtendsFrom(this.compileClasspaths);
        if (this.testedVariant != null) {
            for (Configuration configuration2 : this.testedVariant.getVariantDependencies().getSourceSetImplementationConfigurations()) {
                compileClasspath.extendsFrom(new Configuration[]{configuration2});
            }
            compileClasspath.getDependencies().add((Object)this.project.getDependencies().create((Object)this.project));
        }
        compileClasspath.setCanBeConsumed(false);
        compileClasspath.getResolutionStrategy().sortArtifacts(ResolutionStrategy.SortOrder.CONSUMER_FIRST);
        AttributeContainer compileAttributes = compileClasspath.getAttributes();
        this.applyVariantAttributes(compileAttributes, buildType, consumptionFlavorMap);
        compileAttributes.attribute(Usage.USAGE_ATTRIBUTE, (Object)apiUsage);
        Configuration annotationProcessor = (Configuration)configurations.maybeCreate(variantName + "AnnotationProcessorClasspath");
        annotationProcessor.setVisible(false);
        annotationProcessor.setDescription("Resolved configuration for annotation-processor for variant: " + variantName);
        annotationProcessor.setExtendsFrom(this.annotationConfigs);
        annotationProcessor.setCanBeConsumed(false);
        AttributeContainer annotationAttributes = annotationProcessor.getAttributes();
        annotationAttributes.attribute(Usage.USAGE_ATTRIBUTE, (Object)runtimeUsage);
        this.applyVariantAttributes(annotationAttributes, buildType, consumptionFlavorMap);
        String runtimeClasspathName = variantName + "RuntimeClasspath";
        Configuration runtimeClasspath = (Configuration)configurations.maybeCreate(runtimeClasspathName);
        runtimeClasspath.setVisible(false);
        runtimeClasspath.setDescription("Resolved configuration for runtime for variant: " + variantName);
        runtimeClasspath.setExtendsFrom(this.runtimeClasspaths);
        if (this.testedVariant != null && (this.testedVariant.getVariantDslInfo().getVariantType().isAar() || !this.variantDslInfo.getVariantType().isApk())) {
            runtimeClasspath.getDependencies().add((Object)this.project.getDependencies().create((Object)this.project));
        }
        runtimeClasspath.setCanBeConsumed(false);
        runtimeClasspath.getResolutionStrategy().sortArtifacts(ResolutionStrategy.SortOrder.CONSUMER_FIRST);
        AttributeContainer runtimeAttributes = runtimeClasspath.getAttributes();
        this.applyVariantAttributes(runtimeAttributes, buildType, consumptionFlavorMap);
        runtimeAttributes.attribute(Usage.USAGE_ATTRIBUTE, (Object)runtimeUsage);
        if (this.projectOptions.get(BooleanOption.USE_DEPENDENCY_CONSTRAINTS)) {
            Provider stringCachingService = new StringCachingBuildService.RegistrationAction(this.project).execute();
            compileClasspath.getIncoming().beforeResolve((Action)new ConstraintHandler(runtimeClasspath, this.project.getDependencies(), false, stringCachingService));
            if (variantType.isApk() && this.testedVariant != null) {
                Configuration testedRuntimeClasspath = this.testedVariant.getVariantDependencies().getRuntimeClasspath();
                runtimeClasspath.getIncoming().beforeResolve((Action)new ConstraintHandler(testedRuntimeClasspath, this.project.getDependencies(), true, stringCachingService));
            }
        }
        if (!this.projectOptions.get(BooleanOption.USE_ANDROID_X)) {
            AndroidXDependencyCheck androidXDependencyCheck = new AndroidXDependencyCheck(this.issueReporter);
            compileClasspath.getIncoming().afterResolve((Action)androidXDependencyCheck);
            runtimeClasspath.getIncoming().afterResolve((Action)androidXDependencyCheck);
        }
        Configuration globalTestedApks = (Configuration)configurations.findByName("testedApks");
        if (variantType.isApk() && globalTestedApks != null) {
            Configuration testedApks = (Configuration)configurations.maybeCreate(StringHelper.appendCapitalized((String)variantName, (String)"testedApks"));
            testedApks.setVisible(false);
            testedApks.setDescription("Resolved configuration for tested apks for variant: " + variantName);
            testedApks.extendsFrom(new Configuration[]{globalTestedApks});
            AttributeContainer testedApksAttributes = testedApks.getAttributes();
            this.applyVariantAttributes(testedApksAttributes, buildType, consumptionFlavorMap);
            testedApksAttributes.attribute(Usage.USAGE_ATTRIBUTE, (Object)runtimeUsage);
            providedClasspath = testedApks;
        } else {
            providedClasspath = runtimeClasspath;
        }
        Configuration reverseMetadataValues = null;
        Configuration wearApp = null;
        EnumMap elements = Maps.newEnumMap(AndroidArtifacts.PublishedConfigType.class);
        if (variantType.isBaseModule()) {
            wearApp = (Configuration)configurations.maybeCreate(variantName + "WearBundling");
            wearApp.setDescription("Resolved Configuration for wear app bundling for variant: " + variantName);
            wearApp.setExtendsFrom(this.wearAppConfigs);
            wearApp.setCanBeConsumed(false);
            AttributeContainer wearAttributes = wearApp.getAttributes();
            this.applyVariantAttributes(wearAttributes, buildType, consumptionFlavorMap);
            wearAttributes.attribute(Usage.USAGE_ATTRIBUTE, (Object)runtimeUsage);
        }
        VariantAttr variantNameAttr = (VariantAttr)factory2.named(VariantAttr.class, variantName);
        Map<Attribute<ProductFlavorAttr>, ProductFlavorAttr> publicationFlavorMap = this.getFlavorAttributes(null);
        if (variantType.getPublishToOtherModules()) {
            Configuration runtimeElements = this.createPublishingConfig(configurations, variantName + "RuntimeElements", "Runtime elements for " + variantName, buildType, publicationFlavorMap, variantNameAttr, runtimeUsage);
            runtimeElements.extendsFrom(new Configuration[]{runtimeClasspath});
            elements.put(AndroidArtifacts.PublishedConfigType.RUNTIME_ELEMENTS, runtimeElements);
            Configuration apiElements = this.createPublishingConfig(configurations, variantName + "ApiElements", "API elements for " + variantName, buildType, publicationFlavorMap, variantNameAttr, apiUsage);
            apiElements.setExtendsFrom(this.apiClasspaths);
            elements.put(AndroidArtifacts.PublishedConfigType.API_ELEMENTS, apiElements);
        }
        if (variantType.getPublishToRepository()) {
            if (variantType.isAar()) {
                LibraryElements libraryElements = (LibraryElements)factory2.named(LibraryElements.class, AndroidArtifacts.ArtifactType.AAR.getType());
                Bundling bundling = (Bundling)factory2.named(Bundling.class, "external");
                Category category = (Category)factory2.named(Category.class, "library");
                Configuration runtimePublication = this.createAarPublishingConfiguration(configurations, variantName + "RuntimePublication", "Runtime publication for " + variantName, runtimeUsage, libraryElements, bundling, category, null, null);
                runtimePublication.extendsFrom(new Configuration[]{runtimeClasspath});
                elements.put(AndroidArtifacts.PublishedConfigType.RUNTIME_PUBLICATION, runtimePublication);
                Configuration apiPublication = this.createAarPublishingConfiguration(configurations, variantName + "ApiPublication", "API publication for " + variantName, apiUsage, libraryElements, bundling, category, null, null);
                apiPublication.setExtendsFrom(this.apiClasspaths);
                elements.put(AndroidArtifacts.PublishedConfigType.API_PUBLICATION, apiPublication);
                Configuration allApiPublication = this.createAarPublishingConfiguration(configurations, variantName + "AllApiPublication", "All API publication for " + variantName, apiUsage, libraryElements, bundling, category, buildType, publicationFlavorMap);
                allApiPublication.setExtendsFrom(this.apiClasspaths);
                elements.put(AndroidArtifacts.PublishedConfigType.ALL_API_PUBLICATION, allApiPublication);
                Configuration allRuntimePublication = this.createAarPublishingConfiguration(configurations, variantName + "AllRuntimePublication", "All runtime publication for " + variantName, runtimeUsage, libraryElements, bundling, category, buildType, publicationFlavorMap);
                allRuntimePublication.setExtendsFrom(this.runtimeClasspaths);
                elements.put(AndroidArtifacts.PublishedConfigType.ALL_RUNTIME_PUBLICATION, allRuntimePublication);
            } else {
                Configuration apkPublication = this.createPublishingConfig(configurations, variantName + "ApkPublication", "APK publication for " + variantName, buildType, publicationFlavorMap, null, null);
                elements.put(AndroidArtifacts.PublishedConfigType.APK_PUBLICATION, apkPublication);
                apkPublication.setVisible(false);
                apkPublication.setCanBeConsumed(false);
                Configuration aabPublication = this.createPublishingConfig(configurations, variantName + "AabPublication", "Bundle Publication for " + variantName, buildType, publicationFlavorMap, null, null);
                elements.put(AndroidArtifacts.PublishedConfigType.AAB_PUBLICATION, aabPublication);
                aabPublication.setVisible(false);
                aabPublication.setCanBeConsumed(false);
            }
        }
        if (variantType.getPublishToMetadata()) {
            Configuration reverseMetadataElements = this.createPublishingConfig(configurations, variantName + "ReverseMetadataElements", "Reverse Meta-data elements for " + variantName, buildType, publicationFlavorMap, variantNameAttr, reverseMetadataUsage);
            elements.put(AndroidArtifacts.PublishedConfigType.REVERSE_METADATA_ELEMENTS, reverseMetadataElements);
        }
        if (variantType.isBaseModule()) {
            String reverseMetadataValuesName = variantName + "ReverseMetadataValues";
            reverseMetadataValues = (Configuration)configurations.maybeCreate(reverseMetadataValuesName);
            if (this.featureList != null) {
                DependencyHandler depHandler = this.project.getDependencies();
                ArrayList<String> notFound = new ArrayList<String>();
                for (String feature : this.featureList) {
                    Project p = this.project.findProject(feature);
                    if (p != null) {
                        depHandler.add(reverseMetadataValuesName, (Object)p);
                        continue;
                    }
                    notFound.add(feature);
                }
                if (!notFound.isEmpty()) {
                    this.issueReporter.reportError(IssueReporter.Type.GENERIC, "Unable to find matching projects for Dynamic Features: " + notFound);
                }
            } else {
                reverseMetadataValues.extendsFrom(new Configuration[]{configurations.getByName("feature")});
            }
            reverseMetadataValues.setDescription("Metadata Values dependencies for the base Split");
            reverseMetadataValues.setCanBeConsumed(false);
            AttributeContainer reverseMetadataValuesAttributes = reverseMetadataValues.getAttributes();
            reverseMetadataValuesAttributes.attribute(Usage.USAGE_ATTRIBUTE, (Object)reverseMetadataUsage);
            this.applyVariantAttributes(reverseMetadataValuesAttributes, buildType, consumptionFlavorMap);
        }
        VariantDependenciesBuilder.checkOldConfigurations(configurations, "_" + variantName + "Compile", compileClasspathName);
        VariantDependenciesBuilder.checkOldConfigurations(configurations, "_" + variantName + "Apk", runtimeClasspathName);
        VariantDependenciesBuilder.checkOldConfigurations(configurations, "_" + variantName + "Publish", runtimeClasspathName);
        return new VariantDependencies(variantName, this.variantDslInfo.getVariantType(), compileClasspath, runtimeClasspath, this.runtimeClasspaths, this.implementationConfigurations, elements, providedClasspath, annotationProcessor, reverseMetadataValues, wearApp, this.testedVariant, this.project, this.projectOptions);
    }

    private Configuration createPublishingConfig(ConfigurationContainer configurations, String configName, String configDesc, String buildType, Map<Attribute<ProductFlavorAttr>, ProductFlavorAttr> publicationFlavorMap, VariantAttr variantNameAttr, Usage usage) {
        Configuration config2 = (Configuration)configurations.maybeCreate(configName);
        config2.setDescription(configDesc);
        config2.setCanBeResolved(false);
        AttributeContainer attrContainer = config2.getAttributes();
        this.applyVariantAttributes(attrContainer, buildType, publicationFlavorMap);
        if (variantNameAttr != null) {
            attrContainer.attribute(VariantAttr.ATTRIBUTE, (Object)variantNameAttr);
        }
        if (usage != null) {
            attrContainer.attribute(Usage.USAGE_ATTRIBUTE, (Object)usage);
        }
        return config2;
    }

    private Configuration createAarPublishingConfiguration(ConfigurationContainer configurations, String configName, String configDesc, Usage usage, LibraryElements libraryElements, Bundling bundling, Category category, String buildType, Map<Attribute<ProductFlavorAttr>, ProductFlavorAttr> publicationFlavorMap) {
        Configuration config2 = (Configuration)configurations.maybeCreate(configName);
        config2.setDescription(configDesc);
        config2.setCanBeResolved(false);
        config2.setVisible(false);
        config2.setCanBeConsumed(false);
        AttributeContainer attrContainer = config2.getAttributes();
        attrContainer.attribute(Usage.USAGE_ATTRIBUTE, (Object)usage);
        attrContainer.attribute(LibraryElements.LIBRARY_ELEMENTS_ATTRIBUTE, (Object)libraryElements);
        attrContainer.attribute(Bundling.BUNDLING_ATTRIBUTE, (Object)bundling);
        attrContainer.attribute(Category.CATEGORY_ATTRIBUTE, (Object)category);
        if (buildType != null) {
            Preconditions.checkNotNull(publicationFlavorMap);
            this.applyVariantAttributes(attrContainer, buildType, publicationFlavorMap);
        }
        return config2;
    }

    private static void checkOldConfigurations(ConfigurationContainer configurations, String oldConfigName, String newConfigName) {
        if (configurations.findByName(oldConfigName) != null) {
            throw new RuntimeException(String.format("Configuration with old name %s found. Use new name %s instead.", oldConfigName, newConfigName));
        }
    }

    private Map<Attribute<ProductFlavorAttr>, ProductFlavorAttr> getFlavorAttributes(Map<Attribute<ProductFlavorAttr>, ProductFlavorAttr> flavorSelection) {
        List<ProductFlavor> productFlavors = this.variantDslInfo.getProductFlavorList();
        HashMap map2 = Maps.newHashMapWithExpectedSize((int)productFlavors.size());
        if (this.issueReporter.hasIssue(IssueReporter.Type.UNNAMED_FLAVOR_DIMENSION)) {
            return map2;
        }
        ObjectFactory objectFactory = this.project.getObjects();
        for (ProductFlavor f : productFlavors) {
            assert (f.getDimension() != null);
            map2.put(Attribute.of((String)f.getDimension(), ProductFlavorAttr.class), objectFactory.named(ProductFlavorAttr.class, f.getName()));
        }
        if (flavorSelection != null) {
            map2.putAll(flavorSelection);
        }
        return map2;
    }

    private void applyVariantAttributes(AttributeContainer attributeContainer, String buildType, Map<Attribute<ProductFlavorAttr>, ProductFlavorAttr> flavorMap2) {
        attributeContainer.attribute(BuildTypeAttr.ATTRIBUTE, (Object)this.project.getObjects().named(BuildTypeAttr.class, buildType));
        for (Map.Entry<Attribute<ProductFlavorAttr>, ProductFlavorAttr> entry : flavorMap2.entrySet()) {
            attributeContainer.attribute(entry.getKey(), (Object)entry.getValue());
        }
    }
}

