/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.ide;

import com.android.Version;
import com.android.build.api.artifact.impl.ArtifactsImpl;
import com.android.build.api.component.impl.ComponentImpl;
import com.android.build.api.dsl.ApplicationExtension;
import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.TestAndroidConfig;
import com.android.build.gradle.internal.BuildTypeData;
import com.android.build.gradle.internal.DefaultConfigData;
import com.android.build.gradle.internal.ExtraModelInfo;
import com.android.build.gradle.internal.ProductFlavorData;
import com.android.build.gradle.internal.SdkComponentsBuildService;
import com.android.build.gradle.internal.api.DefaultAndroidSourceSet;
import com.android.build.gradle.internal.component.ConsumableCreationConfig;
import com.android.build.gradle.internal.component.VariantCreationConfig;
import com.android.build.gradle.internal.core.VariantDslInfo;
import com.android.build.gradle.internal.core.VariantDslInfoImpl;
import com.android.build.gradle.internal.core.VariantSources;
import com.android.build.gradle.internal.dsl.BaseFlavor;
import com.android.build.gradle.internal.dsl.BuildType;
import com.android.build.gradle.internal.dsl.DefaultConfig;
import com.android.build.gradle.internal.dsl.LintOptions;
import com.android.build.gradle.internal.dsl.ProductFlavor;
import com.android.build.gradle.internal.dsl.SigningConfig;
import com.android.build.gradle.internal.dsl.TestOptions;
import com.android.build.gradle.internal.errors.SyncIssueReporter;
import com.android.build.gradle.internal.errors.SyncIssueReporterImpl;
import com.android.build.gradle.internal.ide.AaptOptionsImpl;
import com.android.build.gradle.internal.ide.AndroidArtifactImpl;
import com.android.build.gradle.internal.ide.AndroidGradlePluginProjectFlagsImpl;
import com.android.build.gradle.internal.ide.ArtifactMetaDataImpl;
import com.android.build.gradle.internal.ide.BuildTypeContainerImpl;
import com.android.build.gradle.internal.ide.DefaultAndroidProject;
import com.android.build.gradle.internal.ide.DefaultProjectSyncIssues;
import com.android.build.gradle.internal.ide.DependenciesImpl;
import com.android.build.gradle.internal.ide.DependenciesInfoImpl;
import com.android.build.gradle.internal.ide.DependencyFailureHandler;
import com.android.build.gradle.internal.ide.FailsafeModelBuilderParameter;
import com.android.build.gradle.internal.ide.InstantRunImpl;
import com.android.build.gradle.internal.ide.JavaArtifactImpl;
import com.android.build.gradle.internal.ide.ProductFlavorContainerImpl;
import com.android.build.gradle.internal.ide.ProductFlavorImpl;
import com.android.build.gradle.internal.ide.SigningConfigImpl;
import com.android.build.gradle.internal.ide.SourceProviderImpl;
import com.android.build.gradle.internal.ide.StudioVersions;
import com.android.build.gradle.internal.ide.TestOptionsImpl;
import com.android.build.gradle.internal.ide.TestedTargetVariantImpl;
import com.android.build.gradle.internal.ide.VariantBuildInformationImp;
import com.android.build.gradle.internal.ide.VariantImpl;
import com.android.build.gradle.internal.ide.ViewBindingOptionsImpl;
import com.android.build.gradle.internal.ide.dependencies.ArtifactCollectionsInputs;
import com.android.build.gradle.internal.ide.dependencies.BuildMappingUtils;
import com.android.build.gradle.internal.ide.dependencies.DependencyGraphBuilder;
import com.android.build.gradle.internal.ide.dependencies.DependencyGraphBuilderKt;
import com.android.build.gradle.internal.ide.dependencies.Level1DependencyModelBuilder;
import com.android.build.gradle.internal.ide.dependencies.Level2DependencyModelBuilder;
import com.android.build.gradle.internal.ide.dependencies.LibraryDependencyCacheBuildService;
import com.android.build.gradle.internal.ide.dependencies.LibraryUtils;
import com.android.build.gradle.internal.ide.level2.EmptyDependencyGraphs;
import com.android.build.gradle.internal.ide.level2.GlobalLibraryMapImpl;
import com.android.build.gradle.internal.lint.CustomLintCheckUtils;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.MutableTaskContainer;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.services.BuildServicesKt;
import com.android.build.gradle.internal.tasks.DeviceProviderInstrumentTestTask;
import com.android.build.gradle.internal.tasks.ExportConsumerProguardFilesTask;
import com.android.build.gradle.internal.tasks.ExtractApksTask;
import com.android.build.gradle.internal.utils.DesugarLibUtils;
import com.android.build.gradle.internal.variant.VariantInputModel;
import com.android.build.gradle.internal.variant.VariantModel;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.ProjectOptionService;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.options.SyncOptions;
import com.android.builder.compiling.BuildConfigType;
import com.android.builder.core.DefaultManifestParser;
import com.android.builder.core.ManifestAttributeSupplier;
import com.android.builder.core.VariantType;
import com.android.builder.core.VariantTypeImpl;
import com.android.builder.dexing.D8DesugaredMethodsGenerator;
import com.android.builder.errors.IssueReporter;
import com.android.builder.model.AaptOptions;
import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.AndroidGradlePluginProjectFlags;
import com.android.builder.model.AndroidProject;
import com.android.builder.model.BaseArtifact;
import com.android.builder.model.Dependencies;
import com.android.builder.model.JavaArtifact;
import com.android.builder.model.ModelBuilderParameter;
import com.android.builder.model.NativeToolchain;
import com.android.builder.model.ProductFlavorContainer;
import com.android.builder.model.ProjectSyncIssues;
import com.android.builder.model.SyncIssue;
import com.android.builder.model.TestedTargetVariant;
import com.android.builder.model.Variant;
import com.android.builder.model.VariantBuildInformation;
import com.android.builder.model.level2.DependencyGraphs;
import com.android.builder.model.level2.GlobalLibraryMap;
import com.android.utils.Pair;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.gradle.StartParameter;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.Provider;
import org.gradle.api.services.BuildServiceRegistry;
import org.gradle.tooling.provider.model.ParameterizedToolingModelBuilder;

public class ModelBuilder<Extension extends BaseExtension>
implements ParameterizedToolingModelBuilder<ModelBuilderParameter> {
    protected final GlobalScope globalScope;
    protected final Extension extension;
    private final ExtraModelInfo extraModelInfo;
    private final VariantModel variantModel;
    private final SyncIssueReporter syncIssueReporter;
    private final int projectType;
    private int modelLevel = 0;
    private boolean modelWithFullDependency = false;
    private ImmutableMap<String, String> buildMapping = null;

    public ModelBuilder(GlobalScope globalScope, VariantModel variantModel, Extension extension, ExtraModelInfo extraModelInfo, SyncIssueReporter syncIssueReporter, int projectType) {
        this.globalScope = globalScope;
        this.extension = extension;
        this.extraModelInfo = extraModelInfo;
        this.variantModel = variantModel;
        this.syncIssueReporter = syncIssueReporter;
        this.projectType = projectType;
    }

    public boolean canBuild(String modelName) {
        return modelName.equals(AndroidProject.class.getName()) || modelName.equals(GlobalLibraryMap.class.getName()) || modelName.equals(Variant.class.getName()) || modelName.equals(ProjectSyncIssues.class.getName());
    }

    public Object buildAll(String modelName, Project project) {
        this.initBuildMapping(project);
        if (modelName.equals(AndroidProject.class.getName())) {
            return this.buildAndroidProject(project, true);
        }
        if (modelName.equals(Variant.class.getName())) {
            throw new RuntimeException("Please use parameterized tooling API to obtain Variant model.");
        }
        return this.buildNonParameterizedModels(modelName);
    }

    public Object buildAll(String modelName, ModelBuilderParameter parameter, Project project) {
        parameter = new FailsafeModelBuilderParameter(parameter);
        this.initBuildMapping(project);
        if (modelName.equals(AndroidProject.class.getName())) {
            return this.buildAndroidProject(project, parameter.getShouldBuildVariant());
        }
        if (modelName.equals(Variant.class.getName())) {
            return this.buildVariant(project, parameter.getVariantName(), parameter.getShouldGenerateSources());
        }
        return this.buildNonParameterizedModels(modelName);
    }

    private Object buildNonParameterizedModels(String modelName) {
        if (modelName.equals(GlobalLibraryMap.class.getName())) {
            return ModelBuilder.buildGlobalLibraryMap(this.globalScope.getProject().getGradle().getSharedServices());
        }
        if (modelName.equals(ProjectSyncIssues.class.getName())) {
            return this.buildProjectSyncIssuesModel();
        }
        throw new RuntimeException("Invalid model requested: " + modelName);
    }

    public Class<ModelBuilderParameter> getParameterType() {
        return ModelBuilderParameter.class;
    }

    private static Object buildGlobalLibraryMap(BuildServiceRegistry buildServiceRegistry) {
        LibraryDependencyCacheBuildService libraryDependencyCacheBuildService = (LibraryDependencyCacheBuildService)BuildServicesKt.getBuildService(buildServiceRegistry, LibraryDependencyCacheBuildService.class).get();
        return new GlobalLibraryMapImpl(libraryDependencyCacheBuildService.getGlobalLibMap());
    }

    private Object buildProjectSyncIssuesModel() {
        this.syncIssueReporter.lockHandler();
        ImmutableSet.Builder allIssues = ImmutableSet.builder();
        allIssues.addAll(this.syncIssueReporter.getSyncIssues());
        allIssues.addAll(((SyncIssueReporterImpl.GlobalSyncIssueService)BuildServicesKt.getBuildService(this.globalScope.getProject().getGradle().getSharedServices(), SyncIssueReporterImpl.GlobalSyncIssueService.class).get()).getAllIssuesAndClear());
        return new DefaultProjectSyncIssues((Collection<? extends SyncIssue>)allIssues.build());
    }

    private Object buildAndroidProject(Project project, boolean shouldBuildVariant) {
        ProjectOptionService optionService = (ProjectOptionService)BuildServicesKt.getBuildService(project.getGradle().getSharedServices(), ProjectOptionService.class).get();
        ProjectOptions projectOptions = optionService.getProjectOptions();
        Integer modelLevelInt = SyncOptions.buildModelOnlyVersion(projectOptions, project);
        if (modelLevelInt != null) {
            this.modelLevel = modelLevelInt;
        }
        if (this.modelLevel < 3) {
            throw new RuntimeException("This Gradle plugin requires a newer IDE able to request IDE model level 3. For Android Studio this means version 3.0+");
        }
        StudioVersions.verifyIDEIsNotOld(projectOptions);
        this.modelWithFullDependency = projectOptions.get(BooleanOption.IDE_BUILD_MODEL_FEATURE_FULL_DEPENDENCIES);
        List<String> bootClasspath = (Boolean)((SdkComponentsBuildService.VersionedSdkLoader)this.globalScope.getVersionedSdkLoader().get()).getSdkSetupCorrectly().get() != false ? ((List)this.globalScope.getFilteredBootClasspath().get()).stream().map(it -> it.getAsFile().getAbsolutePath()).collect(Collectors.toList()) : Collections.emptyList();
        List<File> frameworkSource = Collections.emptyList();
        ArrayList artifactMetaDataList = Lists.newArrayList(this.extraModelInfo.getExtraArtifacts());
        for (VariantType variantType : VariantType.Companion.getTestComponents()) {
            artifactMetaDataList.add(new ArtifactMetaDataImpl(variantType.getArtifactName(), true, variantType.getArtifactType()));
        }
        com.android.builder.model.LintOptions lintOptions = LintOptions.create(((BaseExtension)this.extension).getLintOptions());
        AaptOptions aaptOptions2 = AaptOptionsImpl.create(((BaseExtension)this.extension).getAaptOptions());
        boolean viewBinding = this.variantModel.getVariants().stream().anyMatch(variantProperties -> variantProperties.getBuildFeatures().getViewBinding());
        ViewBindingOptionsImpl viewBindingOptions = new ViewBindingOptionsImpl(viewBinding);
        DependenciesInfoImpl dependenciesInfo2 = null;
        if (this.extension instanceof ApplicationExtension) {
            ApplicationExtension applicationExtension = (ApplicationExtension)this.extension;
            boolean inApk = applicationExtension.getDependenciesInfo().getIncludeInApk();
            boolean inBundle = applicationExtension.getDependenciesInfo().getIncludeInBundle();
            dependenciesInfo2 = new DependenciesInfoImpl(inApk, inBundle);
        }
        ArrayList flavorDimensionList = ((BaseExtension)this.extension).getFlavorDimensionList() != null ? ((BaseExtension)this.extension).getFlavorDimensionList() : Lists.newArrayList();
        VariantInputModel<DefaultConfig, BuildType, ProductFlavor, SigningConfig> variantInputs = this.variantModel.getInputs();
        DefaultConfigData<DefaultConfig> defaultConfigData = variantInputs.getDefaultConfigData();
        ProductFlavorContainer defaultConfig = ProductFlavorContainerImpl.createProductFlavorContainer(defaultConfigData, defaultConfigData.getDefaultConfig(), this.extraModelInfo.getExtraFlavorSourceProviders("main"));
        ArrayList buildTypes = Lists.newArrayList();
        ArrayList productFlavors = Lists.newArrayList();
        ArrayList variants = Lists.newArrayList();
        ArrayList variantNames = Lists.newArrayList();
        for (BuildTypeData<BuildType> buildTypeData : variantInputs.getBuildTypes().values()) {
            buildTypes.add(BuildTypeContainerImpl.create(buildTypeData, this.extraModelInfo.getExtraBuildTypeSourceProviders(buildTypeData.getBuildType().getName())));
        }
        for (ProductFlavorData productFlavorData : variantInputs.getProductFlavors().values()) {
            productFlavors.add(ProductFlavorContainerImpl.createProductFlavorContainer(productFlavorData, (BaseFlavor)productFlavorData.getProductFlavor(), this.extraModelInfo.getExtraFlavorSourceProviders(((ProductFlavor)productFlavorData.getProductFlavor()).getName())));
        }
        String defaultVariant = this.variantModel.getDefaultVariant();
        for (com.android.build.api.variant.impl.VariantImpl variant : this.variantModel.getVariants()) {
            variantNames.add(variant.getName());
            if (!shouldBuildVariant) continue;
            variants.add(this.createVariant(variant));
        }
        String string = project.getGroup().toString();
        AndroidGradlePluginProjectFlagsImpl flags = this.getFlags();
        Collection variantBuildOutputs = this.variantModel.getVariants().stream().map(this::createBuildInformation).collect(Collectors.toList());
        return new DefaultAndroidProject(project.getName(), string, defaultConfig, flavorDimensionList, buildTypes, productFlavors, variants, variantNames, defaultVariant, this.globalScope.getExtension().getCompileSdkVersion(), (Collection<String>)bootClasspath, (Collection<File>)frameworkSource, ModelBuilder.cloneSigningConfigs(((BaseExtension)this.extension).getSigningConfigs()), aaptOptions2, artifactMetaDataList, (Collection<SyncIssue>)ImmutableList.of(), ((BaseExtension)this.extension).getCompileOptions(), lintOptions, (List<File>)CustomLintCheckUtils.getLocalCustomLintChecksForModel(project, this.syncIssueReporter), project.getBuildDir(), ((BaseExtension)this.extension).getResourcePrefix(), (Collection<NativeToolchain>)ImmutableList.of(), ((BaseExtension)this.extension).getBuildToolsVersion(), ((BaseExtension)this.extension).getNdkVersion(), this.projectType, Version.BUILDER_MODEL_API_VERSION, this.isBaseSplit(), this.getDynamicFeatures(), viewBindingOptions, dependenciesInfo2, flags, variantBuildOutputs);
    }

    private VariantBuildInformation createBuildInformation(ComponentImpl component2) {
        return new VariantBuildInformationImp(component2.getName(), component2.getTaskContainer().assembleTask.getName(), ModelBuilder.toAbsolutePath((RegularFile)component2.getArtifacts().get(InternalArtifactType.APK_IDE_MODEL.INSTANCE).getOrNull()), component2.getTaskContainer().getBundleTask() == null ? component2.computeTaskName("bundle") : component2.getTaskContainer().getBundleTask().getName(), ModelBuilder.toAbsolutePath((RegularFile)component2.getArtifacts().get(InternalArtifactType.BUNDLE_IDE_MODEL.INSTANCE).getOrNull()), ExtractApksTask.Companion.getTaskName(component2), ModelBuilder.toAbsolutePath((RegularFile)component2.getArtifacts().get(InternalArtifactType.APK_FROM_BUNDLE_IDE_MODEL.INSTANCE).getOrNull()));
    }

    private AndroidGradlePluginProjectFlagsImpl getFlags() {
        ImmutableMap.Builder flags = ImmutableMap.builder();
        boolean finalResIds = !this.globalScope.getProjectOptions().get(BooleanOption.USE_NON_FINAL_RES_IDS);
        flags.put((Object)AndroidGradlePluginProjectFlags.BooleanFlag.APPLICATION_R_CLASS_CONSTANT_IDS, (Object)finalResIds);
        flags.put((Object)AndroidGradlePluginProjectFlags.BooleanFlag.TEST_R_CLASS_CONSTANT_IDS, (Object)finalResIds);
        flags.put((Object)AndroidGradlePluginProjectFlags.BooleanFlag.JETPACK_COMPOSE, (Object)this.variantModel.getVariants().stream().anyMatch(variantProperties -> variantProperties.getBuildFeatures().getCompose()));
        flags.put((Object)AndroidGradlePluginProjectFlags.BooleanFlag.ML_MODEL_BINDING, (Object)this.variantModel.getVariants().stream().anyMatch(variantProperties -> variantProperties.getBuildFeatures().getMlModelBinding()));
        boolean transitiveRClass = !this.globalScope.getProjectOptions().get(BooleanOption.NON_TRANSITIVE_R_CLASS);
        flags.put((Object)AndroidGradlePluginProjectFlags.BooleanFlag.TRANSITIVE_R_CLASS, (Object)transitiveRClass);
        return new AndroidGradlePluginProjectFlagsImpl((Map<AndroidGradlePluginProjectFlags.BooleanFlag, Boolean>)flags.build());
    }

    protected boolean isBaseSplit() {
        return false;
    }

    private static String toAbsolutePath(RegularFile regularFile) {
        return regularFile != null ? regularFile.getAsFile().getAbsolutePath() : null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean inspectManifestForInstantTag(ComponentImpl component2) {
        if (this.projectType != 0 && this.projectType != 6) {
            return false;
        }
        VariantSources variantSources = component2.getVariantSources();
        ArrayList<File> manifests = new ArrayList<File>(variantSources.getManifestOverlays());
        File mainManifest = variantSources.getMainManifestIfExists();
        if (mainManifest != null) {
            manifests.add(mainManifest);
        }
        if (manifests.isEmpty()) {
            return false;
        }
        Iterator iterator = manifests.iterator();
        while (iterator.hasNext()) {
            File manifest = (File)iterator.next();
            try {
                FileInputStream inputStream = new FileInputStream(manifest);
                Throwable throwable = null;
                try {
                    XMLInputFactory factory2 = XMLInputFactory.newInstance();
                    XMLEventReader eventReader = factory2.createXMLEventReader(inputStream);
                    while (eventReader.hasNext() && !eventReader.peek().isEndDocument()) {
                        XMLEvent event = eventReader.nextTag();
                        if (event.isStartElement()) {
                            Attribute instant;
                            StartElement startElement = event.asStartElement();
                            if (!startElement.getName().getNamespaceURI().equals("http://schemas.android.com/apk/distribution") || !startElement.getName().getLocalPart().equalsIgnoreCase("module") || (instant = startElement.getAttributeByName(new QName("http://schemas.android.com/apk/distribution", "instant"))) == null || !instant.getValue().equals("true") && !instant.getValue().equals("1")) continue;
                            eventReader.close();
                            boolean bl = true;
                            return bl;
                        }
                        if (!event.isEndElement() || !((EndElement)event).getName().getLocalPart().equalsIgnoreCase("manifest")) continue;
                    }
                    eventReader.close();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (inputStream == null) continue;
                    if (throwable != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    inputStream.close();
                }
            }
            catch (IOException | XMLStreamException e) {
                this.syncIssueReporter.reportError(IssueReporter.Type.GENERIC, "Failed to parse XML in " + manifest.getPath() + "\n" + e.getMessage());
            }
        }
        return false;
    }

    protected Collection<String> getDynamicFeatures() {
        return ImmutableList.of();
    }

    private VariantImpl buildVariant(Project project, String variantName, boolean shouldScheduleSourceGeneration) {
        if (variantName == null) {
            throw new IllegalArgumentException("Variant name cannot be null.");
        }
        for (com.android.build.api.variant.impl.VariantImpl variantImpl : this.variantModel.getVariants()) {
            if (!variantImpl.getName().equals(variantName)) continue;
            VariantImpl variant = this.createVariant(variantImpl);
            if (shouldScheduleSourceGeneration) {
                ModelBuilder.scheduleSourceGeneration(project, variant);
            }
            return variant;
        }
        throw new IllegalArgumentException(String.format("Variant with name '%s' doesn't exist.", variantName));
    }

    private static void scheduleSourceGeneration(Project project, Variant variant) {
        ArrayList artifacts2 = Lists.newArrayList((Object[])new BaseArtifact[]{variant.getMainArtifact()});
        artifacts2.addAll(variant.getExtraAndroidArtifacts());
        artifacts2.addAll(variant.getExtraJavaArtifacts());
        Set sourceGenerationTasks = artifacts2.stream().map(BaseArtifact::getIdeSetupTaskNames).flatMap(Collection::stream).map(taskName -> project.getPath() + ":" + taskName).collect(Collectors.toSet());
        try {
            StartParameter startParameter = project.getGradle().getStartParameter();
            HashSet tasks = new HashSet(startParameter.getTaskNames());
            tasks.addAll(sourceGenerationTasks);
            startParameter.setTaskNames(tasks);
        }
        catch (Throwable e) {
            throw new RuntimeException("Can't modify scheduled tasks at current build step", e);
        }
    }

    private VariantImpl createVariant(ComponentImpl component2) {
        AndroidArtifact mainArtifact = this.createAndroidArtifact("_main_", component2);
        VariantDslInfoImpl variantDslInfo = (VariantDslInfoImpl)component2.getVariantDslInfo();
        File manifest = component2.getVariantSources().getMainManifestIfExists();
        if (manifest != null) {
            DefaultManifestParser attributeSupplier = new DefaultManifestParser(manifest, () -> true, component2.getVariantType().getRequiresManifest(), (IssueReporter)this.syncIssueReporter);
            try {
                this.validateMinSdkVersion((ManifestAttributeSupplier)attributeSupplier);
                this.validateTargetSdkVersion((ManifestAttributeSupplier)attributeSupplier);
            }
            catch (Throwable e) {
                this.syncIssueReporter.reportError(IssueReporter.Type.GENERIC, "Failed to parse XML in " + manifest.getPath() + "\n" + e.getMessage());
            }
        }
        String variantName = component2.getName();
        ArrayList extraAndroidArtifacts = Lists.newArrayList(this.extraModelInfo.getExtraAndroidArtifacts(variantName));
        LibraryDependencyCacheBuildService libraryDependencyCache = (LibraryDependencyCacheBuildService)BuildServicesKt.getBuildService(component2.getServices().getBuildServiceRegistry(), LibraryDependencyCacheBuildService.class).get();
        List<JavaArtifact> clonedExtraJavaArtifacts = this.extraModelInfo.getExtraJavaArtifacts(variantName).stream().map(javaArtifact -> JavaArtifactImpl.clone(javaArtifact, this.modelLevel, this.modelWithFullDependency, libraryDependencyCache)).collect(Collectors.toList());
        if (component2 instanceof com.android.build.api.variant.impl.VariantImpl) {
            com.android.build.api.variant.impl.VariantImpl variant = (com.android.build.api.variant.impl.VariantImpl)component2;
            block6: for (VariantType variantType : VariantType.Companion.getTestComponents()) {
                ComponentImpl testVariant = variant.getTestComponents().get(variantType);
                if (testVariant == null) continue;
                switch ((VariantTypeImpl)variantType) {
                    case ANDROID_TEST: {
                        extraAndroidArtifacts.add(this.createAndroidArtifact(variantType.getArtifactName(), testVariant));
                        continue block6;
                    }
                    case UNIT_TEST: {
                        clonedExtraJavaArtifacts.add(this.createUnitTestsJavaArtifact(variantType, testVariant));
                        continue block6;
                    }
                }
                throw new IllegalArgumentException("Unsupported test variant type ${variantType}.");
            }
        }
        Collection<TestedTargetVariant> testTargetVariants = this.getTestTargetVariants(component2);
        this.checkProguardFiles(component2);
        return new VariantImpl(variantName, component2.getBaseName(), component2.getBuildType(), ModelBuilder.getProductFlavorNames(component2), new ProductFlavorImpl(variantDslInfo.getMergedFlavor(), (Provider<String>)variantDslInfo.getApplicationId()), mainArtifact, extraAndroidArtifacts, clonedExtraJavaArtifacts, testTargetVariants, this.inspectManifestForInstantTag(component2), component2 instanceof VariantCreationConfig ? this.getDesugaredMethods((VariantCreationConfig)((Object)component2)) : ImmutableList.of());
    }

    private void checkProguardFiles(ComponentImpl component2) {
        Project project = this.globalScope.getProject();
        boolean isBaseModule = component2.getVariantType().isBaseModule();
        boolean isDynamicFeature = component2.getVariantType().isDynamicFeature();
        if (!isBaseModule) {
            List<File> consumerProguardFiles = component2.getVariantScope().getConsumerProguardFilesForFeatures();
            ExportConsumerProguardFilesTask.checkProguardFiles(project.getLayout().getBuildDirectory(), isDynamicFeature, consumerProguardFiles, errorMessage -> this.syncIssueReporter.reportError(IssueReporter.Type.GENERIC, (String)errorMessage));
        }
    }

    private Collection<TestedTargetVariant> getTestTargetVariants(ComponentImpl component2) {
        if (this.extension instanceof TestAndroidConfig) {
            TestAndroidConfig testConfig = (TestAndroidConfig)this.extension;
            ArtifactCollection apkArtifacts = component2.getVariantDependencies().getArtifactCollection(AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.MANIFEST_METADATA);
            if (apkArtifacts.getArtifacts().size() == 1) {
                ResolvedArtifactResult result2 = (ResolvedArtifactResult)Iterables.getOnlyElement((Iterable)apkArtifacts.getArtifacts());
                String variant = LibraryUtils.getVariantName(result2);
                return ImmutableList.of((Object)new TestedTargetVariantImpl(testConfig.getTargetProjectPath(), variant));
            }
            if (!apkArtifacts.getFailures().isEmpty()) {
                new DependencyFailureHandler().addErrors(this.globalScope.getProject().getPath() + "@" + component2.getName() + "/testTarget", apkArtifacts.getFailures()).registerIssues(this.syncIssueReporter);
            }
        }
        return ImmutableList.of();
    }

    private JavaArtifactImpl createUnitTestsJavaArtifact(VariantType variantType, ComponentImpl component2) {
        ArtifactsImpl artifacts2 = component2.getArtifacts();
        SourceProviders sourceProviders = ModelBuilder.determineSourceProviders(component2);
        Pair<Dependencies, DependencyGraphs> result2 = this.getDependencies(component2, this.buildMapping, this.modelLevel, this.modelWithFullDependency);
        HashSet<File> additionalTestClasses = new HashSet<File>();
        additionalTestClasses.addAll(component2.getVariantData().getAllPreJavacGeneratedBytecode().getFiles());
        additionalTestClasses.addAll(component2.getVariantData().getAllPostJavacGeneratedBytecode().getFiles());
        if (component2.getGlobalScope().getExtension().getTestOptions().getUnitTests().isIncludeAndroidResources()) {
            additionalTestClasses.add(((Directory)artifacts2.get(InternalArtifactType.UNIT_TEST_CONFIG_DIRECTORY.INSTANCE).get()).getAsFile());
        }
        if (!this.globalScope.getExtension().getAaptOptions().getNamespaced() && component2.getBuildFeatures().getAndroidResources()) {
            additionalTestClasses.add(((RegularFile)component2.getVariantScope().getRJarForUnitTests().get()).getAsFile());
        }
        File mockableJar = this.globalScope.getMockableJarArtifact().getFiles().stream().findFirst().orElse(null);
        return new JavaArtifactImpl(variantType.getArtifactName(), component2.getTaskContainer().getAssembleTask().getName(), component2.getTaskContainer().getCompileTask().getName(), Sets.newHashSet((Object[])new String[]{"createMockableJar"}), ModelBuilder.getGeneratedSourceFoldersForUnitTests(component2), ((Directory)artifacts2.get(InternalArtifactType.JAVAC.INSTANCE).get()).getAsFile(), additionalTestClasses, component2.getVariantData().getJavaResourcesForUnitTesting(), mockableJar, (Dependencies)result2.getFirst(), (DependencyGraphs)result2.getSecond(), sourceProviders.variantSourceProvider, sourceProviders.multiFlavorSourceProvider);
    }

    private Pair<Dependencies, DependencyGraphs> getDependencies(ComponentImpl component2, ImmutableMap<String, String> buildMapping, int modelLevel, boolean modelWithFullDependency) {
        Pair result2;
        if (this.syncIssueReporter.hasIssue(IssueReporter.Type.UNNAMED_FLAVOR_DIMENSION)) {
            result2 = Pair.of((Object)DependenciesImpl.EMPTY, (Object)EmptyDependencyGraphs.EMPTY);
        } else {
            DependencyGraphBuilder graphBuilder = DependencyGraphBuilderKt.getDependencyGraphBuilder();
            if (modelLevel >= 4) {
                Level2DependencyModelBuilder modelBuilder = new Level2DependencyModelBuilder(component2.getServices().getBuildServiceRegistry());
                ArtifactCollectionsInputs artifactCollectionsInputs = new ArtifactCollectionsInputs(component2, ArtifactCollectionsInputs.RuntimeType.FULL, buildMapping);
                graphBuilder.createDependencies(modelBuilder, artifactCollectionsInputs, modelWithFullDependency, this.syncIssueReporter);
                result2 = Pair.of((Object)DependenciesImpl.EMPTY, (Object)modelBuilder.createModel());
            } else {
                Level1DependencyModelBuilder modelBuilder = new Level1DependencyModelBuilder(component2.getServices().getBuildServiceRegistry());
                ArtifactCollectionsInputs artifactCollectionsInputs = new ArtifactCollectionsInputs(component2, ArtifactCollectionsInputs.RuntimeType.PARTIAL, buildMapping);
                graphBuilder.createDependencies(modelBuilder, artifactCollectionsInputs, modelWithFullDependency, this.syncIssueReporter);
                result2 = Pair.of((Object)modelBuilder.createModel(), (Object)EmptyDependencyGraphs.EMPTY);
            }
        }
        return result2;
    }

    private AndroidArtifact createAndroidArtifact(String name2, ComponentImpl component2) {
        VariantScope variantScope = component2.getVariantScope();
        VariantDslInfo variantDslInfo = component2.getVariantDslInfo();
        SigningConfig signingConfig2 = variantDslInfo.getSigningConfig();
        String signingConfigName = null;
        if (signingConfig2 != null) {
            signingConfigName = signingConfig2.getName();
        }
        SourceProviders sourceProviders = ModelBuilder.determineSourceProviders(component2);
        InstantRunImpl instantRun = new InstantRunImpl(this.globalScope.getProject().file((Object)"build_info_removed"), 7);
        Pair<Dependencies, DependencyGraphs> dependencies = this.getDependencies(component2, this.buildMapping, this.modelLevel, this.modelWithFullDependency);
        HashSet<File> additionalClasses = new HashSet<File>();
        additionalClasses.addAll(component2.getVariantData().getAllPreJavacGeneratedBytecode().getFiles());
        additionalClasses.addAll(component2.getVariantData().getAllPostJavacGeneratedBytecode().getFiles());
        additionalClasses.addAll(component2.getCompiledRClasses(AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH).getFiles());
        ArrayList<File> additionalRuntimeApks = new ArrayList<File>();
        TestOptionsImpl testOptions = null;
        if (component2.getVariantType().isTestComponent()) {
            Configuration testHelpers = (Configuration)this.globalScope.getProject().getConfigurations().findByName("androidTestUtil");
            if (testHelpers != null) {
                additionalRuntimeApks.addAll(testHelpers.getFiles());
            }
            DeviceProviderInstrumentTestTask.checkForNonApks(additionalRuntimeApks, message -> this.syncIssueReporter.reportError(IssueReporter.Type.GENERIC, (String)message));
            TestOptions testOptionsDsl = this.globalScope.getExtension().getTestOptions();
            testOptions = new TestOptionsImpl(testOptionsDsl.getAnimationsDisabled(), testOptionsDsl.getExecutionEnum());
        }
        MutableTaskContainer taskContainer = component2.getTaskContainer();
        ArtifactsImpl artifacts2 = component2.getArtifacts();
        return new AndroidArtifactImpl(name2, this.globalScope.getProjectBaseName() + "-" + component2.getBaseName(), taskContainer.getAssembleTask().getName(), (RegularFile)artifacts2.get(InternalArtifactType.APK_IDE_MODEL.INSTANCE).getOrNull(), variantDslInfo.isSigningReady() || component2.getVariantData().outputsAreSigned, signingConfigName, taskContainer.getSourceGenTask().getName(), taskContainer.getCompileTask().getName(), ModelBuilder.getGeneratedSourceFolders(component2), ModelBuilder.getGeneratedResourceFolders(component2), ((Directory)artifacts2.get(InternalArtifactType.JAVAC.INSTANCE).get()).getAsFile(), additionalClasses, component2.getVariantData().getJavaResourcesForUnitTesting(), (Dependencies)dependencies.getFirst(), (DependencyGraphs)dependencies.getSecond(), additionalRuntimeApks, sourceProviders.variantSourceProvider, sourceProviders.multiFlavorSourceProvider, variantDslInfo.getSupportedAbis(), instantRun, testOptions, taskContainer.getConnectedTask() == null ? null : taskContainer.getConnectedTask().getName(), taskContainer.getBundleTask() == null ? component2.computeTaskName("bundle") : taskContainer.getBundleTask().getName(), (RegularFile)artifacts2.get(InternalArtifactType.BUNDLE_IDE_MODEL.INSTANCE).getOrNull(), ExtractApksTask.Companion.getTaskName(component2), (RegularFile)artifacts2.get(InternalArtifactType.APK_FROM_BUNDLE_IDE_MODEL.INSTANCE).getOrNull(), component2 instanceof ConsumableCreationConfig ? ((ConsumableCreationConfig)((Object)component2)).getCodeShrinker() : null);
    }

    private void validateMinSdkVersion(ManifestAttributeSupplier supplier) {
        if (supplier.getMinSdkVersion() != null) {
            this.syncIssueReporter.reportError(IssueReporter.Type.MIN_SDK_VERSION_IN_MANIFEST, "The minSdk version should not be declared in the android manifest file. You can move the version from the manifest to the defaultConfig in the build.gradle file.");
        }
    }

    private void validateTargetSdkVersion(ManifestAttributeSupplier supplier) {
        if (supplier.getTargetSdkVersion() != null) {
            this.syncIssueReporter.reportWarning(IssueReporter.Type.TARGET_SDK_VERSION_IN_MANIFEST, "The targetSdk version should not be declared in the android manifest file. You can move the version from the manifest to the defaultConfig in the build.gradle file.");
        }
    }

    private static SourceProviders determineSourceProviders(ComponentImpl component2) {
        DefaultAndroidSourceSet variantSourceProvider = component2.getVariantSources().getVariantSourceProvider();
        DefaultAndroidSourceSet multiFlavorSourceProvider = component2.getVariantSources().getMultiFlavorSourceProvider();
        return new SourceProviders(variantSourceProvider != null ? new SourceProviderImpl(variantSourceProvider) : null, multiFlavorSourceProvider != null ? new SourceProviderImpl(multiFlavorSourceProvider) : null);
    }

    private static List<String> getProductFlavorNames(ComponentImpl component2) {
        return component2.getProductFlavors().stream().map(kotlin.Pair::getSecond).collect(Collectors.toList());
    }

    public static List<File> getGeneratedSourceFoldersForUnitTests(ComponentImpl component2) {
        if (component2 == null) {
            return Collections.emptyList();
        }
        ArrayList folders = Lists.newArrayList(component2.getVariantData().getExtraGeneratedSourceFolders());
        folders.add(((Directory)component2.getArtifacts().get(InternalArtifactType.AP_GENERATED_SOURCES.INSTANCE).get()).getAsFile());
        return folders;
    }

    public static List<File> getGeneratedSourceFolders(ComponentImpl component2) {
        Directory renderscriptSources;
        boolean ndkMode;
        if (component2 == null) {
            return Collections.emptyList();
        }
        ArtifactsImpl operations = component2.getArtifacts();
        boolean isDataBindingEnabled = component2.getBuildFeatures().getDataBinding();
        boolean isViewBindingEnabled = component2.getBuildFeatures().getViewBinding();
        Directory dataBindingSources = (Directory)operations.get(InternalArtifactType.DATA_BINDING_BASE_CLASS_SOURCE_OUT.INSTANCE).getOrNull();
        boolean addBindingSources = (isDataBindingEnabled || isViewBindingEnabled) && dataBindingSources != null;
        List<File> extraFolders = ModelBuilder.getGeneratedSourceFoldersForUnitTests(component2);
        int additionalFolders = 4;
        if (addBindingSources) {
            ++additionalFolders;
        }
        ArrayList folders = Lists.newArrayListWithExpectedSize((int)(additionalFolders + extraFolders.size()));
        folders.addAll(extraFolders);
        Directory aidlSources = (Directory)operations.get(InternalArtifactType.AIDL_SOURCE_OUTPUT_DIR.INSTANCE).getOrNull();
        if (aidlSources != null) {
            folders.add(aidlSources.getAsFile());
        }
        if (component2.getBuildConfigType() == BuildConfigType.JAVA_CLASS) {
            folders.add(component2.getPaths().getBuildConfigSourceOutputDir());
        }
        if (!(ndkMode = component2.getVariantDslInfo().getRenderscriptNdkModeEnabled()) && (renderscriptSources = (Directory)operations.get(InternalArtifactType.RENDERSCRIPT_SOURCE_OUTPUT_DIR.INSTANCE).getOrNull()) != null) {
            folders.add(renderscriptSources.getAsFile());
        }
        if (addBindingSources) {
            folders.add(dataBindingSources.getAsFile());
        }
        return folders;
    }

    public static List<File> getGeneratedResourceFolders(ComponentImpl component2) {
        ArrayList result2;
        Set extraFolders;
        if (component2 == null) {
            return Collections.emptyList();
        }
        ConfigurableFileCollection extraResFolders = component2.getVariantData().getExtraGeneratedResFolders();
        Set set = extraFolders = extraResFolders != null ? extraResFolders.getFiles() : null;
        if (extraFolders != null && !extraFolders.isEmpty()) {
            result2 = Lists.newArrayListWithCapacity((int)(extraFolders.size() + 2));
            result2.addAll(extraFolders);
        } else {
            result2 = Lists.newArrayListWithCapacity((int)2);
        }
        result2.add(component2.getPaths().getRenderscriptResOutputDir());
        result2.add(component2.getPaths().getGeneratedResOutputDir());
        return result2;
    }

    private static Collection<com.android.builder.model.SigningConfig> cloneSigningConfigs(Collection<? extends com.android.builder.model.SigningConfig> signingConfigs) {
        return signingConfigs.stream().map(SigningConfigImpl::createSigningConfig).collect(Collectors.toList());
    }

    private void initBuildMapping(Project project) {
        if (this.buildMapping == null) {
            this.buildMapping = BuildMappingUtils.computeBuildMapping(project.getGradle());
        }
    }

    private List<String> getDesugaredMethods(VariantCreationConfig creationConfig) {
        List<String> desugaredMethodsFromDesugarLib = DesugarLibUtils.getDesugaredMethods(creationConfig.getGlobalScope().getProject(), creationConfig.isCoreLibraryDesugaringEnabled(), creationConfig.getMinSdkVersion(), creationConfig.getGlobalScope().getExtension().getCompileSdkVersion());
        List desugaredMethodsFromD8 = D8DesugaredMethodsGenerator.INSTANCE.generate();
        ArrayList<String> desugaredMethods = new ArrayList<String>(desugaredMethodsFromDesugarLib);
        desugaredMethods.addAll(desugaredMethodsFromD8);
        return desugaredMethods;
    }

    private static class SourceProviders {
        protected SourceProviderImpl variantSourceProvider;
        protected SourceProviderImpl multiFlavorSourceProvider;

        public SourceProviders(SourceProviderImpl variantSourceProvider, SourceProviderImpl multiFlavorSourceProvider) {
            this.variantSourceProvider = variantSourceProvider;
            this.multiFlavorSourceProvider = multiFlavorSourceProvider;
        }
    }
}

