/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.incremental;

import com.android.tools.build.apkzlib.zfile.ApkCreator;
import com.android.tools.build.apkzlib.zfile.ApkCreatorFactory;
import com.android.tools.build.apkzlib.zip.CentralDirectoryHeader;
import com.android.tools.build.apkzlib.zip.StoredEntry;
import com.android.tools.build.apkzlib.zip.ZFile;
import com.android.tools.build.apkzlib.zip.ZFileOptions;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.StandardCopyOption;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\tH\u0016J8\u0010\u000f\u001a\u00020\u00062\b\u0010\u0010\u001a\u0004\u0018\u00010\u000e2\u0014\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t\u0018\u00010\u00122\u000e\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u0014H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/android/build/gradle/internal/incremental/FolderBasedApkCreator;", "Lcom/android/tools/build/apkzlib/zfile/ApkCreator;", "creationData", "Lcom/android/tools/build/apkzlib/zfile/ApkCreatorFactory$CreationData;", "(Lcom/android/tools/build/apkzlib/zfile/ApkCreatorFactory$CreationData;)V", "close", "", "deleteFile", "entryPath", "", "hasPendingChangesWithWait", "", "writeFile", "inputFile", "Ljava/io/File;", "writeZip", "zip", "transform", "Lcom/google/common/base/Function;", "isIgnored", "Lcom/google/common/base/Predicate;", "Companion", "gradle-core"})
public final class FolderBasedApkCreator
implements ApkCreator {
    private final ApkCreatorFactory.CreationData creationData;
    @NotNull
    public static final Companion Companion = new Companion(null);

    public void writeZip(@Nullable File zip, @Nullable Function<String, String> transform2, @Nullable Predicate<String> isIgnored) {
        if (zip == null) {
            return;
        }
        Companion.proccessZipEntry(zip, isIgnored, (Function1<? super StoredEntry, Unit>)((Function1)new Function1<StoredEntry, Unit>(this){
            final /* synthetic */ FolderBasedApkCreator this$0;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke(@NotNull StoredEntry entry) {
                Intrinsics.checkParameterIsNotNull((Object)entry, (String)"entry");
                Closeable closeable = entry.open();
                boolean bl = false;
                Throwable throwable = null;
                try {
                    InputStream it = (InputStream)closeable;
                    boolean bl2 = false;
                    File file = FolderBasedApkCreator.access$getCreationData$p(this.this$0).getApkPath();
                    CentralDirectoryHeader centralDirectoryHeader = entry.getCentralDirectoryHeader();
                    Intrinsics.checkExpressionValueIsNotNull((Object)centralDirectoryHeader, (String)"entry.centralDirectoryHeader");
                    File destinationFile = new File(file, centralDirectoryHeader.getName());
                    CentralDirectoryHeader centralDirectoryHeader2 = entry.getCentralDirectoryHeader();
                    Intrinsics.checkExpressionValueIsNotNull((Object)centralDirectoryHeader2, (String)"entry.centralDirectoryHeader");
                    String string = centralDirectoryHeader2.getName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"entry.centralDirectoryHeader.name");
                    if (StringsKt.contains$default((CharSequence)string, (CharSequence)"../", (boolean)false, (int)2, null)) {
                        CentralDirectoryHeader centralDirectoryHeader3 = entry.getCentralDirectoryHeader();
                        Intrinsics.checkExpressionValueIsNotNull((Object)centralDirectoryHeader3, (String)"entry.centralDirectoryHeader");
                        throw (Throwable)new InvalidPathException(centralDirectoryHeader3.getName(), "Entry name contains invalid characters");
                    }
                    destinationFile.getParentFile().mkdirs();
                    Files.copy(it, destinationFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            {
                this.this$0 = folderBasedApkCreator;
                super(1);
            }
        }));
    }

    public void writeFile(@NotNull File inputFile, @NotNull String entryPath) {
        Intrinsics.checkParameterIsNotNull((Object)inputFile, (String)"inputFile");
        Intrinsics.checkParameterIsNotNull((Object)entryPath, (String)"entryPath");
        File destinationFile = new File(this.creationData.getApkPath(), entryPath);
        destinationFile.getParentFile().mkdirs();
        Files.copy(inputFile.toPath(), destinationFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    public void deleteFile(@NotNull String entryPath) {
        Intrinsics.checkParameterIsNotNull((Object)entryPath, (String)"entryPath");
        Files.deleteIfExists(new File(this.creationData.getApkPath(), entryPath).toPath());
    }

    public boolean hasPendingChangesWithWait() {
        return false;
    }

    public void close() {
    }

    public FolderBasedApkCreator(@NotNull ApkCreatorFactory.CreationData creationData) {
        Intrinsics.checkParameterIsNotNull((Object)creationData, (String)"creationData");
        this.creationData = creationData;
        File apkPath = this.creationData.getApkPath();
        if (!apkPath.exists()) {
            apkPath.mkdirs();
        }
        File file = apkPath;
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"apkPath");
        boolean bl = file.isDirectory();
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
    }

    public static final /* synthetic */ ApkCreatorFactory.CreationData access$getCreationData$p(FolderBasedApkCreator $this) {
        return $this.creationData;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J2\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u000e\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00040\u000b\u00a8\u0006\r"}, d2={"Lcom/android/build/gradle/internal/incremental/FolderBasedApkCreator$Companion;", "", "()V", "proccessZipEntry", "", "zip", "Ljava/io/File;", "isIgnored", "Lcom/google/common/base/Predicate;", "", "action", "Lkotlin/Function1;", "Lcom/android/tools/build/apkzlib/zip/StoredEntry;", "gradle-core"})
    public static final class Companion {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void proccessZipEntry(@NotNull File zip, @Nullable Predicate<String> isIgnored, @NotNull Function1<? super StoredEntry, Unit> action) {
            Intrinsics.checkParameterIsNotNull((Object)zip, (String)"zip");
            Intrinsics.checkParameterIsNotNull(action, (String)"action");
            Closeable closeable = (Closeable)new ZFile(zip, new ZFileOptions(), true);
            boolean bl = false;
            Throwable throwable = null;
            try {
                ZFile it = (ZFile)closeable;
                boolean bl2 = false;
                Set set = it.entries();
                Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"it.entries()");
                Iterable $this$forEach$iv = set;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    StoredEntry entry = (StoredEntry)element$iv;
                    boolean bl3 = false;
                    Predicate<String> predicate2 = isIgnored;
                    if (predicate2 != null) {
                        StoredEntry storedEntry = entry;
                        Intrinsics.checkExpressionValueIsNotNull((Object)storedEntry, (String)"entry");
                        CentralDirectoryHeader centralDirectoryHeader = storedEntry.getCentralDirectoryHeader();
                        Intrinsics.checkExpressionValueIsNotNull((Object)centralDirectoryHeader, (String)"entry.centralDirectoryHeader");
                        if (predicate2.test((Object)centralDirectoryHeader.getName())) continue;
                    }
                    StoredEntry storedEntry = entry;
                    Intrinsics.checkExpressionValueIsNotNull((Object)storedEntry, (String)"entry");
                    action.invoke((Object)storedEntry);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

