/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.utils;

import com.android.build.gradle.internal.errors.SyncIssueReporterImpl;
import com.android.build.gradle.internal.services.BuildServicesKt;
import com.android.build.gradle.internal.utils.AgpRepositoryChecker;
import com.android.builder.errors.IssueReporter;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.artifacts.repositories.ArtifactRepository;
import org.gradle.api.artifacts.repositories.FlatDirectoryArtifactRepository;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.initialization.dsl.ScriptHandler;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.services.BuildServiceRegistry;
import org.gradle.plugin.management.PluginManagementSpec;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/android/build/gradle/internal/utils/AgpRepositoryChecker;", "", "()V", "CHECK_PERFORMED", "", "JCENTER_URL", "maxProjectsToShow", "", "checkRepositories", "", "project", "Lorg/gradle/api/Project;", "gradle-core"})
public final class AgpRepositoryChecker {
    private static final String CHECK_PERFORMED = "android.agp.repository.check.performed";
    private static final int maxProjectsToShow = 3;
    private static final String JCENTER_URL = "https://jcenter.bintray.com/";
    @NotNull
    public static final AgpRepositoryChecker INSTANCE;

    public final void checkRepositories(@NotNull Project project) {
        Project rootProject;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Project project2 = rootProject = project.getRootProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"rootProject");
        ExtensionContainer extensionContainer = project2.getExtensions();
        Intrinsics.checkExpressionValueIsNotNull((Object)extensionContainer, (String)"rootProject.extensions");
        if (extensionContainer.getExtraProperties().has(CHECK_PERFORMED)) {
            return;
        }
        ExtensionContainer extensionContainer2 = rootProject.getExtensions();
        Intrinsics.checkExpressionValueIsNotNull((Object)extensionContainer2, (String)"rootProject.extensions");
        extensionContainer2.getExtraProperties().set(CHECK_PERFORMED, (Object)true);
        project.getGradle().projectsEvaluated((Action)new Action<Gradle>(project){
            final /* synthetic */ Project $project;

            public final void execute(Gradle gradle) {
                Object reposWithProjects2;
                Map repositories;
                boolean bl = false;
                Map flatDirReposToUsages = new LinkedHashMap<K, V>();
                boolean bl2 = false;
                Set projectsUsingJCenter = new LinkedHashSet<E>();
                Function2<String, ArtifactRepository, Unit> $fun$checkSingleRepo$1 = new Function2<String, ArtifactRepository, Unit>(flatDirReposToUsages, projectsUsingJCenter){
                    final /* synthetic */ Map $flatDirReposToUsages;
                    final /* synthetic */ Set $projectsUsingJCenter;

                    public final void invoke(@NotNull String displayName, @NotNull ArtifactRepository repo) {
                        Intrinsics.checkParameterIsNotNull((Object)displayName, (String)"displayName");
                        Intrinsics.checkParameterIsNotNull((Object)repo, (String)"repo");
                        if (repo instanceof FlatDirectoryArtifactRepository) {
                            Set set = (Set)this.$flatDirReposToUsages.get(((FlatDirectoryArtifactRepository)repo).getName());
                            if (set == null) {
                                boolean bl = false;
                                set = new LinkedHashSet<E>();
                            }
                            Set projectPaths = set;
                            projectPaths.add(displayName);
                            String string = ((FlatDirectoryArtifactRepository)repo).getName();
                            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"repo.name");
                            this.$flatDirReposToUsages.put(string, projectPaths);
                        }
                        if (repo instanceof MavenArtifactRepository && Intrinsics.areEqual((Object)((MavenArtifactRepository)repo).getUrl().toString(), (Object)"https://jcenter.bintray.com/")) {
                            this.$projectsUsingJCenter.add(displayName);
                        }
                    }
                    {
                        this.$flatDirReposToUsages = map2;
                        this.$projectsUsingJCenter = set;
                        super(2);
                    }
                };
                gradle.allprojects((Action)new Action<Project>($fun$checkSingleRepo$1){
                    final /* synthetic */ checkRepositories.1 $checkSingleRepo$1;

                    public final void execute(Project p) {
                        Project project = p;
                        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"p");
                        ScriptHandler scriptHandler = project.getBuildscript();
                        Intrinsics.checkExpressionValueIsNotNull((Object)scriptHandler, (String)"p.buildscript");
                        scriptHandler.getRepositories().all((Action)new Action<ArtifactRepository>(this, p){
                            final /* synthetic */ checkRepositories.2 this$0;
                            final /* synthetic */ Project $p;

                            public final void execute(ArtifactRepository it) {
                                checkRepositories.1 v0 = this.this$0.$checkSingleRepo$1;
                                Project project = this.$p;
                                Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"p");
                                String string = project.getDisplayName();
                                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"p.displayName");
                                ArtifactRepository artifactRepository = it;
                                Intrinsics.checkExpressionValueIsNotNull((Object)artifactRepository, (String)"it");
                                v0.invoke(string, artifactRepository);
                            }
                            {
                                this.this$0 = var1_1;
                                this.$p = project;
                            }
                        });
                        p.getRepositories().all((Action)new Action<ArtifactRepository>(this, p){
                            final /* synthetic */ checkRepositories.2 this$0;
                            final /* synthetic */ Project $p;

                            public final void execute(ArtifactRepository it) {
                                checkRepositories.1 v0 = this.this$0.$checkSingleRepo$1;
                                Project project = this.$p;
                                Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"p");
                                String string = project.getDisplayName();
                                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"p.displayName");
                                ArtifactRepository artifactRepository = it;
                                Intrinsics.checkExpressionValueIsNotNull((Object)artifactRepository, (String)"it");
                                v0.invoke(string, artifactRepository);
                            }
                            {
                                this.this$0 = var1_1;
                                this.$p = project;
                            }
                        });
                    }
                    {
                        this.$checkSingleRepo$1 = var1_1;
                    }
                });
                try {
                    Gradle gradle2 = gradle;
                    if (gradle2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.gradle.api.internal.GradleInternal");
                    }
                    SettingsInternal settingsInternal = ((GradleInternal)gradle2).getSettings();
                    Intrinsics.checkExpressionValueIsNotNull((Object)settingsInternal, (String)"(gradle as GradleInternal).settings");
                    PluginManagementSpec pluginManagementSpec = settingsInternal.getPluginManagement();
                    Intrinsics.checkExpressionValueIsNotNull((Object)pluginManagementSpec, (String)"(gradle as GradleInterna\u2026settings.pluginManagement");
                    pluginManagementSpec.getRepositories().all((Action)new Action<ArtifactRepository>($fun$checkSingleRepo$1){
                        final /* synthetic */ checkRepositories.1 $checkSingleRepo$1;

                        public final void execute(ArtifactRepository it) {
                            ArtifactRepository artifactRepository = it;
                            Intrinsics.checkExpressionValueIsNotNull((Object)artifactRepository, (String)"it");
                            this.$checkSingleRepo$1.invoke("Gradle Settings", artifactRepository);
                        }
                        {
                            this.$checkSingleRepo$1 = var1_1;
                        }
                    });
                    if (GradleVersion.current().compareTo(GradleVersion.version((String)"6.8")) >= 0) {
                        Object dependencyResolutionManagement = ((GradleInternal)gradle).getSettings().getClass().getMethod("getDependencyResolutionManagement", new Class[0]).invoke((Object)((GradleInternal)gradle).getSettings(), new Object[0]);
                        Object object = dependencyResolutionManagement.getClass().getMethod("getRepositories", new Class[0]).invoke(dependencyResolutionManagement, new Object[0]);
                        if (object == null) {
                            throw new TypeCastException("null cannot be cast to non-null type org.gradle.api.artifacts.dsl.RepositoryHandler");
                        }
                        repositories = (RepositoryHandler)object;
                        repositories.all((Action)new Action<ArtifactRepository>($fun$checkSingleRepo$1){
                            final /* synthetic */ checkRepositories.1 $checkSingleRepo$1;

                            public final void execute(ArtifactRepository it) {
                                ArtifactRepository artifactRepository = it;
                                Intrinsics.checkExpressionValueIsNotNull((Object)artifactRepository, (String)"it");
                                this.$checkSingleRepo$1.invoke("Gradle Settings", artifactRepository);
                            }
                            {
                                this.$checkSingleRepo$1 = var1_1;
                            }
                        });
                    }
                }
                catch (Throwable dependencyResolutionManagement) {
                    // empty catch block
                }
                Gradle gradle3 = this.$project.getGradle();
                Intrinsics.checkExpressionValueIsNotNull((Object)gradle3, (String)"project.gradle");
                BuildServiceRegistry buildServiceRegistry = gradle3.getSharedServices();
                Intrinsics.checkExpressionValueIsNotNull((Object)buildServiceRegistry, (String)"project.gradle.sharedServices");
                SyncIssueReporterImpl.GlobalSyncIssueService globalIssues = (SyncIssueReporterImpl.GlobalSyncIssueService)BuildServicesKt.getBuildService(buildServiceRegistry, SyncIssueReporterImpl.GlobalSyncIssueService.class).get();
                repositories = flatDirReposToUsages;
                boolean bl3 = false;
                if (!repositories.isEmpty()) {
                    Iterable iterable = flatDirReposToUsages.entrySet();
                    String string = System.lineSeparator();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"System.lineSeparator()");
                    reposWithProjects2 = CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string, null, null, (int)0, null, (Function1)checkRepositories.reposWithProjects.1.INSTANCE, (int)30, null);
                    IssueReporter.reportWarning$default((IssueReporter)globalIssues, (IssueReporter.Type)IssueReporter.Type.GENERIC, (String)StringsKt.trimIndent((String)("\n                            Using flatDirs should be avoided because it doesn't support any meta-data formats.\n                            Currently detected usages:\n                            " + (String)reposWithProjects2 + "\n                            ")), null, null, (int)12, null);
                }
                reposWithProjects2 = projectsUsingJCenter;
                bl3 = false;
                if (!reposWithProjects2.isEmpty()) {
                    String listOfProjects = CollectionsKt.joinToString$default((Iterable)projectsUsingJCenter, null, null, null, (int)3, null, null, (int)55, null);
                    IssueReporter.reportWarning$default((IssueReporter)globalIssues, (IssueReporter.Type)IssueReporter.Type.JCENTER_IS_DEPRECATED, (String)StringsKt.trimIndent((String)("\n                Please remove usages of `jcenter()` Maven repository from your build scripts and migrate your build to other Maven repositories.\n                This repository is deprecated and it will be shut down in the future.\n                See http://developer.android.com/r/tools/jcenter-end-of-service for more information.\n                Currently detected usages in: " + listOfProjects + "\n                ")), null, null, (int)12, null);
                }
            }
            {
                this.$project = project;
            }
        });
    }

    private AgpRepositoryChecker() {
    }

    static {
        AgpRepositoryChecker agpRepositoryChecker;
        INSTANCE = agpRepositoryChecker = new AgpRepositoryChecker();
    }
}

