/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.options;

import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.IntegerOption;
import com.android.build.gradle.options.Option;
import com.android.build.gradle.options.OptionalBooleanOption;
import com.android.build.gradle.options.ReplacedOption;
import com.android.build.gradle.options.StringOption;
import com.android.build.gradle.options.TestRunnerArguments;
import com.android.builder.model.OptionalCompilationStep;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;

public final class ProjectOptions {
    private final ImmutableMap<String, String> testRunnerArgs;
    private final ProviderFactory providerFactory;
    private final ImmutableMap<BooleanOption, OptionValue<BooleanOption, Boolean>> booleanOptionValues;
    private final ImmutableMap<OptionalBooleanOption, OptionValue<OptionalBooleanOption, Boolean>> optionalBooleanOptionValues;
    private final ImmutableMap<IntegerOption, OptionValue<IntegerOption, Integer>> integerOptionValues;
    private final ImmutableMap<ReplacedOption, OptionValue<ReplacedOption, String>> replacedOptionValues;
    private final ImmutableMap<StringOption, OptionValue<StringOption, String>> stringOptionValues;

    public ProjectOptions(ImmutableMap<String, String> customTestRunnerArgs, ProviderFactory providerFactory) {
        this.providerFactory = providerFactory;
        this.testRunnerArgs = this.readTestRunnerArgs((Map<String, String>)customTestRunnerArgs);
        this.booleanOptionValues = this.createOptionValues(BooleanOption.values());
        this.optionalBooleanOptionValues = this.createOptionValues(OptionalBooleanOption.values());
        this.integerOptionValues = this.createOptionValues(IntegerOption.values());
        this.replacedOptionValues = this.createOptionValues(ReplacedOption.values());
        this.stringOptionValues = this.createOptionValues(StringOption.values());
    }

    private <OptionT extends Option<ValueT>, ValueT> ImmutableMap<OptionT, OptionValue<OptionT, ValueT>> createOptionValues(OptionT[] options) {
        ImmutableMap.Builder map2 = ImmutableMap.builder();
        for (OptionT option : options) {
            map2.put(option, (Object)new OptionValue(this, option));
        }
        return map2.build();
    }

    private ImmutableMap<String, String> readTestRunnerArgs(Map<String, String> customArgs) {
        ImmutableMap.Builder testRunnerArgsBuilder = ImmutableMap.builder();
        ImmutableSet.Builder standardArgKeysBuilder = ImmutableSet.builder();
        for (TestRunnerArguments arg : TestRunnerArguments.values()) {
            standardArgKeysBuilder.add((Object)arg.getShortKey());
            String argValue = (String)this.providerFactory.gradleProperty(arg.getFullKey()).forUseAtConfigurationTime().getOrNull();
            if (argValue == null) continue;
            testRunnerArgsBuilder.put((Object)arg.getShortKey(), (Object)argValue);
        }
        testRunnerArgsBuilder.putAll(customArgs);
        return testRunnerArgsBuilder.build();
    }

    public boolean get(BooleanOption option) {
        Boolean value = (Boolean)((OptionValue)this.booleanOptionValues.get((Object)option)).getValueForUseAtConfiguration();
        if (value != null) {
            return value;
        }
        return option.getDefaultValue();
    }

    public Provider<Boolean> getProvider(BooleanOption option) {
        return this.providerFactory.provider(() -> (Boolean)((OptionValue)this.booleanOptionValues.get((Object)option)).getValueForUseAtExecution().getOrElse((Object)option.getDefaultValue()));
    }

    public Boolean get(OptionalBooleanOption option) {
        return (Boolean)((OptionValue)this.optionalBooleanOptionValues.get((Object)option)).getValueForUseAtConfiguration();
    }

    public Provider<Boolean> getProvider(OptionalBooleanOption option) {
        return ((OptionValue)this.optionalBooleanOptionValues.get((Object)option)).getValueForUseAtExecution();
    }

    public Integer get(IntegerOption option) {
        Integer value = (Integer)((OptionValue)this.integerOptionValues.get((Object)option)).getValueForUseAtConfiguration();
        if (value != null) {
            return value;
        }
        return option.getDefaultValue();
    }

    public Provider<Integer> getProvider(IntegerOption option) {
        return this.providerFactory.provider(() -> {
            Integer value = (Integer)((OptionValue)this.integerOptionValues.get((Object)option)).getValueForUseAtExecution().getOrNull();
            if (value != null) {
                return value;
            }
            return option.getDefaultValue();
        });
    }

    public String get(StringOption option) {
        String value = (String)((OptionValue)this.stringOptionValues.get((Object)option)).getValueForUseAtConfiguration();
        if (value != null) {
            return value;
        }
        return option.getDefaultValue();
    }

    public Provider<String> getProvider(StringOption option) {
        return this.providerFactory.provider(() -> {
            String value = (String)((OptionValue)this.stringOptionValues.get((Object)option)).getValueForUseAtExecution().getOrNull();
            if (value != null) {
                return value;
            }
            return option.getDefaultValue();
        });
    }

    public Map<String, String> getExtraInstrumentationTestRunnerArgs() {
        return this.testRunnerArgs;
    }

    public Set<OptionalCompilationStep> getOptionalCompilationSteps() {
        String values = this.get(StringOption.IDE_OPTIONAL_COMPILATION_STEPS);
        if (values != null) {
            ArrayList<OptionalCompilationStep> optionalCompilationSteps = new ArrayList<OptionalCompilationStep>();
            StringTokenizer st = new StringTokenizer(values, ",");
            while (st.hasMoreElements()) {
                optionalCompilationSteps.add(OptionalCompilationStep.valueOf((String)st.nextToken()));
            }
            return EnumSet.copyOf(optionalCompilationSteps);
        }
        return EnumSet.noneOf(OptionalCompilationStep.class);
    }

    public <OptionT extends Option<ValueT>, ValueT> ImmutableMap<OptionT, ValueT> getExplicitlySetOptions(ImmutableMap<OptionT, OptionValue<OptionT, ValueT>> optionValues) {
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        for (Map.Entry entry : optionValues.entrySet()) {
            Object value = ((OptionValue)entry.getValue()).getValueForUseAtConfiguration();
            if (value == null) continue;
            mapBuilder.put(entry.getKey(), value);
        }
        return mapBuilder.build();
    }

    public ImmutableMap<BooleanOption, Boolean> getExplicitlySetBooleanOptions() {
        return this.getExplicitlySetOptions(this.booleanOptionValues);
    }

    public ImmutableMap<OptionalBooleanOption, Boolean> getExplicitlySetOptionalBooleanOptions() {
        return this.getExplicitlySetOptions(this.optionalBooleanOptionValues);
    }

    public ImmutableMap<IntegerOption, Integer> getExplicitlySetIntegerOptions() {
        return this.getExplicitlySetOptions(this.integerOptionValues);
    }

    public ImmutableMap<StringOption, String> getExplicitlySetStringOptions() {
        return this.getExplicitlySetOptions(this.stringOptionValues);
    }

    private ImmutableMap<ReplacedOption, String> getExplicitlySetReplacedOptions() {
        return this.getExplicitlySetOptions(this.replacedOptionValues);
    }

    public ImmutableMap<Option<?>, Object> getAllOptions() {
        return new ImmutableMap.Builder().putAll(this.getExplicitlySetReplacedOptions()).putAll(this.getExplicitlySetBooleanOptions()).putAll(this.getExplicitlySetOptionalBooleanOptions()).putAll(this.getExplicitlySetIntegerOptions()).putAll(this.getExplicitlySetStringOptions()).build();
    }

    private static class OptionValue<OptionT extends Option<ValueT>, ValueT> {
        private Provider<ValueT> valueForUseAtConfiguration;
        private Provider<ValueT> valueForUseAtExecution;
        private OptionT option;
        final /* synthetic */ ProjectOptions this$0;

        OptionValue(OptionT option) {
            this.this$0 = var1_1;
            this.option = option;
        }

        private ValueT getValueForUseAtConfiguration() {
            if (this.valueForUseAtConfiguration == null) {
                this.valueForUseAtConfiguration = this.setValueForUseAtConfiguration();
            }
            return (ValueT)this.valueForUseAtConfiguration.getOrNull();
        }

        private Provider<ValueT> getValueForUseAtExecution() {
            if (this.valueForUseAtExecution == null) {
                this.valueForUseAtExecution = this.setValueForUseAtExecution();
            }
            return this.valueForUseAtExecution;
        }

        private Provider<ValueT> setValueForUseAtConfiguration() {
            Provider rawValue = this.this$0.providerFactory.gradleProperty(this.option.getPropertyName());
            return this.this$0.providerFactory.provider(() -> {
                String str = (String)rawValue.forUseAtConfigurationTime().getOrNull();
                if (str == null) {
                    return null;
                }
                return this.option.parse(str);
            });
        }

        private Provider<ValueT> setValueForUseAtExecution() {
            Provider rawValue = this.this$0.providerFactory.gradleProperty(this.option.getPropertyName());
            return this.this$0.providerFactory.provider(() -> {
                String str = (String)rawValue.getOrNull();
                if (str == null) {
                    return null;
                }
                return this.option.parse(str);
            });
        }
    }
}

