/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.test;

import com.android.build.api.component.impl.ComponentImpl;
import com.android.build.gradle.internal.component.AndroidTestCreationConfig;
import com.android.build.gradle.internal.tasks.BundleInstallUtils;
import com.android.build.gradle.internal.test.AbstractTestDataImpl;
import com.android.build.gradle.internal.test.BundleTestDataImpl;
import com.android.build.gradle.internal.utils.GuavaKtxKt;
import com.android.builder.testing.api.DeviceConfigProvider;
import com.android.utils.ILogger;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u001e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016R\u0013\u0010\r\u001a\u00020\u000e8\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0015\u0010\u000b\u001a\u0004\u0018\u00010\f8\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001f"}, d2={"Lcom/android/build/gradle/internal/test/BundleTestDataImpl;", "Lcom/android/build/gradle/internal/test/AbstractTestDataImpl;", "providerFactory", "Lorg/gradle/api/provider/ProviderFactory;", "componentImpl", "Lcom/android/build/api/component/impl/ComponentImpl;", "creationConfig", "Lcom/android/build/gradle/internal/component/AndroidTestCreationConfig;", "testApkDir", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/Directory;", "moduleName", "", "apkBundle", "Lorg/gradle/api/file/FileCollection;", "(Lorg/gradle/api/provider/ProviderFactory;Lcom/android/build/api/component/impl/ComponentImpl;Lcom/android/build/gradle/internal/component/AndroidTestCreationConfig;Lorg/gradle/api/provider/Provider;Ljava/lang/String;Lorg/gradle/api/file/FileCollection;)V", "getApkBundle", "()Lorg/gradle/api/file/FileCollection;", "libraryType", "", "getLibraryType", "()Lorg/gradle/api/provider/Provider;", "getModuleName", "()Ljava/lang/String;", "findTestedApks", "", "Ljava/io/File;", "deviceConfigProvider", "Lcom/android/builder/testing/api/DeviceConfigProvider;", "logger", "Lcom/android/utils/ILogger;", "gradle-core"})
public final class BundleTestDataImpl
extends AbstractTestDataImpl {
    @NotNull
    private final Provider<Boolean> libraryType;
    @Nullable
    private final String moduleName;
    @NotNull
    private final FileCollection apkBundle;

    @Override
    @NotNull
    public Provider<Boolean> getLibraryType() {
        return this.libraryType;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<File> findTestedApks(@NotNull DeviceConfigProvider deviceConfigProvider, @NotNull ILogger logger) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)deviceConfigProvider, (String)"deviceConfigProvider");
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        if (this.moduleName != null && deviceConfigProvider.getApiLevel() < 21) {
            logger.warning("Testing dynamic features on devices API < 21 is not currently supported.", new Object[0]);
            ImmutableList immutableList = ImmutableList.of();
            Intrinsics.checkExpressionValueIsNotNull((Object)immutableList, (String)"ImmutableList.of<File>()");
            return (List)immutableList;
        }
        Path path = this.apkBundle.getSingleFile().toPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"apkBundle.singleFile.toPath()");
        Iterable $this$map$iv = BundleInstallUtils.getApkFiles(path, deviceConfigProvider, this.moduleName);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Path path2 = (Path)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            File file = it.toFile();
            collection.add(file);
        }
        return (List)GuavaKtxKt.toImmutableList((List)destination$iv$iv);
    }

    @Input
    @Optional
    @Nullable
    public final String getModuleName() {
        return this.moduleName;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @Optional
    @NotNull
    public final FileCollection getApkBundle() {
        return this.apkBundle;
    }

    public BundleTestDataImpl(@NotNull ProviderFactory providerFactory, @NotNull ComponentImpl componentImpl, @NotNull AndroidTestCreationConfig creationConfig, @NotNull Provider<Directory> testApkDir, @Nullable String moduleName, @NotNull FileCollection apkBundle) {
        Intrinsics.checkParameterIsNotNull((Object)providerFactory, (String)"providerFactory");
        Intrinsics.checkParameterIsNotNull((Object)componentImpl, (String)"componentImpl");
        Intrinsics.checkParameterIsNotNull((Object)creationConfig, (String)"creationConfig");
        Intrinsics.checkParameterIsNotNull(testApkDir, (String)"testApkDir");
        Intrinsics.checkParameterIsNotNull((Object)apkBundle, (String)"apkBundle");
        super(providerFactory, componentImpl, creationConfig, creationConfig.getVariantSources(), testApkDir, null);
        this.moduleName = moduleName;
        this.apkBundle = apkBundle;
        this.libraryType = creationConfig.getServices().provider(libraryType.1.INSTANCE);
    }
}

