/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.gradle.external.cmake.CmakeUtils;
import com.android.build.gradle.external.cmake.server.BuildFiles;
import com.android.build.gradle.external.cmake.server.CmakeInputsResult;
import com.android.build.gradle.external.cmake.server.CodeModel;
import com.android.build.gradle.external.cmake.server.ComputeResult;
import com.android.build.gradle.external.cmake.server.Configuration;
import com.android.build.gradle.external.cmake.server.ConfigureCommandResult;
import com.android.build.gradle.external.cmake.server.FileGroup;
import com.android.build.gradle.external.cmake.server.HandshakeRequest;
import com.android.build.gradle.external.cmake.server.HandshakeResult;
import com.android.build.gradle.external.cmake.server.Project;
import com.android.build.gradle.external.cmake.server.ProtocolVersion;
import com.android.build.gradle.external.cmake.server.Server;
import com.android.build.gradle.external.cmake.server.ServerFactory;
import com.android.build.gradle.external.cmake.server.ServerUtils;
import com.android.build.gradle.external.cmake.server.Target;
import com.android.build.gradle.external.cmake.server.receiver.InteractiveMessage;
import com.android.build.gradle.external.cmake.server.receiver.MessageReceiver;
import com.android.build.gradle.external.cmake.server.receiver.ServerReceiver;
import com.android.build.gradle.internal.cxx.cmake.LinkLibrariesParserKt;
import com.android.build.gradle.internal.cxx.cmake.MakeCmakeMessagePathsAbsoluteKt;
import com.android.build.gradle.internal.cxx.configure.BuildSystemCommandLineKt;
import com.android.build.gradle.internal.cxx.configure.CommandLineArgument;
import com.android.build.gradle.internal.cxx.json.AndroidBuildGradleJsons;
import com.android.build.gradle.internal.cxx.json.NativeBuildConfigValue;
import com.android.build.gradle.internal.cxx.json.NativeLibraryValue;
import com.android.build.gradle.internal.cxx.logging.LoggingEnvironmentKt;
import com.android.build.gradle.internal.cxx.logging.PassThroughPrintWriterLoggingEnvironment;
import com.android.build.gradle.internal.cxx.model.CxxAbiModel;
import com.android.build.gradle.internal.cxx.model.CxxAbiModelKt;
import com.android.build.gradle.internal.cxx.model.CxxCmakeModuleModel;
import com.android.build.gradle.internal.cxx.model.CxxVariantModel;
import com.android.build.gradle.tasks.CmakeExternalNativeJsonGeneratorUtilsKt;
import com.android.build.gradle.tasks.CmakeServerExternalNativeJsonGenerator;
import com.android.build.gradle.tasks.ExternalNativeJsonGenerator;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessInfoBuilder;
import com.android.repository.Revision;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.google.wireless.android.sdk.stats.GradleBuildVariant;
import com.google.wireless.android.sdk.stats.GradleNativeAndroidModule;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.gradle.process.ExecOperations;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 -2\u00020\u0001:\u0001-B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ(\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0006H\u0016J\u0010\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u0006H\u0002J\u0018\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00130\u00052\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J(\u0010\u001f\u001a\u00020 2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010!\u001a\u00020\"H\u0002J\u0018\u0010#\u001a\u00020$2\u0006\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0016H\u0003J \u0010%\u001a\u00020&2\u0006\u0010\u001a\u001a\u00020\u00062\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0003J\u0010\u0010+\u001a\u00020,2\u0006\u0010\u001a\u001a\u00020\u0006H\u0016R\u0014\u0010\n\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006."}, d2={"Lcom/android/build/gradle/tasks/CmakeServerExternalNativeJsonGenerator;", "Lcom/android/build/gradle/tasks/ExternalNativeJsonGenerator;", "variant", "Lcom/android/build/gradle/internal/cxx/model/CxxVariantModel;", "abis", "", "Lcom/android/build/gradle/internal/cxx/model/CxxAbiModel;", "variantBuilder", "Lcom/google/wireless/android/sdk/stats/GradleBuildVariant$Builder;", "(Lcom/android/build/gradle/internal/cxx/model/CxxVariantModel;Ljava/util/List;Lcom/google/wireless/android/sdk/stats/GradleBuildVariant$Builder;)V", "cmake", "Lcom/android/build/gradle/internal/cxx/model/CxxCmakeModuleModel;", "getCmake", "()Lcom/android/build/gradle/internal/cxx/model/CxxCmakeModuleModel;", "doHandshake", "", "generator", "", "sourceDirectory", "Ljava/io/File;", "buildDirectory", "cmakeServer", "Lcom/android/build/gradle/external/cmake/server/Server;", "executeProcess", "ops", "Lorg/gradle/process/ExecOperations;", "abi", "executeProcessAndGetOutput", "generateAndroidGradleBuild", "config", "getBuildFiles", "getHandshakeRequest", "Lcom/android/build/gradle/external/cmake/server/HandshakeRequest;", "cmakeServerProtocolVersion", "Lcom/android/build/gradle/external/cmake/server/ProtocolVersion;", "getNativeBuildConfigValue", "Lcom/android/build/gradle/internal/cxx/json/NativeBuildConfigValue;", "getNativeLibraryValue", "Lcom/android/build/gradle/internal/cxx/json/NativeLibraryValue;", "target", "Lcom/android/build/gradle/external/cmake/server/Target;", "additionalProjectFilesIndexWriter", "Ljava/io/BufferedWriter;", "getProcessBuilder", "Lcom/android/ide/common/process/ProcessInfoBuilder;", "Companion", "gradle-core"})
public final class CmakeServerExternalNativeJsonGenerator
extends ExternalNativeJsonGenerator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String CMAKE_SERVER_LOG_PREFIX = "CMAKE SERVER: ";

    public CmakeServerExternalNativeJsonGenerator(@NotNull CxxVariantModel variant2, @NotNull List<CxxAbiModel> abis2, @Nullable GradleBuildVariant.Builder variantBuilder) {
        Intrinsics.checkParameterIsNotNull((Object)variant2, (String)"variant");
        Intrinsics.checkParameterIsNotNull(abis2, (String)"abis");
        super(variant2, abis2, variantBuilder);
        GradleBuildVariant.Builder builder = variantBuilder;
        if (builder != null) {
            builder.setNativeBuildSystemType(GradleNativeAndroidModule.NativeBuildSystemType.CMAKE);
        }
        CmakeExternalNativeJsonGeneratorUtilsKt.cmakeMakefileChecks(variant2);
    }

    private final CxxCmakeModuleModel getCmake() {
        CxxCmakeModuleModel cxxCmakeModuleModel = this.getVariant().getModule().getCmake();
        if (cxxCmakeModuleModel == null) {
            Intrinsics.throwNpe();
        }
        return cxxCmakeModuleModel;
    }

    @Override
    public void executeProcess(@NotNull ExecOperations ops2, @NotNull CxxAbiModel abi) {
        Intrinsics.checkParameterIsNotNull((Object)ops2, (String)"ops");
        Intrinsics.checkParameterIsNotNull((Object)abi, (String)"abi");
        this.executeProcessAndGetOutput(abi);
    }

    @Override
    @NotNull
    public ProcessInfoBuilder getProcessBuilder(@NotNull CxxAbiModel abi) {
        Intrinsics.checkParameterIsNotNull((Object)abi, (String)"abi");
        ProcessInfoBuilder builder = new ProcessInfoBuilder();
        File file = this.getCmake().getCmakeExe();
        if (file == null) {
            Intrinsics.throwNpe();
        }
        builder.setExecutable(file);
        builder.addArgs(abi.getConfigurationArguments());
        return builder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void executeProcessAndGetOutput(CxxAbiModel abi) {
        File cmakeServerLogFile = CxxAbiModelKt.getCmakeServerLogFile(abi).getAbsoluteFile();
        cmakeServerLogFile.getParentFile().mkdirs();
        AutoCloseable autoCloseable = new PassThroughPrintWriterLoggingEnvironment(new PrintWriter(cmakeServerLogFile, "UTF-8"), CMAKE_SERVER_LOG_PREFIX);
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            File cmakeBinFolder;
            Server cmakeServer;
            PassThroughPrintWriterLoggingEnvironment it = (PassThroughPrintWriterLoggingEnvironment)autoCloseable;
            boolean bl3 = false;
            ServerReceiver serverReceiver2 = new ServerReceiver().setMessageReceiver(new MessageReceiver(this){
                final /* synthetic */ CmakeServerExternalNativeJsonGenerator this$0;
                {
                    this.this$0 = $receiver;
                }

                public final void receive(@NotNull InteractiveMessage message) {
                    Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                    File file = this.this$0.getVariant().getModule().getMakeFile().getParentFile();
                    Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"variant.module.makeFile.parentFile");
                    com.android.build.gradle.tasks.CmakeServerExternalNativeJsonGenerator$Companion.access$logInteractiveMessage(CmakeServerExternalNativeJsonGenerator.Companion, message, file);
                }
            }).setDiagnosticReceiver(executeProcessAndGetOutput.1.serverReceiver.2.INSTANCE);
            File file = this.getCmake().getCmakeExe();
            if (file == null) {
                Intrinsics.throwNpe();
            }
            if ((cmakeServer = ServerFactory.create(cmakeBinFolder = file.getParentFile(), serverReceiver2)) == null) {
                Revision revision = CmakeUtils.getVersion(cmakeBinFolder);
                Intrinsics.checkExpressionValueIsNotNull((Object)revision, (String)"getVersion(cmakeBinFolder)");
                Revision actual = revision;
                revision = StringCompanionObject.INSTANCE;
                String string = "Actual CMake version '%s.%s.%s' did not satisfy requested minimum or default CMake minimum version '%s'. Possibly cmake.dir doesn't match android.externalNativeBuild.cmake.version.";
                Object[] objectArray = new Object[]{actual.getMajor(), actual.getMinor(), actual.getMicro(), this.getCmake().getMinimumCmakeVersion()};
                boolean bl4 = false;
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
                throw new RuntimeException(string2);
            }
            if (!cmakeServer.connect()) {
                throw new RuntimeException(Intrinsics.stringPlus((String)"Unable to connect to Cmake server located at: ", (Object)cmakeBinFolder.getAbsolutePath()));
            }
            try {
                List<CommandLineArgument> arguments = BuildSystemCommandLineKt.toCmakeArguments(abi.getConfigurationArguments());
                List<String> cacheArgumentsList = BuildSystemCommandLineKt.toStringList(BuildSystemCommandLineKt.onlyKeepCmakeServerArguments(arguments));
                Object configureCommandResult = null;
                Object object = BuildSystemCommandLineKt.getCmakeGenerator(arguments);
                if (object == null) {
                    Intrinsics.throwNpe();
                }
                String string = object;
                object = this.getVariant().getModule().getMakeFile().getParentFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"variant.module.makeFile.parentFile");
                Object object2 = object;
                object = BuildSystemCommandLineKt.getCmakeBinaryOutputPath(arguments);
                if (object == null) {
                    Intrinsics.throwNpe();
                }
                this.doHandshake(string, (File)object2, new File((String)object), cmakeServer);
                Object $this$toTypedArray$iv = cacheArgumentsList;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                String[] stringArray = thisCollection$iv.toArray(new String[0]);
                if (stringArray == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                String[] argsArray = stringArray;
                Object object3 = new String[argsArray.length];
                System.arraycopy(argsArray, 0, object3, 0, argsArray.length);
                $this$toTypedArray$iv = cmakeServer.configure((String)object3);
                Intrinsics.checkExpressionValueIsNotNull((Object)$this$toTypedArray$iv, (String)"cmakeServer.configure(*argsArray)");
                configureCommandResult = $this$toTypedArray$iv;
                if (!ServerUtils.isConfigureResultValid(((ConfigureCommandResult)configureCommandResult).configureResult)) {
                    $this$toTypedArray$iv = StringCompanionObject.INSTANCE;
                    object3 = "Error configuring CMake server (%s).\r\n%s";
                    Object[] objectArray = new Object[]{cmakeServer.getCmakePath(), ((ConfigureCommandResult)configureCommandResult).interactiveMessages};
                    boolean bl5 = false;
                    String string3 = String.format((String)object3, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(format, *args)");
                    throw new ProcessException(string3);
                }
                ComputeResult computeResult = CmakeServerExternalNativeJsonGenerator.Companion.doCompute(cmakeServer);
                if (!ServerUtils.isComputedResultValid(computeResult)) {
                    throw new ProcessException(StringsKt.trimIndent((String)("\n                    Error computing CMake server result.\n                    " + ((ConfigureCommandResult)configureCommandResult).interactiveMessages + "\n                    ")));
                }
                this.generateAndroidGradleBuild(abi, cmakeServer);
            }
            finally {
                cmakeServer.disconnect();
            }
            return;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    private final void doHandshake(String generator, File sourceDirectory, File buildDirectory, Server cmakeServer) throws IOException {
        List<ProtocolVersion> supportedProtocolVersions = cmakeServer.getSupportedVersion();
        if (supportedProtocolVersions == null || supportedProtocolVersions.isEmpty()) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "Gradle does not support the Cmake server version. %s";
            Object[] objectArray = new Object[]{CmakeServerExternalNativeJsonGenerator.Companion.getCmakeInfoString(cmakeServer)};
            boolean bl = false;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
            throw new RuntimeException(string2);
        }
        Object object = supportedProtocolVersions.get(0);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"supportedProtocolVersions[0]");
        HandshakeResult handshakeResult = cmakeServer.handshake(this.getHandshakeRequest(generator, sourceDirectory, buildDirectory, (ProtocolVersion)object));
        Intrinsics.checkExpressionValueIsNotNull((Object)handshakeResult, (String)"cmakeServer.handshake(\n            getHandshakeRequest(\n                generator,\n                sourceDirectory,\n                buildDirectory,\n                supportedProtocolVersions[0]\n            )\n        )");
        HandshakeResult handshakeResult2 = handshakeResult;
        if (!ServerUtils.isHandshakeResultValid(handshakeResult2)) {
            handshakeResult = StringCompanionObject.INSTANCE;
            object = "Invalid handshake result from Cmake server: \n%s\n%s";
            Object[] objectArray = new Object[]{CmakeUtils.getObjectToString(handshakeResult2), CmakeServerExternalNativeJsonGenerator.Companion.getCmakeInfoString(cmakeServer)};
            boolean bl = false;
            String string = String.format((String)object, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"java.lang.String.format(format, *args)");
            throw new RuntimeException(string);
        }
    }

    private final HandshakeRequest getHandshakeRequest(String generator, File sourceDirectory, File buildDirectory, ProtocolVersion cmakeServerProtocolVersion) {
        if (!sourceDirectory.isDirectory()) {
            Object[] objectArray = new Object[]{sourceDirectory};
            LoggingEnvironmentKt.errorln("Not a directory: %s", objectArray);
        }
        HandshakeRequest handshakeRequest = new HandshakeRequest();
        handshakeRequest.cookie = "gradle-cmake-cookie";
        handshakeRequest.generator = generator;
        handshakeRequest.protocolVersion = cmakeServerProtocolVersion;
        handshakeRequest.buildDirectory = CmakeServerExternalNativeJsonGenerator.Companion.normalizeFilePath(buildDirectory);
        handshakeRequest.sourceDirectory = CmakeServerExternalNativeJsonGenerator.Companion.normalizeFilePath(sourceDirectory);
        return handshakeRequest;
    }

    private final void generateAndroidGradleBuild(CxxAbiModel config2, Server cmakeServer) throws IOException {
        NativeBuildConfigValue nativeBuildConfigValue = this.getNativeBuildConfigValue(config2, cmakeServer);
        AndroidBuildGradleJsons.writeNativeBuildConfigValueToJsonFile(CxxAbiModelKt.getJsonFile(config2), nativeBuildConfigValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    private final NativeBuildConfigValue getNativeBuildConfigValue(CxxAbiModel abi, Server cmakeServer) throws IOException {
        NativeBuildConfigValue nativeBuildConfigValue = CmakeServerExternalNativeJsonGenerator.Companion.createDefaultNativeBuildConfigValue();
        boolean bl = nativeBuildConfigValue.buildFiles != null;
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        Collection<File> collection = nativeBuildConfigValue.buildFiles;
        if (collection == null) {
            Intrinsics.throwNpe();
        }
        collection.addAll((Collection<File>)this.getBuildFiles(cmakeServer));
        boolean bl5 = nativeBuildConfigValue.cleanCommandsComponents != null;
        bl2 = false;
        bl3 = false;
        if (_Assertions.ENABLED && !bl5) {
            boolean bl6 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        Object object = nativeBuildConfigValue.cleanCommandsComponents;
        if (object == null) {
            Intrinsics.throwNpe();
        }
        List<List<String>> list = object;
        object = this.getCmake().getCmakeExe();
        if (object == null) {
            Intrinsics.throwNpe();
        }
        list.add(CmakeUtils.getCleanCommand((File)object, abi.getCxxBuildFolder()));
        boolean bl7 = nativeBuildConfigValue.buildTargetsCommandComponents != null;
        bl2 = false;
        bl3 = false;
        if (_Assertions.ENABLED && !bl7) {
            boolean bl8 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        File file = this.getCmake().getCmakeExe();
        if (file == null) {
            Intrinsics.throwNpe();
        }
        nativeBuildConfigValue.buildTargetsCommandComponents = CmakeUtils.getBuildTargetsCommand(file, abi.getCxxBuildFolder(), CxxAbiModelKt.getBuildCommandArguments(abi));
        CodeModel codeModel = cmakeServer.codemodel();
        Intrinsics.checkExpressionValueIsNotNull((Object)codeModel, (String)"cmakeServer.codemodel()");
        CodeModel codeModel2 = codeModel;
        if (!ServerUtils.isCodeModelValid(codeModel2)) {
            codeModel = StringCompanionObject.INSTANCE;
            String string = "Invalid code model received from Cmake server: \n%s\n%s";
            Object[] objectArray = new Object[]{CmakeUtils.getObjectToString(codeModel2), CmakeServerExternalNativeJsonGenerator.Companion.getCmakeInfoString(cmakeServer)};
            boolean bl9 = false;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
            throw new RuntimeException(string2);
        }
        boolean bl10 = nativeBuildConfigValue.cFileExtensions != null;
        bl3 = false;
        int n = 0;
        if (_Assertions.ENABLED && !bl10) {
            boolean bl11 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        Collection<String> collection2 = nativeBuildConfigValue.cFileExtensions;
        if (collection2 == null) {
            Intrinsics.throwNpe();
        }
        Collection<String> collection3 = collection2;
        collection2 = CmakeUtils.getCExtensionSet(codeModel2);
        Intrinsics.checkExpressionValueIsNotNull(collection2, (String)"getCExtensionSet(codeModel)");
        collection3.addAll(collection2);
        boolean bl12 = nativeBuildConfigValue.cppFileExtensions != null;
        bl3 = false;
        n = 0;
        if (_Assertions.ENABLED && !bl12) {
            boolean bl13 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        Object object2 = nativeBuildConfigValue.cppFileExtensions;
        if (object2 == null) {
            Intrinsics.throwNpe();
        }
        Collection<String> collection4 = object2;
        object2 = CmakeUtils.getCppExtensionSet(codeModel2);
        Intrinsics.checkExpressionValueIsNotNull(object2, (String)"getCppExtensionSet(codeModel)");
        collection4.addAll((Collection<String>)object2);
        object2 = CxxAbiModelKt.getAdditionalProjectFilesIndexFile(abi);
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"UTF_8");
        n = 8192;
        boolean bl14 = false;
        Configuration[] configurationArray = object2;
        boolean bl15 = false;
        Configuration[] configurationArray2 = configurationArray;
        int n2 = 0;
        configurationArray2 = new FileOutputStream((File)configurationArray2);
        n2 = 0;
        configurationArray = new OutputStreamWriter((OutputStream)configurationArray2, charset);
        bl15 = false;
        object2 = configurationArray instanceof BufferedWriter ? (BufferedWriter)configurationArray : new BufferedWriter((Writer)configurationArray, n);
        boolean bl16 = false;
        n = 0;
        Throwable throwable = null;
        try {
            BufferedWriter additionalProjectFilesIndexWriter = (BufferedWriter)object2;
            boolean bl17 = false;
            Configuration[] configurationArray3 = codeModel2.configurations;
            Intrinsics.checkExpressionValueIsNotNull((Object)configurationArray3, (String)"codeModel.configurations");
            configurationArray2 = configurationArray3;
            int n3 = 0;
            n2 = configurationArray2.length;
            while (n3 < n2) {
                Configuration config2 = configurationArray2[n3];
                ++n3;
                Project[] projectArray = config2.projects;
                Intrinsics.checkExpressionValueIsNotNull((Object)projectArray, (String)"config.projects");
                Project[] projectArray2 = projectArray;
                int n4 = 0;
                int n5 = projectArray2.length;
                while (n4 < n5) {
                    Project project2 = projectArray2[n4];
                    ++n4;
                    Target[] targetArray = project2.targets;
                    Intrinsics.checkExpressionValueIsNotNull((Object)targetArray, (String)"project.targets");
                    Target[] targetArray2 = targetArray;
                    int n6 = 0;
                    int n7 = targetArray2.length;
                    while (n6 < n7) {
                        Target target = targetArray2[n6];
                        ++n6;
                        Intrinsics.checkExpressionValueIsNotNull((Object)target, (String)"target");
                        if (!CmakeServerExternalNativeJsonGenerator.Companion.canAddTargetToNativeLibrary(target)) continue;
                        NativeLibraryValue nativeLibraryValue = this.getNativeLibraryValue(abi, target, additionalProjectFilesIndexWriter);
                        String libraryName = target.name + '-' + config2.name + '-' + abi.getAbi().getTag();
                        boolean bl18 = nativeBuildConfigValue.libraries != null;
                        boolean bl19 = false;
                        boolean bl20 = false;
                        if (_Assertions.ENABLED && !bl18) {
                            boolean bl21 = false;
                            String string = "Assertion failed";
                            throw (Throwable)((Object)new AssertionError((Object)string));
                        }
                        Map<String, NativeLibraryValue> map = nativeBuildConfigValue.libraries;
                        if (map == null) {
                            Intrinsics.throwNpe();
                        }
                        Map<String, NativeLibraryValue> map2 = map;
                        bl19 = false;
                        map2.put(libraryName, nativeLibraryValue);
                    }
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object2, (Throwable)throwable);
        }
        return nativeBuildConfigValue;
    }

    @VisibleForTesting
    private final NativeLibraryValue getNativeLibraryValue(CxxAbiModel abi, Target target, BufferedWriter additionalProjectFilesIndexWriter) throws FileNotFoundException {
        Object object = this.getCmake().getCmakeExe();
        if (object == null) {
            Intrinsics.throwNpe();
        }
        File file = object;
        File file2 = abi.getCxxBuildFolder();
        boolean bl = this.getVariant().isDebuggableEnabled();
        object = abi.getAbi().getTag();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"abi.abi.tag");
        return Companion.getNativeLibraryValue(file, file2, bl, (String)object, target, additionalProjectFilesIndexWriter);
    }

    /*
     * WARNING - void declaration
     */
    private final List<File> getBuildFiles(Server cmakeServer) {
        void $this$sortedBy$iv;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        CmakeInputsResult cmakeInputsResult = cmakeServer.cmakeInputs();
        Intrinsics.checkExpressionValueIsNotNull((Object)cmakeInputsResult, (String)"cmakeServer.cmakeInputs()");
        CmakeInputsResult cmakeInputsResult2 = cmakeInputsResult;
        if (!ServerUtils.isCmakeInputsResultValid(cmakeInputsResult2) || cmakeInputsResult2.buildFiles == null) {
            return CollectionsKt.listOf((Object)this.getVariant().getModule().getMakeFile().getAbsoluteFile());
        }
        String string = cmakeInputsResult2.sourceDirectory;
        File sourceDirectory = new File(string == null ? this.getVariant().getModule().getMakeFile().getAbsoluteFile().getParent() : string);
        Collection collection = CollectionsKt.listOf((Object)this.getVariant().getModule().getMakeFile());
        Object[] objectArray = cmakeInputsResult2.buildFiles;
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"cmakeInputsResult.buildFiles");
        objectArray = objectArray;
        Collection collection2 = collection;
        boolean $i$f$flatMap = false;
        void var7_8 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (void element$iv$iv : $this$flatMapTo$iv$iv) {
            Iterable iterable;
            List list;
            BuildFiles buildFiles = (BuildFiles)element$iv$iv;
            boolean bl = false;
            Object[] objectArray2 = buildFiles.sources;
            List list2 = list = objectArray2 == null ? null : ArraysKt.filterNotNull((Object[])objectArray2);
            if (list == null) {
                boolean bl2 = false;
                iterable = CollectionsKt.emptyList();
            } else {
                iterable = list;
            }
            Iterable list$iv$iv = iterable;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Object object = (List)destination$iv$iv;
        $this$flatMap$iv = (Iterable)object;
        boolean $i$f$map = false;
        $this$flatMapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string2 = (String)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            File file = new File((String)it);
            object.add(file);
        }
        object = (List)destination$iv$iv;
        List files2 = CollectionsKt.plus((Collection)collection2, (Iterable)((Iterable)object));
        $this$map$iv = files2;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            File it = (File)element$iv$iv;
            boolean bl = false;
            String string3 = it.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"it.name");
            if (!(StringsKt.compareTo((String)string3, (String)"CMakeLists.txt", (boolean)true) == 0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void file;
            File it = (File)item$iv$iv;
            collection2 = destination$iv$iv;
            boolean bl = false;
            object = FilesKt.resolve((File)sourceDirectory, (File)file).getCanonicalFile();
            collection2.add(object);
        }
        $this$map$iv = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
        boolean $i$f$sortedBy = false;
        boolean bl = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                File it = (File)a;
                boolean bl2 = false;
                Comparable comparable = Integer.valueOf(it.getPath().length());
                it = (File)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                Integer n = it.getPath().length();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
            }
        });
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\b\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u00102\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u0012\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0002J8\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u001aH\u0007J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0011H\u0002J\u0010\u0010 \u001a\u00020\u00042\u0006\u0010!\u001a\u00020\u0011H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/android/build/gradle/tasks/CmakeServerExternalNativeJsonGenerator$Companion;", "", "()V", "CMAKE_SERVER_LOG_PREFIX", "", "canAddTargetToNativeLibrary", "", "target", "Lcom/android/build/gradle/external/cmake/server/Target;", "createDefaultNativeBuildConfigValue", "Lcom/android/build/gradle/internal/cxx/json/NativeBuildConfigValue;", "doCompute", "Lcom/android/build/gradle/external/cmake/server/ComputeResult;", "cmakeServer", "Lcom/android/build/gradle/external/cmake/server/Server;", "findRuntimeFiles", "", "Ljava/io/File;", "getCmakeInfoString", "getNativeLibraryValue", "Lcom/android/build/gradle/internal/cxx/json/NativeLibraryValue;", "cmakeExecutable", "outputFolder", "isDebuggable", "abi", "additionalProjectFilesIndexWriter", "Ljava/io/BufferedWriter;", "logInteractiveMessage", "", "message", "Lcom/android/build/gradle/external/cmake/server/receiver/InteractiveMessage;", "makeFileDirectory", "normalizeFilePath", "file", "gradle-core"})
    public static final class Companion {
        private Companion() {
        }

        private final String getCmakeInfoString(Server cmakeServer) throws IOException {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "Cmake path: %s, version: %s";
            Object[] objectArray = new Object[]{cmakeServer.getCmakePath(), CmakeUtils.getVersion(new File(cmakeServer.getCmakePath())).toString()};
            boolean bl = false;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
            return string2;
        }

        private final void logInteractiveMessage(InteractiveMessage message, File makeFileDirectory) {
            String correctedMessage;
            block10: {
                block9: {
                    String string;
                    String cmakeWarningPrefix;
                    block8: {
                        block7: {
                            String cmakeErrorPrefix = "CMake Error";
                            cmakeWarningPrefix = "CMake Warning";
                            if (message.type != null && Intrinsics.areEqual((Object)message.type, (Object)"error")) {
                                String string2 = message.errorMessage;
                                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"message.errorMessage");
                                LoggingEnvironmentKt.errorln(MakeCmakeMessagePathsAbsoluteKt.makeCmakeMessagePathsAbsolute(string2, makeFileDirectory), new Object[0]);
                                return;
                            }
                            string = message.message;
                            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"message.message");
                            correctedMessage = MakeCmakeMessagePathsAbsoluteKt.makeCmakeMessagePathsAbsolute(string, makeFileDirectory);
                            if (message.title != null && Intrinsics.areEqual((Object)message.title, (Object)"Error")) break block7;
                            string = message.message;
                            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"message.message");
                            if (!StringsKt.startsWith$default((String)string, (String)cmakeErrorPrefix, (boolean)false, (int)2, null)) break block8;
                        }
                        LoggingEnvironmentKt.errorln(correctedMessage, new Object[0]);
                        return;
                    }
                    if (message.title != null && Intrinsics.areEqual((Object)message.title, (Object)"Warning")) break block9;
                    string = message.message;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"message.message");
                    if (!StringsKt.startsWith$default((String)string, (String)cmakeWarningPrefix, (boolean)false, (int)2, null)) break block10;
                }
                LoggingEnvironmentKt.warnln(correctedMessage, new Object[0]);
                return;
            }
            LoggingEnvironmentKt.infoln(correctedMessage, new Object[0]);
        }

        private final ComputeResult doCompute(Server cmakeServer) throws IOException {
            ComputeResult computeResult = cmakeServer.compute();
            Intrinsics.checkExpressionValueIsNotNull((Object)computeResult, (String)"cmakeServer.compute()");
            return computeResult;
        }

        private final List<File> findRuntimeFiles(Target target) {
            if (target.linkLibraries == null || Intrinsics.areEqual((Object)target.type, (Object)"OBJECT_LIBRARY")) {
                return null;
            }
            Path sysroot = Paths.get(target.sysroot, new String[0]);
            boolean bl = false;
            List runtimeFiles = new ArrayList();
            String string = target.linkLibraries;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"target.linkLibraries");
            for (String library : LinkLibrariesParserKt.parseLinkLibraries(string)) {
                PathMatcher pathMatcher;
                if (StringsKt.startsWith$default((String)library, (String)"-", (boolean)false, (int)2, null)) continue;
                Path path = Paths.get(library, new String[0]);
                boolean bl2 = false;
                boolean bl3 = false;
                Path it = path;
                boolean bl4 = false;
                Path libraryPath = (!it.isAbsolute() ? Paths.get(target.buildDirectory, new String[0]).resolve(it) : it).normalize();
                if (libraryPath.startsWith(sysroot) || (pathMatcher = libraryPath.getFileSystem().getPathMatcher("glob:*.a")).matches(libraryPath.getFileName())) continue;
                File file = libraryPath.toFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"libraryPath.toFile()");
                runtimeFiles.add(file);
            }
            return runtimeFiles;
        }

        @VisibleForTesting
        @NotNull
        public final NativeLibraryValue getNativeLibraryValue(@NotNull File cmakeExecutable, @NotNull File outputFolder, boolean isDebuggable, @NotNull String abi, @NotNull Target target, @NotNull BufferedWriter additionalProjectFilesIndexWriter) {
            int n;
            Intrinsics.checkParameterIsNotNull((Object)cmakeExecutable, (String)"cmakeExecutable");
            Intrinsics.checkParameterIsNotNull((Object)outputFolder, (String)"outputFolder");
            Intrinsics.checkParameterIsNotNull((Object)abi, (String)"abi");
            Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
            Intrinsics.checkParameterIsNotNull((Object)additionalProjectFilesIndexWriter, (String)"additionalProjectFilesIndexWriter");
            NativeLibraryValue nativeLibraryValue = new NativeLibraryValue();
            nativeLibraryValue.abi = abi;
            nativeLibraryValue.buildCommandComponents = CmakeUtils.getBuildCommand(cmakeExecutable, outputFolder, target.name);
            nativeLibraryValue.artifactName = target.name;
            String string = nativeLibraryValue.buildType = isDebuggable ? "debug" : "release";
            if (!Intrinsics.areEqual((Object)"OBJECT_LIBRARY", (Object)target.type) && target.artifacts != null) {
                Object[] objectArray = target.artifacts;
                Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"target.artifacts");
                objectArray = objectArray;
                boolean bl = false;
                Object[] objectArray2 = objectArray;
                n = 0;
                if (!(objectArray2.length == 0)) {
                    nativeLibraryValue.output = new File(target.artifacts[0]);
                }
            }
            nativeLibraryValue.runtimeFiles = this.findRuntimeFiles(target);
            File sourceDirectory = new File(target.sourceDirectory);
            FileGroup[] $this$orEmpty$iv = target.fileGroups;
            boolean $i$f$orEmpty = false;
            FileGroup[] fileGroupArray = $this$orEmpty$iv;
            if ($this$orEmpty$iv == null) {
                fileGroupArray = new FileGroup[]{};
            }
            FileGroup[] fileGroupArray2 = fileGroupArray;
            int n2 = 0;
            n = fileGroupArray2.length;
            while (n2 < n) {
                FileGroup fileGroup = fileGroupArray2[n2];
                ++n2;
                if (Intrinsics.areEqual((Object)fileGroup.language, (Object)"C") || Intrinsics.areEqual((Object)fileGroup.language, (Object)"CXX")) continue;
                String[] stringArray = fileGroup.sources;
                Intrinsics.checkExpressionValueIsNotNull((Object)stringArray, (String)"fileGroup.sources");
                for (String source : stringArray) {
                    Appendable appendable = additionalProjectFilesIndexWriter;
                    Intrinsics.checkExpressionValueIsNotNull((Object)source, (String)"source");
                    CharSequence charSequence = FilesKt.resolve((File)sourceDirectory, (String)source).getAbsolutePath();
                    boolean bl = false;
                    Appendable appendable2 = appendable.append(charSequence);
                    Intrinsics.checkNotNullExpressionValue((Object)appendable2, (String)"append(value)");
                    StringsKt.appendln((Appendable)appendable2);
                }
            }
            return nativeLibraryValue;
        }

        private final boolean canAddTargetToNativeLibrary(Target target) {
            return target.artifacts != null || target.fileGroups != null;
        }

        private final NativeBuildConfigValue createDefaultNativeBuildConfigValue() {
            NativeBuildConfigValue nativeBuildConfigValue = new NativeBuildConfigValue();
            nativeBuildConfigValue.buildFiles = new ArrayList();
            nativeBuildConfigValue.cleanCommandsComponents = new ArrayList();
            nativeBuildConfigValue.libraries = new HashMap();
            nativeBuildConfigValue.toolchains = new HashMap();
            nativeBuildConfigValue.cFileExtensions = new ArrayList();
            nativeBuildConfigValue.cppFileExtensions = new ArrayList();
            nativeBuildConfigValue.stringTable = Maps.newHashMap();
            return nativeBuildConfigValue;
        }

        private final String normalizeFilePath(File file) {
            String string;
            if (ExternalNativeJsonGenerator.Companion.isWindows()) {
                String string2 = file.getPath();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"file.path");
                string = StringsKt.replace$default((String)string2, (String)"\\", (String)"/", (boolean)false, (int)4, null);
            } else {
                String string3 = file.getPath();
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"file.path");
                string = string3;
            }
            return string;
        }

        public static final /* synthetic */ void access$logInteractiveMessage(Companion $this, InteractiveMessage message, File makeFileDirectory) {
            $this.logInteractiveMessage(message, makeFileDirectory);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

