/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.instrumentation;

import com.android.build.api.instrumentation.AsmClassVisitorFactory;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ServiceLoader;
import java.util.function.BiConsumer;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u0000\u001a\u0006\u0012\u0002\b\u00030\u00012\u0012\u0010\u0002\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00030\u0001\u001a\"\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"getParamsImplClass", "Ljava/lang/Class;", "factoryClass", "Lcom/android/build/api/instrumentation/AsmClassVisitorFactory;", "loadTransformFunction", "Ljava/util/function/BiConsumer;", "Ljava/io/InputStream;", "Ljava/io/OutputStream;", "jarFile", "Ljava/io/File;", "jarFileClassLoader", "Ljava/lang/ClassLoader;", "gradle-core"})
public final class InstrumentationUtilsKt {
    @NotNull
    public static final Class<?> getParamsImplClass(@NotNull Class<? extends AsmClassVisitorFactory<?>> factoryClass) {
        Intrinsics.checkParameterIsNotNull(factoryClass, (String)"factoryClass");
        Type type = factoryClass.getGenericInterfaces()[0];
        if (type == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.reflect.ParameterizedType");
        }
        Type type2 = ((ParameterizedType)type).getActualTypeArguments()[0];
        if (type2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.Class<*>");
        }
        return (Class)type2;
    }

    @NotNull
    public static final BiConsumer<InputStream, OutputStream> loadTransformFunction(@NotNull File jarFile, @NotNull ClassLoader jarFileClassLoader) {
        Intrinsics.checkParameterIsNotNull((Object)jarFile, (String)"jarFile");
        Intrinsics.checkParameterIsNotNull((Object)jarFileClassLoader, (String)"jarFileClassLoader");
        ServiceLoader<BiConsumer> serviceLoader = ServiceLoader.load(BiConsumer.class, jarFileClassLoader);
        ArrayList functions = Lists.newArrayList(serviceLoader.iterator());
        Intrinsics.checkExpressionValueIsNotNull((Object)functions, (String)"functions");
        Collection collection = functions;
        boolean bl = false;
        boolean bl2 = !collection.isEmpty();
        bl = false;
        boolean bl3 = false;
        if (!bl2) {
            boolean bl4 = false;
            String string = "Transform jar " + jarFile.getAbsolutePath() + " does not provide a BiConsumer to apply";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        bl2 = functions.size() <= 1;
        bl = false;
        bl3 = false;
        if (!bl2) {
            boolean bl5 = false;
            String string = "Transform jar " + jarFile.getAbsolutePath() + " than one BiConsumer to apply";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        BiConsumer uncheckedFunction = (BiConsumer)functions.get(0);
        Type[] types = uncheckedFunction.getClass().getGenericInterfaces();
        Intrinsics.checkExpressionValueIsNotNull((Object)types, (String)"types");
        for (Type type : types) {
            if (!(type instanceof ParameterizedType)) continue;
            Type[] args = ((ParameterizedType)type).getActualTypeArguments();
            if (!Intrinsics.areEqual((Object)((ParameterizedType)type).getRawType(), BiConsumer.class) || args.length != 2 || !Intrinsics.areEqual((Object)args[0], InputStream.class) || !Intrinsics.areEqual((Object)args[1], OutputStream.class)) continue;
            if (uncheckedFunction == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.util.function.BiConsumer<java.io.InputStream, java.io.OutputStream>");
            }
            return uncheckedFunction;
        }
        throw new IllegalStateException("Transform jar " + jarFile.getAbsolutePath() + " must provide a BiConsumer<InputStream, OutputStream>");
    }
}

