/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.AvdComponentsBuildService;
import com.android.build.gradle.internal.ManagedDeviceUtilsKt;
import com.android.build.gradle.internal.SdkComponentsBuildService;
import com.android.build.gradle.internal.dsl.ManagedVirtualDevice;
import com.android.build.gradle.internal.profile.AnalyticsService;
import com.android.build.gradle.internal.profile.ProfileAwareWorkAction;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.services.BuildServicesKt;
import com.android.build.gradle.internal.tasks.ManagedDeviceSetupTaskKt;
import com.android.build.gradle.internal.tasks.NonIncrementalGlobalTask;
import com.android.build.gradle.internal.tasks.factory.GlobalTaskCreationAction;
import com.android.build.gradle.internal.utils.HasConfigurableValuesKt;
import com.android.repository.Revision;
import com.android.utils.GrabProcessOutput;
import java.io.File;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.file.Directory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.services.BuildServiceRegistry;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001:\u0003\u001f !B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u001a\u001a\u00020\u0005H\u0002J\b\u0010\u001b\u001a\u00020\u0005H\u0002J\b\u0010\u001c\u001a\u00020\u0005H\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0014R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0007R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0007R\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0007R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0007R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0007R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0007R\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0007\u00a8\u0006\""}, d2={"Lcom/android/build/gradle/internal/tasks/ManagedDeviceSetupTask;", "Lcom/android/build/gradle/internal/tasks/NonIncrementalGlobalTask;", "()V", "abi", "Lorg/gradle/api/provider/Property;", "", "getAbi", "()Lorg/gradle/api/provider/Property;", "apiLevel", "", "getApiLevel", "avdService", "Lcom/android/build/gradle/internal/AvdComponentsBuildService;", "getAvdService", "buildToolsRevision", "Lcom/android/repository/Revision;", "getBuildToolsRevision", "compileSdkVersion", "getCompileSdkVersion", "hardwareProfile", "getHardwareProfile", "sdkService", "Lcom/android/build/gradle/internal/SdkComponentsBuildService;", "getSdkService", "systemImageVendor", "getSystemImageVendor", "computeImageHash", "computeVendorString", "computeVersionString", "doTaskAction", "", "CreationAction", "ManagedDeviceSetupParams", "ManagedDeviceSetupRunnable", "gradle-core"})
public abstract class ManagedDeviceSetupTask
extends NonIncrementalGlobalTask {
    @Internal
    @NotNull
    public abstract Property<SdkComponentsBuildService> getSdkService();

    @Internal
    @NotNull
    public abstract Property<AvdComponentsBuildService> getAvdService();

    @Input
    @NotNull
    public abstract Property<String> getCompileSdkVersion();

    @Input
    @NotNull
    public abstract Property<Revision> getBuildToolsRevision();

    @Input
    @NotNull
    public abstract Property<String> getAbi();

    @Input
    @NotNull
    public abstract Property<Integer> getApiLevel();

    @Input
    @NotNull
    public abstract Property<String> getSystemImageVendor();

    @Input
    @NotNull
    public abstract Property<String> getHardwareProfile();

    @Override
    protected void doTaskAction() {
        this.getWorkerExecutor().noIsolation().submit(ManagedDeviceSetupRunnable.class, (Action)new Action<ManagedDeviceSetupParams>(this){
            final /* synthetic */ ManagedDeviceSetupTask this$0;
            {
                this.this$0 = $receiver;
            }

            public final void execute(ManagedDeviceSetupParams it) {
                String string = this.this$0.getProjectName();
                Object object = this.this$0.getPath();
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"path");
                it.initializeWith(string, (String)object, (Provider<AnalyticsService>)((Provider)this.this$0.getAnalyticsService()));
                it.getSdkService().set((Provider)this.this$0.getSdkService());
                it.getCompileSdkVersion().set((Provider)this.this$0.getCompileSdkVersion());
                it.getBuildToolsRevision().set((Provider)this.this$0.getBuildToolsRevision());
                it.getAvdService().set((Provider)this.this$0.getAvdService());
                it.getImageHash().set((Object)ManagedDeviceSetupTask.access$computeImageHash(this.this$0));
                Property<String> property = it.getDeviceName();
                object = this.this$0.getApiLevel().get();
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"apiLevel.get()");
                int n = ((Number)object).intValue();
                object = this.this$0.getSystemImageVendor().get();
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"systemImageVendor.get()");
                String string2 = (String)object;
                object = this.this$0.getAbi().get();
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"abi.get()");
                String string3 = (String)object;
                object = this.this$0.getHardwareProfile().get();
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"hardwareProfile.get()");
                property.set((Object)ManagedDeviceUtilsKt.computeAvdName(n, string2, string3, (String)object));
                it.getHardwareProfile().set((Provider)this.this$0.getHardwareProfile());
            }
        });
    }

    private final String computeImageHash() {
        return "system-images;" + this.computeVersionString() + ';' + this.computeVendorString() + ';' + this.getAbi().get();
    }

    private final String computeVersionString() {
        return Intrinsics.stringPlus((String)"android-", (Object)this.getApiLevel().get());
    }

    private final String computeVendorString() {
        String string;
        String string2 = (String)this.getSystemImageVendor().get();
        if (Intrinsics.areEqual((Object)string2, (Object)"google")) {
            string = "google_apis_playstore";
        } else if (Intrinsics.areEqual((Object)string2, (Object)"aosp")) {
            string = "default";
        } else {
            throw new RuntimeException("Unrecognized systemImageVendor " + this.getSystemImageVendor().get() + ". \"google\" or \"aosp\" expected.");
        }
        return string;
    }

    public static final /* synthetic */ String access$computeImageHash(ManagedDeviceSetupTask $this) {
        return $this.computeImageHash();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/android/build/gradle/internal/tasks/ManagedDeviceSetupTask$ManagedDeviceSetupRunnable;", "Lcom/android/build/gradle/internal/profile/ProfileAwareWorkAction;", "Lcom/android/build/gradle/internal/tasks/ManagedDeviceSetupTask$ManagedDeviceSetupParams;", "()V", "run", "", "gradle-core"})
    public static abstract class ManagedDeviceSetupRunnable
    extends ProfileAwareWorkAction<ManagedDeviceSetupParams> {
        @Override
        public void run() {
            File file;
            SdkComponentsBuildService.VersionedSdkLoader versionedSdkLoader = ((SdkComponentsBuildService)((ManagedDeviceSetupParams)this.getParameters()).getSdkService().get()).sdkLoader((Provider<String>)((Provider)((ManagedDeviceSetupParams)this.getParameters()).getCompileSdkVersion()), (Provider<Revision>)((Provider)((ManagedDeviceSetupParams)this.getParameters()).getBuildToolsRevision()));
            AvdComponentsBuildService avdComponentsBuildService = (AvdComponentsBuildService)((ManagedDeviceSetupParams)this.getParameters()).getAvdService().get();
            Object object = ((ManagedDeviceSetupParams)this.getParameters()).getImageHash().get();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"parameters.imageHash.get()");
            Provider<Directory> provider2 = versionedSdkLoader.sdkImageDirectoryProvider((String)object);
            object = ((ManagedDeviceSetupParams)this.getParameters()).getImageHash().get();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"parameters.imageHash.get()");
            String string = (String)object;
            object = ((ManagedDeviceSetupParams)this.getParameters()).getDeviceName().get();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"parameters.deviceName.get()");
            String string2 = (String)object;
            object = ((ManagedDeviceSetupParams)this.getParameters()).getHardwareProfile().get();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"parameters.hardwareProfile.get()");
            avdComponentsBuildService.avdProvider(provider2, string, string2, (String)object).get();
            AvdComponentsBuildService avdComponentsBuildService2 = (AvdComponentsBuildService)((ManagedDeviceSetupParams)this.getParameters()).getAvdService().get();
            object = ((ManagedDeviceSetupParams)this.getParameters()).getDeviceName().get();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"parameters.deviceName.get()");
            if (avdComponentsBuildService2.deviceSnapshotCreated((String)object)) {
                ManagedDeviceSetupTaskKt.access$getLoggerWrapper$p().info("Snapshot already exists for device " + ((ManagedDeviceSetupParams)this.getParameters()).getDeviceName().get() + '.', new Object[0]);
                return;
            }
            ManagedDeviceSetupTaskKt.access$getLoggerWrapper$p().info(Intrinsics.stringPlus((String)"Creating snapshot for ", (Object)((ManagedDeviceSetupParams)this.getParameters()).getDeviceName().get()), new Object[0]);
            Object object2 = (Directory)versionedSdkLoader.getEmulatorDirectoryProvider().getOrNull();
            File file2 = file = object2 == null ? null : object2.getAsFile();
            if (file == null) {
                object2 = "Emulator is missing.";
                boolean bl = false;
                throw (Throwable)new IllegalStateException(object2.toString());
            }
            File emulatorDir = file;
            File emulatorExecutable = FilesKt.resolve((File)emulatorDir, (String)"emulator");
            Object[] objectArray = new String[]{emulatorExecutable.getAbsolutePath(), Intrinsics.stringPlus((String)"@", (Object)((ManagedDeviceSetupParams)this.getParameters()).getDeviceName().get()), "-no-window", "-read-only", "-no-boot-anim"};
            ProcessBuilder processBuilder = new ProcessBuilder(CollectionsKt.listOf((Object[])objectArray));
            Map<String, String> environment = processBuilder.environment();
            Intrinsics.checkExpressionValueIsNotNull(environment, (String)"environment");
            Map<String, String> map = environment;
            Object object3 = "ANDROID_AVD_HOME";
            String string3 = ((Directory)((AvdComponentsBuildService.Parameters)((AvdComponentsBuildService)((ManagedDeviceSetupParams)this.getParameters()).getAvdService().get()).getParameters()).getAvdLocation().get()).getAsFile().getAbsolutePath();
            boolean bl = false;
            map.put((String)object3, string3);
            Process process2 = processBuilder.start();
            try {
                GrabProcessOutput.grabProcessOutput((Process)process2, (GrabProcessOutput.Wait)GrabProcessOutput.Wait.ASYNC, (GrabProcessOutput.IProcessOutput)new GrabProcessOutput.IProcessOutput(process2){
                    final /* synthetic */ Process $process;
                    {
                        this.$process = $process;
                    }

                    public void out(@Nullable String line) {
                        String string = line;
                        if (string == null) {
                            return;
                        }
                        if (StringsKt.contains$default((CharSequence)line, (CharSequence)"boot completed", (boolean)false, (int)2, null)) {
                            Thread.sleep(5000L);
                            this.$process.destroyForcibly();
                        }
                    }

                    public void err(@Nullable String line) {
                    }
                });
                if (!process2.waitFor(80L, TimeUnit.SECONDS)) {
                    process2.destroyForcibly();
                    process2.waitFor();
                    AvdComponentsBuildService avdComponentsBuildService3 = (AvdComponentsBuildService)((ManagedDeviceSetupParams)this.getParameters()).getAvdService().get();
                    object3 = ((ManagedDeviceSetupParams)this.getParameters()).getDeviceName().get();
                    Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"parameters.deviceName.get()");
                    if (!avdComponentsBuildService3.deviceSnapshotCreated((String)object3)) {
                        object3 = "Failed to generate snapshot for device.";
                        boolean bl2 = false;
                        throw (Throwable)new IllegalStateException(object3.toString());
                    }
                } else {
                    ManagedDeviceSetupTaskKt.access$getLoggerWrapper$p().info(Intrinsics.stringPlus((String)"Successfully created snapshot for ", (Object)((ManagedDeviceSetupParams)this.getParameters()).getDeviceName().get()), new Object[0]);
                }
            }
            catch (Exception e) {
                process2.destroyForcibly();
                process2.waitFor();
                throw new RuntimeException(e);
            }
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0018\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0018\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0007R\u0018\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0007R\u0018\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0007R\u0018\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0007R\u0018\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\f0\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0007R\u0018\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0007\u00a8\u0006\u0017"}, d2={"Lcom/android/build/gradle/internal/tasks/ManagedDeviceSetupTask$ManagedDeviceSetupParams;", "Lcom/android/build/gradle/internal/profile/ProfileAwareWorkAction$Parameters;", "()V", "avdService", "Lorg/gradle/api/provider/Property;", "Lcom/android/build/gradle/internal/AvdComponentsBuildService;", "getAvdService", "()Lorg/gradle/api/provider/Property;", "buildToolsRevision", "Lcom/android/repository/Revision;", "getBuildToolsRevision", "compileSdkVersion", "", "getCompileSdkVersion", "deviceName", "getDeviceName", "hardwareProfile", "getHardwareProfile", "imageHash", "getImageHash", "sdkService", "Lcom/android/build/gradle/internal/SdkComponentsBuildService;", "getSdkService", "gradle-core"})
    public static abstract class ManagedDeviceSetupParams
    extends ProfileAwareWorkAction.Parameters {
        @NotNull
        public abstract Property<SdkComponentsBuildService> getSdkService();

        @NotNull
        public abstract Property<String> getCompileSdkVersion();

        @NotNull
        public abstract Property<Revision> getBuildToolsRevision();

        @NotNull
        public abstract Property<AvdComponentsBuildService> getAvdService();

        @NotNull
        public abstract Property<String> getImageHash();

        @NotNull
        public abstract Property<String> getDeviceName();

        @NotNull
        public abstract Property<String> getHardwareProfile();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB5\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\n\u001a\u00020\u0004\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u0004\u0012\u0006\u0010\u000e\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0002H\u0016R\u000e\u0010\r\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\n\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0019"}, d2={"Lcom/android/build/gradle/internal/tasks/ManagedDeviceSetupTask$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/GlobalTaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/ManagedDeviceSetupTask;", "name", "", "managedDevice", "Lcom/android/build/gradle/internal/dsl/ManagedVirtualDevice;", "globalScope", "Lcom/android/build/gradle/internal/scope/GlobalScope;", "(Ljava/lang/String;Lcom/android/build/gradle/internal/dsl/ManagedVirtualDevice;Lcom/android/build/gradle/internal/scope/GlobalScope;)V", "systemImageSource", "apiLevel", "", "abi", "hardwareProfile", "(Ljava/lang/String;Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;Lcom/android/build/gradle/internal/scope/GlobalScope;)V", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "gradle-core"})
    public static final class CreationAction
    extends GlobalTaskCreationAction<ManagedDeviceSetupTask> {
        @NotNull
        private final String name;
        @NotNull
        private final String systemImageSource;
        private final int apiLevel;
        @NotNull
        private final String abi;
        @NotNull
        private final String hardwareProfile;

        public CreationAction(@NotNull String name, @NotNull String systemImageSource, int apiLevel, @NotNull String abi, @NotNull String hardwareProfile, @NotNull GlobalScope globalScope) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Intrinsics.checkParameterIsNotNull((Object)systemImageSource, (String)"systemImageSource");
            Intrinsics.checkParameterIsNotNull((Object)abi, (String)"abi");
            Intrinsics.checkParameterIsNotNull((Object)hardwareProfile, (String)"hardwareProfile");
            Intrinsics.checkParameterIsNotNull((Object)globalScope, (String)"globalScope");
            super(globalScope);
            this.name = name;
            this.systemImageSource = systemImageSource;
            this.apiLevel = apiLevel;
            this.abi = abi;
            this.hardwareProfile = hardwareProfile;
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        public CreationAction(@NotNull String name, @NotNull ManagedVirtualDevice managedDevice, @NotNull GlobalScope globalScope) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Intrinsics.checkParameterIsNotNull((Object)managedDevice, (String)"managedDevice");
            Intrinsics.checkParameterIsNotNull((Object)globalScope, (String)"globalScope");
            this(name, managedDevice.getSystemImageSource(), managedDevice.getApiLevel(), managedDevice.getAbi(), managedDevice.getDevice(), globalScope);
        }

        @Override
        @NotNull
        public Class<ManagedDeviceSetupTask> getType() {
            return ManagedDeviceSetupTask.class;
        }

        @Override
        public void configure(@NotNull ManagedDeviceSetupTask task) {
            Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
            Property<SdkComponentsBuildService> property = task.getSdkService();
            BuildServiceRegistry buildServiceRegistry = this.globalScope.getSdkComponents();
            Intrinsics.checkExpressionValueIsNotNull(buildServiceRegistry, (String)"globalScope.sdkComponents");
            HasConfigurableValuesKt.setDisallowChanges(property, buildServiceRegistry);
            HasConfigurableValuesKt.setDisallowChanges(task.getCompileSdkVersion(), this.globalScope.getExtension().getCompileSdkVersion());
            HasConfigurableValuesKt.setDisallowChanges(task.getBuildToolsRevision(), this.globalScope.getExtension().getBuildToolsRevision());
            Property<AvdComponentsBuildService> property2 = task.getAvdService();
            buildServiceRegistry = this.globalScope.getAvdComponents();
            Intrinsics.checkExpressionValueIsNotNull(buildServiceRegistry, (String)"globalScope.avdComponents");
            HasConfigurableValuesKt.setDisallowChanges(property2, buildServiceRegistry);
            HasConfigurableValuesKt.setDisallowChanges(task.getSystemImageVendor(), this.systemImageSource);
            HasConfigurableValuesKt.setDisallowChanges(task.getApiLevel(), this.apiLevel);
            HasConfigurableValuesKt.setDisallowChanges(task.getAbi(), this.abi);
            HasConfigurableValuesKt.setDisallowChanges(task.getHardwareProfile(), this.hardwareProfile);
            Property<AnalyticsService> property3 = task.getAnalyticsService();
            buildServiceRegistry = task.getProject().getGradle().getSharedServices();
            Intrinsics.checkExpressionValueIsNotNull((Object)buildServiceRegistry, (String)"task.project.gradle.sharedServices");
            property3.set(BuildServicesKt.getBuildService(buildServiceRegistry, AnalyticsService.class));
        }
    }
}

